/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class Equations {
    @NotNull
    final List<DirectionResultPair> results;
    final boolean stable;

    Equations(@NotNull List<DirectionResultPair> results, boolean stable) {
        if (results == null) {
            Equations.$$$reportNull$$$0(0);
        }
        this.results = results;
        this.stable = stable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Equations that = (Equations)o;
        return this.stable == that.stable && this.results.equals(that.results);
    }

    public int hashCode() {
        return 31 * this.results.hashCode() + (this.stable ? 1 : 0);
    }

    Optional<Result> find(Direction direction) {
        int key = direction.asInt();
        for (DirectionResultPair result : this.results) {
            if (result.directionKey != key) continue;
            return Optional.of(result).map(pair -> pair.result);
        }
        return Optional.empty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "com/intellij/codeInspection/bytecodeAnalysis/Equations", "<init>"));
    }
}

