/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

final class ExpandableArray<T> {
    private static final int INITIAL_SIZE = 30;
    private T[] array;

    ExpandableArray() {
    }

    @Nullable
    @Contract(pure=true)
    T get(int index) {
        return this.array != null && index < this.array.length ? (T)this.array[index] : null;
    }

    void set(int index, T value) {
        if (this.array == null) {
            this.array = new Object[Math.max(index + 1, 30)];
        } else if (index >= this.array.length) {
            this.array = Arrays.copyOf(this.array, Math.max(index + 1, this.array.length * 2));
        }
        this.array[index] = value;
    }
}

