/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

abstract class PResults {
    static final PResult Identity = new PResult(){

        public String toString() {
            return "Identity";
        }
    };
    static final PResult Return = new PResult(){

        public String toString() {
            return "Return";
        }
    };
    static final PResult NPE = new PResult(){

        public String toString() {
            return "NPE";
        }
    };

    PResults() {
    }

    static Set<Set<EKey>> join(Set<? extends Set<EKey>> sop1, Set<? extends Set<EKey>> sop2) {
        HashSet<Set<EKey>> sop = new HashSet<Set<EKey>>();
        sop.addAll(sop1);
        sop.addAll(sop2);
        return sop;
    }

    static Set<Set<EKey>> meet(Set<? extends Set<EKey>> sop1, Set<? extends Set<EKey>> sop2) {
        HashSet<Set<EKey>> sop = new HashSet<Set<EKey>>();
        for (Set<EKey> set : sop1) {
            for (Set<EKey> set2 : sop2) {
                HashSet<EKey> prod = new HashSet<EKey>();
                prod.addAll(set);
                prod.addAll(set2);
                sop.add(prod);
            }
        }
        return sop;
    }

    static PResult combineNullable(PResult r1, PResult r2) throws AnalyzerException {
        if (Identity == r1) {
            return r2;
        }
        if (Identity == r2) {
            return r1;
        }
        if (Return == r1) {
            return r2;
        }
        if (Return == r2) {
            return r1;
        }
        if (NPE == r1) {
            return NPE;
        }
        if (NPE == r2) {
            return NPE;
        }
        return new ConditionalNPE(PResults.join(((ConditionalNPE)r1).sop, ((ConditionalNPE)r2).sop));
    }

    static PResult join(PResult r1, PResult r2) throws AnalyzerException {
        if (Identity == r1) {
            return r2;
        }
        if (Identity == r2) {
            return r1;
        }
        if (Return == r1) {
            return Return;
        }
        if (Return == r2) {
            return Return;
        }
        if (NPE == r1) {
            return r2;
        }
        if (NPE == r2) {
            return r1;
        }
        return new ConditionalNPE(PResults.join(((ConditionalNPE)r1).sop, ((ConditionalNPE)r2).sop));
    }

    static PResult meet(PResult r1, PResult r2) throws AnalyzerException {
        if (Identity == r1) {
            return r2;
        }
        if (Return == r1) {
            return r2;
        }
        if (Return == r2) {
            return r1;
        }
        if (NPE == r1) {
            return NPE;
        }
        if (NPE == r2) {
            return NPE;
        }
        if (Identity == r2) {
            return Identity;
        }
        return new ConditionalNPE(PResults.meet(((ConditionalNPE)r1).sop, ((ConditionalNPE)r2).sop));
    }

    static interface PResult {
    }

    static final class ConditionalNPE
    implements PResult {
        final Set<Set<EKey>> sop;

        ConditionalNPE(Set<Set<EKey>> sop) throws AnalyzerException {
            this.sop = sop;
            ConditionalNPE.checkLimit(sop);
        }

        ConditionalNPE(EKey key) {
            this.sop = new HashSet<Set<EKey>>();
            HashSet<EKey> prod = new HashSet<EKey>();
            prod.add(key);
            this.sop.add(prod);
        }

        static void checkLimit(Set<? extends Set<EKey>> sop) throws AnalyzerException {
            int size = sop.stream().mapToInt(Set::size).sum();
            if (size > 30) {
                throw new AnalyzerException(null, "HEquation size is too big");
            }
        }
    }
}

