/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResultUtil {
    private static final EKey[] EMPTY_PRODUCT = EKey.EMPTY_ARRAY;
    private final ELattice<Value> lattice;
    final Value top;
    final Value bottom;

    ResultUtil(ELattice<Value> lattice) {
        this.lattice = lattice;
        this.top = (Value)lattice.top;
        this.bottom = (Value)lattice.bot;
    }

    Result join(Result r1, Result r2) {
        List<Component> right;
        Result result = this.checkFinal(r1, r2);
        if (result != null) {
            return result;
        }
        result = this.checkFinal(r1, r2);
        if (result != null) {
            return result;
        }
        if (r1 instanceof Value && r2 instanceof Value) {
            return this.lattice.join((Value)r1, (Value)r2);
        }
        if (r1 instanceof Value && r2 instanceof Pending) {
            return this.addSingle((Pending)r2, (Value)r1);
        }
        if (r1 instanceof Pending && r2 instanceof Value) {
            return this.addSingle((Pending)r1, (Value)r2);
        }
        assert (r1 instanceof Pending && r2 instanceof Pending);
        Pending pending1 = (Pending)r1;
        Pending pending2 = (Pending)r2;
        List<Component> left = Arrays.asList(pending1.delta);
        if (left.containsAll(right = Arrays.asList(pending2.delta))) {
            return pending1;
        }
        if (right.containsAll(left)) {
            return pending2;
        }
        HashSet<Component> sum = new HashSet<Component>();
        sum.addAll(left);
        sum.addAll(right);
        return new Pending(DfaUtil.upwardsAntichain(sum, (l, r) -> r.isSuperStateOf((Component)l)));
    }

    @Nullable
    private Result checkFinal(Result r1, Result r2) {
        if (r1 == this.top) {
            return r1;
        }
        if (r1 == this.bottom) {
            return r2;
        }
        return null;
    }

    @NotNull
    private Result addSingle(Pending pending, Value value) {
        for (int i = 0; i < pending.delta.length; ++i) {
            Component component = pending.delta[i];
            if (component.ids.length != 0) continue;
            Value join = this.lattice.join(component.value, value);
            if (join == this.top) {
                Value value2 = this.top;
                if (value2 == null) {
                    ResultUtil.$$$reportNull$$$0(0);
                }
                return value2;
            }
            if (join == component.value) {
                Pending pending2 = pending;
                if (pending2 == null) {
                    ResultUtil.$$$reportNull$$$0(1);
                }
                return pending2;
            }
            Component[] components = (Component[])pending.delta.clone();
            components[i] = new Component(join, EMPTY_PRODUCT);
            return new Pending(components);
        }
        return new Pending((Component[])ArrayUtil.append((Object[])pending.delta, (Object)new Component(value, EMPTY_PRODUCT)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/ResultUtil", "addSingle"));
    }
}

