/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;

enum Value implements Result
{
    Bot,
    NotNull,
    Null,
    True,
    False,
    Fail,
    Pure,
    Top;

    static final List<Value> BOOLEAN;
    static final List<Value> OBJECT;

    static List<Value> typeValues(Type type) {
        if (ASMUtils.isReferenceType(type)) {
            return OBJECT;
        }
        if (ASMUtils.isBooleanType(type)) {
            return BOOLEAN;
        }
        return List.of();
    }

    @Nullable
    static Value fromBasicValue(BasicValue value) {
        if (value == AbstractValues.TrueValue) {
            return True;
        }
        if (value == AbstractValues.FalseValue) {
            return False;
        }
        if (value == AbstractValues.NullValue) {
            return Null;
        }
        if (value instanceof AbstractValues.NotNullValue) {
            return NotNull;
        }
        return null;
    }

    ContractReturnValue toReturnValue() {
        return switch (this.ordinal()) {
            case 4 -> ContractReturnValue.returnFalse();
            case 3 -> ContractReturnValue.returnTrue();
            case 1 -> ContractReturnValue.returnNotNull();
            case 2 -> ContractReturnValue.returnNull();
            case 5 -> ContractReturnValue.fail();
            default -> ContractReturnValue.returnAny();
        };
    }

    StandardMethodContract.ValueConstraint toValueConstraint() {
        return switch (this.ordinal()) {
            case 4 -> StandardMethodContract.ValueConstraint.FALSE_VALUE;
            case 3 -> StandardMethodContract.ValueConstraint.TRUE_VALUE;
            case 1 -> StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
            case 2 -> StandardMethodContract.ValueConstraint.NULL_VALUE;
            default -> StandardMethodContract.ValueConstraint.ANY_VALUE;
        };
    }

    static {
        BOOLEAN = List.of(True, False);
        OBJECT = List.of(Null, NotNull);
    }
}

