/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public final class ASMUtils {
    public static final Type THIS_TYPE = Type.getObjectType((String)"this");
    public static final Type THROWABLE_TYPE = Type.getObjectType((String)"java/lang/Throwable");
    public static final BasicValue THIS_VALUE = new BasicValue(THIS_TYPE);
    public static final BasicValue THROWABLE_VALUE = new BasicValue(THROWABLE_TYPE);

    @Contract(pure=true)
    public static boolean isReferenceType(Type tp) {
        int sort = tp.getSort();
        return sort == 10 || sort == 9;
    }

    @Contract(pure=true)
    public static boolean isBooleanType(Type tp) {
        return Type.BOOLEAN_TYPE.equals((Object)tp);
    }

    @Contract(pure=true)
    public static boolean isThisType(Type tp) {
        return THIS_TYPE.equals((Object)tp);
    }

    @Contract(pure=true)
    public static int getSizeFast(String desc) {
        return switch (desc.charAt(0)) {
            case 'D', 'J' -> 2;
            default -> 1;
        };
    }

    @Contract(pure=true)
    public static int getReturnSizeFast(String methodDesc) {
        return switch (methodDesc.charAt(methodDesc.indexOf(41) + 1)) {
            case 'D', 'J' -> 2;
            default -> 1;
        };
    }

    @Contract(pure=true)
    public static boolean isReferenceReturnType(String methodDesc) {
        return switch (methodDesc.charAt(methodDesc.indexOf(41) + 1)) {
            case 'L', '[' -> true;
            default -> false;
        };
    }

    public static <V extends Value> Frame<V>[] newFrameArray(int size) {
        Frame[] a = new Frame[size];
        return a;
    }

    public static <V> List<V>[] newListArray(int size) {
        List[] a = new List[size];
        return a;
    }
}

