/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;

public final class DFSTree {
    public final int[] preOrder;
    public final int[] postOrder;
    private final LongOpenHashSet nonBack;
    private final LongOpenHashSet back;
    public final boolean[] loopEnters;

    DFSTree(int[] preOrder, int[] postOrder, LongOpenHashSet nonBack, LongOpenHashSet back, boolean[] loopEnters) {
        this.preOrder = preOrder;
        this.postOrder = postOrder;
        this.nonBack = nonBack;
        this.back = back;
        this.loopEnters = loopEnters;
    }

    public boolean isBackEmpty() {
        return this.back.isEmpty();
    }

    public boolean isDescendant(int child, int parent) {
        return this.preOrder[parent] <= this.preOrder[child] && this.postOrder[child] <= this.postOrder[parent];
    }

    public void iterateBack(EdgeVisitor visitor2) {
        DFSTree.iterate(this.back, visitor2);
    }

    public void iterateNonBack(EdgeVisitor visitor2) {
        DFSTree.iterate(this.nonBack, visitor2);
    }

    private static void iterate(LongOpenHashSet set, EdgeVisitor visitor2) {
        LongIterator iterator = set.iterator();
        while (iterator.hasNext()) {
            long packed = iterator.nextLong();
            visitor2.visit((int)(packed >>> 32), (int)packed);
        }
    }

    private static void putEdge(LongOpenHashSet set, int from, int to) {
        set.add((long)from * 0x100000000L + (long)to);
    }

    public static DFSTree build(int[][] transitions, int edgeCount) {
        LongOpenHashSet nonBack = new LongOpenHashSet();
        LongOpenHashSet back = new LongOpenHashSet();
        boolean[] marked = new boolean[transitions.length];
        boolean[] scanned = new boolean[transitions.length];
        int[] preOrder = new int[transitions.length];
        int[] postOrder = new int[transitions.length];
        int entered = 0;
        int completed = 0;
        boolean[] loopEnters = new boolean[transitions.length];
        preOrder[0] = ++entered;
        marked[0] = true;
        boolean[] stackFlag = new boolean[edgeCount * 2 + 1];
        int[] stackFrom = new int[edgeCount * 2 + 1];
        int[] stackTo = new int[edgeCount * 2 + 1];
        int top = 0;
        stackFlag[top] = true;
        stackTo[top] = 0;
        ++top;
        for (int to : transitions[0]) {
            stackFlag[top] = false;
            stackFrom[top] = 0;
            stackTo[top] = to;
            ++top;
        }
        while (top > 0) {
            if (stackFlag[--top]) {
                postOrder[stackTo[top]] = ++completed;
                scanned[stackTo[top]] = true;
                continue;
            }
            int from = stackFrom[top];
            int to = stackTo[top];
            if (!marked[to]) {
                DFSTree.putEdge(nonBack, from, to);
                preOrder[to] = ++entered;
                marked[to] = true;
                stackFlag[top] = true;
                stackTo[top] = to;
                ++top;
                for (int to1 : transitions[to]) {
                    stackFlag[top] = false;
                    stackFrom[top] = to;
                    stackTo[top] = to1;
                    ++top;
                }
                continue;
            }
            if (preOrder[to] > preOrder[from]) {
                DFSTree.putEdge(nonBack, from, to);
                continue;
            }
            if (preOrder[to] < preOrder[from] && !scanned[to]) {
                DFSTree.putEdge(back, from, to);
                loopEnters[to] = true;
                continue;
            }
            DFSTree.putEdge(nonBack, from, to);
        }
        return new DFSTree(preOrder, postOrder, nonBack, back, loopEnters);
    }

    public static interface EdgeVisitor {
        public void visit(int var1, int var2);
    }
}

