/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CanBeFinalAnnotator
extends RefGraphAnnotatorEx {
    private final RefManager myManager;
    static long CAN_BE_FINAL_MASK;

    CanBeFinalAnnotator(@NotNull RefManager manager) {
        if (manager == null) {
            CanBeFinalAnnotator.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
    }

    public void initialize(RefManager refManager) {
        CAN_BE_FINAL_MASK = refManager.getLastUsedMask();
    }

    public void onInitialize(RefElement refElement) {
        ((RefElementImpl)refElement).setFlag(true, CAN_BE_FINAL_MASK);
    }

    private static void mark(RefElement refElement) {
        RefFieldImpl field;
        if (refElement instanceof RefClass) {
            RefClass refClass = (RefClass)refElement;
            if (refClass.isEntry()) {
                ((RefClassImpl)refClass).setFlag(false, CAN_BE_FINAL_MASK);
            }
            for (RefClass baseClass : refClass.getBaseClasses()) {
                baseClass.initializeIfNeeded();
                ((RefClassImpl)baseClass).setFlag(false, CAN_BE_FINAL_MASK);
            }
            if (refClass.isAbstract() || refClass.isAnonymous() || refClass.isInterface()) {
                ((RefClassImpl)refClass).setFlag(false, CAN_BE_FINAL_MASK);
            }
        } else if (refElement instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refElement;
            RefClass aClass = refMethod.getOwnerClass();
            if (aClass != null) {
                aClass.initializeIfNeeded();
            }
            if (refMethod.isConstructor() || refMethod.isAbstract() || refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || aClass != null && aClass.isAnonymous() || aClass != null && aClass.isInterface()) {
                ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
            }
            for (RefMethod superMethod : refMethod.getSuperMethods()) {
                superMethod.initializeIfNeeded();
                ((RefMethodImpl)superMethod).setFlag(false, CAN_BE_FINAL_MASK);
            }
        } else if (refElement instanceof RefFieldImpl && (field = (RefFieldImpl)refElement).isImplicitlyWritten()) {
            field.setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement referenceElement) {
        if (!forWriting) {
            return;
        }
        if (!(refWhat instanceof RefField)) {
            return;
        }
        RefField refField = (RefField)refWhat;
        if (refFrom instanceof RefClass && refField.getOwnerClass() != refFrom) {
            ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
        } else if (refField.getUastElement().getUastInitializer() != null) {
            ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
        } else if (!(refFrom instanceof RefMethod) || !((RefMethod)refFrom).isConstructor() || ((RefMethod)refFrom).getOwnerClass() != refField.getOwnerClass() || refField.isStatic()) {
            if (!referencedFromClassInitializer || PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiLambdaExpression.class, (boolean)true) != null) {
                ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
            }
        } else if (PsiTreeUtil.getParentOfType((PsiElement)referenceElement, PsiLambdaExpression.class, (boolean)true) != null) {
            ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    public void onReferencesBuild(RefElement refElement) {
        RefMethod refMethod;
        CanBeFinalAnnotator.mark(refElement);
        if (refElement instanceof RefClass) {
            PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)refElement.getPsiElement(), PsiClass.class);
            if (psiClass != null) {
                Collection writtenVariables;
                ControlFlow flow;
                PsiCodeBlock body;
                Object[] psiFields = psiClass.getFields();
                HashSet allFields = new HashSet();
                ContainerUtil.addAll(allFields, (Object[])psiFields);
                ArrayList<PsiVariable> instanceInitializerInitializedFields = new ArrayList<PsiVariable>();
                HashSet<PsiField> fieldsInitializedInInitializers = null;
                for (PsiClassInitializer psiClassInitializer : psiClass.getInitializers()) {
                    body = psiClassInitializer.getBody();
                    try {
                        flow = ControlFlowFactory.getInstance((Project)body.getProject()).getControlFlow((PsiElement)body, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                    }
                    catch (AnalysisCanceledException e) {
                        flow = ControlFlow.EMPTY;
                    }
                    writtenVariables = new ArrayList();
                    ControlFlowUtil.getWrittenVariables((ControlFlow)flow, (int)0, (int)flow.getSize(), (boolean)false, writtenVariables);
                    if (fieldsInitializedInInitializers == null) {
                        fieldsInitializedInInitializers = new HashSet<PsiField>();
                    }
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (!allFields.contains(psiVariable) || !ControlFlowUtil.isVariableDefinitelyAssigned((PsiVariable)psiVariable, (ControlFlow)flow)) continue;
                        if (instanceInitializerInitializedFields.contains(psiVariable)) {
                            allFields.remove(psiVariable);
                            instanceInitializerInitializedFields.remove(psiVariable);
                        } else {
                            instanceInitializerInitializedFields.add(psiVariable);
                        }
                        fieldsInitializedInInitializers.add((PsiField)psiVariable);
                    }
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (instanceInitializerInitializedFields.contains(psiVariable)) continue;
                        allFields.remove(psiVariable);
                    }
                }
                for (PsiMethod psiMethod : psiClass.getConstructors()) {
                    body = psiMethod.getBody();
                    if (body == null) continue;
                    try {
                        flow = ControlFlowFactory.getInstance((Project)body.getProject()).getControlFlow((PsiElement)body, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                    }
                    catch (AnalysisCanceledException e) {
                        flow = ControlFlow.EMPTY;
                    }
                    writtenVariables = ControlFlowUtil.getWrittenVariables((ControlFlow)flow, (int)0, (int)flow.getSize(), (boolean)false);
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (!instanceInitializerInitializedFields.contains(psiVariable)) continue;
                        allFields.remove(psiVariable);
                        instanceInitializerInitializedFields.remove(psiVariable);
                    }
                    List redirectedConstructors = JavaPsiConstructorUtil.getChainedConstructors((PsiMethod)psiMethod);
                    if (redirectedConstructors.isEmpty()) {
                        List ssaVariables = ControlFlowUtil.getSSAVariables((ControlFlow)flow);
                        ArrayList<PsiVariable> good = new ArrayList<PsiVariable>(ssaVariables);
                        good.addAll(instanceInitializerInitializedFields);
                        allFields.retainAll(good);
                        continue;
                    }
                    allFields.removeAll(writtenVariables);
                }
                for (Object object : psiFields) {
                    RefFieldImpl refField;
                    if ((fieldsInitializedInInitializers == null || fieldsInitializedInInitializers.contains(object)) && allFields.contains(object) || object.getInitializer() != null || (refField = (RefFieldImpl)this.myManager.getReference((PsiElement)object)) == null) continue;
                    refField.initializeIfNeeded();
                    refField.setFlag(false, CAN_BE_FINAL_MASK);
                }
            }
        } else if (refElement instanceof RefMethod && (refMethod = (RefMethod)refElement).isEntry()) {
            ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/canBeFinal/CanBeFinalAnnotator", "<init>"));
    }
}

