/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public final class StaticGuardedByInstanceInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.concurrency.annotation.issues", (Object[])new Object[0]);
        if (string == null) {
            StaticGuardedByInstanceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "StaticGuardedByInstance";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            StaticGuardedByInstanceInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(@NotNull PsiAnnotation annotation) {
            PsiClass containingClass;
            if (annotation == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class);
            if (member == null) {
                return;
            }
            if (!member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null) {
                return;
            }
            PsiAnnotationMemberValue guardRef = annotation.findAttributeValue("value");
            if (guardRef == null) {
                return;
            }
            if ("this".equals(guardValue)) {
                this.registerError((PsiElement)guardRef);
            }
            if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class)) == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)guardRef);
        }

        public void visitDocTag(@NotNull PsiDocTag psiDocTag) {
            PsiClass containingClass;
            if (psiDocTag == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiMember.class);
            if (member == null) {
                return;
            }
            if (!member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if ("this".equals(guardValue)) {
                this.registerError((PsiElement)psiDocTag);
            }
            if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class)) == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("static")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, JavaAnalysisBundle.message((String)"static.member.guarded.by.instance.0.loc", (Object[])new Object[]{guardValue}), new LocalQuickFix[0]);
        }

        private void registerError(PsiElement element) {
            this.myHolder.registerProblem(element, JavaAnalysisBundle.message((String)"static.member.guarded.by.instance.ref.loc", (Object[])new Object[0]), new LocalQuickFix[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDocTag";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAnnotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDocTag";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

