/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.interpreter.ReachabilityCountingInterpreter;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaDfaAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceArgumentAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaPolyadicPartAnchor;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.AssertionDisabledDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DataFlowIRProvider;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonDataflow {
    private CommonDataflow() {
    }

    @NotNull
    private static DataflowResult runDFA(final @Nullable PsiElement block) {
        if (block == null) {
            return new DataflowResult(RunnerResult.NOT_APPLICABLE);
        }
        final CommonDataflowListener listener = new CommonDataflowListener();
        StandardDataFlowRunner runner = new StandardDataFlowRunner(block.getProject(), ThreeState.UNSURE){

            @Override
            @NotNull
            protected StandardDataFlowInterpreter createInterpreter(@NotNull DfaListener listener2, @NotNull ControlFlow flow) {
                if (listener2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (flow == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new ReachabilityCountingInterpreter(flow, listener2, false, true, 0);
            }

            @Override
            protected void afterInterpretation(@NotNull ControlFlow flow, @NotNull StandardDataFlowInterpreter interpreter, @NotNull RunnerResult result) {
                if (flow == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (interpreter == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (result == RunnerResult.OK) {
                    Set unreachable = ((ReachabilityCountingInterpreter)interpreter).getUnreachable();
                    listener.myResult.myUnreachable.addAll(DataFlowIRProvider.computeUnreachableSegments((PsiElement)block, (Set)unreachable));
                }
                super.afterInterpretation(flow, interpreter, result);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "flow";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreter";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "createInterpreter";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterInterpretation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        RunnerResult result = runner.analyzeMethodRecursively(block, listener);
        if (result != RunnerResult.OK) {
            return new DataflowResult(result);
        }
        if (!(block instanceof PsiClass)) {
            DataflowResult dataflowResult = listener.myResult;
            if (dataflowResult == null) {
                CommonDataflow.$$$reportNull$$$0(0);
            }
            return dataflowResult;
        }
        PsiClass psiClass = (PsiClass)block;
        DataflowResult dfr = listener.myResult.copy();
        List<DfaMemoryState> states = listener.myEndOfInitializerStates;
        for (PsiMethod method : psiClass.getConstructors()) {
            PsiCodeBlock body = method.getBody();
            if (body == null) continue;
            PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
            List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall(psiClass, method) ? Collections.singletonList(runner.createMemoryState()) : ContainerUtil.map(states, DfaMemoryState::createCopy);
            if (runner.analyzeBlockRecursively((PsiElement)body, initialStates, listener) == RunnerResult.OK) {
                dfr = listener.myResult.copy();
                continue;
            }
            listener.myResult = dfr;
        }
        DataflowResult dataflowResult = dfr;
        if (dataflowResult == null) {
            CommonDataflow.$$$reportNull$$$0(1);
        }
        return dataflowResult;
    }

    @Nullable
    public static DataflowResult getDataflowResult(@NotNull PsiElement context) {
        PsiElement body;
        if (context == null) {
            CommonDataflow.$$$reportNull$$$0(2);
        }
        if ((body = DfaUtil.getDataflowContext(context)) == null) {
            return null;
        }
        ConcurrentMap fileMap = (ConcurrentMap)CachedValuesManager.getCachedValue((PsiElement)body.getContainingFile(), () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.createMap(e -> {
            DataflowResult result = CommonDataflow.runDFA(e);
            return result.myResult != RunnerResult.OK ? null : result;
        }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return (DataflowResult)fileMap.get(body);
    }

    @NotNull
    public static DfType getDfType(@NotNull PsiExpression expression) {
        if (expression == null) {
            CommonDataflow.$$$reportNull$$$0(3);
        }
        return CommonDataflow.getDfType(expression, false);
    }

    @NotNull
    public static DfType getDfType(@NotNull PsiExpression expression, boolean ignoreAssertions) {
        DataflowResult result;
        if (expression == null) {
            CommonDataflow.$$$reportNull$$$0(4);
        }
        if ((result = CommonDataflow.getDataflowResult((PsiElement)expression)) == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CommonDataflow.$$$reportNull$$$0(5);
            }
            return dfType;
        }
        expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        DfType dfType = ignoreAssertions ? result.getDfTypeNoAssertions(expression) : result.getDfType(expression);
        if (dfType == null) {
            CommonDataflow.$$$reportNull$$$0(6);
        }
        return dfType;
    }

    @Contract(value="null -> null")
    @Nullable
    public static LongRangeSet getExpressionRange(@Nullable PsiExpression expression) {
        if (expression == null) {
            return null;
        }
        Object value = ExpressionUtils.computeConstantExpression(expression);
        LongRangeSet rangeSet = LongRangeSet.fromConstant((Object)value);
        if (rangeSet != null) {
            return rangeSet;
        }
        DfType dfType = CommonDataflow.getDfType(expression);
        return dfType instanceof DfIntegralType ? ((DfIntegralType)dfType).getRange() : null;
    }

    @Contract(value="null -> null")
    public static Object computeValue(@Nullable PsiExpression expression) {
        PsiExpression expressionToAnalyze = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression);
        if (expressionToAnalyze == null) {
            return null;
        }
        Object computed = ExpressionUtils.computeConstantExpression(expressionToAnalyze);
        if (computed != null) {
            return computed;
        }
        return CommonDataflow.getDfType(expressionToAnalyze).getConstantOfType(Object.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/CommonDataflow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runDFA";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDataflowResult";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static final class DataflowResult {
        @NotNull
        private final Map<JavaDfaAnchor, DataflowPoint> myData;
        @NotNull
        private final List<TextRange> myUnreachable;
        @NotNull
        private Map<JavaDfaAnchor, DataflowPoint> myDataAssertionsDisabled;
        @NotNull
        private final RunnerResult myResult;

        public DataflowResult(@NotNull RunnerResult result) {
            if (result == null) {
                DataflowResult.$$$reportNull$$$0(0);
            }
            this.myData = new HashMap<JavaDfaAnchor, DataflowPoint>();
            this.myUnreachable = new ArrayList<TextRange>();
            this.myDataAssertionsDisabled = this.myData;
            this.myResult = result;
        }

        @NotNull
        DataflowResult copy() {
            DataflowResult copy = new DataflowResult(this.myResult);
            this.myData.forEach((anchor, point) -> copy.myData.put((JavaDfaAnchor)anchor, new DataflowPoint((DataflowPoint)point)));
            copy.myUnreachable.addAll(this.myUnreachable);
            DataflowResult dataflowResult = copy;
            if (dataflowResult == null) {
                DataflowResult.$$$reportNull$$$0(1);
            }
            return dataflowResult;
        }

        void add(JavaDfaAnchor anchor, DfaMemoryState memState, DfaValue value) {
            DfaVariableValue assertionDisabled = AssertionDisabledDescriptor.getAssertionsDisabledVar(value.getFactory());
            if (assertionDisabled == null) {
                assert (this.myData == this.myDataAssertionsDisabled);
                this.updateDataPoint(this.myData, anchor, memState, value);
            } else {
                DfType type = memState.getDfType((DfaValue)assertionDisabled);
                if (type == DfTypes.TRUE || type == DfTypes.FALSE) {
                    if (this.myData == this.myDataAssertionsDisabled) {
                        this.myDataAssertionsDisabled = new HashMap<JavaDfaAnchor, DataflowPoint>(this.myData);
                    }
                    this.updateDataPoint(type == DfTypes.TRUE ? this.myDataAssertionsDisabled : this.myData, anchor, memState, value);
                } else {
                    this.updateDataPoint(this.myData, anchor, memState, value);
                    if (this.myData != this.myDataAssertionsDisabled) {
                        this.updateDataPoint(this.myDataAssertionsDisabled, anchor, memState, value);
                    }
                }
            }
        }

        private void updateDataPoint(Map<JavaDfaAnchor, DataflowPoint> data, JavaDfaAnchor anchor, DfaMemoryState memState, DfaValue value) {
            PsiExpression expression;
            PsiElement parent;
            DataflowPoint point = data.computeIfAbsent(anchor, e -> new DataflowPoint());
            if (DfaTypeValue.isContractFail((DfaValue)value)) {
                point.myMayFailByContract = true;
                return;
            }
            if (point.myDfType != DfType.TOP && anchor instanceof JavaExpressionAnchor && (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)(expression = ((JavaExpressionAnchor)anchor).getExpression()).getParent())) instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor((PsiElement)((PsiConditionalExpression)parent).getCondition(), (PsiElement)expression, (boolean)false)) {
                this.add(new JavaExpressionAnchor((PsiExpression)parent), memState, value);
            }
            point.addFacts(memState, value);
            point.addValue(memState, value);
        }

        public boolean anchorWasAnalyzed(@NotNull JavaDfaAnchor anchor) {
            if (anchor == null) {
                DataflowResult.$$$reportNull$$$0(2);
            }
            return this.myData.containsKey(anchor);
        }

        @Contract(value="null -> false")
        public boolean cannotFailByContract(@Nullable PsiCallExpression call) {
            if (call == null) {
                return false;
            }
            DataflowPoint point = this.myData.get(new JavaExpressionAnchor((PsiExpression)call));
            return point != null && !point.myMayFailByContract;
        }

        @NotNull
        public Collection<TextRange> getUnreachableRanges() {
            List<Object> list = this.myResult != RunnerResult.OK ? Collections.emptyList() : this.myUnreachable;
            if (list == null) {
                DataflowResult.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public Set<Object> getExpressionValues(@Nullable PsiExpression expression) {
            if (expression == null) {
                Set<Object> set = Collections.emptySet();
                if (set == null) {
                    DataflowResult.$$$reportNull$$$0(4);
                }
                return set;
            }
            DataflowPoint point = this.myData.get(new JavaExpressionAnchor(expression));
            if (point == null) {
                Set<Object> set = Collections.emptySet();
                if (set == null) {
                    DataflowResult.$$$reportNull$$$0(5);
                }
                return set;
            }
            Set<Object> values = point.myPossibleValues;
            Set<Object> set = values == null ? Collections.emptySet() : Collections.unmodifiableSet(values);
            if (set == null) {
                DataflowResult.$$$reportNull$$$0(6);
            }
            return set;
        }

        @NotNull
        public DfType getDfType(PsiExpression expression) {
            if (expression == null) {
                DfType dfType = DfType.TOP;
                if (dfType == null) {
                    DataflowResult.$$$reportNull$$$0(7);
                }
                return dfType;
            }
            DataflowPoint point = this.myData.get(new JavaExpressionAnchor(expression));
            DfType dfType = point == null ? DfType.TOP : point.myDfType;
            if (dfType == null) {
                DataflowResult.$$$reportNull$$$0(8);
            }
            return dfType;
        }

        @NotNull
        public DfType getDfType(@NotNull JavaDfaAnchor anchor) {
            DataflowPoint point;
            if (anchor == null) {
                DataflowResult.$$$reportNull$$$0(9);
            }
            DfType dfType = (point = this.myData.get(anchor)) == null ? DfType.TOP : point.myDfType;
            if (dfType == null) {
                DataflowResult.$$$reportNull$$$0(10);
            }
            return dfType;
        }

        @NotNull
        public DfType getDfTypeNoAssertions(@NotNull JavaDfaAnchor anchor) {
            DataflowPoint point;
            if (anchor == null) {
                DataflowResult.$$$reportNull$$$0(11);
            }
            DfType dfType = (point = this.myDataAssertionsDisabled.get(anchor)) == null ? DfType.TOP : point.myDfType;
            if (dfType == null) {
                DataflowResult.$$$reportNull$$$0(12);
            }
            return dfType;
        }

        @NotNull
        public DfType getDfTypeNoAssertions(PsiExpression expression) {
            if (expression == null) {
                DfType dfType = DfType.TOP;
                if (dfType == null) {
                    DataflowResult.$$$reportNull$$$0(13);
                }
                return dfType;
            }
            DataflowPoint point = this.myDataAssertionsDisabled.get(new JavaExpressionAnchor(expression));
            DfType dfType = point == null ? DfType.TOP : point.myDfType;
            if (dfType == null) {
                DataflowResult.$$$reportNull$$$0(14);
            }
            return dfType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 4, 5, 6, 7, 8, 10, 12, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/CommonDataflow$DataflowResult";
                    break;
                }
                case 2: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow$DataflowResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnreachableRanges";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpressionValues";
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfType";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDfTypeNoAssertions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "anchorWasAnalyzed";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDfType";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getDfTypeNoAssertions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 4, 5, 6, 7, 8, 10, 12, 13, 14 -> new IllegalStateException(string);
            };
        }
    }

    private static class CommonDataflowListener
    implements JavaDfaListener {
        private DataflowResult myResult = new DataflowResult(RunnerResult.OK);
        private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();

        private CommonDataflowListener() {
        }

        @Override
        public void beforeInstanceInitializerEnd(@NotNull DfaMemoryState state) {
            if (state == null) {
                CommonDataflowListener.$$$reportNull$$$0(0);
            }
            this.myEndOfInitializerStates.add(state.createCopy());
        }

        @Override
        public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState state) {
            if (value == null) {
                CommonDataflowListener.$$$reportNull$$$0(1);
            }
            if (expression == null) {
                CommonDataflowListener.$$$reportNull$$$0(2);
            }
            if (state == null) {
                CommonDataflowListener.$$$reportNull$$$0(3);
            }
            this.myResult.add(new JavaExpressionAnchor(expression), state, value);
        }

        @Override
        public void beforePush(@NotNull @NotNull DfaValue @NotNull [] args, @NotNull DfaValue value, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            if (value == null) {
                CommonDataflowListener.$$$reportNull$$$0(4);
            }
            if (anchor == null) {
                CommonDataflowListener.$$$reportNull$$$0(5);
            }
            if (state == null) {
                CommonDataflowListener.$$$reportNull$$$0(6);
            }
            if (args == null) {
                CommonDataflowListener.$$$reportNull$$$0(7);
            }
            JavaDfaListener.super.beforePush(args, value, anchor, state);
            if (anchor instanceof JavaMethodReferenceArgumentAnchor || anchor instanceof JavaPolyadicPartAnchor || anchor instanceof JavaMethodReferenceReturnAnchor) {
                this.myResult.add((JavaDfaAnchor)anchor, state, value);
            }
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            if (problem == null) {
                CommonDataflowListener.$$$reportNull$$$0(8);
            }
            if (value == null) {
                CommonDataflowListener.$$$reportNull$$$0(9);
            }
            if (failed == null) {
                CommonDataflowListener.$$$reportNull$$$0(10);
            }
            if (state == null) {
                CommonDataflowListener.$$$reportNull$$$0(11);
            }
            if (problem instanceof ContractFailureProblem && failed != ThreeState.NO) {
                this.myResult.add(new JavaExpressionAnchor((PsiExpression)((ContractFailureProblem)problem).getAnchor()), state, (DfaValue)value.getFactory().fromDfType(DfType.FAIL));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failed";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/CommonDataflow$CommonDataflowListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeInstanceInitializerEnd";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeExpressionPush";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePush";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCondition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DataflowPoint {
        @NotNull
        DfType myDfType = DfType.BOTTOM;
        @Nullable
        Set<Object> myPossibleValues = Collections.emptySet();
        boolean myMayFailByContract = false;

        DataflowPoint() {
        }

        DataflowPoint(DataflowPoint other) {
            this.myDfType = other.myDfType;
            this.myPossibleValues = other.myPossibleValues;
            this.myMayFailByContract = other.myMayFailByContract;
        }

        void addValue(DfaMemoryState memState, DfaValue value) {
            if (this.myPossibleValues == null) {
                return;
            }
            DfType dfType = memState.getDfType(value);
            Object newValue = dfType.getConstantOfType(Object.class);
            if (newValue == null && !dfType.equals((Object)DfTypes.NULL)) {
                this.myPossibleValues = null;
                return;
            }
            if (this.myPossibleValues.contains(newValue)) {
                return;
            }
            if (this.myPossibleValues.isEmpty()) {
                this.myPossibleValues = Collections.singleton(newValue);
            } else {
                this.myPossibleValues = new HashSet<Object>(this.myPossibleValues);
                this.myPossibleValues.add(newValue);
            }
        }

        void addFacts(DfaMemoryState memState, DfaValue value) {
            if (this.myDfType == DfType.TOP) {
                return;
            }
            DfType newType = memState.getDfTypeIncludingDerived(value);
            this.myDfType = this.myDfType.join(newType);
        }
    }
}

