/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.psi.PsiMethod;
import com.siyeh.ig.callMatcher.CallMatcher;

public final class ConsumedStreamUtils {
    private static final CallMatcher ON_CLOSE_STREAM = CallMatcher.instanceCall("java.util.stream.BaseStream", "onClose");
    private static final CallMatcher CLOSE_STREAM_MATCHERS = CallMatcher.instanceCall("java.util.stream.BaseStream", "close");
    private static final CallMatcher SKIP_STREAM = CallMatcher.instanceCall("java.util.stream.BaseStream", "parallel", "sequential").parameterCount(0);
    private static final CallMatcher MARK_AND_CONSUMED_STREAM = CallMatcher.instanceCall("java.util.stream.BaseStream", "iterator", "spliterator", "forEach", "forEachOrdered", "toArray", "reduce", "collect", "sum", "min", "max", "count", "average", "summaryStatistics", "anyMatch", "allMatch", "nonMatch", "findFirst", "findAny", "toList", "filter", "map", "mapToObj", "mapToInt", "mapToLong", "mapToDouble", "flatMap", "flatMapToInt", "flatMapToLong", "flatMapToDouble", "mapMulti", "mapMultiToInt", "mapMultiToLong", "mapMultiToDouble", "distinct", "sorted", "peek", "limit", "skip", "takeWhile", "dropWhile", "asLongStream", "asDoubleStream", "boxed");
    private static final CallMatcher CALL_TO_MARK_CONSUMED = CallMatcher.anyOf(MARK_AND_CONSUMED_STREAM, CLOSE_STREAM_MATCHERS);
    private static final CallMatcher NONE_LEAKS_STREAM = CallMatcher.anyOf(MARK_AND_CONSUMED_STREAM, CLOSE_STREAM_MATCHERS, ON_CLOSE_STREAM, SKIP_STREAM);
    private static final CallMatcher IS_CHECKED_CALL = CallMatcher.anyOf(MARK_AND_CONSUMED_STREAM, ON_CLOSE_STREAM);

    public static boolean isCheckedCallForConsumedStream(PsiMethod method) {
        return IS_CHECKED_CALL.methodMatches(method);
    }

    public static CallMatcher getSkipStreamMatchers() {
        return SKIP_STREAM;
    }

    public static CallMatcher getCallToMarkConsumedStreamMatchers() {
        return CALL_TO_MARK_CONSUMED;
    }

    public static CallMatcher getAllNonLeakStreamMatchers() {
        return NONE_LEAKS_STREAM;
    }
}

