/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.java.inst.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.java.inst.ThrowInstruction;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ContractChecker {
    ContractChecker() {
    }

    static Map<PsiElement, @InspectionMessage String> checkContractClause(PsiMethod method, StandardMethodContract contract, boolean ownContract) {
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return Collections.emptyMap();
        }
        DfaValueFactory factory = new DfaValueFactory(method.getProject());
        ControlFlow flow = ControlFlowAnalyzer.buildFlow((PsiElement)body, factory, true);
        if (flow == null) {
            return Collections.emptyMap();
        }
        final ContractCheckListener interceptor = new ContractCheckListener(method, contract, ownContract);
        StandardDataFlowInterpreter interpreter = new StandardDataFlowInterpreter(flow, interceptor, true){

            protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
                if (instructionState == null) {
                    1.$$$reportNull$$$0(0);
                }
                Instruction instruction = instructionState.getInstruction();
                DfaMemoryState memState = instructionState.getMemoryState();
                if (instruction instanceof ThrowInstruction) {
                    ContainerUtil.addIfNotNull(interceptor.myFailures, (Object)((ThrowInstruction)instruction).getAnchor());
                } else if (instruction instanceof ReturnInstruction) {
                    interceptor.myMayReturnNormally = true;
                } else if (instruction instanceof MethodCallInstruction) {
                    PsiCall call = ((MethodCallInstruction)instruction).getCallExpression();
                    if (!memState.isEphemeral() && call != null) {
                        if (interceptor.myContract.getReturnValue().isFail()) {
                            interceptor.myFailures.add((PsiElement)call);
                            if (DfaInstructionState.EMPTY_ARRAY == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return DfaInstructionState.EMPTY_ARRAY;
                        }
                        if (ContractCheckListener.weCannotInferAnythingAboutMethodReturnValue((MethodCallInstruction)instruction)) {
                            DfaInstructionState[] states;
                            for (DfaInstructionState state : states = super.acceptInstruction(instructionState)) {
                                state.getMemoryState().markEphemeral();
                            }
                            if (states == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return states;
                        }
                    }
                }
                DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(instructionState);
                if (dfaInstructionStateArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return dfaInstructionStateArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instructionState";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/ContractChecker$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractChecker$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "acceptInstruction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "acceptInstruction";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3 -> new IllegalStateException(string);
                };
            }
        };
        PsiParameter[] parameters = method.getParameterList().getParameters();
        DfaMemoryState initialState = DfaUtil.createStateWithEnabledAssertions(factory);
        for (int i = 0; i < contract.getParameterCount(); ++i) {
            StandardMethodContract.ValueConstraint constraint = contract.getParameterConstraint(i);
            DfaValue comparisonValue = constraint.getComparisonValue(factory);
            if (comparisonValue == null) continue;
            boolean negated = constraint.shouldUseNonEqComparison();
            DfaVariableValue dfaParam = PlainDescriptor.createVariableValue(factory, (PsiVariable)parameters[i]);
            initialState.applyCondition(dfaParam.cond(RelationType.equivalence((!negated ? 1 : 0) != 0), comparisonValue));
        }
        interpreter.interpret(initialState);
        return interceptor.getErrors();
    }

    private static class ContractCheckListener
    implements JavaDfaListener {
        private final PsiMethod myMethod;
        private final StandardMethodContract myContract;
        private final boolean myOwnContract;
        private final Set<PsiElement> myViolations = new HashSet<PsiElement>();
        private final Set<PsiElement> myNonViolations = new HashSet<PsiElement>();
        private final Set<PsiElement> myFailures = new HashSet<PsiElement>();
        private boolean myMayReturnNormally = false;

        ContractCheckListener(PsiMethod method, StandardMethodContract contract, boolean ownContract) {
            this.myMethod = method;
            this.myContract = contract;
            this.myOwnContract = ownContract;
        }

        @Override
        public void beforeValueReturn(@NotNull DfaValue value, @Nullable PsiExpression expression, @NotNull PsiElement context, @NotNull DfaMemoryState state) {
            if (value == null) {
                ContractCheckListener.$$$reportNull$$$0(0);
            }
            if (context == null) {
                ContractCheckListener.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ContractCheckListener.$$$reportNull$$$0(2);
            }
            if (context != this.myMethod || expression == null || state.isEphemeral()) {
                return;
            }
            if (!this.myContract.getReturnValue().isValueCompatible(state, value)) {
                this.myViolations.add((PsiElement)expression);
            } else {
                this.myNonViolations.add((PsiElement)expression);
            }
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            if (problem == null) {
                ContractCheckListener.$$$reportNull$$$0(3);
            }
            if (value == null) {
                ContractCheckListener.$$$reportNull$$$0(4);
            }
            if (failed == null) {
                ContractCheckListener.$$$reportNull$$$0(5);
            }
            if (state == null) {
                ContractCheckListener.$$$reportNull$$$0(6);
            }
            if (problem instanceof ContractFailureProblem && failed != ThreeState.NO) {
                ContainerUtil.addIfNotNull(this.myFailures, (Object)((PsiExpression)((ContractFailureProblem)problem).getAnchor()));
            }
        }

        private Map<PsiElement, @InspectionMessage String> getErrors() {
            HashMap<PsiElement, @InspectionMessage String> errors = new HashMap<PsiElement, String>();
            for (PsiElement element : this.myViolations) {
                if (this.myNonViolations.contains(element)) continue;
                errors.put(element, JavaAnalysisBundle.message((String)"inspection.contract.checker.contract.violated", (Object[])new Object[]{this.myContract}));
            }
            if (!this.myContract.getReturnValue().isFail()) {
                if (!(!this.myOwnContract || this.myMayReturnNormally || PsiUtil.canBeOverridden((PsiMethod)this.myMethod) && ControlFlowUtils.methodAlwaysThrowsException(this.myMethod))) {
                    for (PsiElement element : this.myFailures) {
                        if (this.myContract.isTrivial()) {
                            errors.put(element, JavaAnalysisBundle.message((String)"inspection.contract.checker.method.always.fails.trivial", (Object[])new Object[]{this.myContract}));
                            continue;
                        }
                        errors.put(element, JavaAnalysisBundle.message((String)"inspection.contract.checker.method.always.fails.nontrivial", (Object[])new Object[]{this.myContract}));
                    }
                }
            } else if (this.myFailures.isEmpty() && errors.isEmpty() && this.myMayReturnNormally) {
                PsiIdentifier nameIdentifier = this.myMethod.getNameIdentifier();
                errors.put((PsiElement)(nameIdentifier != null ? nameIdentifier : this.myMethod), JavaAnalysisBundle.message((String)"inspection.contract.checker.no.exception.thrown", (Object[])new Object[]{this.myContract}));
            }
            return errors;
        }

        private static boolean weCannotInferAnythingAboutMethodReturnValue(MethodCallInstruction instruction) {
            PsiMethod target = instruction.getTargetMethod();
            return instruction.getContracts().isEmpty() && target != null && !target.isConstructor() && !NullableNotNullManager.isNotNull((PsiModifierListOwner)target);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "failed";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/ContractChecker$ContractCheckListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeValueReturn";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCondition";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

