/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeType;
import com.intellij.codeInspection.dataFlow.types.DfBooleanType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.ChronoUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomMethodHandlers {
    private static final CallMatcher CONSTANT_CALLS = CallMatcher.anyOf(CallMatcher.exactInstanceCall("java.lang.String", "contains", "indexOf", "startsWith", "endsWith", "lastIndexOf", "length", "trim", "substring", "equals", "equalsIgnoreCase", "charAt", "codePointAt", "compareTo", "replace", "strip", "stripLeading", "stripTrailing", "isBlank"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterCount(1), CallMatcher.staticCall("java.lang.Math", "abs", "sqrt", "min", "max", "addExact", "absExact", "subtractExact", "multiplyExact", "incrementExact", "decrementExact", "toIntExact", "negateExact", "sin", "cos", "tan", "asin", "acos", "atan", "cbrt", "hypot", "exp", "pow", "log", "log10"), CallMatcher.staticCall("java.lang.StrictMath", "abs", "sqrt", "min", "max", "addExact", "absExact", "subtractExact", "multiplyExact", "incrementExact", "decrementExact", "toIntExact", "negateExact", "sin", "cos", "tan", "asin", "acos", "atan", "cbrt", "hypot", "exp", "pow", "log", "log10"), CallMatcher.staticCall("java.lang.Integer", "toString", "toBinaryString", "toHexString", "toOctalString", "toUnsignedString").parameterTypes("int"), CallMatcher.staticCall("java.lang.Long", "toString", "toBinaryString", "toHexString", "toOctalString", "toUnsignedString").parameterTypes("long"), CallMatcher.staticCall("java.lang.Double", "toString", "toHexString").parameterTypes("double"), CallMatcher.staticCall("java.lang.Float", "toString", "toHexString").parameterTypes("float"), CallMatcher.staticCall("java.lang.Byte", "toString").parameterTypes("byte"), CallMatcher.staticCall("java.lang.Short", "toString").parameterTypes("short"), CallMatcher.staticCall("java.lang.Boolean", "parseBoolean").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Integer", "parseInt").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Long", "parseLong").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Double", "parseDouble").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Float", "parseFloat").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Byte", "parseByte").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Short", "parseShort").parameterTypes("java.lang.String"), CallMatcher.staticCall("java.lang.Integer", "compare", "compareUnsigned").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "compare", "compareUnsigned").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Double", "compare").parameterTypes("double", "double"), CallMatcher.staticCall("java.lang.Float", "compare").parameterTypes("float", "float"), CallMatcher.staticCall("java.lang.Byte", "compare", "compareUnsigned").parameterTypes("byte", "byte"), CallMatcher.staticCall("java.lang.Short", "compare", "compareUnsigned").parameterTypes("short", "short"), CallMatcher.staticCall("java.lang.Boolean", "compare").parameterTypes("boolean", "boolean"), CallMatcher.exactInstanceCall("java.lang.Integer", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Long", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Double", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Float", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Byte", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Short", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Character", "toString").parameterCount(0), CallMatcher.exactInstanceCall("java.lang.Boolean", "toString").parameterCount(0));
    public static final int MAX_STRING_CONSTANT_LENGTH_TO_TRACK = 256;
    private static final CallMapper<CustomMethodHandler> CUSTOM_METHOD_HANDLERS = new CallMapper<CustomMethodHandler>().register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "indexOf", "lastIndexOf"), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.STRING_LENGTH))).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "trim", "strip", "stripLeading", "stripTrailing"), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.shorterOrEqualString(args.myQualifier, memState, factory))).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "indexOf", "lastIndexOf"), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.indexOf(args.myQualifier, memState, factory, SpecialField.COLLECTION_SIZE))).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("int"), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, false))).register((CallMatcher)CallMatcher.staticCall("java.lang.Math", "abs").parameterTypes("long"), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.mathAbs(args.myArguments, memState, true))).register((CallMatcher)CallMatcher.exactInstanceCall("java.lang.String", "substring"), (args, memState, factory, method) -> CustomMethodHandlers.substring(args, memState, factory, method.getReturnType())).register(OptionalUtil.OPTIONAL_OF_NULLABLE, CustomMethodHandlers.toValue((args, memState, factory, method) -> SpecialField.OPTIONAL_VALUE.asDfType(memState.getDfType(args.myArguments[0])))).register((CallMatcher)CallMatcher.instanceCall("java.util.Calendar", "get").parameterTypes("int"), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.calendarGet(args, memState, factory))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "get", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.LocalTime", "get", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.LocalDateTime", "get", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.OffsetTime", "get", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.OffsetDateTime", "get", "getLong").parameterTypes("java.time.temporal.TemporalField"), CallMatcher.instanceCall("java.time.ZonedDateTime", "get", "getLong").parameterTypes("java.time.temporal.TemporalField")), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.chronoGet(args, memState, method))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.io.InputStream", "skip").parameterTypes("long"), CallMatcher.instanceCall("java.io.Reader", "skip").parameterTypes("long")), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.skip(args.myArguments, memState))).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Integer", "toString").parameterCount(1), CallMatcher.staticCall("java.lang.Long", "toString").parameterCount(1), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("int"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("long")), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsDecimalString(args, memState))).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "toHexString").parameterCount(1), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 4, 32))).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "toOctalString").parameterCount(1), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 3, 32))).register((CallMatcher)CallMatcher.staticCall("java.lang.Integer", "toBinaryString").parameterCount(1), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 1, 32))).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "toHexString").parameterCount(1), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 4, 64))).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "toOctalString").parameterCount(1), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 3, 64))).register((CallMatcher)CallMatcher.staticCall("java.lang.Long", "toBinaryString").parameterCount(1), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.numberAsString(args, memState, 1, 64))).register((CallMatcher)CallMatcher.instanceCall("java.lang.Enum", "name").parameterCount(0), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.enumName(args.myQualifier, memState, method.getReturnType()))).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "emptyList", "emptySet", "emptyMap").parameterCount(0), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.getEmptyCollectionConstant(method))).register((CallMatcher)CallMatcher.exactInstanceCall("java.lang.Class", "getName", "getSimpleName", "getCanonicalName").parameterCount(0), CustomMethodHandlers.toValue((args, memState, factory, method) -> CustomMethodHandlers.className(memState, args.myQualifier, method.getName(), method.getReturnType()))).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Collections", "singleton", "singletonList", "singletonMap"), CallMatcher.staticCall("java.util.List", "of"), CallMatcher.staticCall("java.util.Set", "of"), CallMatcher.staticCall("java.util.Map", "of", "ofEntries"), CallMatcher.staticCall("java.util.Arrays", "asList")), CustomMethodHandlers::collectionFactory).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Integer", "compare").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "compare").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Byte", "compare").parameterTypes("byte", "byte"), CallMatcher.staticCall("java.lang.Short", "compare").parameterTypes("short", "short")), CustomMethodHandlers.toValue((args, state, factory, method) -> CustomMethodHandlers.compareInteger(args, state))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Random", "nextInt").parameterTypes("int"), CallMatcher.instanceCall("java.util.SplittableRandom", "nextInt").parameterTypes("int"), CallMatcher.instanceCall("java.util.SplittableRandom", "nextInt").parameterTypes("int", "int")), CustomMethodHandlers.toValue(CustomMethodHandlers::randomNextInt)).register((CallMatcher)CallMatcher.staticCall("java.util.Arrays", "copyOf"), (arguments, state, factory, method) -> CustomMethodHandlers.copyOfArray(arguments, factory, method)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "unmodifiableCollection", "unmodifiableList", "unmodifiableSet", "unmodifiableMap", "unmodifiableSortedSet", "unmodifiableSortedMap", "unmodifiableNavigableSet", "unmodifiableNavigableMap").parameterCount(1), (arguments, state, factory, method) -> CustomMethodHandlers.unmodifiableView(arguments, factory, method)).register((CallMatcher)CallMatcher.staticCall("java.util.Collections", "checkedCollection", "checkedList", "checkedSet", "checkedMap", "checkedSortedSet", "checkedSortedMap", "checkedNavigableSet", "checkedNavigableMap", "checkedQueue", "synchronizedCollection", "synchronizedList", "synchronizedSet", "synchronizedMap", "synchronizedSortedSet", "synchronizedSortedMap", "synchronizedNavigableSet", "synchronizedNavigableMap"), (arguments, state, factory, method) -> CustomMethodHandlers.collectionView((DfaValue)ArrayUtil.getFirstElement((Object[])arguments.myArguments), factory, method)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Map", "keySet", "values", "entrySet").parameterCount(0), CallMatcher.instanceCall("java.util.NavigableSet", "descendingSet").parameterCount(0), CallMatcher.instanceCall("java.util.NavigableMap", "descendingMap").parameterCount(0)), (arguments, state, factory, method) -> CustomMethodHandlers.collectionView(arguments.myQualifier, factory, method)).register((CallMatcher)CallMatcher.instanceCall("java.util.Collection", "toArray").parameterTypes("T[]"), CustomMethodHandlers::collectionToArray).register((CallMatcher)CallMatcher.instanceCall("java.util.Collection", "toArray").parameterCount(0), CustomMethodHandlers::collectionToArray).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "toCharArray").parameterCount(0), CustomMethodHandlers::stringToCharArray).register((CallMatcher)CallMatcher.exactInstanceCall("java.lang.Object", "getClass").parameterCount(0), CustomMethodHandlers.toValue(CustomMethodHandlers::objectGetClass)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "random").parameterCount(0), CallMatcher.instanceCall("java.util.Random", "nextDouble").parameterCount(0), CallMatcher.instanceCall("java.util.SplittableRandom", "nextDouble").parameterCount(0)), CustomMethodHandlers.toValue((arguments, state, factory, method) -> DfTypes.doubleRange(0.0, Math.nextDown(1.0)))).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "sin", "cos").parameterCount(1), CallMatcher.staticCall("java.lang.StrictMath", "sin", "cos").parameterCount(1)), CustomMethodHandlers.toValue((arguments, state, factory, method) -> DfTypes.doubleRange(-1.0, 1.0).join((DfType)DfTypes.DOUBLE_NAN))).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "hypot", "sqrt", "exp").parameterCount(1), CallMatcher.staticCall("java.lang.StrictMath", "hypot", "sqrt", "exp").parameterCount(1)), CustomMethodHandlers.toValue((arguments, state, factory, method) -> DfTypes.doubleRange(0.0, Double.POSITIVE_INFINITY).join((DfType)DfTypes.DOUBLE_NAN))).register((CallMatcher)CallMatcher.instanceCall("java.util.Random", "nextFloat").parameterCount(0), CustomMethodHandlers.toValue((arguments, state, factory, method) -> DfTypes.floatRange(0.0f, Math.nextDown(1.0f)))).register((CallMatcher)CallMatcher.staticCall("java.lang.Double", "isNaN").parameterTypes("double"), CustomMethodHandlers.toValue((arguments, state, factory, method) -> CustomMethodHandlers.isNaN(arguments, state, DfTypes.DOUBLE_NAN))).register((CallMatcher)CallMatcher.staticCall("java.lang.Float", "isNaN").parameterTypes("float"), CustomMethodHandlers.toValue((arguments, state, factory, method) -> CustomMethodHandlers.isNaN(arguments, state, DfTypes.FLOAT_NAN))).register(CallMatcher.anyOf(CallMatcher.staticCall("com.google.common.collect.Lists", "newArrayList", "newLinkedList", "newCopyOnWriteArrayList").parameterCount(0), CallMatcher.staticCall("com.google.common.collect.Sets", "newHashSet", "newLinkedHashSet", "newIdentityHashSet", "newCopyOnWriteArraySet", "newConcurrentHashSet", "newTreeSet").parameterCount(0), CallMatcher.staticCall("com.google.common.collect.Maps", "newHashMap", "newLinkedHashMap", "newIdentityHashMap", "newConcurrentHashMap", "newTreeMap").parameterCount(0)), CustomMethodHandlers.toValue((arguments, state, factory, method) -> SpecialField.COLLECTION_SIZE.asDfType(DfTypes.intValue(0)).meet((DfType)DfTypes.LOCAL_OBJECT)));

    private static CustomMethodHandler toValue(DfTypeCustomMethodHandler handler) {
        return handler;
    }

    public static CustomMethodHandler find(PsiMethod method) {
        CustomMethodHandler handler = null;
        if (CustomMethodHandlers.isConstantCall(method)) {
            handler = CustomMethodHandlers.toValue((arguments, state, factory, m) -> CustomMethodHandlers.handleConstantCall(arguments, state, m));
        }
        CustomMethodHandler handler2 = CUSTOM_METHOD_HANDLERS.mapFirst(method);
        return handler == null ? handler2 : handler.compose(handler2);
    }

    @Contract(value="null -> false")
    public static boolean isConstantCall(PsiMethod method) {
        return CONSTANT_CALLS.methodMatches(method);
    }

    @NotNull
    private static DfType handleConstantCall(DfaCallArguments arguments, DfaMemoryState state, PsiMethod method) {
        Object result;
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(0);
            }
            return dfType;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Object qualifierValue = null;
        if (!method.hasModifierProperty("static") && (qualifierValue = CustomMethodHandlers.getConstantValue(state, arguments.myQualifier)) == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(1);
            }
            return dfType;
        }
        for (DfaValue argument : arguments.myArguments) {
            long longValue;
            Object argumentValue = CustomMethodHandlers.getConstantValue(state, argument);
            if (argumentValue == null) {
                DfType dfType = DfType.TOP;
                if (dfType == null) {
                    CustomMethodHandlers.$$$reportNull$$$0(2);
                }
                return dfType;
            }
            if (argumentValue instanceof Long && (longValue = ((Long)argumentValue).longValue()) >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                argumentValue = (int)longValue;
            }
            args.add(argumentValue);
        }
        Method jvmMethod = CustomMethodHandlers.toJvmMethod(method);
        if (jvmMethod == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(3);
            }
            return dfType;
        }
        try {
            result = jvmMethod.invoke(qualifierValue, args.toArray());
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof NumberFormatException || e.getCause() instanceof ArithmeticException) {
                DfType dfType = DfType.FAIL;
                if (dfType == null) {
                    CustomMethodHandlers.$$$reportNull$$$0(4);
                }
                return dfType;
            }
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(5);
            }
            return dfType;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(6);
            }
            return dfType;
        }
        DfConstantType<?> dfConstantType = DfTypes.constant(result, returnType);
        if (dfConstantType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(7);
        }
        return dfConstantType;
    }

    private static Method toJvmMethod(final PsiMethod method) {
        return (Method)CachedValuesManager.getCachedValue((PsiElement)method, (CachedValueProvider)new CachedValueProvider<Method>(){

            @NotNull
            public CachedValueProvider.Result<Method> compute() {
                Method reflection = this.getMethod();
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)reflection, (Object[])new Object[]{method});
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result;
            }

            private static Class<?> toJvmType(PsiType type) {
                if (TypeUtils.isJavaLangString(type)) {
                    return String.class;
                }
                if (TypeUtils.isJavaLangObject(type)) {
                    return Object.class;
                }
                if (TypeUtils.typeEquals("java.lang.CharSequence", type)) {
                    return CharSequence.class;
                }
                if (PsiTypes.intType().equals((Object)type)) {
                    return Integer.TYPE;
                }
                if (PsiTypes.booleanType().equals((Object)type)) {
                    return Boolean.TYPE;
                }
                if (PsiTypes.byteType().equals((Object)type)) {
                    return Byte.TYPE;
                }
                if (PsiTypes.shortType().equals((Object)type)) {
                    return Short.TYPE;
                }
                if (PsiTypes.charType().equals((Object)type)) {
                    return Character.TYPE;
                }
                if (PsiTypes.longType().equals((Object)type)) {
                    return Long.TYPE;
                }
                if (PsiTypes.floatType().equals((Object)type)) {
                    return Float.TYPE;
                }
                if (PsiTypes.doubleType().equals((Object)type)) {
                    return Double.TYPE;
                }
                return null;
            }

            @Nullable
            private Method getMethod() {
                Class<?> containingClass;
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return null;
                }
                try {
                    containingClass = Class.forName(aClass.getQualifiedName());
                }
                catch (ClassNotFoundException ignored) {
                    return null;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                Class[] parameterTypes = new Class[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    PsiParameter parameter = parameters[i];
                    PsiType type = parameter.getType();
                    Class<?> jvmType = 1.toJvmType(type);
                    if (jvmType == null) {
                        return null;
                    }
                    parameterTypes[i] = jvmType;
                }
                return ReflectionUtil.getMethod(containingClass, (String)method.getName(), (Class[])parameterTypes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/CustomMethodHandlers$1", "compute"));
            }
        });
    }

    @NotNull
    private static DfType indexOf(DfaValue qualifier, DfaMemoryState memState, DfaValueFactory factory, SpecialField specialField) {
        DfaValue length = specialField.createValue(factory, qualifier);
        LongRangeSet range = DfIntType.extractRange(memState.getDfType(length));
        DfType dfType = DfTypes.intRange(LongRangeSet.range((long)-1L, (long)(range.max() - 1L)));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    @NotNull
    private static DfType shorterOrEqualString(DfaValue qualifier, DfaMemoryState memState, DfaValueFactory factory) {
        DfaValue length = SpecialField.STRING_LENGTH.createValue(factory, qualifier);
        LongRangeSet range = DfIntType.extractRange(memState.getDfType(length));
        DfType dfType = SpecialField.STRING_LENGTH.asDfType(DfTypes.intRange(LongRangeSet.range((long)0L, (long)range.max())));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(9);
        }
        return dfType;
    }

    @Nullable
    private static DfaValue copyOfArray(DfaCallArguments arguments, DfaValueFactory factory, PsiMethod method) {
        if (arguments.myArguments.length < 2) {
            return null;
        }
        return factory.getWrapperFactory().createWrapper(DfTypes.typedObject(method.getReturnType(), Nullability.NOT_NULL).meet((DfType)DfTypes.LOCAL_OBJECT), (DerivedVariableDescriptor)SpecialField.ARRAY_LENGTH, arguments.myArguments[1]);
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null")
    private static DfaValue collectionView(@Nullable DfaValue orig, @NotNull DfaValueFactory factory, @NotNull PsiMethod method) {
        if (factory == null) {
            CustomMethodHandlers.$$$reportNull$$$0(10);
        }
        if (method == null) {
            CustomMethodHandlers.$$$reportNull$$$0(11);
        }
        if (orig == null) {
            return null;
        }
        return factory.getWrapperFactory().createWrapper(DfTypes.typedObject(method.getReturnType(), Nullability.NOT_NULL), (DerivedVariableDescriptor)SpecialField.COLLECTION_SIZE, SpecialField.COLLECTION_SIZE.createValue(factory, orig));
    }

    @Nullable
    private static DfaValue unmodifiableView(@NotNull DfaCallArguments arguments, @NotNull DfaValueFactory factory, @NotNull PsiMethod method) {
        if (arguments == null) {
            CustomMethodHandlers.$$$reportNull$$$0(12);
        }
        if (factory == null) {
            CustomMethodHandlers.$$$reportNull$$$0(13);
        }
        if (method == null) {
            CustomMethodHandlers.$$$reportNull$$$0(14);
        }
        if (arguments.myArguments.length != 1) {
            return null;
        }
        return factory.getWrapperFactory().createWrapper(DfTypes.typedObject(method.getReturnType(), Nullability.NOT_NULL).meet((DfType)Mutability.UNMODIFIABLE_VIEW.asDfType()), (DerivedVariableDescriptor)SpecialField.COLLECTION_SIZE, SpecialField.COLLECTION_SIZE.createValue(factory, arguments.myArguments[0]));
    }

    @Nullable
    private static DfaValue collectionFactory(DfaCallArguments args, DfaMemoryState memState, DfaValueFactory factory, PsiMethod method) {
        PsiType type = method.getReturnType();
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        int factor = PsiTypesUtil.classNameEquals((PsiType)type, (String)"java.util.Map") ? 2 : 1;
        Object size = method.isVarArgs() ? SpecialField.ARRAY_LENGTH.createValue(factory, args.myArguments[0]) : factory.fromDfType((DfType)DfTypes.intValue(args.myArguments.length / factor));
        boolean asList = method.getName().equals("asList");
        Mutability mutability = asList ? Mutability.MUTABLE : Mutability.UNMODIFIABLE;
        DfType result = DfTypes.typedObject(type, Nullability.NOT_NULL).meet((DfType)mutability.asDfType());
        if (asList) {
            result = result.meet((DfType)DfTypes.LOCAL_OBJECT);
        }
        return factory.getWrapperFactory().createWrapper(result, (DerivedVariableDescriptor)SpecialField.COLLECTION_SIZE, size);
    }

    private static DfType getEmptyCollectionConstant(PsiMethod method) {
        String fieldName = "EMPTY_" + method.getName().substring("empty".length()).toUpperCase(Locale.ROOT);
        PsiClass collectionsClass = method.getContainingClass();
        if (collectionsClass == null) {
            return DfType.TOP;
        }
        PsiField field = collectionsClass.findFieldByName(fieldName, false);
        if (field == null) {
            return DfType.TOP;
        }
        return DfTypes.referenceConstant((Object)field, field.getType());
    }

    @Nullable
    private static DfaValue substring(DfaCallArguments args, DfaMemoryState state, DfaValueFactory factory, PsiType stringType) {
        if (stringType == null || !stringType.equalsToText("java.lang.String")) {
            return null;
        }
        DfaValue qualifier = args.myQualifier;
        DfaValue[] arguments = args.myArguments;
        if (arguments.length < 1 || arguments.length > 2 || arguments[0] == null) {
            return null;
        }
        DfaValue from = arguments[0];
        DfaValue lenVal = SpecialField.STRING_LENGTH.createValue(factory, qualifier);
        DfaValue to = arguments.length == 1 ? lenVal : arguments[1];
        DfaValue resultLen = factory.getBinOpFactory().create(to, from, state, (DfIntegralType)DfTypes.INT, LongRangeBinOp.MINUS);
        if (resultLen instanceof DfaBinOpValue) {
            resultLen = factory.fromDfType(state.getDfType(resultLen));
        }
        return factory.getWrapperFactory().createWrapper(DfTypes.typedObject(stringType, Nullability.NOT_NULL), (DerivedVariableDescriptor)SpecialField.STRING_LENGTH, resultLen);
    }

    @NotNull
    private static DfType mathAbs(DfaValue[] args, DfaMemoryState memState, boolean isLong) {
        DfaValue arg = (DfaValue)ArrayUtil.getFirstElement((Object[])args);
        if (arg == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(15);
            }
            return dfType;
        }
        DfType type = memState.getDfType(arg);
        LongRangeSet range = isLong ? DfLongType.extractRange(type) : DfIntType.extractRange(type);
        DfType dfType = isLong ? DfTypes.longRange(range.abs(LongRangeType.INT64)) : DfTypes.intRange(range.abs(LongRangeType.INT32));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(16);
        }
        return dfType;
    }

    @NotNull
    private static DfType chronoGet(DfaCallArguments arguments, DfaMemoryState state, PsiMethod method) {
        DfaValue[] myArguments = arguments.myArguments;
        if (myArguments.length != 1 || myArguments[0] == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(17);
            }
            return dfType;
        }
        DfType myArgument = state.getDfType(myArguments[0]);
        PsiEnumConstant enumConstant = (PsiEnumConstant)myArgument.getConstantOfType(PsiEnumConstant.class);
        if (enumConstant == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(18);
            }
            return dfType;
        }
        PsiType enumType = enumConstant.getType();
        if (!enumType.equalsToText("java.time.temporal.ChronoField")) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(19);
            }
            return dfType;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(20);
            }
            return dfType;
        }
        ChronoField myChronoField = ChronoUtil.getChronoField(enumConstant.getName());
        if (myChronoField == null || !ChronoUtil.isAnyGetSupported(method, myChronoField)) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(21);
            }
            return dfType;
        }
        LongRangeSet range = LongRangeSet.range((long)myChronoField.range().getMinimum(), (long)myChronoField.range().getMaximum());
        String methodName = method.getName();
        if ("get".equals(methodName)) {
            DfType dfType = DfTypes.intRange(range);
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(22);
            }
            return dfType;
        }
        if ("getLong".equals(methodName)) {
            DfType dfType = DfTypes.longRange(range);
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(23);
            }
            return dfType;
        }
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(24);
        }
        return dfType;
    }

    @NotNull
    private static DfType calendarGet(DfaCallArguments arguments, DfaMemoryState state, DfaValueFactory factory) {
        if (arguments.myArguments.length != 1) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(25);
            }
            return dfType;
        }
        Integer val = (Integer)state.getDfType(arguments.myArguments[0]).getConstantOfType(Integer.class);
        if (val == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(26);
            }
            return dfType;
        }
        LongRangeSet range = switch (val) {
            case 5 -> LongRangeSet.range((long)1L, (long)31L);
            case 2 -> {
                PsiType type = TypeConstraint.fromDfType(state.getDfType(arguments.myQualifier)).getPsiType(factory.getProject());
                if (TypeUtils.typeEquals("java.util.GregorianCalendar", type)) {
                    yield LongRangeSet.range((long)0L, (long)11L);
                }
                yield LongRangeSet.range((long)0L, (long)12L);
            }
            case 9 -> LongRangeSet.range((long)0L, (long)1L);
            case 6 -> LongRangeSet.range((long)1L, (long)366L);
            case 10 -> LongRangeSet.range((long)0L, (long)11L);
            case 11 -> LongRangeSet.range((long)0L, (long)23L);
            case 12, 13 -> LongRangeSet.range((long)0L, (long)59L);
            case 14 -> LongRangeSet.range((long)0L, (long)999L);
            default -> null;
        };
        DfType dfType = range == null ? DfType.TOP : DfTypes.intRange(range);
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(27);
        }
        return dfType;
    }

    @NotNull
    private static DfType skip(DfaValue[] arguments, DfaMemoryState state) {
        if (arguments.length != 1) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(28);
            }
            return dfType;
        }
        LongRangeSet range = DfLongType.extractRange(state.getDfType(arguments[0]));
        DfType dfType = DfTypes.longRange(LongRangeSet.range((long)0L, (long)Math.max(0L, range.max())));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(29);
        }
        return dfType;
    }

    @NotNull
    private static DfType numberAsDecimalString(DfaCallArguments args, DfaMemoryState state) {
        DfaValue arg = args.myArguments[0];
        if (arg == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(30);
            }
            return dfType;
        }
        return CustomMethodHandlers.numberAsDecimalString(state, arg);
    }

    @NotNull
    public static DfType numberAsDecimalString(@NotNull DfaMemoryState state, @NotNull DfaValue arg) {
        LongRangeSet range;
        if (state == null) {
            CustomMethodHandlers.$$$reportNull$$$0(31);
        }
        if (arg == null) {
            CustomMethodHandlers.$$$reportNull$$$0(32);
        }
        if ((range = DfLongType.extractRange(state.getDfType(arg))).isEmpty()) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(33);
            }
            return dfType;
        }
        long min = range.min();
        long max = range.max();
        DfType length = min >= 0L ? DfTypes.intRange(LongRangeSet.range((long)String.valueOf(min).length(), (long)String.valueOf(max).length())) : (max <= 0L ? DfTypes.intRange(LongRangeSet.range((long)String.valueOf(max).length(), (long)String.valueOf(min).length())) : DfTypes.intRange(LongRangeSet.range((long)1L, (long)Math.max(String.valueOf(max).length(), String.valueOf(min).length()))));
        DfType dfType = SpecialField.STRING_LENGTH.asDfType(length);
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(34);
        }
        return dfType;
    }

    @NotNull
    private static DfType numberAsString(DfaCallArguments args, DfaMemoryState state, int bitsPerChar, int maxBits) {
        DfaValue arg = args.myArguments[0];
        if (arg == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(35);
            }
            return dfType;
        }
        LongRangeSet range = DfLongType.extractRange(state.getDfType(arg));
        int usedBits = range.min() >= 0L ? 64 - Long.numberOfLeadingZeros(range.max()) : maxBits;
        int max = Math.max(1, (usedBits - 1) / bitsPerChar + 1);
        DfType dfType = SpecialField.STRING_LENGTH.asDfType(DfTypes.intRange(LongRangeSet.range((long)1L, (long)max)));
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(36);
        }
        return dfType;
    }

    @NotNull
    private static DfType enumName(DfaValue qualifier, DfaMemoryState state, PsiType type) {
        DfType dfType = state.getDfType(qualifier);
        PsiEnumConstant value = (PsiEnumConstant)dfType.getConstantOfType(PsiEnumConstant.class);
        if (value != null) {
            DfConstantType<?> dfConstantType = DfTypes.referenceConstant((Object)value.getName(), type);
            if (dfConstantType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(37);
            }
            return dfConstantType;
        }
        DfType dfType2 = DfType.TOP;
        if (dfType2 == null) {
            CustomMethodHandlers.$$$reportNull$$$0(38);
        }
        return dfType2;
    }

    @NotNull
    private static DfType objectGetClass(DfaCallArguments arguments, DfaMemoryState state, DfaValueFactory factory, PsiMethod method) {
        DfaValue qualifier = arguments.myQualifier;
        TypeConstraint fact = TypeConstraint.fromDfType(state.getDfType(qualifier));
        if (fact instanceof TypeConstraint.Exact && !(fact instanceof TypeConstraints.ExactSubclass)) {
            PsiType qualifierType = fact.getPsiType(factory.getProject());
            PsiType classType = method.getReturnType();
            if (classType != null && qualifierType != null) {
                DfConstantType<?> dfConstantType = DfTypes.referenceConstant((Object)qualifierType, classType);
                if (dfConstantType == null) {
                    CustomMethodHandlers.$$$reportNull$$$0(39);
                }
                return dfConstantType;
            }
        }
        DfType dfType = SpecialField.INSTANTIABLE_CLASS.asDfType(DfTypes.TRUE);
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(40);
        }
        return dfType;
    }

    private static Object getConstantValue(DfaMemoryState memoryState, DfaValue value) {
        DfType type = DfaUtil.getUnboxedDfType(memoryState, value);
        Object constant = type.getConstantOfType(Object.class);
        if (constant instanceof String && ((String)constant).length() > 256) {
            return null;
        }
        return constant;
    }

    @NotNull
    private static DfType randomNextInt(DfaCallArguments arguments, DfaMemoryState state, DfaValueFactory factory, PsiMethod method) {
        LongRangeSet fromUpperBound;
        LongRangeSet fromLowerBound;
        DfaValue[] values = arguments.myArguments;
        if (values == null) {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(41);
            }
            return dfType;
        }
        if (values.length == 1) {
            fromLowerBound = LongRangeSet.range((long)0L, (long)0x7FFFFFFEL);
            fromUpperBound = DfIntType.extractRange(state.getDfType(values[0])).fromRelation(RelationType.LT);
        } else if (values.length == 2) {
            fromLowerBound = DfIntType.extractRange(state.getDfType(values[0])).fromRelation(RelationType.GE);
            fromUpperBound = DfIntType.extractRange(state.getDfType(values[1])).fromRelation(RelationType.LT);
        } else {
            DfType dfType = DfType.TOP;
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(42);
            }
            return dfType;
        }
        LongRangeSet intersection = fromLowerBound.meet(fromUpperBound);
        DfType dfType = DfTypes.intRangeClamped(intersection);
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(43);
        }
        return dfType;
    }

    @NotNull
    private static DfType className(DfaMemoryState memState, DfaValue qualifier, String name, PsiType stringType) {
        PsiClass psiClass;
        PsiClassType type = (PsiClassType)memState.getDfType(qualifier).getConstantOfType(PsiClassType.class);
        if (type != null && (psiClass = type.resolve()) != null) {
            String result = switch (name) {
                case "getSimpleName" -> {
                    if (psiClass instanceof PsiAnonymousClass) {
                        yield "";
                    }
                    yield psiClass.getName();
                }
                case "getName" -> {
                    if (PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass)) {
                        yield null;
                    }
                    yield ClassUtil.getJVMClassName((PsiClass)psiClass);
                }
                default -> psiClass.getQualifiedName();
            };
            DfType dfType = result == null && !name.equals("getCanonicalName") ? DfType.TOP : DfTypes.constant((Object)result, stringType);
            if (dfType == null) {
                CustomMethodHandlers.$$$reportNull$$$0(44);
            }
            return dfType;
        }
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(45);
        }
        return dfType;
    }

    private static DfType compareInteger(DfaCallArguments args, DfaMemoryState state) {
        DfaValue[] arguments = args.myArguments;
        if (arguments.length != 2) {
            return DfType.TOP;
        }
        RelationType relation = state.getRelation(arguments[0], arguments[1]);
        if (relation == null) {
            LongRangeSet left = DfLongType.extractRange(state.getDfType(arguments[0]));
            LongRangeSet right = DfLongType.extractRange(state.getDfType(arguments[1]));
            if (left.isEmpty() || right.isEmpty()) {
                return DfType.BOTTOM;
            }
            if (left.max() < right.min()) {
                relation = RelationType.LT;
            } else if (left.max() <= right.min()) {
                relation = RelationType.LE;
            } else if (left.min() > right.max()) {
                relation = RelationType.GT;
            } else if (left.min() >= right.max()) {
                relation = RelationType.GE;
            } else if (!left.intersects(right)) {
                relation = RelationType.NE;
            } else if (left.getConstantValue() != null && left.equals(right)) {
                relation = RelationType.EQ;
            }
        }
        if (relation != null) {
            return DfTypes.intRangeClamped(LongRangeSet.point((long)0L).fromRelation(relation));
        }
        return DfType.TOP;
    }

    @NotNull
    private static DfaValue collectionToArray(DfaCallArguments arguments, DfaMemoryState state, DfaValueFactory factory, PsiMethod method) {
        PsiType type;
        DfType result = DfType.TOP;
        DfaValue collection = arguments.myQualifier;
        DfaValue collectionSize = SpecialField.COLLECTION_SIZE.createValue(factory, collection);
        LongRangeSet collectionSizeRange = DfIntType.extractRange(state.getDfType(collectionSize));
        DfaValue finalSize = collectionSize;
        if (arguments.myArguments.length == 1) {
            DfaValue arrayLength;
            DfaValue array = arguments.myArguments[0];
            DfType arrType = state.getDfType(array);
            TypeConstraint constraint = TypeConstraint.fromDfType(arrType);
            if (constraint.isExact()) {
                result = constraint.asDfType();
            }
            if (!state.areEqual(arrayLength = SpecialField.ARRAY_LENGTH.createValue(factory, array), collectionSize)) {
                LongRangeSet arraySizeRange = DfIntType.extractRange(state.getDfType(arrayLength));
                LongRangeSet biggerArrays = collectionSizeRange.fromRelation(RelationType.GT).meet(arraySizeRange);
                LongRangeSet biggerCollections = arraySizeRange.fromRelation(RelationType.GE).meet(collectionSizeRange);
                if (!biggerArrays.isEmpty()) {
                    finalSize = factory.fromDfType(DfTypes.intRange(biggerArrays.join(biggerCollections)));
                }
            }
        } else if (arguments.myArguments.length == 0 && (type = method.getReturnType()) instanceof PsiArrayType) {
            result = TypeConstraints.exact(type).asDfType();
        }
        DfaValue dfaValue = factory.getWrapperFactory().createWrapper(result.meet((DfType)DfTypes.NOT_NULL_OBJECT), (DerivedVariableDescriptor)SpecialField.ARRAY_LENGTH, finalSize);
        if (dfaValue == null) {
            CustomMethodHandlers.$$$reportNull$$$0(46);
        }
        return dfaValue;
    }

    @NotNull
    private static DfaValue stringToCharArray(DfaCallArguments arguments, DfaMemoryState state, DfaValueFactory factory, PsiMethod method) {
        DfaValue string = arguments.myQualifier;
        DfaValue stringLength = SpecialField.STRING_LENGTH.createValue(factory, string);
        DfaValue dfaValue = factory.getWrapperFactory().createWrapper(DfTypes.typedObject((PsiType)PsiTypes.charType().createArrayType(), Nullability.NOT_NULL).meet((DfType)DfTypes.LOCAL_OBJECT), (DerivedVariableDescriptor)SpecialField.ARRAY_LENGTH, stringLength);
        if (dfaValue == null) {
            CustomMethodHandlers.$$$reportNull$$$0(47);
        }
        return dfaValue;
    }

    @NotNull
    private static DfType isNaN(DfaCallArguments arguments, DfaMemoryState state, DfType nan) {
        DfType type = state.getDfType(arguments.myArguments[0]);
        DfBooleanType dfBooleanType = type.isSuperType(nan) ? (type.equals((Object)DfTypes.FLOAT_NAN) || type.equals((Object)DfTypes.DOUBLE_NAN) ? DfTypes.TRUE : DfTypes.BOOLEAN) : DfTypes.FALSE;
        if (dfBooleanType == null) {
            CustomMethodHandlers.$$$reportNull$$$0(48);
        }
        return dfBooleanType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 10, 11, 12, 13, 14, 31, 32 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/CustomMethodHandlers";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "handleConstantCall";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "indexOf";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "shorterOrEqualString";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/CustomMethodHandlers";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mathAbs";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "chronoGet";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "calendarGet";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 30: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "numberAsDecimalString";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "numberAsString";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "enumName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "objectGetClass";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "randomNextInt";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "className";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectionToArray";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToCharArray";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "isNaN";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectionView";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableView";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "numberAsDecimalString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 10, 11, 12, 13, 14, 31, 32 -> new IllegalArgumentException(string);
        };
    }

    static interface DfTypeCustomMethodHandler
    extends CustomMethodHandler {
        @NotNull
        public DfType getMethodResult(DfaCallArguments var1, DfaMemoryState var2, DfaValueFactory var3, PsiMethod var4);

        @Override
        @Nullable
        default public DfaValue getMethodResultValue(DfaCallArguments callArguments, DfaMemoryState memState, DfaValueFactory factory, PsiMethod method) {
            DfType dfType = this.getMethodResult(callArguments, memState, factory, method);
            return dfType == DfType.TOP ? null : factory.fromDfType(dfType);
        }
    }

    public static interface CustomMethodHandler {
        @Nullable
        public DfaValue getMethodResultValue(DfaCallArguments var1, DfaMemoryState var2, DfaValueFactory var3, PsiMethod var4);

        default public CustomMethodHandler compose(CustomMethodHandler other) {
            if (other == null) {
                return this;
            }
            return (args, memState, factory, method) -> {
                DfaValue result = this.getMethodResultValue(args, memState, factory, method);
                return result == null ? other.getMethodResultValue(args, memState, factory, method) : result;
            };
        }
    }
}

