/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.AddAnnotationModCommandAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DataFlowInstructionVisitor;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullParameterConstraintChecker;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.TrackingRunner;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithArgumentFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithObjectsEqualsFix;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.SwitchUtils;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class DataFlowInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    private static final String SHORT_NAME = "DataFlowIssue";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = true;
    public boolean REPORT_UNSOUND_WARNINGS = true;

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", "false"));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER").setAttribute("value", "false"));
        }
        if (!this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL").setAttribute("value", "false"));
        }
        if (!this.REPORT_UNSOUND_WARNINGS) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_UNSOUND_WARNINGS").setAttribute("value", "false"));
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(1);
        }
        return new JavaElementVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (aClass instanceof PsiTypeParameter) {
                    return;
                }
                if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass) && !(aClass instanceof PsiEnumConstantInitializer)) {
                    return;
                }
                StandardDataFlowRunner runner = new StandardDataFlowRunner(holder.getProject(), ThreeState.fromBoolean((boolean)DataFlowInspectionBase.this.IGNORE_ASSERT_STATEMENTS));
                DataFlowInstructionVisitor visitor2 = DataFlowInspectionBase.this.analyzeDfaWithNestedClosures((PsiElement)aClass, holder, runner, Collections.singletonList(runner.createMemoryState()));
                List<DfaMemoryState> states = visitor2.getEndOfInitializerStates();
                boolean physical = aClass.isPhysical();
                for (PsiMethod method : aClass.getConstructors()) {
                    if (physical && !method.isPhysical()) continue;
                    PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
                    List initialStates = JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)call) || call == null && DfaUtil.hasImplicitImpureSuperCall(aClass, method) ? Collections.singletonList(runner.createMemoryState()) : ContainerUtil.map(states, DfaMemoryState::createCopy);
                    this.analyzeMethod(method, runner, initialStates);
                }
            }

            public void visitMethod(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (method.isConstructor()) {
                    return;
                }
                StandardDataFlowRunner runner = new StandardDataFlowRunner(holder.getProject(), ThreeState.fromBoolean((boolean)DataFlowInspectionBase.this.IGNORE_ASSERT_STATEMENTS));
                this.analyzeMethod(method, runner, Collections.singletonList(runner.createMemoryState()));
            }

            private void analyzeMethod(PsiMethod method, StandardDataFlowRunner runner, List<DfaMemoryState> initialStates) {
                PsiCodeBlock scope = method.getBody();
                if (scope == null) {
                    return;
                }
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
                if (containingClass != null && PsiUtil.isLocalOrAnonymousClass((PsiClass)containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
                    return;
                }
                DataFlowInspectionBase.this.analyzeDfaWithNestedClosures((PsiElement)scope, holder, runner, initialStates);
                DataFlowInspectionBase.this.analyzeNullLiteralMethodArguments(method, holder);
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                PsiType returnType;
                PsiType methodReturnType;
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitMethodReferenceExpression(expression);
                if (!DataFlowInspectionBase.this.REPORT_UNSOUND_WARNINGS) {
                    return;
                }
                PsiElement resolve = expression.resolve();
                if (resolve instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper((PsiType)(methodReturnType = ((PsiMethod)resolve).getReturnType())) && NullableNotNullManager.isNullable((PsiModifierListOwner)((PsiMethod)resolve)) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)(returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)expression)))) {
                    holder.registerProblem((PsiElement)expression, JavaAnalysisBundle.message((String)"dataflow.message.unboxing.method.reference", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private void analyzeNullLiteralMethodArguments(PsiMethod method, ProblemsHolder holder) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && holder.isOnTheFly()) {
            for (PsiParameter parameter : NullParameterConstraintChecker.checkMethodParameters(method)) {
                PsiIdentifier name = parameter.getNameIdentifier();
                if (name == null) continue;
                holder.registerProblem((PsiElement)name, JavaAnalysisBundle.message((String)"dataflow.method.fails.with.null.argument", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{this.createNavigateToNullParameterUsagesFix(parameter)});
            }
        }
    }

    private DataFlowInstructionVisitor analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, StandardDataFlowRunner dfaRunner, Collection<? extends DfaMemoryState> initialStates) {
        DataFlowInstructionVisitor visitor2 = new DataFlowInstructionVisitor(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE);
        ControlFlow flow = dfaRunner.buildFlow(scope);
        if (flow == null) {
            return visitor2;
        }
        visitor2.initInstanceOf(flow.getInstructions());
        RunnerResult rc = dfaRunner.analyzeFlow(scope, visitor2, initialStates, flow);
        if (rc == RunnerResult.OK) {
            if (dfaRunner.wasForciblyMerged() && (ApplicationManager.getApplication().isUnitTestMode() || Registry.is((String)"ide.dfa.report.imprecise"))) {
                DataFlowInspectionBase.reportAnalysisQualityProblem(holder, scope, "dataflow.not.precise");
            }
            this.createDescription(holder, visitor2, scope, flow.getInstructions());
            dfaRunner.forNestedClosures((closure, states) -> this.analyzeDfaWithNestedClosures((PsiElement)closure, holder, dfaRunner, (Collection<? extends DfaMemoryState>)states));
        } else if (rc == RunnerResult.TOO_COMPLEX) {
            DataFlowInspectionBase.reportAnalysisQualityProblem(holder, scope, "dataflow.too.complex");
        }
        return visitor2;
    }

    private static void reportAnalysisQualityProblem(ProblemsHolder holder, PsiElement scope, @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") @PropertyKey(resourceBundle="messages.JavaAnalysisBundle") String problemKey) {
        PsiIdentifier name = null;
        String message = null;
        if (scope.getParent() instanceof PsiMethod) {
            name = ((PsiMethod)scope.getParent()).getNameIdentifier();
            message = JavaAnalysisBundle.message((String)problemKey, (Object[])new Object[]{"Method <code>#ref</code>"});
        } else if (scope instanceof PsiClass) {
            name = ((PsiClass)scope).getNameIdentifier();
            message = JavaAnalysisBundle.message((String)problemKey, (Object[])new Object[]{"Class initializer"});
        }
        if (name != null) {
            holder.registerProblem((PsiElement)name, message, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createCastFixes(PsiTypeCastExpression castExpression, PsiType realType, boolean onTheFly, boolean alwaysFails) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createNPEFixes(@Nullable PsiExpression qualifier, PsiExpression expression, boolean onTheFly, boolean alwaysNull) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createUnboxingNullableFixes(@NotNull PsiExpression qualifier, PsiElement anchor, boolean onTheFly) {
        if (qualifier == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(4);
        }
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    protected @NotNull List<@NotNull LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef, boolean onTheFly) {
        List<LocalQuickFix> list = Collections.emptyList();
        if (list == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    protected LocalQuickFix createUnwrapSwitchLabelFix() {
        return null;
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix() {
        return null;
    }

    protected LocalQuickFix createRemoveAssignmentFix(PsiAssignmentExpression assignment) {
        return null;
    }

    private void createDescription(ProblemsHolder holder, DataFlowInstructionVisitor visitor2, PsiElement scope, Instruction @NotNull [] instructions) {
        if (instructions == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(7);
        }
        ProblemReporter reporter = new ProblemReporter(holder, scope);
        this.reportFailingCasts(reporter, visitor2);
        this.reportUnreachableSwitchBranches(visitor2.getSwitchLabelsReachability(), holder);
        this.reportAlwaysFailingCalls(reporter, visitor2);
        List<NullabilityProblemKind.NullabilityProblem<?>> problems = NullabilityProblemKind.postprocessNullabilityProblems(visitor2.problems().toList());
        this.reportNullabilityProblems(reporter, problems);
        this.reportNullableReturns(reporter, problems, scope);
        DataFlowInspectionBase.reportRedundantInstanceOf(visitor2, reporter);
        DataFlowInspectionBase.reportArrayAccessProblems(holder, visitor2);
        DataFlowInspectionBase.reportArrayStoreProblems(holder, visitor2);
        if (this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL && visitor2.isAlwaysReturnsNotNull(instructions)) {
            this.reportAlwaysReturnsNotNull(holder, scope);
        }
        this.reportMutabilityViolations(holder, visitor2.getMutabilityViolations(true), JavaAnalysisBundle.message((String)"dataflow.message.immutable.modified", (Object[])new Object[0]));
        this.reportMutabilityViolations(holder, visitor2.getMutabilityViolations(false), JavaAnalysisBundle.message((String)"dataflow.message.immutable.passed", (Object[])new Object[0]));
        this.reportDuplicateAssignments(reporter, visitor2);
        DataFlowInspectionBase.reportPointlessSameArguments(reporter, visitor2);
        this.reportStreamConsumed(holder, visitor2);
    }

    private static void reportRedundantInstanceOf(DataFlowInstructionVisitor visitor2, ProblemReporter reporter) {
        visitor2.redundantInstanceOfs().forEach(anchor -> {
            PsiExpression expression;
            Object object = anchor instanceof JavaExpressionAnchor ? ((JavaExpressionAnchor)anchor).getExpression() : (expression = anchor instanceof JavaMethodReferenceReturnAnchor ? ((JavaMethodReferenceReturnAnchor)anchor).getMethodReferenceExpression() : null);
            if (expression == null || DataFlowInspectionBase.shouldBeSuppressed(expression)) {
                return;
            }
            if (ContainerUtil.exists((Iterable)JavaPsiPatternUtil.getExposedPatternVariables((PsiExpression)expression), var -> VariableAccessUtils.variableIsUsed((PsiVariable)var, var.getDeclarationScope()))) {
                return;
            }
            RedundantInstanceofFix action = new RedundantInstanceofFix((PsiElement)expression);
            reporter.registerProblem((PsiElement)expression, JavaAnalysisBundle.message((String)"dataflow.message.redundant.instanceof", (Object[])new Object[0]), LocalQuickFix.from((ModCommandAction)action));
        });
    }

    private void reportUnreachableSwitchBranches(Map<PsiCaseLabelElement, ThreeState> labelReachability, ProblemsHolder holder) {
        PsiCaseLabelElement label2;
        PsiSwitchLabelStatementBase labelStatement;
        if (labelReachability.isEmpty()) {
            return;
        }
        HashSet<PsiSwitchBlock> coveredSwitches = new HashSet<PsiSwitchBlock>();
        HashMap<PsiCaseLabelElement, PsiSwitchBlock> unreachableLabels = new HashMap<PsiCaseLabelElement, PsiSwitchBlock>();
        for (Map.Entry<PsiCaseLabelElement, ThreeState> entry : labelReachability.entrySet()) {
            PsiSwitchBlock switchBlock2;
            ThreeState guardReachability;
            PsiExpression guardExpression;
            if (entry.getValue() != ThreeState.YES || (labelStatement = PsiImplUtil.getSwitchLabel((PsiCaseLabelElement)(label2 = entry.getKey()))) == null || (guardExpression = labelStatement.getGuardExpression()) != null && (guardReachability = labelReachability.get(guardExpression)) != ThreeState.YES || (switchBlock2 = labelStatement.getEnclosingSwitchBlock()) == null || !DataFlowInspectionBase.canRemoveTheOnlyReachableLabel(label2, switchBlock2)) continue;
            if (!((StreamEx)((StreamEx)StreamEx.iterate((Object)labelStatement, Objects::nonNull, l -> (PsiSwitchLabelStatementBase)PsiTreeUtil.getPrevSiblingOfType((PsiElement)l, PsiSwitchLabelStatementBase.class)).skip(1L)).map(PsiSwitchLabelStatementBase::getCaseLabelElementList).nonNull().flatArray(PsiCaseLabelElementList::getElements).append((Stream)StreamEx.iterate((Object)label2, Objects::nonNull, l -> (PsiCaseLabelElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)l, PsiCaseLabelElement.class)).skip(1L))).allMatch(l -> labelReachability.get(l) == ThreeState.NO)) {
                ((StreamEx)((StreamEx)((StreamEx)StreamEx.iterate((Object)labelStatement, Objects::nonNull, l -> (PsiSwitchLabelStatementBase)PsiTreeUtil.getNextSiblingOfType((PsiElement)l, PsiSwitchLabelStatementBase.class)).remove(SwitchUtils::isDefaultLabel)).skip(1L)).map(PsiSwitchLabelStatementBase::getCaseLabelElementList).nonNull().flatArray(PsiCaseLabelElementList::getElements).append((Stream)StreamEx.iterate((Object)label2, Objects::nonNull, l -> (PsiCaseLabelElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)l, PsiCaseLabelElement.class)).skip(1L))).forEach(l -> unreachableLabels.put((PsiCaseLabelElement)l, switchBlock2));
                continue;
            }
            coveredSwitches.add(switchBlock2);
            LocalQuickFix unwrapFix = switchBlock2 instanceof PsiSwitchExpression && !CodeBlockSurrounder.canSurround((PsiExpression)((PsiSwitchExpression)switchBlock2)) || SwitchUtils.findRemovableUnreachableBranches(label2, switchBlock2).isEmpty() ? null : this.createUnwrapSwitchLabelFix();
            holder.registerProblem((PsiElement)label2, JavaAnalysisBundle.message((String)"dataflow.message.only.switch.label", (Object[])new Object[0]), LocalQuickFix.notNullElements((LocalQuickFix)unwrapFix));
        }
        for (Map.Entry<PsiCaseLabelElement, ThreeState> entry : labelReachability.entrySet()) {
            PsiSwitchBlock switchBlock3;
            if (entry.getValue() != ThreeState.NO || (labelStatement = PsiImplUtil.getSwitchLabel((PsiCaseLabelElement)(label2 = entry.getKey()))) == null || (switchBlock3 = labelStatement.getEnclosingSwitchBlock()) == null || coveredSwitches.contains(switchBlock3)) continue;
            unreachableLabels.put(label2, switchBlock3);
        }
        unreachableLabels.forEach((label, switchBlock) -> {
            if (DataFlowInspectionBase.isThrowing(label)) {
                return;
            }
            Set<PsiElement> suspiciousElements = DataFlowInspectionBase.findSuspiciousLabelElements(switchBlock);
            if (!suspiciousElements.contains(label)) {
                holder.problem((PsiElement)label, JavaAnalysisBundle.message((String)"dataflow.message.unreachable.switch.label", (Object[])new Object[0])).maybeFix(this.createDeleteLabelFix((PsiCaseLabelElement)label)).register();
            }
        });
    }

    @Nullable
    protected LocalQuickFix createDeleteLabelFix(PsiCaseLabelElement label) {
        return null;
    }

    private static boolean isThrowing(PsiCaseLabelElement label) {
        PsiCaseLabelElementList caseLabelList = (PsiCaseLabelElementList)ObjectUtils.tryCast((Object)label.getParent(), PsiCaseLabelElementList.class);
        if (caseLabelList == null) {
            return false;
        }
        PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)caseLabelList.getParent(), PsiSwitchLabelStatementBase.class);
        if (labelStatement == null) {
            return false;
        }
        if (labelStatement instanceof PsiSwitchLabeledRuleStatement) {
            return ControlFlowUtils.stripBraces(((PsiSwitchLabeledRuleStatement)labelStatement).getBody()) instanceof PsiThrowStatement;
        }
        if (labelStatement instanceof PsiSwitchLabelStatement) {
            PsiSwitchLabelStatementBase cur = labelStatement;
            while (true) {
                PsiElement next;
                if (!((next = cur.getNextSibling()) instanceof PsiComment || next instanceof PsiWhiteSpace || next instanceof PsiSwitchLabelStatement)) {
                    return next instanceof PsiThrowStatement;
                }
                cur = next;
            }
        }
        return false;
    }

    private static boolean canRemoveTheOnlyReachableLabel(@NotNull PsiCaseLabelElement label, @NotNull PsiSwitchBlock switchBlock) {
        if (label == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(8);
        }
        if (switchBlock == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(9);
        }
        if (!(label instanceof PsiPattern)) {
            return true;
        }
        PsiExpression selector = switchBlock.getExpression();
        if (selector == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return false;
        }
        if (!JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)label, (PsiType)selectorType)) {
            return true;
        }
        int branchCount = SwitchUtils.calculateBranchCount(switchBlock);
        return branchCount > 1;
    }

    private static void reportPointlessSameArguments(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        visitor2.pointlessSameArguments().forKeyValue((expr, eq) -> {
            PsiElement name = expr.getReferenceNameElement();
            if (name != null) {
                PsiExpression[] expressions = PsiExpression.EMPTY_ARRAY;
                if (expr.getParent() instanceof PsiMethodCallExpression && (expressions = ((PsiMethodCallExpression)expr.getParent()).getArgumentList().getExpressions()).length == 2 && PsiUtil.isConstantExpression((PsiExpression)expressions[0]) && PsiUtil.isConstantExpression((PsiExpression)expressions[1]) && !EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(expressions[0], expressions[1])) {
                    return;
                }
                if (eq.firstArgEqualToResult()) {
                    String message = eq.argsEqual() ? JavaAnalysisBundle.message((String)"dataflow.message.pointless.same.arguments", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"dataflow.message.pointless.same.argument.and.result", (Object[])new Object[]{1});
                    ReplaceWithArgumentFix fix = expressions.length == 2 ? new ReplaceWithArgumentFix(expressions[0], 0) : null;
                    reporter.registerProblem(name, message, LocalQuickFix.notNullElements((LocalQuickFix)fix));
                } else if (eq.argsEqual()) {
                    reporter.registerProblem(name, JavaAnalysisBundle.message((String)"dataflow.message.pointless.same.arguments", (Object[])new Object[0]), new LocalQuickFix[0]);
                } else if (eq.secondArgEqualToResult()) {
                    ReplaceWithArgumentFix fix = expressions.length == 2 ? new ReplaceWithArgumentFix(expressions[1], 1) : null;
                    reporter.registerProblem(name, JavaAnalysisBundle.message((String)"dataflow.message.pointless.same.argument.and.result", (Object[])new Object[]{2}), LocalQuickFix.notNullElements((LocalQuickFix)fix));
                }
            }
        });
    }

    private void reportDuplicateAssignments(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        visitor2.sameValueAssignments().forEach(expr -> {
            DfType value;
            PsiReferenceExpression ref;
            PsiElement patt0$temp;
            if ((expr = PsiUtil.skipParenthesizedExprDown((PsiExpression)expr)) == null) {
                return;
            }
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiAssignmentExpression.class);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)expr, (Class[])new Class[]{PsiForStatement.class, PsiClassInitializer.class});
            if (context instanceof PsiForStatement && PsiTreeUtil.isAncestor((PsiElement)((PsiForStatement)context).getInitialization(), (PsiElement)expr, (boolean)true)) {
                return;
            }
            if (expr instanceof PsiReferenceExpression && (patt0$temp = (ref = (PsiReferenceExpression)expr).resolve()) instanceof PsiField) {
                Object constValue;
                PsiField field = (PsiField)patt0$temp;
                if (field.hasModifierProperty("final")) {
                    return;
                }
                if (context instanceof PsiClassInitializer && assignment != null && (constValue = ExpressionUtils.computeConstantExpression(assignment.getRExpression())) == PsiTypesUtil.getDefaultValue((PsiType)expr.getType()) && (field.hasModifierProperty("static") || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)ref)) && field.getContainingClass() == ((PsiClassInitializer)context).getContainingClass()) {
                    return;
                }
            }
            if ((value = CommonDataflow.getDfType(expr, this.IGNORE_ASSERT_STATEMENTS)) == DfTypes.TRUE || value == DfTypes.FALSE) {
                return;
            }
            String message = assignment != null && !assignment.getOperationTokenType().equals(JavaTokenType.EQ) ? JavaAnalysisBundle.message((String)"dataflow.message.redundant.update", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"dataflow.message.redundant.assignment", (Object[])new Object[0]);
            reporter.registerProblem((PsiElement)expr, message, LocalQuickFix.notNullElements((LocalQuickFix)this.createRemoveAssignmentFix(assignment)));
        });
    }

    private void reportMutabilityViolations(ProblemsHolder holder, Set<PsiElement> violations, @InspectionMessage String message) {
        for (PsiElement violation : violations) {
            holder.registerProblem(violation, message, LocalQuickFix.notNullElements((LocalQuickFix)this.createMutabilityViolationFix(violation)));
        }
    }

    protected LocalQuickFix createMutabilityViolationFix(PsiElement violation) {
        return null;
    }

    protected void reportNullabilityProblems(ProblemReporter reporter, List<NullabilityProblemKind.NullabilityProblem<?>> problems) {
        for (NullabilityProblemKind.NullabilityProblem<?> problem : problems) {
            PsiExpression expression = problem.getDereferencedExpression();
            boolean nullLiteral = ExpressionUtils.isNullLiteral(expression);
            if (!this.REPORT_UNSOUND_WARNINGS && (expression == null || !nullLiteral && CommonDataflow.getDfType(expression, this.IGNORE_ASSERT_STATEMENTS) != DfTypes.NULL) || expression != null && !nullLiteral && PsiTypes.nullType().equals(expression.getType())) continue;
            boolean alwaysNull = problem.isAlwaysNull(this.IGNORE_ASSERT_STATEMENTS);
            NullabilityProblemKind.innerClassNPE.ifMyProblem(problem, newExpression -> {
                List<LocalQuickFix> fixes = this.createNPEFixes(newExpression.getQualifier(), (PsiExpression)newExpression, reporter.isOnTheFly(), alwaysNull);
                reporter.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiElement)newExpression), problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            });
            NullabilityProblemKind.callMethodRefNPE.ifMyProblem(problem, methodRef -> reporter.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.npe.methodref.invocation", (Object[])new Object[0]), this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)methodRef, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY)));
            NullabilityProblemKind.callNPE.ifMyProblem(problem, call -> this.reportCallMayProduceNpe(reporter, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), (PsiMethodCallExpression)call, alwaysNull));
            NullabilityProblemKind.passingToNotNullParameter.ifMyProblem(problem, expr -> {
                List<LocalQuickFix> fixes = this.createNPEFixes(expression, expression, reporter.isOnTheFly(), alwaysNull);
                reporter.registerProblem((PsiElement)expression, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            });
            NullabilityProblemKind.passingToNotNullMethodRefParameter.ifMyProblem(problem, methodRef -> {
                LocalQuickFix[] fixes = this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)methodRef, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.passing.nullable.argument.methodref", (Object[])new Object[0]), fixes);
            });
            NullabilityProblemKind.unboxingMethodRefParameter.ifMyProblem(problem, methodRef -> {
                LocalQuickFix[] fixes = this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)methodRef, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)methodRef, JavaAnalysisBundle.message((String)"dataflow.message.unboxing.nullable.argument.methodref", (Object[])new Object[0]), fixes);
            });
            NullabilityProblemKind.arrayAccessNPE.ifMyProblem(problem, arrayAccess -> {
                LocalQuickFix[] fixes = this.createNPEFixes(arrayAccess.getArrayExpression(), (PsiExpression)arrayAccess, reporter.isOnTheFly(), alwaysNull).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)arrayAccess, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fixes);
            });
            NullabilityProblemKind.templateNPE.ifMyProblem(problem, template -> {
                PsiExpression processor = template.getProcessor();
                LocalQuickFix[] fixes = this.createNPEFixes(processor, (PsiExpression)template, reporter.isOnTheFly(), alwaysNull).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)processor, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fixes);
            });
            NullabilityProblemKind.fieldAccessNPE.ifMyProblem(problem, element -> {
                PsiElement parent = element.getParent();
                PsiExpression fieldAccess = parent instanceof PsiReferenceExpression ? (PsiExpression)parent : element;
                LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)element, fieldAccess, reporter.isOnTheFly(), alwaysNull).toArray(LocalQuickFix.EMPTY_ARRAY);
                reporter.registerProblem((PsiElement)element, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fix);
            });
            NullabilityProblemKind.unboxingNullable.ifMyProblem(problem, element -> {
                PsiExpression anchor = expression;
                if (anchor instanceof PsiTypeCastExpression && anchor.getType() instanceof PsiPrimitiveType) {
                    anchor = Objects.requireNonNull(((PsiTypeCastExpression)anchor).getOperand());
                }
                if (anchor != null) {
                    LocalQuickFix[] fixes = this.createUnboxingNullableFixes(anchor, (PsiElement)element, reporter.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
                    reporter.registerProblem((PsiElement)anchor, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fixes);
                }
            });
            NullabilityProblemKind.nullableFunctionReturn.ifMyProblem(problem, expr -> reporter.registerProblem((PsiElement)(expression == null ? expr : expression), problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), new LocalQuickFix[0]));
            Consumer<PsiExpression> reportNullability = expr -> this.reportNullabilityProblem(reporter, problem, expression);
            NullabilityProblemKind.assigningToNotNull.ifMyProblem(problem, reportNullability);
            NullabilityProblemKind.storingToNotNullArray.ifMyProblem(problem, reportNullability);
            if (!this.SUGGEST_NULLABLE_ANNOTATIONS) continue;
            NullabilityProblemKind.passingToNonAnnotatedMethodRefParameter.ifMyProblem(problem, methodRef -> this.reportNullableArgumentPassedToNonAnnotatedMethodRef(reporter, problem, (PsiMethodReferenceExpression)methodRef));
            NullabilityProblemKind.passingToNonAnnotatedParameter.ifMyProblem(problem, top -> this.reportNullableArgumentsPassedToNonAnnotated(reporter, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), expression, (PsiExpression)top, alwaysNull));
            NullabilityProblemKind.assigningToNonAnnotatedField.ifMyProblem(problem, top -> this.reportNullableAssignedToNonAnnotatedField(reporter, (PsiExpression)top, expression, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), alwaysNull));
        }
    }

    private void reportNullabilityProblem(ProblemReporter reporter, NullabilityProblemKind.NullabilityProblem<?> problem, PsiExpression expr) {
        LocalQuickFix[] fixes = this.createNPEFixes(expr, expr, reporter.isOnTheFly(), problem.isAlwaysNull(this.IGNORE_ASSERT_STATEMENTS)).toArray(LocalQuickFix.EMPTY_ARRAY);
        reporter.registerProblem((PsiElement)expr, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), fixes);
    }

    private static void reportArrayAccessProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.outOfBoundsArrayAccesses().forEach(access -> {
            PsiExpression indexExpression = access.getIndexExpression();
            if (indexExpression != null) {
                holder.registerProblem((PsiElement)indexExpression, JavaAnalysisBundle.message((String)"dataflow.message.array.index.out.of.bounds", (Object[])new Object[0]), new LocalQuickFix[0]);
            }
        });
        visitor2.negativeArraySizes().forEach(dimExpression -> holder.registerProblem((PsiElement)dimExpression, JavaAnalysisBundle.message((String)"dataflow.message.negative.array.size", (Object[])new Object[0]), new LocalQuickFix[0]));
    }

    private void reportStreamConsumed(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.streamConsumed().forKeyValue((psiElement, alwaysFails) -> {
            if (!this.REPORT_UNSOUND_WARNINGS && !alwaysFails.booleanValue()) {
                return;
            }
            holder.registerProblem(psiElement, JavaAnalysisBundle.message((String)(alwaysFails != false ? "dataflow.message.stream.consumed.always" : "dataflow.message.stream.consumed"), (Object[])new Object[0]), new LocalQuickFix[0]);
        });
    }

    private static void reportArrayStoreProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.getArrayStoreProblems().forEach((assignment, types) -> holder.registerProblem((PsiElement)assignment.getOperationSign(), JavaAnalysisBundle.message((String)"dataflow.message.arraystore", (Object[])new Object[]{((PsiType)types.getFirst()).getCanonicalText(), ((PsiType)types.getSecond()).getCanonicalText()}), new LocalQuickFix[0]));
    }

    private void reportAlwaysReturnsNotNull(ProblemsHolder holder, PsiElement scope) {
        PsiMethod method;
        PsiElement psiElement = scope.getParent();
        if (!(psiElement instanceof PsiMethod) || PsiUtil.canBeOverridden((PsiMethod)(method = (PsiMethod)psiElement))) {
            return;
        }
        NullabilityAnnotationInfo info = NullableNotNullManager.getInstance((Project)scope.getProject()).findOwnNullabilityInfo((PsiModifierListOwner)method);
        if (info == null || info.getNullability() != Nullability.NULLABLE) {
            return;
        }
        if (TypeUtils.typeEquals("java.lang.Void", method.getReturnType())) {
            return;
        }
        PsiAnnotation annotation = info.getAnnotation();
        if (!annotation.isPhysical() || DataFlowInspectionBase.alsoAppliesToInternalSubType(annotation, method)) {
            return;
        }
        PsiJavaCodeReferenceElement annoName = annotation.getNameReferenceElement();
        assert (annoName != null);
        String msg = JavaAnalysisBundle.message((String)"dataflow.message.return.notnull.from.nullable", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName(annotation), method.getName()});
        holder.problem((PsiElement)annoName, msg).maybeFix(AddAnnotationModCommandAction.createAddNotNullFix((PsiModifierListOwner)method)).fix((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)this, "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL", JavaAnalysisBundle.message((String)"inspection.data.flow.turn.off.nullable.returning.notnull.quickfix", (Object[])new Object[0]), false)).register();
    }

    private static boolean alsoAppliesToInternalSubType(PsiAnnotation annotation, PsiMethod method) {
        return AnnotationTargetUtil.isTypeAnnotation((PsiAnnotation)annotation) && method.getReturnType() instanceof PsiArrayType;
    }

    private void reportAlwaysFailingCalls(ProblemReporter reporter, DataFlowInstructionVisitor visitor2) {
        ((StreamEx)visitor2.alwaysFailingCalls().remove(TestUtils::isExceptionExpected)).forEach(anchor -> {
            List<? extends MethodContract> contracts = DataFlowInstructionVisitor.getContracts(anchor);
            if (contracts != null && contracts.isEmpty()) {
                PsiMethod psiMethod;
                if (anchor instanceof PsiCallExpression) {
                    PsiCallExpression call = (PsiCallExpression)anchor;
                    psiMethod = call.resolveMethod();
                } else if (anchor instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)anchor;
                    psiMethod = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class);
                } else {
                    psiMethod = null;
                }
                PsiMethod method = psiMethod;
                contracts = DfaUtil.addRangeContracts(method, List.of());
            }
            if (contracts == null) {
                return;
            }
            String message = DataFlowInspectionBase.getContractMessage(contracts);
            LocalQuickFix causeFix = this.createExplainFix((PsiExpression)anchor, new TrackingRunner.FailingCallDfaProblemType());
            reporter.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiElement)anchor), message, LocalQuickFix.notNullElements((LocalQuickFix)causeFix));
        });
    }

    @NotNull
    @InspectionMessage
    private static String getContractMessage(List<? extends MethodContract> contracts) {
        if (contracts.isEmpty()) {
            String string = JavaAnalysisBundle.message((String)"dataflow.message.fail", (Object[])new Object[0]);
            if (string == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (ContainerUtil.and(contracts, mc -> ContainerUtil.and(mc.getConditions(), ContractValue::isBoundCheckingCondition))) {
            String string = JavaAnalysisBundle.message((String)"dataflow.message.contract.fail.index", (Object[])new Object[0]);
            if (string == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"dataflow.message.contract.fail", (Object[])new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiElement element) {
        PsiJavaCodeReferenceElement ref;
        if (element == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(13);
        }
        if (element instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            ref = newExpression.getClassReference();
        } else if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)element;
            ref = callExpression.getMethodExpression();
        } else {
            PsiElement psiElement = element;
            if (psiElement == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        if (ref != null) {
            PsiElement name = ref.getReferenceNameElement();
            Object object = name != null ? name : ref;
            if (object == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(15);
            }
            return object;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(16);
        }
        return psiElement;
    }

    private void reportNullableArgumentPassedToNonAnnotatedMethodRef(@NotNull ProblemReporter reporter, @NotNull NullabilityProblemKind.NullabilityProblem<?> problem, @NotNull PsiMethodReferenceExpression methodRef) {
        PsiMethod target;
        if (reporter == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(17);
        }
        if (problem == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(18);
        }
        if (methodRef == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(19);
        }
        if ((target = (PsiMethod)ObjectUtils.tryCast((Object)methodRef.resolve(), PsiMethod.class)) == null) {
            return;
        }
        PsiParameter[] parameters = target.getParameterList().getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiParameter parameter = parameters[0];
        if (!BaseIntentionAction.canModify((PsiElement)parameter)) {
            return;
        }
        ModCommandAction fix = AddAnnotationModCommandAction.createAddNullableFix((PsiModifierListOwner)parameter);
        reporter.registerProblem((PsiElement)methodRef, problem.getMessage(this.IGNORE_ASSERT_STATEMENTS), LocalQuickFix.notNullElements((LocalQuickFix)(parameters.length == 1 ? LocalQuickFix.from((ModCommandAction)fix) : null)));
    }

    private void reportNullableArgumentsPassedToNonAnnotated(ProblemReporter reporter, @InspectionMessage String message, PsiExpression expression, PsiExpression top, boolean alwaysNull) {
        PsiParameter parameter = MethodCallUtils.getParameterForArgument(top);
        if (parameter == null) {
            return;
        }
        PsiModifierListOwner target = (PsiModifierListOwner)Objects.requireNonNullElse(JavaPsiRecordUtil.getComponentForCanonicalConstructorParameter((PsiParameter)parameter), parameter);
        if (BaseIntentionAction.canModify((PsiElement)target)) {
            List<LocalQuickFix> fixes = this.createNPEFixes(expression, top, reporter.isOnTheFly(), alwaysNull);
            fixes.add(LocalQuickFix.from((ModCommandAction)AddAnnotationModCommandAction.createAddNullableFix(target)));
            reporter.registerProblem((PsiElement)expression, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private void reportNullableAssignedToNonAnnotatedField(ProblemReporter reporter, PsiExpression top, PsiExpression expression, @InspectionMessage String message, boolean alwaysNull) {
        PsiField field = DataFlowInspectionBase.getAssignedField((PsiElement)top);
        if (field != null) {
            List<LocalQuickFix> fixes = this.createNPEFixes(expression, top, reporter.isOnTheFly(), alwaysNull);
            fixes.add(LocalQuickFix.from((ModCommandAction)AddAnnotationModCommandAction.createAddNullableFix((PsiModifierListOwner)field)));
            reporter.registerProblem((PsiElement)expression, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    @Nullable
    private static PsiField getAssignedField(PsiElement assignedValue) {
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)assignedValue.getParent());
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
            PsiElement target = lExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)lExpression).resolve() : null;
            return (PsiField)ObjectUtils.tryCast((Object)target, PsiField.class);
        }
        return null;
    }

    private void reportCallMayProduceNpe(ProblemReporter reporter, @InspectionMessage String message, PsiMethodCallExpression callExpression, boolean alwaysNull) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        List<LocalQuickFix> fixes = this.createNPEFixes(methodExpression.getQualifierExpression(), (PsiExpression)callExpression, reporter.isOnTheFly(), alwaysNull);
        if (!alwaysNull) {
            ContainerUtil.addIfNotNull(fixes, (Object)((Object)ReplaceWithObjectsEqualsFix.createFix(callExpression, methodExpression)));
        }
        PsiElement toHighlight = DataFlowInspectionBase.getElementToHighlight((PsiElement)callExpression);
        reporter.registerProblem(toHighlight, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void reportFailingCasts(@NotNull ProblemReporter reporter, @NotNull DataFlowInstructionVisitor visitor2) {
        if (reporter == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(20);
        }
        if (visitor2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(21);
        }
        visitor2.getFailingCastExpressions().forKeyValue((typeCast, info) -> {
            boolean alwaysFails = (Boolean)info.getFirst();
            PsiType realType = (PsiType)info.getSecond();
            if (!this.REPORT_UNSOUND_WARNINGS && !alwaysFails) {
                return;
            }
            PsiExpression operand = typeCast.getOperand();
            PsiTypeElement castType = typeCast.getCastType();
            if (ExpressionUtils.isNullLiteral(operand) || DfTypes.NULL.equals(CommonDataflow.getDfType(operand, this.IGNORE_ASSERT_STATEMENTS))) {
                return;
            }
            assert (castType != null);
            assert (operand != null);
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>(this.createCastFixes((PsiTypeCastExpression)typeCast, realType, reporter.isOnTheFly(), alwaysFails));
            ContainerUtil.addIfNotNull(fixes, (Object)this.createExplainFix((PsiExpression)typeCast, new TrackingRunner.CastDfaProblemType()));
            String text = PsiExpressionTrimRenderer.render((PsiExpression)operand);
            String message = alwaysFails ? JavaAnalysisBundle.message((String)"dataflow.message.cce.always", (Object[])new Object[]{text}) : JavaAnalysisBundle.message((String)"dataflow.message.cce", (Object[])new Object[]{text});
            reporter.registerProblem((PsiElement)castType, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        });
    }

    @Nullable
    protected LocalQuickFix createExplainFix(PsiExpression anchor, TrackingRunner.DfaProblemType problemType) {
        return null;
    }

    private static boolean shouldBeSuppressed(@NotNull PsiExpression anchor) {
        if (anchor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(22);
        }
        if (anchor instanceof PsiInstanceOfExpression) {
            PsiType type = ((PsiInstanceOfExpression)anchor).getOperand().getType();
            if (type == null || !TypeConstraints.instanceOf(type).isResolved()) {
                return true;
            }
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERN_GUARDS_AND_RECORD_PATTERNS, (PsiElement)anchor)) {
                return false;
            }
            PsiPrimaryPattern pattern = ((PsiInstanceOfExpression)anchor).getPattern();
            if (pattern instanceof PsiTypeTestPattern && ((PsiTypeTestPattern)pattern).getPatternVariable() != null) {
                PsiTypeElement checkType = ((PsiTypeTestPattern)pattern).getCheckType();
                return checkType != null && checkType.getType().isAssignableFrom(type);
            }
        }
        return false;
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent = block.getParent();
        if (parent instanceof PsiMethod) {
            return (PsiMethod)parent;
        }
        if (parent instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(ProblemReporter reporter, List<NullabilityProblemKind.NullabilityProblem<?>> problems, @NotNull PsiElement block) {
        PsiMethod method;
        if (block == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(23);
        }
        if ((method = DataFlowInspectionBase.getScopeMethod(block)) == null) {
            return;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)method.getProject());
        NullabilityAnnotationInfo info = manager.findEffectiveNullabilityInfo((PsiModifierListOwner)method);
        if (info == null || info.isInferred()) {
            info = DfaPsiUtil.getTypeNullabilityInfo(PsiTypesUtil.getMethodReturnType((PsiElement)block));
        }
        PsiAnnotation anno = info == null ? null : info.getAnnotation();
        Nullability nullability = info == null ? Nullability.UNKNOWN : info.getNullability();
        PsiType returnType = method.getReturnType();
        if (!(nullability != Nullability.NULLABLE || info.isInferred() && DfaPsiUtil.getTypeNullability(returnType) != Nullability.NULLABLE)) {
            return;
        }
        if (nullability == Nullability.NOT_NULL && info.isInferred()) {
            return;
        }
        if (nullability != Nullability.NOT_NULL && (!this.SUGGEST_NULLABLE_ANNOTATIONS || block.getParent() instanceof PsiLambdaExpression)) {
            return;
        }
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiTypes.voidType().equals((Object)returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        this.reportNullableReturnsProblems(reporter, problems, nullability, anno, manager);
    }

    protected void reportNullableReturnsProblems(ProblemReporter reporter, List<NullabilityProblemKind.NullabilityProblem<?>> problems, Nullability nullability, PsiAnnotation anno, NullableNotNullManager manager) {
        for (NullabilityProblemKind.NullabilityProblem problem : StreamEx.of(problems).map(NullabilityProblemKind.nullableReturn::asMyProblem).nonNull()) {
            ModCommandAction fix;
            PsiMethod surroundingMethod;
            PsiExpression anchor = (PsiExpression)problem.getAnchor();
            PsiExpression expr = problem.getDereferencedExpression();
            boolean exactlyNull = problem.isAlwaysNull(this.IGNORE_ASSERT_STATEMENTS);
            if (!this.REPORT_UNSOUND_WARNINGS && !exactlyNull) continue;
            if (nullability == Nullability.NOT_NULL) {
                String presentable = NullableStuffInspectionBase.getPresentableAnnoName(anno);
                String text = exactlyNull ? JavaAnalysisBundle.message((String)"dataflow.message.return.null.from.notnull", (Object[])new Object[]{presentable}) : JavaAnalysisBundle.message((String)"dataflow.message.return.nullable.from.notnull", (Object[])new Object[]{presentable});
                List fixes = this.createNPEFixes(expr, expr, reporter.isOnTheFly(), exactlyNull);
                surroundingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
                if (surroundingMethod != null && (fix = AddAnnotationModCommandAction.createAddNullableFix((PsiModifierListOwner)surroundingMethod)) != null) {
                    fixes = StreamEx.of(fixes).append((Object)LocalQuickFix.from((ModCommandAction)fix)).toList();
                }
                reporter.registerProblem((PsiElement)expr, text, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            String defaultNullable = manager.getDefaultAnnotation(Nullability.NULLABLE, (PsiElement)anchor);
            if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)anchor, (String)defaultNullable)) continue;
            String presentableNullable = StringUtil.getShortName((String)defaultNullable);
            String text = exactlyNull ? JavaAnalysisBundle.message((String)"dataflow.message.return.null.from.notnullable", (Object[])new Object[]{presentableNullable}) : JavaAnalysisBundle.message((String)"dataflow.message.return.nullable.from.notnullable", (Object[])new Object[]{presentableNullable});
            surroundingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)anchor, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            fix = surroundingMethod == null ? null : LocalQuickFix.from((ModCommandAction)AddAnnotationModCommandAction.createAddNullableFix((PsiModifierListOwner)surroundingMethod));
            reporter.registerProblem((PsiElement)expr, text, LocalQuickFix.notNullElements((LocalQuickFix)fix));
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @NotNull
    private static Set<PsiElement> findSuspiciousLabelElements(@NotNull PsiSwitchBlock switchBlock) {
        PsiExpression selector;
        if (switchBlock == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(25);
        }
        if ((selector = switchBlock.getExpression()) == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(26);
            }
            return set;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(27);
            }
            return set;
        }
        List labelElements = ContainerUtil.filterIsInstance((Collection)JavaPsiSwitchUtil.getSwitchBranches((PsiSwitchBlock)switchBlock), PsiCaseLabelElement.class);
        if (labelElements.isEmpty()) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(28);
            }
            return set;
        }
        MultiMap duplicateCandidates = JavaPsiSwitchUtil.getValuesAndLabels((PsiSwitchBlock)switchBlock);
        SmartHashSet result = new SmartHashSet();
        for (Map.Entry entry : duplicateCandidates.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            result.addAll((Collection)entry.getValue());
        }
        PsiCaseLabelElement unconditionalPattern = (PsiCaseLabelElement)ContainerUtil.find((Iterable)labelElements, element -> JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)element, (PsiType)selectorType));
        PsiElement defaultElement = JavaPsiSwitchUtil.findDefaultElement((PsiSwitchBlock)switchBlock);
        if (unconditionalPattern != null && defaultElement != null) {
            result.add(unconditionalPattern);
            result.add(defaultElement);
        }
        Set set = (Set)StreamEx.ofKeys((Map)JavaPsiSwitchUtil.findDominatedLabels((PsiSwitchBlock)switchBlock), value -> value instanceof PsiPattern).into((Collection)result);
        if (set == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(29);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 10, 11, 12, 14, 15, 16, 24, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 9: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCastFixes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnboxingNullableFixes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createMethodReferenceNPEFixes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractMessage";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findSuspiciousLabelElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUnboxingNullableFixes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRemoveTheOnlyReachableLabel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reportNullableArgumentPassedToNonAnnotatedMethodRef";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportFailingCasts";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeSuppressed";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportNullableReturns";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findSuspiciousLabelElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 10, 11, 12, 14, 15, 16, 24, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    protected static class ProblemReporter {
        private final Set<PsiElement> myReportedAnchors = new HashSet<PsiElement>();
        private final ProblemsHolder myHolder;
        private final PsiElement myScope;

        ProblemReporter(ProblemsHolder holder, PsiElement scope) {
            this.myHolder = holder;
            this.myScope = scope;
        }

        public void registerProblem(PsiElement element, @InspectionMessage String message, LocalQuickFix ... fixes) {
            if (fixes == null) {
                ProblemReporter.$$$reportNull$$$0(0);
            }
            if (this.register(element)) {
                this.myHolder.registerProblem(element, message, fixes);
            }
        }

        private boolean register(PsiElement element) {
            PsiExpression deparenthesized;
            PsiMember member;
            if (!PsiTreeUtil.isAncestor((PsiElement)this.myScope, (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (this.myScope instanceof PsiClass && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class)) instanceof PsiMethod && !((PsiMethod)member).isConstructor()) {
                return false;
            }
            if (!this.myReportedAnchors.add(element)) {
                return false;
            }
            if (element instanceof PsiParenthesizedExpression && (deparenthesized = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)element))) != null) {
                this.myReportedAnchors.add((PsiElement)deparenthesized);
            }
            return true;
        }

        boolean isOnTheFly() {
            return this.myHolder.isOnTheFly();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixes", "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$ProblemReporter", "registerProblem"));
        }
    }
}

