/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullabilityProblemKind;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.java.JavaDfaValueFactory;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaMethodReferenceReturnAnchor;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaSwitchLabelTakenAnchor;
import com.intellij.codeInspection.dataFlow.java.inst.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ThisDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayIndexProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ArrayStoreProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ClassCastProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ConsumedStreamProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.JvmDfaProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.MutabilityProblem;
import com.intellij.codeInspection.dataFlow.jvm.problems.NegativeArraySizeProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DataFlowInstructionVisitor
implements JavaDfaListener {
    private static final Logger LOG = Logger.getInstance(DataFlowInstructionVisitor.class);
    private final Map<NullabilityProblemKind.NullabilityProblem<?>, StateInfo> myStateInfos = new LinkedHashMap();
    private final Map<PsiTypeCastExpression, StateInfo> myClassCastProblems = new HashMap<PsiTypeCastExpression, StateInfo>();
    private final Map<PsiTypeCastExpression, TypeConstraint> myRealOperandTypes = new HashMap<PsiTypeCastExpression, TypeConstraint>();
    private final Map<ContractFailureProblem, Boolean> myFailingCalls = new HashMap<ContractFailureProblem, Boolean>();
    private final Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> myArrayStoreProblems = new HashMap<PsiAssignmentExpression, Pair<PsiType, PsiType>>();
    private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
    private final Map<PsiExpression, ThreeState> myNegativeArraySizes = new HashMap<PsiExpression, ThreeState>();
    private final Map<PsiElement, StateInfo> myStreamConsumed = new HashMap<PsiElement, StateInfo>();
    private final Set<PsiElement> myReceiverMutabilityViolation = new HashSet<PsiElement>();
    private final Set<PsiElement> myArgumentMutabilityViolation = new HashSet<PsiElement>();
    private final Map<PsiExpression, Boolean> mySameValueAssigned = new HashMap<PsiExpression, Boolean>();
    private final Map<PsiReferenceExpression, ArgResultEquality> mySameArguments = new HashMap<PsiReferenceExpression, ArgResultEquality>();
    private final Map<PsiCaseLabelElement, ThreeState> mySwitchLabelsReachability = new HashMap<PsiCaseLabelElement, ThreeState>();
    private final boolean myDebug;
    private boolean myAlwaysReturnsNotNull = true;
    private final List<DfaMemoryState> myEndOfInitializerStates = new ArrayList<DfaMemoryState>();
    private final Set<DfaAnchor> myPotentiallyRedundantInstanceOf = new HashSet<DfaAnchor>();
    private final Map<DfaAnchor, ThreeState> myConstantInstanceOf = new HashMap<DfaAnchor, ThreeState>();
    private final boolean myStrictMode;
    private static final CallMatcher USELESS_SAME_ARGUMENTS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Integer", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Long", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Float", "min", "max").parameterCount(2), CallMatcher.staticCall("java.lang.Double", "min", "max").parameterCount(2), CallMatcher.instanceCall("java.lang.String", "replace").parameterCount(2), CallMatcher.staticCall("java.util.Objects", "requireNonNullElse").parameterTypes("T", "T"), CallMatcher.instanceCall("java.util.concurrent.TimeUnit", "convert").parameterTypes("long", "java.util.concurrent.TimeUnit"));

    DataFlowInstructionVisitor(boolean strictMode) {
        this.myStrictMode = strictMode;
        Application application = ApplicationManager.getApplication();
        this.myDebug = application.isEAP() || application.isInternal() || application.isUnitTestMode();
    }

    public void beforeAssignment(@NotNull DfaValue value, @NotNull DfaValue target, @NotNull DfaMemoryState memState, @Nullable DfaAnchor anchor) {
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(0);
        }
        if (target == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(1);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(2);
        }
        if (!(anchor instanceof JavaExpressionAnchor)) {
            return;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)((JavaExpressionAnchor)anchor).getExpression(), PsiAssignmentExpression.class);
        if (assignment == null) {
            return;
        }
        PsiExpression left = assignment.getLExpression();
        if (!Boolean.FALSE.equals(this.mySameValueAssigned.get(left))) {
            if (!left.isPhysical()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Non-physical element in assignment instruction: " + left.getParent().getText(), new Throwable());
                }
            } else {
                DfType dfType = memState.getDfType(value);
                if (!(!memState.areEqual(value, target) || DataFlowInstructionVisitor.isFloatingZero(dfType.getConstantOfType(Number.class)) || TypeUtils.isJavaLangString(left.getType()) && dfType != DfTypes.NULL || DataFlowInstructionVisitor.isAssignmentToDefaultValueInConstructor(target, assignment.getRExpression()))) {
                    this.mySameValueAssigned.merge(left, Boolean.TRUE, Boolean::logicalAnd);
                } else {
                    this.mySameValueAssigned.put(left, Boolean.FALSE);
                }
            }
        }
    }

    void initInstanceOf(Instruction[] instructions) {
        StreamEx.of((Object[])instructions).select(InstanceofInstruction.class).map(ExpressionPushingInstruction::getDfaAnchor).into(this.myPotentiallyRedundantInstanceOf);
    }

    private static boolean isAssignmentToDefaultValueInConstructor(DfaValue target, PsiExpression rExpression) {
        PsiType type;
        boolean isDefaultValue;
        if (!(target instanceof DfaVariableValue)) {
            return false;
        }
        DfaVariableValue var = (DfaVariableValue)target;
        PsiElement psiElement = var.getPsiVariable();
        if (!(psiElement instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)psiElement;
        if (var.getQualifier() == null || !(var.getQualifier().getDescriptor() instanceof ThisDescriptor)) {
            return false;
        }
        while (rExpression instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)rExpression).getOperationTokenType().equals(JavaTokenType.EQ)) {
            rExpression = ((PsiAssignmentExpression)rExpression).getRExpression();
        }
        DfaValue dest = JavaDfaValueFactory.getExpressionDfaValue(var.getFactory(), rExpression);
        if (dest == null) {
            return false;
        }
        DfType dfType = dest.getDfType();
        boolean bl = isDefaultValue = dfType.isConst(PsiTypesUtil.getDefaultValue((PsiType)(type = field.getType()))) || dfType.isConst((Object)0) && TypeConversionUtil.isIntegralNumberType((PsiType)type);
        if (!isDefaultValue) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)rExpression, PsiMethod.class);
        return method != null && method.isConstructor();
    }

    private static boolean isFloatingZero(Object value) {
        if (value instanceof Double) {
            Double dValue = (Double)value;
            return dValue == 0.0;
        }
        if (value instanceof Float) {
            Float fValue = (Float)value;
            return fValue.floatValue() == 0.0f;
        }
        return false;
    }

    StreamEx<PsiExpression> sameValueAssignments() {
        return StreamEx.ofKeys(this.mySameValueAssigned, Boolean::booleanValue);
    }

    EntryStream<PsiReferenceExpression, ArgResultEquality> pointlessSameArguments() {
        return EntryStream.of(this.mySameArguments).filterValues(ArgResultEquality::hasEquality);
    }

    StreamEx<NullabilityProblemKind.NullabilityProblem<?>> problems() {
        return EntryStream.of(this.myStateInfos).filterValues(StateInfo::shouldReport).mapKeyValue((np, si) -> si.unknown ? np.makeUnknown() : np);
    }

    public Map<PsiAssignmentExpression, Pair<PsiType, PsiType>> getArrayStoreProblems() {
        return this.myArrayStoreProblems;
    }

    Map<PsiCaseLabelElement, ThreeState> getSwitchLabelsReachability() {
        return this.mySwitchLabelsReachability;
    }

    EntryStream<PsiTypeCastExpression, Pair<Boolean, PsiType>> getFailingCastExpressions() {
        return EntryStream.of(this.myClassCastProblems).filterValues(StateInfo::shouldReport).mapToValue((cast, info) -> Pair.create((Object)info.alwaysFails(), (Object)this.myRealOperandTypes.getOrDefault(cast, TypeConstraints.TOP).getPsiType(cast.getProject())));
    }

    Set<PsiElement> getMutabilityViolations(boolean receiver) {
        return receiver ? this.myReceiverMutabilityViolation : this.myArgumentMutabilityViolation;
    }

    public List<DfaMemoryState> getEndOfInitializerStates() {
        return this.myEndOfInitializerStates;
    }

    Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
        return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, arg_0 -> ThreeState.YES.equals(arg_0));
    }

    Stream<PsiExpression> negativeArraySizes() {
        return StreamEx.ofKeys(this.myNegativeArraySizes, arg_0 -> ThreeState.YES.equals(arg_0));
    }

    EntryStream<PsiElement, Boolean> streamConsumed() {
        return EntryStream.of(this.myStreamConsumed).filterValues(StateInfo::shouldReport).mapToValue((element, info) -> info.alwaysFails());
    }

    StreamEx<PsiExpression> alwaysFailingCalls() {
        return (StreamEx)StreamEx.ofKeys(this.myFailingCalls, v -> v).map(JvmDfaProblem::getAnchor).distinct();
    }

    boolean isAlwaysReturnsNotNull(Instruction[] instructions) {
        return this.myAlwaysReturnsNotNull && ContainerUtil.exists((Object[])instructions, i -> i instanceof ReturnInstruction && ((ReturnInstruction)i).getAnchor() instanceof PsiReturnStatement);
    }

    StreamEx<DfaAnchor> redundantInstanceOfs() {
        return (StreamEx)StreamEx.of(this.myPotentiallyRedundantInstanceOf).filter(anchor -> this.myConstantInstanceOf.get(anchor) == ThreeState.UNSURE);
    }

    @Override
    public void beforePush(@NotNull @NotNull DfaValue @NotNull [] args, @NotNull DfaValue value, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
        JavaMethodReferenceReturnAnchor returnAnchor;
        PsiMethodReferenceExpression methodRef;
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(3);
        }
        if (anchor == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(5);
        }
        if (args == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(6);
        }
        JavaDfaListener.super.beforePush(args, value, anchor, state);
        if (anchor instanceof JavaExpressionAnchor) {
            PsiMethodCallExpression call;
            JavaExpressionAnchor expressionAnchor = (JavaExpressionAnchor)anchor;
            PsiExpression expression = expressionAnchor.getExpression();
            if (expression instanceof PsiLiteralExpression) {
                return;
            }
            if (expression instanceof PsiMethodCallExpression && USELESS_SAME_ARGUMENTS.test(call = (PsiMethodCallExpression)expression)) {
                this.checkUselessCall(args, value, state, call.getMethodExpression());
            }
        }
        if (anchor instanceof JavaMethodReferenceReturnAnchor && USELESS_SAME_ARGUMENTS.methodReferenceMatches(methodRef = (returnAnchor = (JavaMethodReferenceReturnAnchor)anchor).getMethodReferenceExpression())) {
            this.checkUselessCall(args, value, state, (PsiReferenceExpression)methodRef);
        }
        if (anchor instanceof JavaSwitchLabelTakenAnchor) {
            JavaSwitchLabelTakenAnchor labelTakenAnchor = (JavaSwitchLabelTakenAnchor)anchor;
            DfType type = state.getDfType(value);
            this.mySwitchLabelsReachability.merge(labelTakenAnchor.getLabelElement(), DataFlowInstructionVisitor.fromDfType(type), ThreeState::merge);
            return;
        }
        if (this.myPotentiallyRedundantInstanceOf.contains(anchor)) {
            if (DataFlowInstructionVisitor.isUsefulInstanceof(args, value, state)) {
                this.myPotentiallyRedundantInstanceOf.remove(anchor);
            } else {
                this.myConstantInstanceOf.merge(anchor, DataFlowInstructionVisitor.fromDfType(state.getDfType(value)), ThreeState::merge);
            }
        }
    }

    @NotNull
    private static ThreeState fromDfType(DfType type) {
        ThreeState threeState = type.equals((Object)DfTypes.TRUE) ? ThreeState.YES : (type.equals((Object)DfTypes.FALSE) ? ThreeState.NO : ThreeState.UNSURE);
        if (threeState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(7);
        }
        return threeState;
    }

    private static boolean isUsefulInstanceof(@NotNull @NotNull DfaValue @NotNull [] args, @NotNull DfaValue value, @NotNull DfaMemoryState state) {
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(8);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(9);
        }
        if (args == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(10);
        }
        if (args.length != 2) {
            return true;
        }
        DfType type = state.getDfType(value);
        if (type.equals((Object)DfTypes.BOOLEAN)) {
            if (args[0] instanceof DfaTypeValue && args[1] instanceof DfaTypeValue && !DfaTypeValue.isUnknown((DfaValue)args[0])) {
                TypeConstraint left = TypeConstraint.fromDfType(args[0].getDfType());
                TypeConstraint right = TypeConstraint.fromDfType(args[1].getDfType());
                return !right.isSuperConstraintOf(left);
            }
            return true;
        }
        return type.equals((Object)DfTypes.FALSE) && DfaNullability.fromDfType(state.getDfType(args[0])) != DfaNullability.NULL;
    }

    private void checkUselessCall(@NotNull @NotNull DfaValue @NotNull [] args, @NotNull DfaValue value, @NotNull DfaMemoryState state, @NotNull PsiReferenceExpression expression) {
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(11);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(13);
        }
        if (args == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(14);
        }
        if (args.length == 3) {
            ArgResultEquality equality = new ArgResultEquality(state.areEqual(args[1], args[2]), state.areEqual(value, args[1]), state.areEqual(value, args[2]));
            this.mySameArguments.merge(expression, equality, ArgResultEquality::merge);
        }
    }

    @Override
    public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState memState) {
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(15);
        }
        if (expression == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(16);
        }
        if (memState == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(17);
        }
        if (this.myDebug && !expression.isPhysical()) {
            throw new IllegalStateException("Non-physical expression is passed");
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent());
        if (parent instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)parent;
            TypeConstraint fact = TypeConstraint.fromDfType(memState.getDfType(value));
            this.myRealOperandTypes.merge(cast, fact, TypeConstraint::join);
        }
    }

    @Override
    public void beforeValueReturn(@NotNull DfaValue value, @Nullable PsiExpression expression, @NotNull PsiElement context, @NotNull DfaMemoryState state) {
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(18);
        }
        if (context == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(19);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(20);
        }
        if (context instanceof PsiMethod || context instanceof PsiLambdaExpression) {
            this.myAlwaysReturnsNotNull = this.myAlwaysReturnsNotNull && !state.getDfType(value).isSuperType((DfType)DfTypes.NULL);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
        if (problem == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(21);
        }
        if (value == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(22);
        }
        if (failed == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(23);
        }
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(24);
        }
        if (problem instanceof MutabilityProblem) {
            MutabilityProblem mutabilityProblem = (MutabilityProblem)problem;
            if (failed == ThreeState.YES) {
                this.reportMutabilityViolation(mutabilityProblem.isReceiver(), (PsiElement)mutabilityProblem.getAnchor());
                return;
            }
        }
        if (problem instanceof NegativeArraySizeProblem) {
            NegativeArraySizeProblem arraySizeProblem = (NegativeArraySizeProblem)problem;
            this.myNegativeArraySizes.merge((PsiExpression)arraySizeProblem.getAnchor(), failed, ThreeState::merge);
            return;
        }
        if (problem instanceof ArrayIndexProblem) {
            ArrayIndexProblem indexProblem = (ArrayIndexProblem)problem;
            this.myOutOfBoundsArrayAccesses.merge((PsiArrayAccessExpression)indexProblem.getAnchor(), failed, ThreeState::merge);
            return;
        }
        if (problem instanceof ClassCastProblem) {
            ClassCastProblem castProblem = (ClassCastProblem)problem;
            this.myClassCastProblems.computeIfAbsent((PsiTypeCastExpression)castProblem.getAnchor(), e -> new StateInfo()).update(state, ThreeState.fromBoolean((failed != ThreeState.YES ? 1 : 0) != 0));
            return;
        }
        if (problem instanceof ArrayStoreProblem) {
            ArrayStoreProblem storeProblem = (ArrayStoreProblem)problem;
            if (failed == ThreeState.YES) {
                this.myArrayStoreProblems.put((PsiAssignmentExpression)storeProblem.getAnchor(), (Pair<PsiType, PsiType>)Pair.create((Object)storeProblem.getFromType(), (Object)storeProblem.getToType()));
                return;
            }
        }
        if (problem instanceof ContractFailureProblem) {
            ContractFailureProblem contractFailure = (ContractFailureProblem)problem;
            Boolean isFailing = this.myFailingCalls.get(problem);
            if (isFailing == null) {
                if (DataFlowInstructionVisitor.hasTrivialFailContract((PsiExpression)contractFailure.getAnchor())) return;
            }
            this.myFailingCalls.put(contractFailure, failed == ThreeState.YES && !Boolean.FALSE.equals(isFailing));
            return;
        }
        if (problem instanceof NullabilityProblemKind.NullabilityProblem) {
            boolean unknown;
            NullabilityProblemKind.NullabilityProblem nullabilityProblem = (NullabilityProblemKind.NullabilityProblem)problem;
            DfaNullability nullability = DfaNullability.fromDfType(state.getDfType(value));
            boolean notNullable = nullability != DfaNullability.NULL && nullability != DfaNullability.NULLABLE;
            boolean bl = unknown = this.myStrictMode && nullability == DfaNullability.UNKNOWN;
            ThreeState ok = notNullable ? (unknown ? ThreeState.UNSURE : ThreeState.YES) : ThreeState.NO;
            StateInfo info = this.myStateInfos.computeIfAbsent(nullabilityProblem, k -> new StateInfo());
            info.update(state, ok);
            return;
        }
        if (!(problem instanceof ConsumedStreamProblem)) return;
        ConsumedStreamProblem consumedStreamProblem = (ConsumedStreamProblem)problem;
        this.myStreamConsumed.computeIfAbsent((PsiElement)consumedStreamProblem.getAnchor(), e -> new StateInfo()).update(state, ThreeState.fromBoolean((failed != ThreeState.YES ? 1 : 0) != 0));
    }

    @Override
    public void beforeInstanceInitializerEnd(@NotNull DfaMemoryState state) {
        if (state == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(25);
        }
        this.myEndOfInitializerStates.add(state.createCopy());
    }

    private static boolean hasTrivialFailContract(@NotNull PsiExpression call) {
        List<? extends MethodContract> contracts;
        if (call == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(26);
        }
        return (contracts = DataFlowInstructionVisitor.getContracts(call)) != null && contracts.size() == 1 && contracts.get(0).isTrivial() && contracts.get(0).getReturnValue().isFail();
    }

    private void reportMutabilityViolation(boolean receiver, @NotNull PsiElement anchor) {
        if (anchor == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(27);
        }
        if (receiver) {
            if (anchor instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)anchor;
                anchor = methodRef.getReferenceNameElement();
            } else if (anchor instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)anchor;
                anchor = call.getMethodExpression().getReferenceNameElement();
            }
            if (anchor != null) {
                this.myReceiverMutabilityViolation.add(anchor);
            }
        } else {
            this.myArgumentMutabilityViolation.add(anchor);
        }
    }

    @Nullable
    static List<? extends MethodContract> getContracts(@NotNull PsiExpression anchor) {
        PsiMethodReferenceExpression methodRef;
        PsiElement psiElement;
        List<? extends MethodContract> contracts;
        if (anchor == null) {
            DataFlowInstructionVisitor.$$$reportNull$$$0(28);
        }
        if (anchor instanceof PsiCallExpression) {
            PsiCallExpression call = (PsiCallExpression)anchor;
            contracts = JavaMethodContractUtil.getMethodCallContracts(call);
        } else if (anchor instanceof PsiMethodReferenceExpression && (psiElement = (methodRef = (PsiMethodReferenceExpression)anchor).resolve()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            contracts = JavaMethodContractUtil.getMethodContracts(method);
        } else {
            return null;
        }
        return contracts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 4: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 20: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failed";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInstructionVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromDfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeAssignment";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "beforePush";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUsefulInstanceof";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkUselessCall";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "beforeExpressionPush";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "beforeValueReturn";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onCondition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "beforeInstanceInitializerEnd";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasTrivialFailContract";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reportMutabilityViolation";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getContracts";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    record ArgResultEquality(boolean argsEqual, boolean firstArgEqualToResult, boolean secondArgEqualToResult) {
        ArgResultEquality merge(ArgResultEquality other) {
            return new ArgResultEquality(this.argsEqual && other.argsEqual, this.firstArgEqualToResult && other.firstArgEqualToResult, this.secondArgEqualToResult && other.secondArgEqualToResult);
        }

        boolean hasEquality() {
            return this.argsEqual || this.firstArgEqualToResult || this.secondArgEqualToResult;
        }
    }

    private static class StateInfo {
        boolean ephemeralException;
        boolean normalException;
        boolean normalOk;
        boolean unknown = true;

        private StateInfo() {
        }

        void update(DfaMemoryState state, ThreeState ok) {
            if (state.isEphemeral()) {
                if (ok != ThreeState.YES) {
                    this.ephemeralException = true;
                }
                if (ok != ThreeState.UNSURE) {
                    this.unknown = false;
                }
            } else if (ok == ThreeState.YES) {
                this.normalOk = true;
            } else {
                this.normalException = true;
                if (ok != ThreeState.UNSURE) {
                    this.unknown = false;
                }
            }
        }

        boolean shouldReport() {
            return this.normalException || this.ephemeralException && !this.normalOk;
        }

        boolean alwaysFails() {
            return (this.normalException || this.ephemeralException) && !this.normalOk;
        }
    }
}

