/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ConsumedStreamUtils;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ConstructionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HardcodedContracts {
    private static final List<MethodContract> ARRAY_RANGE_CONTRACTS = List.of(MethodContract.singleConditionContract(ContractValue.argument(1), RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), ContractReturnValue.fail()), MethodContract.singleConditionContract(ContractValue.argument(2), RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), ContractReturnValue.fail()), MethodContract.singleConditionContract(ContractValue.argument(1), RelationType.GT, ContractValue.argument(2), ContractReturnValue.fail()));
    private static final CallMatcher QUEUE_POLL = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Queue", "poll").parameterCount(0), CallMatcher.instanceCall("java.util.Deque", "pollFirst", "pollLast").parameterCount(0));
    private static final Set<String> PURE_ARRAY_METHODS = Set.of("binarySearch", "spliterator", "stream", "equals", "deepEquals");
    private static final CallMatcher NO_PARAMETER_LEAK_METHODS = CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "addAll", "removeAll", "retainAll").parameterTypes("java.util.Collection"), CallMatcher.instanceCall("java.util.List", "addAll").parameterTypes("int", "java.util.Collection"), CallMatcher.instanceCall("java.util.Map", "putAll").parameterTypes("java.util.Map"));
    private static final CallMatcher NO_QUALIFIER_LEAK_MATCHERS = ConsumedStreamUtils.getAllNonLeakStreamMatchers();
    private static final CallMapper<ContractProvider> HARDCODED_CONTRACTS = new CallMapper<ContractProvider>().register(CallMatcher.anyOf(CallMatcher.staticCall("com.google.common.base.Preconditions", "checkNotNull"), CallMatcher.staticCall("java.util.Objects", "requireNonNull")), (call, cnt) -> cnt > 0 ? HardcodedContracts.failIfNull(0, cnt, true) : null).register((CallMatcher)CallMatcher.staticCall("com.google.common.base.Preconditions", "checkArgument", "checkState"), (call, cnt) -> {
        if (cnt == 0) {
            return null;
        }
        StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(cnt);
        constraints[0] = StandardMethodContract.ValueConstraint.FALSE_VALUE;
        return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
    }).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "charAt", "codePointAt").parameterCount(1), ContractProvider.of(HardcodedContracts.specialFieldRangeContract(0, RelationType.LT, SpecialField.STRING_LENGTH))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.lang.String", "substring", "subSequence").parameterCount(2), CallMatcher.instanceCall("java.lang.String", "substring").parameterCount(1)), (call, cnt) -> HardcodedContracts.getSubstringContracts(cnt == 2)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "isEmpty").parameterCount(0), ContractProvider.of(SpecialField.STRING_LENGTH.getEmptyContracts())).register((CallMatcher)CallMatcher.staticCall("com.google.common.base.Strings", "emptyToNull").parameterTypes("java.lang.String"), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0).specialField(SpecialField.STRING_LENGTH), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnNull()), MethodContract.trivialContract(ContractReturnValue.returnParameter(0)))).register((CallMatcher)CallMatcher.staticCall("com.google.common.base.Strings", "isNullOrEmpty").parameterTypes("java.lang.String"), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.nullValue(), ContractReturnValue.returnTrue()), MethodContract.singleConditionContract(ContractValue.argument(0).specialField(SpecialField.STRING_LENGTH), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()))).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "isBlank").parameterCount(0), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.STRING_LENGTH), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "isEmpty").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "isEmpty").parameterCount(0)), ContractProvider.of(SpecialField.COLLECTION_SIZE.getEmptyContracts())).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "equalsIgnoreCase").parameterCount(1), ContractProvider.of(SpecialField.STRING_LENGTH.getEqualsContracts())).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Set", "equals").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.List", "equals").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Map", "equals").parameterTypes("java.lang.Object")), ContractProvider.of(SpecialField.COLLECTION_SIZE.getEqualsContracts())).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "contains").parameterCount(1), CallMatcher.instanceCall("java.util.Map", "containsKey", "containsValue").parameterCount(1)), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnFalse()))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Set", "add").parameterCount(1)), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()))).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "get", "remove").parameterTypes("int"), ContractProvider.of(HardcodedContracts.specialFieldRangeContract(0, RelationType.LT, SpecialField.COLLECTION_SIZE))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.SortedSet", "first", "last").parameterCount(0), CallMatcher.instanceCall("java.util.Deque", "getFirst", "getLast").parameterCount(0), CallMatcher.instanceCall("java.util.Queue", "element").parameterCount(0)), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.fail()))).register((CallMatcher)CallMatcher.staticCall("java.util.Arrays", "fill", "parallelPrefix", "parallelSort", "sort", "spliterator", "stream"), (call, cnt) -> cnt >= 3 ? ARRAY_RANGE_CONTRACTS : null).register((CallMatcher)CallMatcher.staticCall("java.util.Arrays", "binarySearch"), (call, cnt) -> cnt >= 4 ? ARRAY_RANGE_CONTRACTS : null).register((CallMatcher)CallMatcher.staticCall("org.mockito.ArgumentMatchers", "argThat", "assertArg").parameterCount(1), ContractProvider.of((MethodContract)StandardMethodContract.fromText("_->_"))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Queue", "peek", "poll").parameterCount(0), CallMatcher.instanceCall("java.util.Deque", "peekFirst", "peekLast", "pollFirst", "pollLast").parameterCount(0)), (call, paramCount) -> Arrays.asList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnNull()), MethodContract.trivialContract(ContractReturnValue.returnAny()))).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "max").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "max").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "max").parameterTypes("long", "long")), (call, paramCount) -> HardcodedContracts.mathMinMax(true)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Math", "min").parameterTypes("long", "long"), CallMatcher.staticCall("java.lang.Integer", "min").parameterTypes("int", "int"), CallMatcher.staticCall("java.lang.Long", "min").parameterTypes("long", "long")), (call, paramCount) -> HardcodedContracts.mathMinMax(false)).register((CallMatcher)CallMatcher.instanceCall("java.lang.String", "startsWith", "endsWith", "contains"), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0).specialField(SpecialField.STRING_LENGTH), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.qualifier(), ContractReturnValue.returnTrue()), MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.STRING_LENGTH), RelationType.LT, ContractValue.argument(0).specialField(SpecialField.STRING_LENGTH), ContractReturnValue.returnFalse()))).register((CallMatcher)CallMatcher.instanceCall("java.lang.Object", "equals").parameterTypes("java.lang.Object"), (call, paramCount) -> HardcodedContracts.equalsContracts(call)).register(CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2)), (call, paramCount) -> HardcodedContracts.objectEqualsContracts(call)).register((CallMatcher)CallMatcher.staticCall("java.util.Arrays", "equals", "deepEquals").parameterCount(2), ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.argument(1), ContractReturnValue.returnTrue()), StandardMethodContract.fromText("null,!null->false"), StandardMethodContract.fromText("!null,null->false"), MethodContract.singleConditionContract(ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), RelationType.NE, ContractValue.argument(1).specialField(SpecialField.ARRAY_LENGTH), ContractReturnValue.returnFalse()))).register((CallMatcher)CallMatcher.enumValues(), ContractProvider.of((MethodContract)StandardMethodContract.fromText("->new"))).register((CallMatcher)CallMatcher.staticCall("java.lang.System", "arraycopy"), (ContractProvider)((Object)((Function<PsiMethodCallExpression, ContractProvider>)expression -> HardcodedContracts.getArraycopyContract()))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "isAfter"), CallMatcher.instanceCall("java.time.LocalTime", "isAfter"), CallMatcher.instanceCall("java.time.OffsetTime", "isAfter"), CallMatcher.instanceCall("java.time.OffsetDateTime", "isAfter"), CallMatcher.instanceCall("java.time.ZonedDateTime", "isAfter"), CallMatcher.instanceCall("java.time.LocalDateTime", "isAfter"), CallMatcher.instanceCall("java.util.Date", "after"), CallMatcher.instanceCall("java.time.Year", "isAfter"), CallMatcher.instanceCall("java.time.YearMonth", "isAfter")), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.GT, ContractValue.argument(0), ContractReturnValue.returnBoolean(true)), MethodContract.trivialContract(ContractReturnValue.returnBoolean(false))))).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.time.LocalDate", "isBefore"), CallMatcher.instanceCall("java.time.LocalTime", "isBefore"), CallMatcher.instanceCall("java.time.OffsetTime", "isBefore"), CallMatcher.instanceCall("java.time.OffsetDateTime", "isBefore"), CallMatcher.instanceCall("java.time.ZonedDateTime", "isBefore"), CallMatcher.instanceCall("java.time.LocalDateTime", "isBefore"), CallMatcher.instanceCall("java.util.Date", "before"), CallMatcher.instanceCall("java.time.Year", "isBefore"), CallMatcher.instanceCall("java.time.YearMonth", "isBefore")), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.LT, ContractValue.argument(0), ContractReturnValue.returnBoolean(true)), MethodContract.trivialContract(ContractReturnValue.returnBoolean(false))))).register(ConsumedStreamUtils.getSkipStreamMatchers(), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.trivialContract(ContractReturnValue.returnThis())))).register((CallMatcher)CallMatcher.staticCall("java.lang.Character", "isSurrogate").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.constant(Character.valueOf('\ud800'), (PsiType)PsiTypes.charType()), ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.GT, ContractValue.constant(Character.valueOf('\udfff'), (PsiType)PsiTypes.charType()), ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue())))).register((CallMatcher)CallMatcher.staticCall("java.lang.Character", "isHighSurrogate").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.constant(Character.valueOf('\ud800'), (PsiType)PsiTypes.charType()), ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.GT, ContractValue.constant(Character.valueOf('\udbff'), (PsiType)PsiTypes.charType()), ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue())))).register((CallMatcher)CallMatcher.staticCall("java.lang.Character", "isLowSurrogate").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.constant(Character.valueOf('\udc00'), (PsiType)PsiTypes.charType()), ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.GT, ContractValue.constant(Character.valueOf('\udfff'), (PsiType)PsiTypes.charType()), ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue())))).register((CallMatcher)CallMatcher.staticCall("java.lang.Character", "isSupplementaryCodePoint").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.constant(65536, (PsiType)PsiTypes.intType()), ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.GT, ContractValue.constant(0x10FFFF, (PsiType)PsiTypes.intType()), ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue())))).register((CallMatcher)CallMatcher.staticCall("java.lang.Character", "isValidCodePoint").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.constant(0, (PsiType)PsiTypes.intType()), ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.GT, ContractValue.constant(0x10FFFF, (PsiType)PsiTypes.intType()), ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue())))).register((CallMatcher)CallMatcher.staticCall("java.lang.Character", "isBmpCodePoint").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.constant(0, (PsiType)PsiTypes.intType()), ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.GE, ContractValue.constant(65536, (PsiType)PsiTypes.intType()), ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue())))).register((CallMatcher)CallMatcher.staticCall("org.springframework.util.CollectionUtils", "isEmpty").parameterCount(1), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.nullValue(), ContractReturnValue.returnTrue()), MethodContract.singleConditionContract(ContractValue.argument(0).specialField(SpecialField.COLLECTION_SIZE), RelationType.EQ, ContractValue.zero(), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse())))).register((CallMatcher)CallMatcher.instanceCall("java.util.concurrent.TimeUnit", "convert").parameterCount(2), (Function<PsiMethodCallExpression, ContractProvider>)((Object)ContractProvider.of(MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.EQ, ContractValue.argument(1), ContractReturnValue.returnParameter(0)))));

    public static boolean isKnownNoParameterLeak(@Nullable PsiMethod method) {
        PsiClass aClass;
        if (method == null) {
            return false;
        }
        if (ConstructionUtils.isCollectionConstructor(method) && (aClass = method.getContainingClass()) != null) {
            String name = aClass.getQualifiedName();
            return name != null && name.startsWith("java.util.") && (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Map"));
        }
        return NO_PARAMETER_LEAK_METHODS.methodMatches(method);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isKnownNoQualifierLeak(@Nullable PsiMethod method) {
        return NO_QUALIFIER_LEAK_MATCHERS.methodMatches(method);
    }

    @NotNull
    private static ContractProvider getArraycopyContract() {
        ContractValue src = ContractValue.argument(0);
        ContractValue srcPos = ContractValue.argument(1);
        ContractValue dest = ContractValue.argument(2);
        ContractValue destPos = ContractValue.argument(3);
        ContractValue length = ContractValue.argument(4);
        ContractValue srcLength = src.specialField(SpecialField.ARRAY_LENGTH);
        ContractValue dstLength = dest.specialField(SpecialField.ARRAY_LENGTH);
        ContractProvider contractProvider = ContractProvider.of(MethodContract.singleConditionContract(srcPos, RelationType.GT, srcLength, ContractReturnValue.fail()), MethodContract.singleConditionContract(destPos, RelationType.GT, dstLength, ContractReturnValue.fail()), MethodContract.singleConditionContract(srcPos, RelationType.LT, ContractValue.zero(), ContractReturnValue.fail()), MethodContract.singleConditionContract(destPos, RelationType.LT, ContractValue.zero(), ContractReturnValue.fail()), MethodContract.singleConditionContract(length, RelationType.LT, ContractValue.zero(), ContractReturnValue.fail()), MethodContract.singleConditionContract(length, RelationType.GT, srcLength, ContractReturnValue.fail()), MethodContract.singleConditionContract(length, RelationType.GT, dstLength, ContractReturnValue.fail()));
        if (contractProvider == null) {
            HardcodedContracts.$$$reportNull$$$0(0);
        }
        return contractProvider;
    }

    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call) {
        List<MethodContract> contracts;
        PsiClass owner;
        if (method == null) {
            HardcodedContracts.$$$reportNull$$$0(1);
        }
        if ((owner = method.getContainingClass()) == null) {
            return Collections.emptyList();
        }
        PsiFile file = owner.getContainingFile();
        if (file != null && InjectedLanguageManager.getInstance((Project)owner.getProject()).isInjectedFragment(file)) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className = owner.getQualifiedName();
        if (className == null) {
            return Collections.emptyList();
        }
        if (method.isConstructor() && className.equals("java.util.concurrent.ArrayBlockingQueue") && paramCount == 3) {
            return List.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LT, ContractValue.argument(2).specialField(SpecialField.COLLECTION_SIZE), ContractReturnValue.fail()), MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LE, ContractValue.constant(0, (PsiType)PsiTypes.intType()), ContractReturnValue.fail()));
        }
        ContractProvider provider = HARDCODED_CONTRACTS.mapFirst(method);
        if (provider != null && (contracts = provider.getContracts(call, paramCount)) != null) {
            return contracts;
        }
        String methodName = method.getName();
        if ("org.apache.commons.lang.Validate".equals(className) || "org.apache.commons.lang3.Validate".equals(className) || "org.springframework.util.Assert".equals(className)) {
            if (("isTrue".equals(methodName) || "state".equals(methodName)) && paramCount > 0) {
                StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = StandardMethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
            }
            if ("notNull".equals(methodName) && paramCount > 0) {
                StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = StandardMethodContract.ValueConstraint.NULL_VALUE;
                StandardMethodContract contract = new StandardMethodContract(constraints, ContractReturnValue.fail());
                if (PsiTypes.voidType().equals((Object)method.getReturnType())) {
                    return Collections.singletonList(contract);
                }
                return Arrays.asList(contract, new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), ContractReturnValue.returnParameter(0)));
            }
        } else {
            if (HardcodedContracts.isJunit(className) || HardcodedContracts.isTestng(className) || className.equals("org.hamcrest.MatcherAssert") || className.equals("org.hamcrest.junit.MatcherAssert")) {
                return HardcodedContracts.handleTestFrameworks(method, paramCount, className, methodName, call);
            }
            if (TypeUtils.isOptional(owner)) {
                if (OptionalUtil.OPTIONAL_GET.methodMatches(method) || "orElseThrow".equals(methodName)) {
                    return Collections.singletonList(HardcodedContracts.optionalAbsentContract(ContractReturnValue.fail()));
                }
                if ("isPresent".equals(methodName) && paramCount == 0) {
                    return Arrays.asList(HardcodedContracts.optionalAbsentContract(ContractReturnValue.returnFalse()), MethodContract.trivialContract(ContractReturnValue.returnTrue()));
                }
                if ("isEmpty".equals(methodName) && paramCount == 0) {
                    return Arrays.asList(HardcodedContracts.optionalAbsentContract(ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()));
                }
            } else if (MethodUtils.isEquals(method)) {
                return Collections.singletonList(new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()));
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> getSubstringContracts(boolean endLimited) {
        ArrayList<MethodContract> contracts = new ArrayList<MethodContract>(3);
        contracts.add(HardcodedContracts.specialFieldRangeContract(0, RelationType.LE, SpecialField.STRING_LENGTH));
        if (endLimited) {
            contracts.add(HardcodedContracts.specialFieldRangeContract(1, RelationType.LE, SpecialField.STRING_LENGTH));
            contracts.add(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.LE.getNegated(), ContractValue.argument(1), ContractReturnValue.fail()));
        }
        ArrayList<MethodContract> arrayList = contracts;
        if (arrayList == null) {
            HardcodedContracts.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    static MethodContract optionalAbsentContract(ContractReturnValue returnValue) {
        return MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.OPTIONAL_VALUE), RelationType.EQ, ContractValue.nullValue(), returnValue);
    }

    static MethodContract specialFieldRangeContract(int index, RelationType type, SpecialField specialField) {
        return MethodContract.singleConditionContract(ContractValue.argument(index), type.getNegated(), ContractValue.qualifier().specialField(specialField), ContractReturnValue.fail());
    }

    static List<MethodContract> mathMinMax(boolean isMax) {
        return Arrays.asList(MethodContract.singleConditionContract(ContractValue.argument(0), isMax ? RelationType.GT : RelationType.LT, ContractValue.argument(1), ContractReturnValue.returnParameter(0)), MethodContract.trivialContract(ContractReturnValue.returnParameter(1)));
    }

    private static List<MethodContract> equalsContracts(PsiMethodCallExpression call) {
        PsiType type;
        PsiExpression qualifier;
        PsiExpression psiExpression = qualifier = call == null ? null : call.getMethodExpression().getQualifierExpression();
        if (qualifier != null && (type = qualifier.getType()) != null && (HardcodedContracts.knownAsEqualByReference(type) || TypeConstraints.exact(type).isComparedByEquals())) {
            return Arrays.asList(MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.EQ, ContractValue.argument(0), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()));
        }
        return Arrays.asList(new StandardMethodContract(new StandardMethodContract.ValueConstraint[]{StandardMethodContract.ValueConstraint.NULL_VALUE}, ContractReturnValue.returnFalse()), MethodContract.singleConditionContract(ContractValue.qualifier(), RelationType.EQ, ContractValue.argument(0), ContractReturnValue.returnTrue()));
    }

    private static List<MethodContract> objectEqualsContracts(PsiMethodCallExpression call) {
        PsiExpression[] args;
        PsiType type;
        if (call != null && (type = (args = call.getArgumentList().getExpressions())[0].getType()) != null && (HardcodedContracts.knownAsEqualByReference(type) || TypeConstraints.exact(type).isComparedByEquals())) {
            return Arrays.asList(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.argument(1), ContractReturnValue.returnTrue()), MethodContract.trivialContract(ContractReturnValue.returnFalse()));
        }
        return List.of(MethodContract.singleConditionContract(ContractValue.argument(0), RelationType.EQ, ContractValue.argument(1), ContractReturnValue.returnTrue()), StandardMethodContract.fromText("null,!null->false"), StandardMethodContract.fromText("!null,null->false"));
    }

    private static boolean knownAsEqualByReference(PsiType type) {
        if (type instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
        return psiClass != null && (psiClass.isEnum() || "java.lang.Class".equals(psiClass.getQualifiedName()));
    }

    private static boolean isJunit(String className) {
        return className.startsWith("junit.framework.") || className.startsWith("org.junit.") || className.equals("org.testng.AssertJUnit");
    }

    private static boolean isJunit5(String className) {
        return className.startsWith("org.junit.jupiter.");
    }

    private static boolean isTestng(String className) {
        return className.startsWith("org.testng.") && !className.equals("org.testng.AssertJUnit");
    }

    private static List<MethodContract> handleTestFrameworks(PsiMethod method, int paramCount, String className, String methodName, @Nullable PsiMethodCallExpression call) {
        if (call != null && ("assertThat".equals(methodName) || "assumeThat".equals(methodName) || "that".equals(methodName))) {
            return HardcodedContracts.handleAssertThat(paramCount, call);
        }
        if (!HardcodedContracts.isJunit(className) && !HardcodedContracts.isTestng(className)) {
            return Collections.emptyList();
        }
        boolean testng = HardcodedContracts.isTestng(className);
        if ("fail".equals(methodName)) {
            return Collections.singletonList(StandardMethodContract.trivialContract(paramCount, ContractReturnValue.fail()));
        }
        if (paramCount == 0) {
            return Collections.emptyList();
        }
        int checkedParam = testng || HardcodedContracts.isJunit5(className) ? 0 : paramCount - 1;
        PsiType type = Objects.requireNonNull(method.getParameterList().getParameter(checkedParam)).getType();
        StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
        if (("assertTrue".equals(methodName) || "assumeTrue".equals(methodName)) && PsiTypes.booleanType().equals((Object)type)) {
            constraints[checkedParam] = StandardMethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
        }
        if (("assertFalse".equals(methodName) || "assumeFalse".equals(methodName)) && PsiTypes.booleanType().equals((Object)type)) {
            constraints[checkedParam] = StandardMethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
        }
        if ("assertNull".equals(methodName) && TypeUtils.isJavaLangObject(type)) {
            constraints[checkedParam] = StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
        }
        if ("assertNotNull".equals(methodName) && TypeUtils.isJavaLangObject(type)) {
            return HardcodedContracts.failIfNull(checkedParam, paramCount, false);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static StandardMethodContract.ValueConstraint constraintFromMatcher(PsiExpression expr, boolean negate) {
        if (!(expr instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
        String calledName = call.getMethodExpression().getReferenceName();
        PsiExpression[] args = call.getArgumentList().getExpressions();
        String string = calledName;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"array", "arrayWithSize", "arrayContaining", "arrayContainingInAnyOrder", "contains", "containsInAnyOrder", "containsString", "endsWith", "startsWith", "stringContainsInOrder", "empty", "emptyArray", "emptyCollectionOf", "emptyIterable", "emptyIterableOf", "hasEntry", "hasItem", "hasItems", "hasKey", "hasProperty", "hasSize", "hasToString", "hasValue", "hasXPath", "notNullValue", "nullValue", "equalTo", "not", "is"}, (Object)string, n)) {
            case 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> {
                if (negate) {
                    yield null;
                }
                yield StandardMethodContract.ValueConstraint.NULL_VALUE;
            }
            case 24 -> {
                if (negate) {
                    yield StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
                }
                yield StandardMethodContract.ValueConstraint.NULL_VALUE;
            }
            case 25 -> {
                if (negate) {
                    yield StandardMethodContract.ValueConstraint.NULL_VALUE;
                }
                yield StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
            }
            case 26 -> {
                if (args.length == 1) {
                    yield HardcodedContracts.constraintFromLiteral(args[0], negate);
                }
                yield null;
            }
            case 27 -> {
                if (args.length == 1) {
                    yield HardcodedContracts.constraintFromMatcher(args[0], !negate);
                }
                yield null;
            }
            case 28 -> {
                if (args.length == 1) {
                    StandardMethodContract.ValueConstraint fromMatcher = HardcodedContracts.constraintFromMatcher(args[0], negate);
                    if (fromMatcher == null) {
                        yield HardcodedContracts.constraintFromLiteral(args[0], negate);
                    }
                    yield fromMatcher;
                }
                yield null;
            }
            default -> null;
        };
    }

    @Nullable
    private static StandardMethodContract.ValueConstraint constraintFromLiteral(PsiExpression arg, boolean negate) {
        if (!((arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)arg)) instanceof PsiLiteralExpression)) {
            return null;
        }
        Object value = ((PsiLiteralExpression)arg).getValue();
        if (value == null) {
            return negate ? StandardMethodContract.ValueConstraint.NULL_VALUE : StandardMethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        if (Boolean.TRUE.equals(value)) {
            return negate ? StandardMethodContract.ValueConstraint.TRUE_VALUE : StandardMethodContract.ValueConstraint.FALSE_VALUE;
        }
        if (Boolean.FALSE.equals(value)) {
            return negate ? StandardMethodContract.ValueConstraint.FALSE_VALUE : StandardMethodContract.ValueConstraint.TRUE_VALUE;
        }
        return null;
    }

    @NotNull
    private static List<MethodContract> handleAssertThat(int paramCount, @NotNull PsiMethodCallExpression call) {
        PsiExpression[] args;
        if (call == null) {
            HardcodedContracts.$$$reportNull$$$0(3);
        }
        if ((args = call.getArgumentList().getExpressions()).length == paramCount) {
            for (int i = 1; i < args.length; ++i) {
                StandardMethodContract.ValueConstraint constraint = HardcodedContracts.constraintFromMatcher(args[i], false);
                if (constraint == null) continue;
                StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[i - 1] = constraint;
                List<MethodContract> list = Collections.singletonList(new StandardMethodContract(constraints, ContractReturnValue.fail()));
                if (list == null) {
                    HardcodedContracts.$$$reportNull$$$0(4);
                }
                return list;
            }
        }
        List<MethodContract> list = Collections.emptyList();
        if (list == null) {
            HardcodedContracts.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private static List<MethodContract> failIfNull(int argIndex, int argCount, boolean returnArg) {
        StandardMethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(argCount);
        constraints[argIndex] = StandardMethodContract.ValueConstraint.NULL_VALUE;
        StandardMethodContract failContract = new StandardMethodContract(constraints, ContractReturnValue.fail());
        if (returnArg) {
            List<MethodContract> list = Arrays.asList(failContract, StandardMethodContract.trivialContract(argCount, ContractReturnValue.returnParameter(argIndex)));
            if (list == null) {
                HardcodedContracts.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<MethodContract> list = Collections.singletonList(failContract);
        if (list == null) {
            HardcodedContracts.$$$reportNull$$$0(7);
        }
        return list;
    }

    public static MutationSignature getHardcodedMutation(PsiMethod method) {
        PsiParameter[] parameters;
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return MutationSignature.unknown();
        }
        String className = aClass.getQualifiedName();
        if (className == null) {
            return MutationSignature.unknown();
        }
        String name = method.getName();
        if ("java.util.Objects".equals(className) && "requireNonNull".equals(name) && (parameters = method.getParameterList().getParameters()).length == 2 && parameters[1].getType().getCanonicalText().contains("Supplier")) {
            return MutationSignature.unknown();
        }
        if ("remove".equals(name) || "add".equals(name)) {
            return MutationSignature.pure().alsoMutatesThis();
        }
        if ("java.lang.System".equals(className)) {
            return MutationSignature.unknown();
        }
        if ("java.util.Arrays".equals(className)) {
            return PURE_ARRAY_METHODS.contains(name) ? MutationSignature.pure() : MutationSignature.pure().alsoMutatesArg(0);
        }
        if (QUEUE_POLL.methodMatches(method)) {
            return MutationSignature.pure().alsoMutatesThis();
        }
        return MutationSignature.pure();
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent = element.getParent();
            return parent != null && HardcodedContracts.hasHardcodedContracts(parent.getParent());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArraycopyContract";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstringContracts";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleAssertThat";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "failIfNull";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHardcodedContracts";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleAssertThat";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }

    @FunctionalInterface
    static interface ContractProvider {
        public List<MethodContract> getContracts(PsiMethodCallExpression var1, int var2);

        public static ContractProvider of(MethodContract contract) {
            return (call, paramCount) -> Collections.singletonList(contract);
        }

        public static ContractProvider of(MethodContract ... contracts) {
            return (call, paramCount) -> Arrays.asList(contracts);
        }
    }
}

