/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.PsiFieldImpl;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MutationSignature {
    public static final String ATTR_MUTATES = "mutates";
    static final MutationSignature UNKNOWN = new MutationSignature(Kind.MUTATES_ANYTHING, false, false, new boolean[0]);
    private static final MutationSignature PURE = new MutationSignature(Kind.PURE, false, false, new boolean[0]);
    private static final MutationSignature TRANSPARENT = new MutationSignature(Kind.TRANSPARENT, false, false, new boolean[0]);
    private static final MutationSignature MUTATES_THIS_ONLY = new MutationSignature(Kind.OTHER, true, false, new boolean[0]);
    @NotNull
    private final Kind myKind;
    private final boolean myThis;
    private final boolean myIo;
    private final boolean[] myParameters;

    private MutationSignature(@NotNull Kind kind, boolean mutatesThis, boolean io, boolean[] params) {
        if (kind == null) {
            MutationSignature.$$$reportNull$$$0(0);
        }
        if ((kind == Kind.PURE || kind == Kind.TRANSPARENT || kind == Kind.MUTATES_ANYTHING) && (mutatesThis || io || params.length != 0)) {
            throw new IllegalArgumentException();
        }
        this.myKind = kind;
        this.myThis = mutatesThis;
        this.myIo = io;
        this.myParameters = params;
    }

    public boolean mutatesThis() {
        return this.myThis;
    }

    public boolean performsIO() {
        return this.myIo;
    }

    public boolean mutatesArg(int n) {
        return n < this.myParameters.length && this.myParameters[n];
    }

    public boolean preservesThis() {
        return this != UNKNOWN && !this.myThis;
    }

    public boolean preservesArg(int n) {
        return this != UNKNOWN && !this.mutatesArg(n);
    }

    public MutationSignature alsoMutatesThis() {
        return this == UNKNOWN || this.myThis ? this : (this.isPure() ? MUTATES_THIS_ONLY : new MutationSignature(Kind.OTHER, true, this.myIo, this.myParameters));
    }

    public MutationSignature alsoMutatesArg(int n) {
        if (this.myParameters.length > n && this.myParameters[n]) {
            return this;
        }
        boolean[] params = Arrays.copyOf(this.myParameters, Math.max(n + 1, this.myParameters.length));
        params[n] = true;
        return new MutationSignature(Kind.OTHER, this.myThis, this.myIo, params);
    }

    public boolean isPure() {
        return this.myKind == Kind.PURE || this.myKind == Kind.TRANSPARENT;
    }

    public boolean isTransparent() {
        return this.myKind == Kind.TRANSPARENT;
    }

    public int hashCode() {
        int result = this.myKind.hashCode();
        result = 31 * result + Boolean.hashCode(this.myThis);
        result = 31 * result + Boolean.hashCode(this.myIo);
        result = 31 * result + Arrays.hashCode(this.myParameters);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MutationSignature)) return false;
        MutationSignature signature = (MutationSignature)obj;
        if (signature.myKind != this.myKind) return false;
        if (signature.myThis != this.myThis) return false;
        if (signature.myIo != this.myIo) return false;
        if (!Arrays.equals(signature.myParameters, this.myParameters)) return false;
        return true;
    }

    public String toString() {
        return switch (this.myKind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "(transparent)";
            case 1 -> "(pure)";
            case 2 -> "(unknown)";
            case 3 -> IntStreamEx.range((int)this.myParameters.length).mapToEntry(idx -> "param" + (idx + 1), idx -> this.myParameters[idx]).prepend((Object)"this", (Object)this.myThis).prepend((Object)"io", (Object)this.myIo).filterValues(b -> b).keys().joining((CharSequence)",");
        };
    }

    public Stream<PsiExpression> mutatedExpressions(PsiMethodCallExpression call) {
        PsiExpression qualifier;
        Object[] args = call.getArgumentList().getExpressions();
        StreamEx elements = IntStreamEx.range((int)Math.min(this.myParameters.length, MethodCallUtils.isVarArgCall((PsiCall)call) ? args.length - 1 : args.length)).filter(idx -> this.myParameters[idx]).elements(args);
        if (this.myThis && (qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression())) != null) {
            return elements.prepend((Object)qualifier);
        }
        return elements;
    }

    public boolean mutatesAnything() {
        if (this.myThis || this.myIo) {
            return true;
        }
        for (boolean parameter : this.myParameters) {
            if (!parameter) continue;
            return true;
        }
        return false;
    }

    public static MutationSignature parse(@NotNull String signature) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(1);
        }
        if (signature.trim().isEmpty()) {
            return UNKNOWN;
        }
        boolean mutatesThis = false;
        boolean mutatesIO = false;
        boolean[] args = new boolean[]{};
        for (String part : signature.split(",")) {
            if ((part = part.trim()).equals("this")) {
                mutatesThis = true;
                continue;
            }
            if (part.equals("io")) {
                mutatesIO = true;
                continue;
            }
            if (part.equals("param")) {
                if (args.length == 0) {
                    args = new boolean[]{true};
                    continue;
                }
                args[0] = true;
                continue;
            }
            if (part.startsWith("param")) {
                int argNum = Integer.parseInt(part.substring("param".length()));
                if (argNum < 0 || argNum > 255) {
                    throw new IllegalArgumentException(JavaAnalysisBundle.message((String)"mutation.signature.problem.invalid.token", (Object[])new Object[]{part}));
                }
                if (args.length < argNum) {
                    args = Arrays.copyOf(args, argNum);
                }
                args[argNum - 1] = true;
                continue;
            }
            if (part.isEmpty()) continue;
            throw new IllegalArgumentException(JavaAnalysisBundle.message((String)"mutation.signature.problem.invalid.token", (Object[])new Object[]{part}));
        }
        return new MutationSignature(Kind.OTHER, mutatesThis, mutatesIO, args);
    }

    @Nullable
    @InspectionMessage
    public static String checkSignature(@NotNull String signature, @NotNull PsiMethod method) {
        if (signature == null) {
            MutationSignature.$$$reportNull$$$0(2);
        }
        if (method == null) {
            MutationSignature.$$$reportNull$$$0(3);
        }
        try {
            MutationSignature ms = MutationSignature.parse(signature);
            if (ms.myThis && method.hasModifierProperty("static")) {
                return JavaAnalysisBundle.message((String)"mutation.signature.problem.static.method.cannot.mutate.this", (Object[])new Object[0]);
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (ms.myParameters.length > parameters.length) {
                return JavaAnalysisBundle.message((String)"mutation.signature.problem.reference.to.parameter.invalid", (Object[])new Object[]{ms.myParameters.length});
            }
            for (int i = 0; i < ms.myParameters.length; ++i) {
                PsiType type;
                if (!ms.myParameters[i] || !ClassUtils.isImmutable(type = parameters[i].getType())) continue;
                return JavaAnalysisBundle.message((String)"mutation.signature.problem.parameter.has.immutable.type", (Object[])new Object[]{i + 1, type.getPresentableText()});
            }
        }
        catch (IllegalArgumentException ex) {
            return ex.getMessage();
        }
        return null;
    }

    @NotNull
    public static MutationSignature fromMethod(@Nullable PsiMethod method) {
        if (method == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(4);
            }
            return mutationSignature;
        }
        MutationSignature mutationSignature = JavaMethodContractUtil.getContractInfo(method).getMutationSignature();
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(5);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature fromCall(@Nullable PsiCall call) {
        if (call == null) {
            MutationSignature mutationSignature = UNKNOWN;
            if (mutationSignature == null) {
                MutationSignature.$$$reportNull$$$0(6);
            }
            return mutationSignature;
        }
        PsiMethod method = call.resolveMethod();
        if (method != null && !method.isDefaultConstructor()) {
            if (SpecialField.findSpecialField((PsiElement)method) != null) {
                MutationSignature mutationSignature = PURE;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(7);
                }
                return mutationSignature;
            }
            return MutationSignature.fromMethod(method);
        }
        if (call instanceof PsiNewExpression) {
            PsiElement psiElement;
            PsiNewExpression newExpression = (PsiNewExpression)call;
            if (newExpression.isArrayCreation()) {
                MutationSignature mutationSignature = PURE;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(8);
                }
                return mutationSignature;
            }
            if (newExpression.getArgumentList() == null || !newExpression.getArgumentList().isEmpty()) {
                MutationSignature mutationSignature = UNKNOWN;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(9);
                }
                return mutationSignature;
            }
            PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
            if (classReference == null || !((psiElement = classReference.resolve()) instanceof PsiClass)) {
                MutationSignature mutationSignature = UNKNOWN;
                if (mutationSignature == null) {
                    MutationSignature.$$$reportNull$$$0(10);
                }
                return mutationSignature;
            }
            PsiClass clazz = (PsiClass)psiElement;
            HashSet<PsiClass> visited = new HashSet<PsiClass>();
            do {
                for (PsiField psiField : clazz.getFields()) {
                    PsiExpression initializer;
                    if (psiField.hasModifierProperty("static") || !psiField.hasInitializer() || (initializer = PsiUtil.skipParenthesizedExprDown((PsiExpression)PsiFieldImpl.getDetachedInitializer((PsiVariable)psiField))) instanceof PsiLiteralExpression) continue;
                    MutationSignature mutationSignature = UNKNOWN;
                    if (mutationSignature == null) {
                        MutationSignature.$$$reportNull$$$0(11);
                    }
                    return mutationSignature;
                }
                for (PsiField psiField : clazz.getInitializers()) {
                    if (psiField.hasModifierProperty("static")) continue;
                    MutationSignature mutationSignature = UNKNOWN;
                    if (mutationSignature == null) {
                        MutationSignature.$$$reportNull$$$0(12);
                    }
                    return mutationSignature;
                }
                for (PsiField psiField : clazz.getConstructors()) {
                    if (!psiField.getParameterList().isEmpty()) continue;
                    return MutationSignature.fromMethod((PsiMethod)psiField);
                }
            } while ((clazz = clazz.getSuperClass()) != null && visited.add(clazz));
            return MutationSignature.unknown();
        }
        MutationSignature mutationSignature = UNKNOWN;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(13);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature pure() {
        MutationSignature mutationSignature = PURE;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(14);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature transparent() {
        MutationSignature mutationSignature = TRANSPARENT;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(15);
        }
        return mutationSignature;
    }

    @NotNull
    public static MutationSignature unknown() {
        MutationSignature mutationSignature = UNKNOWN;
        if (mutationSignature == null) {
            MutationSignature.$$$reportNull$$$0(16);
        }
        return mutationSignature;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/MutationSignature";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethod";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "fromCall";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "pure";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "transparent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "unknown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkSignature";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    private static enum Kind {
        TRANSPARENT,
        PURE,
        MUTATES_ANYTHING,
        OTHER;

    }
}

