/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.java.inst.AssignInstruction;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PlainDescriptor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.lang.ir.PushInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class NullParameterConstraintChecker {
    NullParameterConstraintChecker() {
    }

    static PsiParameter @NotNull [] checkMethodParameters(PsiMethod method) {
        if (method.getBody() == null) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(0);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        HashSet<PsiParameter> nullableParameters = new HashSet<PsiParameter>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            PsiParameter parameter = parameters[index];
            if (parameter.getType() instanceof PsiPrimitiveType || NullableNotNullManager.getNullability((PsiModifierListOwner)parameter) != Nullability.UNKNOWN || !JavaNullMethodArgumentUtil.hasNullArgument(method, index)) continue;
            nullableParameters.add(parameter);
        }
        if (nullableParameters.isEmpty()) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(1);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        DfaValueFactory factory = new DfaValueFactory(method.getProject());
        ControlFlow flow = ControlFlowAnalyzer.buildFlow((PsiElement)method.getBody(), factory, true);
        if (flow == null) {
            if (PsiParameter.EMPTY_ARRAY == null) {
                NullParameterConstraintChecker.$$$reportNull$$$0(2);
            }
            return PsiParameter.EMPTY_ARRAY;
        }
        NullParameterCheckerInterpreter interpreter = new NullParameterCheckerInterpreter(flow, nullableParameters);
        flow.keepVariables(desc -> {
            PsiParameter psi;
            PsiElement patt0$temp = desc.getPsiElement();
            return patt0$temp instanceof PsiParameter && nullableParameters.contains(psi = (PsiParameter)patt0$temp);
        });
        JvmDfaMemoryStateImpl state = new JvmDfaMemoryStateImpl(factory);
        for (PsiParameter parameter : nullableParameters) {
            state.applyCondition(PlainDescriptor.createVariableValue(factory, (PsiVariable)parameter).eq((DfType)DfaNullability.NULLABLE.asDfType()));
        }
        interpreter.interpret((DfaMemoryState)state);
        PsiParameter[] psiParameterArray = (PsiParameter[])interpreter.myPossiblyViolatedParameters.stream().filter(interpreter.myUsedParameters::contains).filter(interpreter.myParametersWithSuccessfulExecutionInNotNullState::contains).toArray(PsiParameter[]::new);
        if (psiParameterArray == null) {
            NullParameterConstraintChecker.$$$reportNull$$$0(3);
        }
        return psiParameterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker", "checkMethodParameters"));
    }

    private static class NullParameterCheckerInterpreter
    extends StandardDataFlowInterpreter {
        final Set<PsiParameter> myPossiblyViolatedParameters;
        final Set<PsiParameter> myUsedParameters;
        final Set<PsiParameter> myParametersWithSuccessfulExecutionInNotNullState;

        private NullParameterCheckerInterpreter(ControlFlow flow, Set<PsiParameter> nullableParameters) {
            super(flow, DfaListener.EMPTY);
            this.myPossiblyViolatedParameters = nullableParameters;
            this.myUsedParameters = new HashSet<PsiParameter>();
            this.myParametersWithSuccessfulExecutionInNotNullState = new HashSet<PsiParameter>();
        }

        protected DfaInstructionState @NotNull [] acceptInstruction(@NotNull DfaInstructionState instructionState) {
            PsiElement psiVariable;
            DfaValue value;
            PsiElement psiVar;
            DfaValue var;
            Instruction instruction;
            if (instructionState == null) {
                NullParameterCheckerInterpreter.$$$reportNull$$$0(0);
            }
            if ((instruction = instructionState.getInstruction()) instanceof PushInstruction && (var = ((PushInstruction)instruction).getValue()) instanceof DfaVariableValue && (psiVar = ((DfaVariableValue)var).getPsiVariable()) instanceof PsiParameter) {
                this.myUsedParameters.add((PsiParameter)psiVar);
            }
            if (instruction instanceof AssignInstruction && (value = ((AssignInstruction)instruction).getAssignedValue()) instanceof DfaVariableValue && (psiVariable = ((DfaVariableValue)value).getPsiVariable()) instanceof PsiParameter) {
                this.myPossiblyViolatedParameters.remove(psiVariable);
            }
            if (instruction instanceof ReturnInstruction) {
                DfaMemoryState memState = instructionState.getMemoryState();
                for (PsiParameter parameter : this.myPossiblyViolatedParameters.toArray(PsiParameter.EMPTY_ARRAY)) {
                    DfaVariableValue dfaVar = PlainDescriptor.createVariableValue(this.getFactory(), (PsiVariable)parameter);
                    if (!memState.getDfType((DfaValue)dfaVar).isSuperType((DfType)DfTypes.NULL)) {
                        this.myParametersWithSuccessfulExecutionInNotNullState.add(parameter);
                        continue;
                    }
                    this.myPossiblyViolatedParameters.remove(parameter);
                }
            }
            DfaInstructionState[] dfaInstructionStateArray = super.acceptInstruction(instructionState);
            if (dfaInstructionStateArray == null) {
                NullParameterCheckerInterpreter.$$$reportNull$$$0(1);
            }
            return dfaInstructionStateArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "instructionState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$NullParameterCheckerInterpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/NullParameterConstraintChecker$NullParameterCheckerInterpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acceptInstruction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptInstruction";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

