/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ConsumedStreamUtils;
import com.intellij.codeInspection.dataFlow.DfaCallArguments;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfStreamStateType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.util.Objects;
import java.util.Set;

final class SideEffectHandlers {
    private static final CallMapper<SideEffectHandler> HANDLERS = new CallMapper<SideEffectHandler>().register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.List", "set").parameterTypes("int", "E")), (factory, state, arguments) -> {}).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "clear").parameterCount(0), CallMatcher.instanceCall("java.util.Map", "clear").parameterCount(0)), (factory, state, arguments) -> SideEffectHandlers.collectionClear(factory, state, arguments)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.List", "add").parameterTypes("E"), CallMatcher.instanceCall("java.util.List", "add").parameterTypes("int", "E")), (factory, state, arguments) -> SideEffectHandlers.collectionAdd(factory, state, arguments, true)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Set", "add").parameterTypes("E"), CallMatcher.instanceCall("java.util.Map", "put").parameterTypes("K", "V")), (factory, state, arguments) -> SideEffectHandlers.collectionAdd(factory, state, arguments, false)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.List", "addAll").parameterTypes("java.util.Collection"), CallMatcher.instanceCall("java.util.List", "addAll").parameterTypes("int", "java.util.Collection")), (factory, state, arguments) -> SideEffectHandlers.collectionAddAll(factory, state, arguments, true)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Set", "addAll").parameterTypes("java.util.Collection"), CallMatcher.instanceCall("java.util.Map", "putAll").parameterTypes("java.util.Map")), (factory, state, arguments) -> SideEffectHandlers.collectionAddAll(factory, state, arguments, false)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.Collection", "removeAll", "retainAll").parameterTypes("java.util.Collection"), CallMatcher.instanceCall("java.util.Map", "removeAll").parameterTypes("java.util.Map")), (factory, state, arguments) -> SideEffectHandlers.collectionReduce(factory, state, arguments)).register(CallMatcher.anyOf(CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Set", "remove").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Map", "remove").parameterTypes("java.lang.Object"), CallMatcher.instanceCall("java.util.Map", "remove").parameterTypes("java.lang.Object", "java.lang.Object")), (factory, state, arguments) -> SideEffectHandlers.collectionRemove(factory, state, arguments, false)).register((CallMatcher)CallMatcher.instanceCall("java.util.List", "remove").parameterTypes("int"), (factory, state, arguments) -> SideEffectHandlers.collectionRemove(factory, state, arguments, true)).register(ConsumedStreamUtils.getCallToMarkConsumedStreamMatchers(), (factory, state, arguments) -> SideEffectHandlers.streamConsume(factory, state, arguments));

    SideEffectHandlers() {
    }

    private static void collectionAdd(DfaValueFactory factory, DfaMemoryState state, DfaCallArguments arguments, boolean list) {
        DfaVariableValue size = (DfaVariableValue)ObjectUtils.tryCast((Object)SpecialField.COLLECTION_SIZE.createValue(factory, arguments.myQualifier), DfaVariableValue.class);
        if (size != null) {
            DfIntType sizeType = (DfIntType)ObjectUtils.tryCast((Object)state.getDfType((DfaValue)size), DfIntType.class);
            DfType resultSize = SpecialField.COLLECTION_SIZE.getDefaultValue();
            if (sizeType != null) {
                resultSize = sizeType.eval(DfTypes.intValue(1), LongRangeBinOp.PLUS).meet(DfTypes.intRange(JvmPsiRangeSetUtil.indexRange()));
                if (!list) {
                    resultSize = resultSize.join(sizeType.meet(DfTypes.intRange(LongRangeSet.range((long)1L, (long)Integer.MAX_VALUE))));
                }
                if (resultSize == DfType.BOTTOM) {
                    resultSize = SpecialField.COLLECTION_SIZE.getDefaultValue();
                }
            }
            SideEffectHandlers.updateState(state, size, resultSize);
        }
    }

    private static void collectionRemove(DfaValueFactory factory, DfaMemoryState state, DfaCallArguments arguments, boolean strict) {
        DfaVariableValue size = (DfaVariableValue)ObjectUtils.tryCast((Object)SpecialField.COLLECTION_SIZE.createValue(factory, arguments.myQualifier), DfaVariableValue.class);
        if (size != null) {
            DfIntType sizeType = (DfIntType)ObjectUtils.tryCast((Object)state.getDfType((DfaValue)size), DfIntType.class);
            DfType resultSize = SpecialField.COLLECTION_SIZE.getDefaultValue();
            if (sizeType != null) {
                resultSize = sizeType.eval(DfTypes.intRange(LongRangeSet.range((long)(strict ? 1L : 0L), (long)1L)), LongRangeBinOp.MINUS).meet(DfTypes.intRange(JvmPsiRangeSetUtil.indexRange()));
            }
            SideEffectHandlers.updateState(state, size, resultSize);
        }
    }

    private static void collectionAddAll(DfaValueFactory factory, DfaMemoryState state, DfaCallArguments arguments, boolean list) {
        DfaVariableValue size = (DfaVariableValue)ObjectUtils.tryCast((Object)SpecialField.COLLECTION_SIZE.createValue(factory, arguments.myQualifier), DfaVariableValue.class);
        DfaValue argSize = SpecialField.COLLECTION_SIZE.createValue(factory, (DfaValue)ArrayUtil.getLastElement((Object[])arguments.myArguments));
        if (size != null) {
            DfIntType sizeType = (DfIntType)ObjectUtils.tryCast((Object)state.getDfType((DfaValue)size), DfIntType.class);
            DfType argSizeType = (DfType)ObjectUtils.tryCast((Object)state.getDfType(argSize), DfIntType.class);
            DfType resultSize = SpecialField.COLLECTION_SIZE.getDefaultValue();
            if (sizeType != null && argSizeType != null) {
                LongRangeSet totalRange = JvmPsiRangeSetUtil.indexRange();
                if (!list) {
                    LongRangeSet argSizeRange = DfIntType.extractRange(argSizeType);
                    if (!argSizeRange.contains(0L)) {
                        totalRange = totalRange.without(0L);
                    }
                    LongRangeSet addedForSet = argSizeRange.fromRelation(RelationType.LE).meet(JvmPsiRangeSetUtil.indexRange());
                    argSizeType = argSizeType.join(DfTypes.intRange(addedForSet));
                }
                if ((resultSize = sizeType.eval(argSizeType, LongRangeBinOp.PLUS).meet(DfTypes.intRange(totalRange))) == DfType.BOTTOM) {
                    resultSize = SpecialField.COLLECTION_SIZE.getDefaultValue();
                }
            }
            SideEffectHandlers.updateState(state, size, resultSize);
        }
    }

    private static void collectionReduce(DfaValueFactory factory, DfaMemoryState state, DfaCallArguments arguments) {
        DfaVariableValue size = (DfaVariableValue)ObjectUtils.tryCast((Object)SpecialField.COLLECTION_SIZE.createValue(factory, arguments.myQualifier), DfaVariableValue.class);
        if (size != null) {
            DfIntType sizeType = (DfIntType)ObjectUtils.tryCast((Object)state.getDfType((DfaValue)size), DfIntType.class);
            DfType resultSize = SpecialField.COLLECTION_SIZE.getDefaultValue();
            if (sizeType != null) {
                LongRangeSet newSize = sizeType.getRange().fromRelation(RelationType.LE).meet(JvmPsiRangeSetUtil.indexRange());
                resultSize = sizeType.join(DfTypes.intRange(newSize));
            }
            SideEffectHandlers.updateState(state, size, resultSize);
        }
    }

    private static void collectionClear(DfaValueFactory factory, DfaMemoryState state, DfaCallArguments arguments) {
        DfaVariableValue size = (DfaVariableValue)ObjectUtils.tryCast((Object)SpecialField.COLLECTION_SIZE.createValue(factory, arguments.myQualifier), DfaVariableValue.class);
        if (size != null) {
            SideEffectHandlers.updateState(state, size, DfTypes.intValue(0));
        }
    }

    private static void streamConsume(DfaValueFactory factory, DfaMemoryState state, DfaCallArguments arguments) {
        DfaVariableValue consumedStream = (DfaVariableValue)ObjectUtils.tryCast((Object)SpecialField.CONSUMED_STREAM.createValue(factory, arguments.myQualifier), DfaVariableValue.class);
        if (consumedStream != null) {
            SideEffectHandlers.updateState(state, consumedStream, DfStreamStateType.CONSUMED);
        }
    }

    static SideEffectHandler getHandler(PsiMethod method) {
        return HANDLERS.mapFirst(method);
    }

    private static void updateState(DfaMemoryState state, DfaVariableValue var, DfType type) {
        state.flushFieldsQualifiedBy(Set.of((DfaValue)Objects.requireNonNull(var.getQualifier())));
        state.meetDfType((DfaValue)var, type);
    }

    static interface SideEffectHandler {
        public void handleSideEffect(DfaValueFactory var1, DfaMemoryState var2, DfaCallArguments var3);
    }
}

