/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.java.JavaClassDef;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.LambdaMetafactory;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeConstraints {
    @NotNull
    public static final TypeConstraint TOP = new TopConstraint();
    @NotNull
    public static final TypeConstraint BOTTOM = new BottomConstraint();
    @NotNull
    public static final TypeConstraint.Exact EXACTLY_OBJECT = new ExactObject();

    @Nullable
    private static TypeConstraint.Exact createExact(@NotNull PsiType type) {
        if (type == null) {
            TypeConstraints.$$$reportNull$$$0(0);
        }
        if (type instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)type;
            PsiType componentType = arrayType.getComponentType();
            if (componentType instanceof PsiPrimitiveType) {
                for (PrimitiveArray p : PrimitiveArray.values()) {
                    if (!p.getType().equals((Object)componentType)) continue;
                    return p;
                }
                return null;
            }
            TypeConstraint.Exact componentConstraint = TypeConstraints.createExact(componentType);
            return componentConstraint == null ? null : new ExactArray(componentConstraint);
        }
        if (type instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)type;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null) {
                return new Unresolved(type.getCanonicalText());
            }
            if (!(psiClass instanceof PsiTypeParameter)) {
                return TypeConstraints.exactClass(psiClass);
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static TypeConstraint exact(@NotNull PsiType type) {
        TypeConstraint.Exact exact;
        if (type == null) {
            TypeConstraints.$$$reportNull$$$0(1);
        }
        if ((exact = TypeConstraints.createExact(type = TypeConstraints.normalizeType(type))) != null && exact.canBeInstantiated()) {
            TypeConstraint.Exact exact2 = exact;
            if (exact2 == null) {
                TypeConstraints.$$$reportNull$$$0(2);
            }
            return exact2;
        }
        TypeConstraint typeConstraint = BOTTOM;
        if (typeConstraint == null) {
            TypeConstraints.$$$reportNull$$$0(3);
        }
        return typeConstraint;
    }

    @NotNull
    public static TypeConstraint exactSubtype(@NotNull PsiElement id, @NotNull PsiType superType) {
        TypeConstraint.Exact exact;
        if (id == null) {
            TypeConstraints.$$$reportNull$$$0(4);
        }
        if (superType == null) {
            TypeConstraints.$$$reportNull$$$0(5);
        }
        if ((superType = TypeConstraints.normalizeType(superType)) instanceof PsiClassType && (exact = TypeConstraints.createExact(superType)) != null && !exact.isFinal()) {
            return new ExactSubclass(id, exact);
        }
        if (superType instanceof PsiIntersectionType) {
            PsiIntersectionType intersectionType = (PsiIntersectionType)superType;
            ArrayList<TypeConstraint.Exact> supers = new ArrayList<TypeConstraint.Exact>();
            for (PsiType conjunct : intersectionType.getConjuncts()) {
                TypeConstraint.Exact exact2 = TypeConstraints.createExact(conjunct);
                if (exact2 == null || exact2.isFinal()) {
                    TypeConstraint typeConstraint = BOTTOM;
                    if (typeConstraint == null) {
                        TypeConstraints.$$$reportNull$$$0(6);
                    }
                    return typeConstraint;
                }
                supers.add(exact2);
            }
            return new ExactSubclass(id, supers.toArray(new TypeConstraint.Exact[0]));
        }
        TypeConstraint typeConstraint = BOTTOM;
        if (typeConstraint == null) {
            TypeConstraints.$$$reportNull$$$0(7);
        }
        return typeConstraint;
    }

    @NotNull
    public static TypeConstraint exactSubtype(@NotNull PsiElement id, @NotNull List<ClassDef> superClasses) {
        Object[] supers;
        if (id == null) {
            TypeConstraints.$$$reportNull$$$0(8);
        }
        if (superClasses == null) {
            TypeConstraints.$$$reportNull$$$0(9);
        }
        if (ContainerUtil.or((Object[])(supers = (TypeConstraint.Exact[])ContainerUtil.map2Array(superClasses, TypeConstraint.Exact.class, cls -> TypeConstraints.exactClass(cls))), TypeConstraint.Exact::isFinal)) {
            TypeConstraint typeConstraint = BOTTOM;
            if (typeConstraint == null) {
                TypeConstraints.$$$reportNull$$$0(10);
            }
            return typeConstraint;
        }
        if (supers.length == 0) {
            supers = new TypeConstraint.Exact[]{EXACTLY_OBJECT};
        }
        return new ExactSubclass(id, (TypeConstraint.Exact[])supers);
    }

    @Contract(pure=true)
    @NotNull
    public static TypeConstraint instanceOf(@NotNull PsiType type) {
        if (type == null) {
            TypeConstraints.$$$reportNull$$$0(11);
        }
        if (type instanceof PsiLambdaExpressionType || type instanceof PsiMethodReferenceType) {
            TypeConstraint typeConstraint = TOP;
            if (typeConstraint == null) {
                TypeConstraints.$$$reportNull$$$0(12);
            }
            return typeConstraint;
        }
        if ((type = TypeConstraints.normalizeType(type)) instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
            type = disjunctionType.getLeastUpperBound();
        }
        if (type instanceof PsiIntersectionType) {
            PsiIntersectionType intersectionType = (PsiIntersectionType)type;
            PsiType[] conjuncts = intersectionType.getConjuncts();
            TypeConstraint result = TOP;
            for (PsiType conjunct : conjuncts) {
                TypeConstraint.Exact exact = TypeConstraints.createExact(conjunct);
                if (exact == null) {
                    TypeConstraint typeConstraint = new Unresolved(type.getCanonicalText()).instanceOf();
                    if (typeConstraint == null) {
                        TypeConstraints.$$$reportNull$$$0(13);
                    }
                    return typeConstraint;
                }
                result = result.meet(exact.instanceOf());
            }
            TypeConstraint typeConstraint = result;
            if (typeConstraint == null) {
                TypeConstraints.$$$reportNull$$$0(14);
            }
            return typeConstraint;
        }
        TypeConstraint.Exact exact = TypeConstraints.createExact(type);
        if (exact == null) {
            TypeConstraint typeConstraint = new Unresolved(type.getCanonicalText()).instanceOf();
            if (typeConstraint == null) {
                TypeConstraints.$$$reportNull$$$0(15);
            }
            return typeConstraint;
        }
        TypeConstraint typeConstraint = exact.instanceOf();
        if (typeConstraint == null) {
            TypeConstraints.$$$reportNull$$$0(16);
        }
        return typeConstraint;
    }

    @NotNull
    private static PsiType normalizeType(@NotNull PsiType psiType) {
        PsiIntersectionType intersectionType;
        PsiType[] types;
        if (psiType == null) {
            TypeConstraints.$$$reportNull$$$0(17);
        }
        if (psiType instanceof PsiArrayType) {
            PsiType normalized = TypeConstraints.normalizeType(psiType.getDeepComponentType());
            int dimensions = psiType.getArrayDimensions();
            if (normalized instanceof PsiIntersectionType) {
                PsiType[] types2 = (PsiType[])ContainerUtil.map2Array((Object[])((PsiIntersectionType)normalized).getConjuncts(), (Object[])PsiType.EMPTY_ARRAY, t -> PsiTypesUtil.createArrayType((PsiType)t, (int)dimensions));
                PsiType psiType2 = PsiIntersectionType.createIntersection((boolean)true, (PsiType[])types2);
                if (psiType2 == null) {
                    TypeConstraints.$$$reportNull$$$0(18);
                }
                return psiType2;
            }
            PsiType psiType3 = PsiTypesUtil.createArrayType((PsiType)normalized, (int)dimensions);
            if (psiType3 == null) {
                TypeConstraints.$$$reportNull$$$0(19);
            }
            return psiType3;
        }
        if (psiType instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)psiType;
            return TypeConstraints.normalizeType(wildcardType.getExtendsBound());
        }
        if (psiType instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType wildcardType = (PsiCapturedWildcardType)psiType;
            return TypeConstraints.normalizeType(wildcardType.getUpperBound());
        }
        if (psiType instanceof PsiIntersectionType && (types = (PsiType[])ContainerUtil.map2Array((Object[])(intersectionType = (PsiIntersectionType)psiType).getConjuncts(), (Object[])PsiType.EMPTY_ARRAY, TypeConstraints::normalizeType)).length > 0) {
            PsiType psiType4 = PsiIntersectionType.createIntersection((boolean)true, (PsiType[])types);
            if (psiType4 == null) {
                TypeConstraints.$$$reportNull$$$0(20);
            }
            return psiType4;
        }
        if (psiType instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)psiType;
            return TypeConstraints.normalizeClassType(classType, new HashSet<PsiClass>());
        }
        PsiType psiType5 = psiType;
        if (psiType5 == null) {
            TypeConstraints.$$$reportNull$$$0(21);
        }
        return psiType5;
    }

    @NotNull
    private static PsiType normalizeClassType(@NotNull PsiClassType psiType, Set<PsiClass> processed) {
        PsiClass aClass;
        if (psiType == null) {
            TypeConstraints.$$$reportNull$$$0(22);
        }
        if ((aClass = psiType.resolve()) instanceof PsiTypeParameter) {
            PsiClassType[] types = aClass.getExtendsListTypes();
            ArrayList<PsiType> result = new ArrayList<PsiType>();
            for (PsiClassType type : types) {
                PsiClass resolved = type.resolve();
                if (resolved == null || !processed.add(resolved)) continue;
                PsiClassType classType = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(resolved);
                result.add(TypeConstraints.normalizeClassType(classType, processed));
            }
            if (!result.isEmpty()) {
                PsiType psiType2 = PsiIntersectionType.createIntersection((boolean)true, (PsiType[])result.toArray(PsiType.EMPTY_ARRAY));
                if (psiType2 == null) {
                    TypeConstraints.$$$reportNull$$$0(23);
                }
                return psiType2;
            }
            PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)aClass.getManager(), (GlobalSearchScope)aClass.getResolveScope());
            if (psiClassType == null) {
                TypeConstraints.$$$reportNull$$$0(24);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = psiType;
        if (psiClassType == null) {
            TypeConstraints.$$$reportNull$$$0(25);
        }
        return psiClassType;
    }

    @NotNull
    public static TypeConstraint.Exact exactClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TypeConstraints.$$$reportNull$$$0(26);
        }
        return TypeConstraints.exactClass(new JavaClassDef(psiClass));
    }

    @NotNull
    public static TypeConstraint.Exact exactClass(@NotNull ClassDef classDef) {
        String name;
        if (classDef == null) {
            TypeConstraints.$$$reportNull$$$0(27);
        }
        if ((name = classDef.getQualifiedName()) != null) {
            switch (name) {
                case "java.lang.Object": {
                    TypeConstraint.Exact exact = EXACTLY_OBJECT;
                    if (exact == null) {
                        TypeConstraints.$$$reportNull$$$0(28);
                    }
                    return exact;
                }
                case "java.lang.Cloneable": {
                    ArraySuperInterface arraySuperInterface = ArraySuperInterface.CLONEABLE;
                    if (arraySuperInterface == null) {
                        TypeConstraints.$$$reportNull$$$0(29);
                    }
                    return arraySuperInterface;
                }
                case "java.io.Serializable": {
                    ArraySuperInterface arraySuperInterface = ArraySuperInterface.SERIALIZABLE;
                    if (arraySuperInterface == null) {
                        TypeConstraints.$$$reportNull$$$0(30);
                    }
                    return arraySuperInterface;
                }
            }
        }
        return new ExactClass(classDef, false);
    }

    @NotNull
    public static TypeConstraint.Exact singleton(@NotNull ClassDef classDef) {
        if (classDef == null) {
            TypeConstraints.$$$reportNull$$$0(31);
        }
        if (!classDef.isFinal()) {
            throw new IllegalArgumentException("Singleton class must be final");
        }
        return new ExactClass(classDef, true);
    }

    public static TypeConstraint.Exact unresolved(String fqn) {
        return new Unresolved(fqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7, 10, 12, 13, 14, 15, 16, 18, 19, 20, 21, 23, 24, 25, 28, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClasses";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "exact";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "exactSubtype";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "instanceOf";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeType";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeClassType";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "exactClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExact";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "exact";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exactSubtype";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "normalizeType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "normalizeClassType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "exactClass";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7, 10, 12, 13, 14, 15, 16, 18, 19, 20, 21, 23, 24, 25, 28, 29, 30 -> new IllegalStateException(string);
        };
    }

    static enum PrimitiveArray implements TypeConstraint.Exact
    {
        BOOLEAN(PsiTypes.booleanType()),
        INT(PsiTypes.intType()),
        BYTE(PsiTypes.byteType()),
        SHORT(PsiTypes.shortType()),
        LONG(PsiTypes.longType()),
        CHAR(PsiTypes.charType()),
        FLOAT(PsiTypes.floatType()),
        DOUBLE(PsiTypes.doubleType());

        private final PsiPrimitiveType myType;

        private PrimitiveArray(PsiPrimitiveType type) {
            this.myType = type;
        }

        @Override
        @NotNull
        public PsiType getPsiType(Project project) {
            PsiArrayType psiArrayType = this.myType.createArrayType();
            if (psiArrayType == null) {
                PrimitiveArray.$$$reportNull$$$0(0);
            }
            return psiArrayType;
        }

        @NotNull
        public String toString() {
            String string = this.myType.getCanonicalText() + "[]";
            if (string == null) {
                PrimitiveArray.$$$reportNull$$$0(1);
            }
            return string;
        }

        PsiPrimitiveType getType() {
            return this.myType;
        }

        @Override
        @NotNull
        public DfType getArrayComponentType() {
            DfType dfType = DfTypes.typedObject((PsiType)this.myType, Nullability.UNKNOWN);
            if (dfType == null) {
                PrimitiveArray.$$$reportNull$$$0(2);
            }
            return dfType;
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of((Object[])ArraySuperInterface.values()).append((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                PrimitiveArray.$$$reportNull$$$0(3);
            }
            return other.equals(this);
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                PrimitiveArray.$$$reportNull$$$0(4);
            }
            return other.equals(this) || other.isAssignableFrom(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$PrimitiveArray";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrayComponentType";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$PrimitiveArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isConvertibleFrom";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    record ExactArray(@NotNull TypeConstraint.Exact component) implements TypeConstraint.Exact
    {
        @NotNull
        private final TypeConstraint.Exact component;

        ExactArray(@NotNull TypeConstraint.Exact component) {
            if (component == null) {
                ExactArray.$$$reportNull$$$0(0);
            }
        }

        @Override
        @NotNull
        public TypeConstraint.Exact convert(TypeConstraintFactory factory) {
            TypeConstraint.Exact component = this.component.convert(factory);
            return component == this.component ? this : new ExactArray(component);
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            PsiType componentType = this.component.getPsiType(project);
            return componentType == null ? null : componentType.createArrayType();
        }

        @Override
        @NotNull
        public String toString() {
            String string = String.valueOf(this.component) + "[]";
            if (string == null) {
                ExactArray.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isFinal() {
            return this.component.isFinal();
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return this.component.superTypes().map(ExactArray::new).append((Object[])ArraySuperInterface.values()).append((Object)EXACTLY_OBJECT);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactArray.$$$reportNull$$$0(2);
            }
            if (!(other instanceof ExactArray)) return false;
            ExactArray exactArray = (ExactArray)other;
            try {
                TypeConstraint.Exact exact;
                TypeConstraint.Exact otherComponent = exact = exactArray.component();
                if (!this.component.isAssignableFrom(otherComponent)) return false;
                return true;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactArray.$$$reportNull$$$0(3);
            }
            if (other instanceof ExactArray) {
                ExactArray exactArray = (ExactArray)other;
                try {
                    TypeConstraint.Exact exact;
                    TypeConstraint.Exact otherComponent = exact = exactArray.component();
                    return this.component.isConvertibleFrom(otherComponent);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            if (other instanceof ArraySuperInterface) {
                return true;
            }
            return other == EXACTLY_OBJECT;
        }

        @Override
        @NotNull
        public DfType getArrayComponentType() {
            DfType dfType = this.component.instanceOf().asDfType();
            if (dfType == null) {
                ExactArray.$$$reportNull$$$0(4);
            }
            return dfType;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @NotNull
        public TypeConstraint.Exact component() {
            TypeConstraint.Exact exact = this.component;
            if (exact == null) {
                ExactArray.$$$reportNull$$$0(5);
            }
            return exact;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactArray";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactArray";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrayComponentType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "component";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isConvertibleFrom";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    record Unresolved(@NotNull String reference) implements TypeConstraint.Exact
    {
        @NotNull
        private final String reference;

        Unresolved(@NotNull String reference) {
            if (reference == null) {
                Unresolved.$$$reportNull$$$0(0);
            }
        }

        @Override
        public boolean isResolved() {
            return false;
        }

        @Override
        @NotNull
        public String toString() {
            String string = "<unresolved> " + this.reference;
            if (string == null) {
                Unresolved.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                Unresolved.$$$reportNull$$$0(2);
            }
            return other instanceof Unresolved || other instanceof ExactClass;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                Unresolved.$$$reportNull$$$0(3);
            }
            return other instanceof Unresolved || other instanceof ExactClass || other instanceof ArraySuperInterface;
        }

        @NotNull
        public String reference() {
            String string = this.reference;
            if (string == null) {
                Unresolved.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$Unresolved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$Unresolved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isConvertibleFrom";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 4 -> new IllegalStateException(string);
            };
        }
    }

    static final class ExactSubclass
    implements TypeConstraint.Exact {
        @NotNull
        private final @NotNull TypeConstraint.Exact @NotNull [] mySupers;
        @NotNull
        private final Object myId;

        ExactSubclass(@NotNull Object id, TypeConstraint.Exact ... supers) {
            if (id == null) {
                ExactSubclass.$$$reportNull$$$0(0);
            }
            if (supers == null) {
                ExactSubclass.$$$reportNull$$$0(1);
            }
            assert (supers.length != 0);
            for (TypeConstraint.Exact superClass : supers) {
                if (superClass instanceof ExactClass || superClass instanceof ArraySuperInterface || superClass instanceof Unresolved || superClass == EXACTLY_OBJECT) continue;
                throw new IllegalArgumentException("Unexpected supertype: " + String.valueOf(superClass));
            }
            this.mySupers = supers;
            this.myId = id;
        }

        @Override
        @NotNull
        public TypeConstraint.Exact convert(TypeConstraintFactory factory) {
            return new ExactSubclass(this.myId, (TypeConstraint.Exact[])ContainerUtil.map2Array((Object[])this.mySupers, TypeConstraint.Exact.class, ex -> ex.convert(factory)));
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            PsiType[] types = (PsiType[])((StreamEx)StreamEx.of((Object[])this.mySupers).map(st -> st.getPsiType(project)).distinct()).toArray((Object[])PsiType.EMPTY_ARRAY);
            return types.length == 0 ? null : PsiIntersectionType.createIntersection((PsiType[])types);
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return (StreamEx)StreamEx.of((Object[])this.mySupers).flatMap(TypeConstraint.Exact::superTypes).distinct();
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactSubclass.$$$reportNull$$$0(2);
            }
            return this.equals(other);
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactSubclass.$$$reportNull$$$0(3);
            }
            return this.equals(other) || other.isAssignableFrom(this);
        }

        @Override
        public String toShortString() {
            return "? extends " + StreamEx.of((Object[])this.mySupers).map(TypeConstraint.Exact::toShortString).joining((CharSequence)" & ");
        }

        public int hashCode() {
            return Arrays.hashCode(this.mySupers) * 31 + this.myId.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ExactSubclass)) return false;
            ExactSubclass subclass = (ExactSubclass)obj;
            if (!subclass.myId.equals(this.myId)) return false;
            if (!Arrays.equals(subclass.mySupers, this.mySupers)) return false;
            return true;
        }

        public String toString() {
            return "? extends " + StreamEx.of((Object[])this.mySupers).map((Function<TypeConstraint.Exact, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lcom/intellij/codeInspection/dataFlow/TypeConstraint$Exact;)Ljava/lang/String;)()).joining((CharSequence)" & ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supers";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactSubclass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAssignableFrom";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isConvertibleFrom";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ClassDef {
        public boolean isInheritor(@NotNull ClassDef var1);

        public boolean isConvertible(@NotNull ClassDef var1);

        public boolean isInterface();

        public boolean isEnum();

        public boolean isFinal();

        public boolean isAbstract();

        @Nullable
        public PsiEnumConstant getEnumConstant(int var1);

        @Nullable
        public String getQualifiedName();

        @NotNull
        public @NotNull Stream<@NotNull ClassDef> superTypes();

        @Nullable
        public PsiType toPsiType(@NotNull Project var1);
    }

    static enum ArraySuperInterface implements TypeConstraint.Exact
    {
        CLONEABLE("java.lang.Cloneable"),
        SERIALIZABLE("java.io.Serializable");

        @NotNull
        private final String myReference;

        private ArraySuperInterface(String reference) {
            if (reference == null) {
                ArraySuperInterface.$$$reportNull$$$0(0);
            }
            this.myReference = reference;
        }

        @Override
        @NotNull
        public PsiType getPsiType(Project project) {
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName(this.myReference);
            if (psiClassType == null) {
                ArraySuperInterface.$$$reportNull$$$0(1);
            }
            return psiClassType;
        }

        @NotNull
        public String toString() {
            String string = this.myReference;
            if (string == null) {
                ArraySuperInterface.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of((Object)EXACTLY_OBJECT);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ArraySuperInterface.$$$reportNull$$$0(3);
            }
            if (this.equals(other)) {
                return true;
            }
            if (other instanceof PrimitiveArray || other instanceof ExactArray || other instanceof Unresolved) {
                return true;
            }
            if (other instanceof ExactClass) {
                ExactClass exactClass = (ExactClass)other;
                return exactClass.isSubtypeOf(this.myReference);
            }
            if (other instanceof ExactSubclass) {
                ExactSubclass subclass = (ExactSubclass)other;
                for (TypeConstraint.Exact superClass : subclass.mySupers) {
                    if (!this.isAssignableFrom(superClass)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ArraySuperInterface.$$$reportNull$$$0(4);
            }
            return !other.isFinal() || this.isAssignableFrom(other);
        }

        @Override
        public boolean canBeInstantiated() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ArraySuperInterface";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ArraySuperInterface";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isConvertibleFrom";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    record ExactClass(@NotNull ClassDef classDef, boolean isSingleton) implements TypeConstraint.Exact
    {
        @NotNull
        private final ClassDef classDef;

        ExactClass(@NotNull ClassDef classDef, boolean isSingleton) {
            if (classDef == null) {
                ExactClass.$$$reportNull$$$0(0);
            }
            assert (!(classDef instanceof PsiTypeParameter));
        }

        @Override
        @NotNull
        public TypeConstraint.Exact convert(TypeConstraintFactory factory) {
            TypeConstraint.Exact exact = factory.create(this.classDef);
            if (exact == null) {
                ExactClass.$$$reportNull$$$0(1);
            }
            return exact;
        }

        @Override
        public boolean isEnum() {
            return this.classDef.isEnum();
        }

        @Override
        @Nullable
        public PsiEnumConstant getEnumConstant(int ordinal) {
            return this.classDef.getEnumConstant(ordinal);
        }

        @Override
        public DfType getUnboxedType() {
            String name;
            String string = name = this.classDef.getQualifiedName();
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"java.lang.Boolean", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Byte", "java.lang.Short", "java.lang.Character"}, (Object)string, n)) {
                case 0 -> DfTypes.BOOLEAN;
                case 1 -> DfTypes.INT;
                case 2 -> DfTypes.LONG;
                case 3 -> DfTypes.DOUBLE;
                case 4 -> DfTypes.FLOAT;
                case 5 -> DfTypes.intRange(Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange((PsiType)PsiTypes.byteType())));
                case 6 -> DfTypes.intRange(Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange((PsiType)PsiTypes.shortType())));
                case 7 -> DfTypes.intRange(Objects.requireNonNull(JvmPsiRangeSetUtil.typeRange((PsiType)PsiTypes.charType())));
                default -> DfType.BOTTOM;
            };
        }

        @Override
        public boolean isPrimitiveWrapper() {
            String name = this.classDef.getQualifiedName();
            return name != null && TypeConversionUtil.isPrimitiveWrapper((String)name);
        }

        @Override
        public boolean canBeInstantiated() {
            return (this.classDef.isFinal() || !this.classDef.isAbstract()) && !"java.lang.Void".equals(this.classDef.getQualifiedName());
        }

        @Override
        public boolean isComparedByEquals() {
            String name = this.classDef.getQualifiedName();
            return name != null && ("java.lang.String".equals(name) || TypeConversionUtil.isPrimitiveWrapper((String)name));
        }

        @Override
        @Nullable
        public PsiType getPsiType(Project project) {
            return this.classDef.toPsiType(project);
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.classDef.toString();
            if (string == null) {
                ExactClass.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isFinal() {
            return this.classDef.isFinal();
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.of(this.classDef.superTypes()).map(TypeConstraints::exactClass);
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactClass.$$$reportNull$$$0(3);
            }
            if (this.equals(other) || other instanceof Unresolved) {
                return true;
            }
            if (other instanceof ExactClass) {
                ExactClass exactClass = (ExactClass)other;
                return exactClass.classDef.isInheritor(this.classDef);
            }
            if (other instanceof ExactSubclass) {
                ExactSubclass subclass = (ExactSubclass)other;
                for (TypeConstraint.Exact superClass : subclass.mySupers) {
                    if (!this.isAssignableFrom(superClass)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactClass.$$$reportNull$$$0(4);
            }
            if (this.equals(other) || other instanceof Unresolved || other == EXACTLY_OBJECT) {
                return true;
            }
            if (other instanceof ArraySuperInterface) {
                if (this.classDef.isInterface()) {
                    return true;
                }
                if (!this.classDef.isFinal()) {
                    return true;
                }
                return this.isSubtypeOf(((ArraySuperInterface)other).myReference);
            }
            if (other instanceof ExactClass) {
                ExactClass exactClass = (ExactClass)other;
                return this.classDef.isConvertible(exactClass.classDef);
            }
            if (other instanceof ExactSubclass) {
                ExactSubclass subclass = (ExactSubclass)other;
                for (TypeConstraint.Exact superClass : subclass.mySupers) {
                    if (!this.isConvertibleFrom(superClass)) continue;
                    return true;
                }
            }
            return false;
        }

        @NotNull
        public ClassDef classDef() {
            ClassDef classDef = this.classDef;
            if (classDef == null) {
                ExactClass.$$$reportNull$$$0(5);
            }
            return classDef;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classDef";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactClass";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convert";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classDef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isConvertibleFrom";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 5 -> new IllegalStateException(string);
            };
        }
    }

    static final class TopConstraint
    implements TypeConstraint {
        TopConstraint() {
        }

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == null) {
                TopConstraint.$$$reportNull$$$0(0);
            }
            TopConstraint topConstraint = this;
            if (topConstraint == null) {
                TopConstraint.$$$reportNull$$$0(1);
            }
            return topConstraint;
        }

        @Override
        @NotNull
        public TypeConstraint tryJoinExactly(@NotNull TypeConstraint other) {
            if (other == null) {
                TopConstraint.$$$reportNull$$$0(2);
            }
            TopConstraint topConstraint = this;
            if (topConstraint == null) {
                TopConstraint.$$$reportNull$$$0(3);
            }
            return topConstraint;
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (other == null) {
                TopConstraint.$$$reportNull$$$0(4);
            }
            TypeConstraint typeConstraint = other;
            if (typeConstraint == null) {
                TopConstraint.$$$reportNull$$$0(5);
            }
            return typeConstraint;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == null) {
                TopConstraint.$$$reportNull$$$0(6);
            }
            return true;
        }

        @Override
        public boolean isSubtypeOf(@NotNull String className) {
            if (className == null) {
                TopConstraint.$$$reportNull$$$0(7);
            }
            return false;
        }

        @Override
        public TypeConstraint tryNegate() {
            return BOTTOM;
        }

        public String toString() {
            return "";
        }

        @Override
        public DfType getUnboxedType() {
            return DfType.TOP;
        }

        @Override
        @NotNull
        public TypeConstraint arrayOf() {
            TypeConstraint typeConstraint = new ExactArray(EXACTLY_OBJECT).instanceOf();
            if (typeConstraint == null) {
                TopConstraint.$$$reportNull$$$0(8);
            }
            return typeConstraint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$TopConstraint";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$TopConstraint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryJoinExactly";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "arrayOf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 8: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperConstraintOf";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSubtypeOf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5, 8 -> new IllegalStateException(string);
            };
        }
    }

    static final class BottomConstraint
    implements TypeConstraint {
        BottomConstraint() {
        }

        @Override
        @NotNull
        public TypeConstraint join(@NotNull TypeConstraint other) {
            if (other == null) {
                BottomConstraint.$$$reportNull$$$0(0);
            }
            TypeConstraint typeConstraint = other;
            if (typeConstraint == null) {
                BottomConstraint.$$$reportNull$$$0(1);
            }
            return typeConstraint;
        }

        @Override
        @NotNull
        public TypeConstraint tryJoinExactly(@NotNull TypeConstraint other) {
            if (other == null) {
                BottomConstraint.$$$reportNull$$$0(2);
            }
            TypeConstraint typeConstraint = other;
            if (typeConstraint == null) {
                BottomConstraint.$$$reportNull$$$0(3);
            }
            return typeConstraint;
        }

        @Override
        @NotNull
        public TypeConstraint meet(@NotNull TypeConstraint other) {
            if (other == null) {
                BottomConstraint.$$$reportNull$$$0(4);
            }
            BottomConstraint bottomConstraint = this;
            if (bottomConstraint == null) {
                BottomConstraint.$$$reportNull$$$0(5);
            }
            return bottomConstraint;
        }

        @Override
        public boolean isSuperConstraintOf(@NotNull TypeConstraint other) {
            if (other == null) {
                BottomConstraint.$$$reportNull$$$0(6);
            }
            return other == this;
        }

        @Override
        public boolean isSubtypeOf(@NotNull String className) {
            if (className == null) {
                BottomConstraint.$$$reportNull$$$0(7);
            }
            return false;
        }

        @Override
        public TypeConstraint tryNegate() {
            return TOP;
        }

        public String toString() {
            return "<impossible type>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$BottomConstraint";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$BottomConstraint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "join";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "tryJoinExactly";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "meet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "join";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "tryJoinExactly";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "meet";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSuperConstraintOf";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSubtypeOf";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3, 5 -> new IllegalStateException(string);
            };
        }
    }

    static final class ExactObject
    implements TypeConstraint.Exact {
        ExactObject() {
        }

        @Override
        public StreamEx<TypeConstraint.Exact> superTypes() {
            return StreamEx.empty();
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isAssignableFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactObject.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public boolean isConvertibleFrom(@NotNull TypeConstraint.Exact other) {
            if (other == null) {
                ExactObject.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        @NotNull
        public TypeConstraint instanceOf() {
            TypeConstraint typeConstraint = TOP;
            if (typeConstraint == null) {
                ExactObject.$$$reportNull$$$0(2);
            }
            return typeConstraint;
        }

        @Override
        @NotNull
        public TypeConstraint notInstanceOf() {
            TypeConstraint typeConstraint = BOTTOM;
            if (typeConstraint == null) {
                ExactObject.$$$reportNull$$$0(3);
            }
            return typeConstraint;
        }

        public String toString() {
            return "java.lang.Object";
        }

        @Override
        public PsiType getPsiType(Project project) {
            return JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName("java.lang.Object");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$ExactObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instanceOf";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "notInstanceOf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isAssignableFrom";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isConvertibleFrom";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    public static interface TypeConstraintFactory {
        @NotNull
        default public TypeConstraint.Exact create(@NotNull ClassDef def) {
            String qualifiedName;
            if (def == null) {
                TypeConstraintFactory.$$$reportNull$$$0(0);
            }
            if ((qualifiedName = def.getQualifiedName()) != null) {
                TypeConstraint.Exact exact = this.create(qualifiedName);
                if (exact == null) {
                    TypeConstraintFactory.$$$reportNull$$$0(1);
                }
                return exact;
            }
            TypeConstraint.Exact exact = TypeConstraints.unresolved(def.toString());
            if (exact == null) {
                TypeConstraintFactory.$$$reportNull$$$0(2);
            }
            return exact;
        }

        @NotNull
        public TypeConstraint.Exact create(@NotNull String var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "def";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/dataFlow/TypeConstraints$TypeConstraintFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/dataFlow/TypeConstraints$TypeConstraintFactory";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

