/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public final class UnsatisfiedRangeInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnsatisfiedRangeInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethod(@NotNull PsiMethod method) {
                PsiReturnStatement[] statements;
                PsiCodeBlock body;
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((body = method.getBody()) == null) {
                    return;
                }
                PsiType returnType = method.getReturnType();
                LongRangeSet fromType = JvmPsiRangeSetUtil.typeRange(returnType);
                if (fromType == null) {
                    return;
                }
                LongRangeSet range = JvmPsiRangeSetUtil.fromPsiElement((PsiModifierListOwner)method);
                if (range.contains(fromType)) {
                    return;
                }
                for (PsiReturnStatement statement : statements = PsiUtil.findReturnStatements((PsiCodeBlock)body)) {
                    PsiExpression value = statement.getReturnValue();
                    if (value == null) continue;
                    ExpressionUtils.nonStructuralChildren(value).forEach(expression -> {
                        LongRangeSet returnRange;
                        DfIntegralType val = (DfIntegralType)ObjectUtils.tryCast((Object)CommonDataflow.getDfType(expression), DfIntegralType.class);
                        if (val != null && !(returnRange = val.getRange()).intersects(range)) {
                            Long constantValue = returnRange.getConstantValue();
                            String message = JavaAnalysisBundle.message((String)(constantValue == null ? "inspection.unsatisfied.range.message" : "inspection.unsatisfied.range.message.value"), (Object[])new Object[]{JvmPsiRangeSetUtil.getPresentationText(returnRange, returnType), JvmPsiRangeSetUtil.getPresentationText(range, returnType)});
                            holder.registerProblem((PsiElement)expression, message, new LocalQuickFix[0]);
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/UnsatisfiedRangeInspection$1", "visitMethod"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/dataFlow/UnsatisfiedRangeInspection", "buildVisitor"));
    }
}

