/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.fix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.java.JavaBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceWithConstantValueFix
extends PsiBasedModCommandAction<PsiExpression> {
    @NotNull
    private final String myPresentableName;
    @NotNull
    private final String myReplacementText;
    @NotNull
    private final ThreeState myExtractSideEffects;

    public ReplaceWithConstantValueFix(@NotNull PsiExpression expression, @NotNull String presentableName, @NotNull String replacementText) {
        if (expression == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(1);
        }
        if (replacementText == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)expression);
        this.myPresentableName = presentableName;
        this.myReplacementText = replacementText;
        this.myExtractSideEffects = ThreeState.UNSURE;
    }

    private ReplaceWithConstantValueFix(@NotNull PsiExpression expression, @NotNull String presentableName, @NotNull String replacementText, boolean extractSideEffects) {
        if (expression == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(3);
        }
        if (presentableName == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(4);
        }
        if (replacementText == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(5);
        }
        super((PsiElement)expression);
        this.myPresentableName = presentableName;
        this.myReplacementText = replacementText;
        this.myExtractSideEffects = ThreeState.fromBoolean((boolean)extractSideEffects);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiExpression element) {
        if (context == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(7);
        }
        return switch (this.myExtractSideEffects) {
            default -> throw new MatchException(null, null);
            case ThreeState.YES -> Presentation.of((String)JavaBundle.message((String)"intention.family.name.extract.possible.side.effects", (Object[])new Object[0]));
            case ThreeState.NO -> Presentation.of((String)JavaBundle.message((String)"intention.family.name.delete.possible.side.effects", (Object[])new Object[0]));
            case ThreeState.UNSURE -> Presentation.of((String)CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myPresentableName}));
        };
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"replace.with.constant.value", (Object[])new Object[0]);
        if (string == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiExpression expression) {
        if (context == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(10);
        }
        List<Object> sideEffects = this.myExtractSideEffects == ThreeState.NO ? List.of() : SideEffectChecker.extractSideEffectExpressions(expression);
        CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression(expression);
        if (surrounder == null) {
            sideEffects = List.of();
        }
        if (sideEffects.isEmpty()) {
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)expression, expr -> this.applyFix((PsiExpression)expr, PsiStatement.EMPTY_ARRAY));
            if (modCommand == null) {
                ReplaceWithConstantValueFix.$$$reportNull$$$0(11);
            }
            return modCommand;
        }
        if (this.myExtractSideEffects == ThreeState.UNSURE) {
            ModCommand modCommand = ModCommand.chooseAction((String)JavaAnalysisBundle.message((String)"replace.with.constant.value.title", (Object[])new Object[0]), (ModCommandAction[])new ModCommandAction[]{new ReplaceWithConstantValueFix(expression, this.myPresentableName, this.myReplacementText, true), new ReplaceWithConstantValueFix(expression, this.myPresentableName, this.myReplacementText, false)});
            if (modCommand == null) {
                ReplaceWithConstantValueFix.$$$reportNull$$$0(12);
            }
            return modCommand;
        }
        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression);
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)expression, (expr, updater) -> this.applyFix((PsiExpression)expr, statements));
        if (modCommand == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(13);
        }
        return modCommand;
    }

    private void applyFix(@NotNull PsiExpression expression, @NotNull @NotNull PsiStatement @NotNull [] sideEffects) {
        PsiMethodCallExpression grandParent;
        PsiExpressionList list;
        PsiElement psiElement;
        if (expression == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(14);
        }
        if (sideEffects == null) {
            ReplaceWithConstantValueFix.$$$reportNull$$$0(15);
        }
        if (sideEffects.length > 0) {
            CodeBlockSurrounder surrounder = Objects.requireNonNull(CodeBlockSurrounder.forExpression(expression));
            CodeBlockSurrounder.SurroundResult result = surrounder.surround();
            expression = result.getExpression();
            BlockUtils.addBefore((PsiStatement)result.getAnchor(), (PsiStatement[])sideEffects);
        }
        PsiMethodCallExpression call = (psiElement = expression.getParent()) instanceof PsiExpressionList && (psiElement = (list = (PsiExpressionList)psiElement).getParent()) instanceof PsiMethodCallExpression ? (grandParent = (PsiMethodCallExpression)psiElement) : null;
        PsiMethod targetMethod = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        if (call != null) {
            JavaResolveResult result = call.resolveMethodGenerics();
            substitutor = result.getSubstitutor();
            targetMethod = (PsiMethod)ObjectUtils.tryCast((Object)result.getElement(), PsiMethod.class);
        }
        new CommentTracker().replaceAndRestoreComments((PsiElement)expression, this.myReplacementText);
        if (targetMethod != null) {
            ExtractMethodUtil.addCastsToEnsureResolveTarget(targetMethod, substitutor, call);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithConstantValueFix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sideEffects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/fix/ReplaceWithConstantValueFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

