/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.inference;

import com.intellij.codeInspection.dataFlow.inference.CannotRestoreExpressionException;
import com.intellij.codeInspection.dataFlow.inference.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.inference.MethodReturnInferenceResult;
import com.intellij.codeInspection.dataFlow.inference.PreContract;
import com.intellij.codeInspection.dataFlow.inference.PurityInferenceResult;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiMethodImpl;
import java.util.BitSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003J\u000e\u0010&\u001a\u00020\fH\u00c0\u0003\u00a2\u0006\u0002\b'J\u000e\u0010(\u001a\u00020\fH\u00c0\u0003\u00a2\u0006\u0002\b)JO\u0010*\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\u0014\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010.\u001a\u00020\fH\u00d6\u0081\u0004J\n\u0010/\u001a\u000200H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/codeInspection/dataFlow/inference/MethodData;", "", "methodReturn", "Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "purity", "Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "contracts", "", "Lcom/intellij/codeInspection/dataFlow/inference/PreContract;", "notNullParameters", "Ljava/util/BitSet;", "bodyStart", "", "bodyEnd", "<init>", "(Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;Ljava/util/List;Ljava/util/BitSet;II)V", "getMethodReturn", "()Lcom/intellij/codeInspection/dataFlow/inference/MethodReturnInferenceResult;", "getPurity", "()Lcom/intellij/codeInspection/dataFlow/inference/PurityInferenceResult;", "getContracts", "()Ljava/util/List;", "getNotNullParameters", "()Ljava/util/BitSet;", "getBodyStart$intellij_java_analysis_impl", "()I", "getBodyEnd$intellij_java_analysis_impl", "myDetachedBody", "Lcom/intellij/psi/PsiCodeBlock;", "methodBody", "Lkotlin/Function0;", "method", "Lcom/intellij/psi/impl/source/PsiMethodImpl;", "getDetachedBody", "component1", "component2", "component3", "component4", "component5", "component5$intellij_java_analysis_impl", "component6", "component6$intellij_java_analysis_impl", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.java.analysis.impl"})
public final class MethodData {
    @Nullable
    private final MethodReturnInferenceResult methodReturn;
    @Nullable
    private final PurityInferenceResult purity;
    @NotNull
    private final List<PreContract> contracts;
    @NotNull
    private final BitSet notNullParameters;
    private final int bodyStart;
    private final int bodyEnd;
    @Nullable
    private volatile PsiCodeBlock myDetachedBody;

    public MethodData(@Nullable MethodReturnInferenceResult methodReturn, @Nullable PurityInferenceResult purity, @NotNull List<? extends PreContract> contracts, @NotNull BitSet notNullParameters, int bodyStart, int bodyEnd) {
        Intrinsics.checkNotNullParameter(contracts, (String)"contracts");
        Intrinsics.checkNotNullParameter((Object)notNullParameters, (String)"notNullParameters");
        this.methodReturn = methodReturn;
        this.purity = purity;
        this.contracts = contracts;
        this.notNullParameters = notNullParameters;
        this.bodyStart = bodyStart;
        this.bodyEnd = bodyEnd;
    }

    @Nullable
    public final MethodReturnInferenceResult getMethodReturn() {
        return this.methodReturn;
    }

    @Nullable
    public final PurityInferenceResult getPurity() {
        return this.purity;
    }

    @NotNull
    public final List<PreContract> getContracts() {
        return this.contracts;
    }

    @NotNull
    public final BitSet getNotNullParameters() {
        return this.notNullParameters;
    }

    public final int getBodyStart$intellij_java_analysis_impl() {
        return this.bodyStart;
    }

    public final int getBodyEnd$intellij_java_analysis_impl() {
        return this.bodyEnd;
    }

    @NotNull
    public final Function0<PsiCodeBlock> methodBody(@NotNull PsiMethodImpl method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return () -> MethodData.methodBody$lambda$0(method, this);
    }

    private final PsiCodeBlock getDetachedBody(PsiMethodImpl method) {
        Document document = method.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            PsiCodeBlock psiCodeBlock = method.getBody();
            Intrinsics.checkNotNull((Object)psiCodeBlock);
            return psiCodeBlock;
        }
        Document document2 = document;
        try {
            CharSequence charSequence = PsiDocumentManager.getInstance((Project)method.getProject()).getLastCommittedText(document2);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLastCommittedText(...)");
            CharSequence charSequence2 = charSequence;
            int n = this.bodyStart;
            int n2 = this.bodyEnd;
            String bodyText = ((Object)charSequence2.subSequence(n, n2)).toString();
            PsiCodeBlock psiCodeBlock = JavaPsiFacade.getElementFactory((Project)method.getProject()).createCodeBlockFromText(bodyText, (PsiElement)method);
            Intrinsics.checkNotNullExpressionValue((Object)psiCodeBlock, (String)"createCodeBlockFromText(...)");
            return psiCodeBlock;
        }
        catch (RuntimeException e) {
            throw ContractInferenceIndexKt.handleInconsistency(method, this, e);
        }
    }

    @Nullable
    public final MethodReturnInferenceResult component1() {
        return this.methodReturn;
    }

    @Nullable
    public final PurityInferenceResult component2() {
        return this.purity;
    }

    @NotNull
    public final List<PreContract> component3() {
        return this.contracts;
    }

    @NotNull
    public final BitSet component4() {
        return this.notNullParameters;
    }

    public final int component5$intellij_java_analysis_impl() {
        return this.bodyStart;
    }

    public final int component6$intellij_java_analysis_impl() {
        return this.bodyEnd;
    }

    @NotNull
    public final MethodData copy(@Nullable MethodReturnInferenceResult methodReturn, @Nullable PurityInferenceResult purity, @NotNull List<? extends PreContract> contracts, @NotNull BitSet notNullParameters, int bodyStart, int bodyEnd) {
        Intrinsics.checkNotNullParameter(contracts, (String)"contracts");
        Intrinsics.checkNotNullParameter((Object)notNullParameters, (String)"notNullParameters");
        return new MethodData(methodReturn, purity, contracts, notNullParameters, bodyStart, bodyEnd);
    }

    public static /* synthetic */ MethodData copy$default(MethodData methodData, MethodReturnInferenceResult methodReturnInferenceResult, PurityInferenceResult purityInferenceResult, List list, BitSet bitSet, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            methodReturnInferenceResult = methodData.methodReturn;
        }
        if ((n3 & 2) != 0) {
            purityInferenceResult = methodData.purity;
        }
        if ((n3 & 4) != 0) {
            list = methodData.contracts;
        }
        if ((n3 & 8) != 0) {
            bitSet = methodData.notNullParameters;
        }
        if ((n3 & 0x10) != 0) {
            n = methodData.bodyStart;
        }
        if ((n3 & 0x20) != 0) {
            n2 = methodData.bodyEnd;
        }
        return methodData.copy(methodReturnInferenceResult, purityInferenceResult, list, bitSet, n, n2);
    }

    @NotNull
    public String toString() {
        return "MethodData(methodReturn=" + this.methodReturn + ", purity=" + this.purity + ", contracts=" + this.contracts + ", notNullParameters=" + this.notNullParameters + ", bodyStart=" + this.bodyStart + ", bodyEnd=" + this.bodyEnd + ")";
    }

    public int hashCode() {
        int result = this.methodReturn == null ? 0 : this.methodReturn.hashCode();
        result = result * 31 + (this.purity == null ? 0 : this.purity.hashCode());
        result = result * 31 + ((Object)this.contracts).hashCode();
        result = result * 31 + this.notNullParameters.hashCode();
        result = result * 31 + Integer.hashCode(this.bodyStart);
        result = result * 31 + Integer.hashCode(this.bodyEnd);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodData)) {
            return false;
        }
        MethodData methodData = (MethodData)other;
        if (!Intrinsics.areEqual((Object)this.methodReturn, (Object)methodData.methodReturn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.purity, (Object)methodData.purity)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.contracts, methodData.contracts)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.notNullParameters, (Object)methodData.notNullParameters)) {
            return false;
        }
        if (this.bodyStart != methodData.bodyStart) {
            return false;
        }
        return this.bodyEnd == methodData.bodyEnd;
    }

    /*
     * WARNING - void declaration
     */
    private static final PsiCodeBlock methodBody$lambda$0(PsiMethodImpl $method, MethodData this$0) {
        PsiCodeBlock psiCodeBlock;
        if ($method.getStub() != null) {
            void var2_2;
            PsiCodeBlock detached = this$0.myDetachedBody;
            if (detached == null) {
                this$0.myDetachedBody = detached = this$0.getDetachedBody($method);
            } else {
                boolean bl;
                boolean bl2 = bl = Intrinsics.areEqual((Object)detached.getParent(), (Object)$method) || Intrinsics.areEqual((Object)detached.getContainingFile().getContext(), (Object)$method);
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            psiCodeBlock = var2_2;
        } else {
            psiCodeBlock = $method.getBody();
            if (psiCodeBlock == null) {
                throw new CannotRestoreExpressionException("Method body is not found");
            }
        }
        return psiCodeBlock;
    }
}

