/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java;

import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.LinkedHashSet;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassDef
implements TypeConstraints.ClassDef {
    @NotNull
    private final PsiClass myClass;

    public JavaClassDef(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaClassDef.$$$reportNull$$$0(0);
        }
        this.myClass = aClass;
    }

    @Override
    public boolean isInheritor(@NotNull TypeConstraints.ClassDef superType) {
        if (superType == null) {
            JavaClassDef.$$$reportNull$$$0(1);
        }
        return superType instanceof JavaClassDef && InheritanceUtil.isInheritorOrSelf((PsiClass)this.myClass, (PsiClass)((JavaClassDef)superType).myClass, (boolean)true);
    }

    @Override
    public boolean isConvertible(@NotNull TypeConstraints.ClassDef other) {
        if (other == null) {
            JavaClassDef.$$$reportNull$$$0(2);
        }
        if (!(other instanceof JavaClassDef)) {
            return false;
        }
        PsiClass otherClass = ((JavaClassDef)other).myClass;
        if (this.myClass.isInterface() || otherClass.isInterface()) {
            if (otherClass.hasModifierProperty("sealed")) {
                return TypeConversionUtil.canConvertSealedTo((PsiClass)otherClass, (PsiClass)this.myClass);
            }
            if (this.myClass.hasModifierProperty("sealed")) {
                return TypeConversionUtil.canConvertSealedTo((PsiClass)this.myClass, (PsiClass)otherClass);
            }
        }
        if (this.myClass.isInterface() && otherClass.isInterface()) {
            return true;
        }
        if (this.myClass.isInterface() && !otherClass.hasModifierProperty("final")) {
            return true;
        }
        if (otherClass.isInterface() && !this.myClass.hasModifierProperty("final")) {
            return true;
        }
        PsiManager manager = this.myClass.getManager();
        return manager.areElementsEquivalent((PsiElement)this.myClass, (PsiElement)otherClass) || otherClass.isInheritor(this.myClass, true) || this.myClass.isInheritor(otherClass, true);
    }

    @Override
    public boolean isInterface() {
        return this.myClass.isInterface();
    }

    @Override
    public boolean isEnum() {
        return this.myClass.isEnum();
    }

    @Override
    @Nullable
    public PsiEnumConstant getEnumConstant(int ordinal) {
        int cur = 0;
        for (PsiField field : this.myClass.getFields()) {
            if (!(field instanceof PsiEnumConstant)) continue;
            if (cur == ordinal) {
                return (PsiEnumConstant)field;
            }
            ++cur;
        }
        return null;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        return this.myClass.getQualifiedName();
    }

    @NotNull
    public @NotNull StreamEx<@NotNull TypeConstraints.ClassDef> superTypes() {
        LinkedHashSet superTypes = new LinkedHashSet();
        InheritanceUtil.processSupers((PsiClass)this.myClass, (boolean)false, t -> {
            if (!(t instanceof PsiTypeParameter) && !t.hasModifierProperty("final")) {
                superTypes.add(t);
            }
            return true;
        });
        StreamEx streamEx = StreamEx.of(superTypes).map(JavaClassDef::new);
        if (streamEx == null) {
            JavaClassDef.$$$reportNull$$$0(3);
        }
        return streamEx;
    }

    @Override
    @NotNull
    public PsiType toPsiType(@NotNull Project project) {
        if (project == null) {
            JavaClassDef.$$$reportNull$$$0(4);
        }
        PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)project).createType(this.myClass);
        if (psiClassType == null) {
            JavaClassDef.$$$reportNull$$$0(5);
        }
        return psiClassType;
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaClassDef && this.myClass.getManager().areElementsEquivalent((PsiElement)this.myClass, (PsiElement)((JavaClassDef)obj).myClass);
    }

    public int hashCode() {
        return Objects.hashCode(this.myClass.getName());
    }

    @Override
    public boolean isFinal() {
        return this.myClass instanceof PsiAnonymousClass || this.myClass.hasModifierProperty("final");
    }

    @Override
    public boolean isAbstract() {
        return this.myClass.hasModifierProperty("abstract");
    }

    public String toString() {
        PsiClass psiClass;
        Object name = this.myClass.getQualifiedName();
        if (name == null) {
            name = this.myClass.getName();
        }
        if (name == null && (psiClass = this.myClass) instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)psiClass;
            PsiClass baseClass = anonymousClass.getBaseClassType().resolve();
            name = "anonymous " + String.valueOf(baseClass == null ? anonymousClass.getBaseClassReference().getReferenceName() : new JavaClassDef(baseClass));
        }
        return String.valueOf(name);
    }

    @NotNull
    public static TypeConstraints.TypeConstraintFactory typeConstraintFactory(@NotNull PsiElement context) {
        if (context == null) {
            JavaClassDef.$$$reportNull$$$0(6);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)context.getProject());
        GlobalSearchScope scope = context.getResolveScope();
        TypeConstraints.TypeConstraintFactory typeConstraintFactory = fqn -> {
            PsiClass psiClass = facade.findClass(fqn, scope);
            return psiClass == null ? TypeConstraints.unresolved(fqn) : TypeConstraints.exactClass(psiClass);
        };
        if (typeConstraintFactory == null) {
            JavaClassDef.$$$reportNull$$$0(7);
        }
        return typeConstraintFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/JavaClassDef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/JavaClassDef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "superTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "typeConstraintFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInheritor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConvertible";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPsiType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "typeConstraintFactory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

