/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java;

import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.DfaWrappedValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;

public final class JavaDfaHelpers {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static DfaValue dropLocality(DfaValue value, DfaMemoryState state) {
        if (!(value instanceof DfaVariableValue)) {
            DfType type = value.getDfType();
            if (type.isLocal() && type instanceof DfReferenceType) {
                DfReferenceType dfType2 = ((DfReferenceType)type).dropLocality();
                if (value instanceof DfaWrappedValue) {
                    return value.getFactory().getWrapperFactory().createWrapper((DfType)dfType2, ((DfaWrappedValue)value).getSpecialField(), (DfaValue)((DfaWrappedValue)value).getWrappedValue());
                }
                return value.getFactory().fromDfType((DfType)dfType2);
            }
            return value;
        }
        DfaVariableValue var = (DfaVariableValue)value;
        @NotNull UnaryOperator updater = dfType -> {
            DfType dfType2;
            if (dfType instanceof DfReferenceType) {
                DfReferenceType refType = (DfReferenceType)dfType;
                dfType2 = refType.dropLocality();
            } else {
                dfType2 = dfType;
            }
            return dfType2;
        };
        state.updateDfType((DfaValue)var, updater);
        for (DfaVariableValue v : new ArrayList(var.getDependentVariables())) {
            state.updateDfType((DfaValue)v, updater);
        }
        return value;
    }

    public static boolean mayLeakFromType(@NotNull DfType type) {
        if (type == null) {
            JavaDfaHelpers.$$$reportNull$$$0(0);
        }
        if (type == DfType.BOTTOM) {
            return false;
        }
        TypeConstraint constraint;
        DfType arrayComponentType;
        while ((arrayComponentType = (constraint = TypeConstraint.fromDfType(type)).getArrayComponentType()) != DfType.BOTTOM) {
            type = arrayComponentType;
        }
        return !(type instanceof DfPrimitiveType) && !constraint.isExact("java.lang.String") && !constraint.isExact("java.lang.Class");
    }

    @NotNull
    public static DfType getFunctionDfType(@NotNull PsiFunctionalExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JavaDfaHelpers.$$$reportNull$$$0(1);
        }
        PsiType psiType = (parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiTypeCastExpression ? ((PsiTypeCastExpression)parent).getType() : expression.getFunctionalInterfaceType();
        DfType dfType = (psiType == null ? DfType.TOP : TypeConstraints.exactSubtype((PsiElement)expression, psiType).asDfType()).meet((DfType)DfTypes.NOT_NULL_OBJECT);
        if (dfType == null) {
            JavaDfaHelpers.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    static boolean mayLeakFromExpression(@NotNull PsiExpression expression) {
        PsiElement parent;
        if (expression == null) {
            JavaDfaHelpers.$$$reportNull$$$0(3);
        }
        return !((parent = ExpressionUtils.getPassThroughParent(expression)) instanceof PsiInstanceOfExpression) && !(parent instanceof PsiPolyadicExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/JavaDfaHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/JavaDfaHelpers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionDfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mayLeakFromType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionDfType";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mayLeakFromExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

