/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.jvm.problems.ContractFailureProblem;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public final class AssertInstanceOfInliner
implements CallInliner {
    private static final CallMatcher ASSERT_INSTANCE_OF = CallMatcher.staticCall("org.junit.jupiter.api.Assertions", "assertInstanceOf");

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            AssertInstanceOfInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            AssertInstanceOfInliner.$$$reportNull$$$0(1);
        }
        if (!ASSERT_INSTANCE_OF.matches((PsiExpression)call)) {
            return false;
        }
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length < 2 || expressions.length > 3) {
            return false;
        }
        PsiExpression wantedClass = expressions[0];
        PsiExpression objectToTest = expressions[1];
        builder.pushExpression(wantedClass).pushExpression(objectToTest).boxUnbox(objectToTest, (PsiType)PsiType.getJavaLangObject((PsiManager)call.getManager(), (GlobalSearchScope)call.getResolveScope())).splice(2, 0, 0, 1);
        if (expressions.length == 3) {
            builder.pushExpression(expressions[2]).pop();
        }
        builder.isInstance((PsiMethodCallExpression)null).ensure(RelationType.EQ, DfTypes.TRUE, new ContractFailureProblem((PsiExpression)call), "java.lang.AssertionError").pop();
        return true;
    }

    @Override
    public boolean mayInferPreciseType(@NotNull PsiExpression expression) {
        PsiParameter argument;
        if (expression == null) {
            AssertInstanceOfInliner.$$$reportNull$$$0(2);
        }
        return (argument = MethodCallUtils.getParameterForArgument(expression)) != null && ASSERT_INSTANCE_OF.methodMatches((PsiMethod)argument.getDeclarationScope());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inliner/AssertInstanceOfInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mayInferPreciseType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

