/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;

public class ClassMethodsInliner
implements CallInliner {
    private static final CallMatcher IS_ASSIGNABLE_FROM = CallMatcher.instanceCall("java.lang.Class", "isAssignableFrom").parameterTypes("java.lang.Class");
    private static final CallMatcher IS_INSTANCE = CallMatcher.instanceCall("java.lang.Class", "isInstance").parameterTypes("java.lang.Object");
    private static final CallMatcher OBJECT_GET_CLASS = CallMatcher.instanceCall("java.lang.Object", "getClass").parameterCount(0);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        PsiExpression qualifier;
        if (builder == null) {
            ClassMethodsInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            ClassMethodsInliner.$$$reportNull$$$0(1);
        }
        if ((qualifier = call.getMethodExpression().getQualifierExpression()) == null) {
            return false;
        }
        if (IS_ASSIGNABLE_FROM.matches((PsiExpression)call)) {
            PsiExpression getClassQualifier;
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            PsiMethodCallExpression nestedCall = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arg), PsiMethodCallExpression.class);
            PsiExpression psiExpression = getClassQualifier = OBJECT_GET_CLASS.matches((PsiExpression)nestedCall) ? nestedCall.getMethodExpression().getQualifierExpression() : null;
            if (getClassQualifier != null) {
                builder.pushExpression(qualifier).pushExpression(getClassQualifier).swap().isInstance(call);
            } else {
                builder.pushExpression(qualifier).pushExpression(arg).isAssignableFrom(call);
            }
            return true;
        }
        if (IS_INSTANCE.matches((PsiExpression)call)) {
            PsiExpression arg = call.getArgumentList().getExpressions()[0];
            builder.pushExpression(qualifier).pushExpression(arg).boxUnbox(arg, (PsiType)PsiType.getJavaLangObject((PsiManager)call.getManager(), (GlobalSearchScope)call.getResolveScope())).swap().isInstance(call);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/dataFlow/java/inliner/ClassMethodsInliner";
        objectArray[2] = "tryInlineCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

