/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.function.Predicate;

final class InlinerUtil {
    InlinerUtil() {
    }

    static boolean isLambdaChainParameterReference(PsiExpression expression, Predicate<? super PsiType> chainTypePredicate) {
        if (!(expression instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiParameter target = (PsiParameter)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression).resolve(), PsiParameter.class);
        if (target == null) {
            return false;
        }
        if (!(target.getParent() instanceof PsiParameterList)) {
            return false;
        }
        PsiLambdaExpression lambda = (PsiLambdaExpression)ObjectUtils.tryCast((Object)target.getParent().getParent(), PsiLambdaExpression.class);
        if (lambda == null) {
            return false;
        }
        PsiExpressionList list = (PsiExpressionList)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)lambda.getParent()), PsiExpressionList.class);
        if (list == null) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)list.getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return false;
        }
        PsiMethodCallExpression qualifierCall = call;
        do {
            if ((qualifierCall = MethodCallUtils.getQualifierMethodCall(qualifierCall)) != null) continue;
            return false;
        } while (qualifierCall.getArgumentList().isEmpty());
        PsiType type = qualifierCall.getType();
        return type != null && chainTypePredicate.test((PsiType)type);
    }
}

