/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inliner;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.java.CFGBuilder;
import com.intellij.codeInspection.dataFlow.java.inliner.CallInliner;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.problems.MutabilityProblem;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class MapUpdateInliner
implements CallInliner {
    private static final CallMatcher MAP_COMPUTE = CallMatcher.instanceCall("java.util.Map", "computeIfAbsent", "computeIfPresent", "compute").parameterCount(2);
    private static final CallMatcher MAP_MERGE = CallMatcher.instanceCall("java.util.Map", "merge").parameterCount(3);

    @Override
    public boolean tryInlineCall(@NotNull CFGBuilder builder, @NotNull PsiMethodCallExpression call) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(0);
        }
        if (call == null) {
            MapUpdateInliner.$$$reportNull$$$0(1);
        }
        if (MAP_COMPUTE.test(call)) {
            String name;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = call.getType();
            if (type == null) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression key = args[0];
            PsiExpression function = args[1];
            builder.pushExpression(qualifier).ensure(RelationType.IS, Mutability.MUTABLE.asDfType(), new MutabilityProblem((PsiElement)call, true), null).pushExpression(key).boxUnbox(key, PsiUtil.substituteTypeParameter((PsiType)qualifier.getType(), (String)"java.util.Map", (int)0, (boolean)true)).evaluateFunction(function);
            switch (name = Objects.requireNonNull(call.getMethodExpression().getReferenceName())) {
                case "computeIfAbsent": {
                    MapUpdateInliner.inlineComputeIfAbsent(builder, function, type);
                    break;
                }
                case "computeIfPresent": {
                    MapUpdateInliner.inlineComputeIfPresent(builder, function, type);
                    break;
                }
                case "compute": {
                    MapUpdateInliner.inlineCompute(builder, function, type);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported name: " + name);
                }
            }
            builder.resultOf((PsiExpression)call);
            return true;
        }
        if (MAP_MERGE.test(call)) {
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            PsiType type = call.getType();
            if (type == null) {
                return false;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            PsiExpression key = args[0];
            PsiExpression value = args[1];
            PsiExpression function = args[2];
            builder.pushExpression(qualifier).ensure(RelationType.IS, Mutability.MUTABLE.asDfType(), new MutabilityProblem((PsiElement)call, true), null).pushExpression(key).pop().pushExpression(value).boxUnbox(value, ExpectedTypeUtils.findExpectedType(value, false)).evaluateFunction(function).pushUnknown().ifNotNull().push(DfTypes.typedObject(type, Nullability.NOT_NULL)).swap().invokeFunction(2, function).end().chain(b -> MapUpdateInliner.flushSize(b)).resultOf((PsiExpression)call);
            return true;
        }
        return false;
    }

    private static void flushSize(CFGBuilder builder) {
        builder.swap().unwrap(SpecialField.COLLECTION_SIZE).pushUnknown().assign().pop();
    }

    private static void inlineComputeIfAbsent(@NotNull CFGBuilder builder, PsiExpression function, PsiType type) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(2);
        }
        builder.pushUnknown().ifNull().invokeFunction(1, function).chain(MapUpdateInliner::flushSize).elseBranch().splice(2, new int[0]).push(DfTypes.typedObject(type, Nullability.NOT_NULL)).end();
    }

    private static void inlineComputeIfPresent(@NotNull CFGBuilder builder, PsiExpression function, PsiType type) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(3);
        }
        builder.pushUnknown().ifNotNull().push(DfTypes.typedObject(type, Nullability.NOT_NULL)).invokeFunction(2, function).chain(MapUpdateInliner::flushSize).elseBranch().splice(2, new int[0]).pushNull().end();
    }

    private static void inlineCompute(@NotNull CFGBuilder builder, PsiExpression function, PsiType type) {
        if (builder == null) {
            MapUpdateInliner.$$$reportNull$$$0(4);
        }
        builder.push(DfTypes.typedObject(type, Nullability.NULLABLE)).invokeFunction(2, function).chain(MapUpdateInliner::flushSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inliner/MapUpdateInliner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInlineCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineComputeIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineComputeIfPresent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "inlineCompute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

