/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.JavaDfaHelpers;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.ArrayElementDescriptor;
import com.intellij.codeInspection.dataFlow.jvm.problems.IndexOutOfBoundsProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayStoreInstruction
extends ExpressionPushingInstruction {
    @Nullable
    protected final DfaControlTransferValue myOutOfBoundsTransfer;
    @NotNull
    protected final IndexOutOfBoundsProblem myIndexProblem;
    @Nullable
    protected final VariableDescriptor myStaticVariable;

    public ArrayStoreInstruction(@Nullable DfaAnchor anchor, @NotNull IndexOutOfBoundsProblem problem, @Nullable DfaControlTransferValue outOfBoundsTransfer, @Nullable VariableDescriptor variable) {
        if (problem == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(0);
        }
        super(anchor);
        this.myIndexProblem = problem;
        this.myOutOfBoundsTransfer = outOfBoundsTransfer;
        this.myStaticVariable = variable;
    }

    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(1);
        }
        DfaControlTransferValue transfer = this.myOutOfBoundsTransfer == null ? null : this.myOutOfBoundsTransfer.bindToFactory(factory);
        return new ArrayStoreInstruction(this.getDfaAnchor(), this.myIndexProblem, transfer, this.myStaticVariable);
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        DfaInstructionState[] states;
        if (interpreter == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(2);
        }
        if (stateBefore == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(3);
        }
        DfaValue valueToStore = stateBefore.pop();
        DfaValue index = stateBefore.pop();
        DfaValue array = stateBefore.pop();
        ArrayList<DfaInstructionState> finalStates = new ArrayList<DfaInstructionState>();
        if (this.myOutOfBoundsTransfer != null) {
            finalStates.addAll(IndexOutOfBoundsProblem.dispatchTransfer(interpreter, stateBefore.createCopy(), this.myOutOfBoundsTransfer));
        }
        if ((states = this.myIndexProblem.processOutOfBounds(interpreter, stateBefore, index, array, this.myOutOfBoundsTransfer)) != null) {
            return states;
        }
        JavaDfaHelpers.dropLocality(valueToStore, stateBefore);
        this.checkArrayElementAssignability(interpreter, stateBefore, valueToStore, array);
        LongRangeSet rangeSet = DfIntType.extractRange(stateBefore.getDfType(index));
        DfaValue arrayElementValue = ArrayElementDescriptor.getArrayElementValue(interpreter.getFactory(), array, rangeSet);
        interpreter.getListener().beforeAssignment(valueToStore, arrayElementValue, stateBefore, this.getDfaAnchor());
        if (arrayElementValue instanceof DfaVariableValue) {
            stateBefore.setVarValue((DfaVariableValue)arrayElementValue, valueToStore);
            interpreter.getListener().afterAssignment(valueToStore, arrayElementValue, stateBefore, this.getDfaAnchor());
            this.pushResult(interpreter, stateBefore, arrayElementValue, new DfaValue[0]);
        } else {
            stateBefore.flushFieldsQualifiedBy(Set.of(array));
            this.pushResult(interpreter, stateBefore, valueToStore, new DfaValue[0]);
        }
        finalStates.add(this.nextState(interpreter, stateBefore));
        return finalStates.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    protected void checkArrayElementAssignability(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState memState, @NotNull DfaValue dfaSource, @NotNull DfaValue qualifier) {
        if (interpreter == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(4);
        }
        if (memState == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(5);
        }
        if (dfaSource == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(6);
        }
        if (qualifier == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(7);
        }
    }

    public List<VariableDescriptor> getRequiredDescriptors(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            ArrayStoreInstruction.$$$reportNull$$$0(8);
        }
        return List.of(SpecialField.ARRAY_LENGTH);
    }

    public String toString() {
        return "ARRAY_STORE " + String.valueOf(this.getDfaAnchor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dfaSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/ArrayStoreInstruction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "bindToFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArrayElementAssignability";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequiredDescriptors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

