/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.GetterDescriptor;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstanceofInstruction
extends ExpressionPushingInstruction {
    private final boolean myClassObjectCheck;

    public InstanceofInstruction(@Nullable DfaAnchor anchor, boolean classObjectCheck) {
        super(anchor);
        this.myClassObjectCheck = classObjectCheck;
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        if (interpreter == null) {
            InstanceofInstruction.$$$reportNull$$$0(0);
        }
        if (stateBefore == null) {
            InstanceofInstruction.$$$reportNull$$$0(1);
        }
        DfaValue dfaRight = stateBefore.pop();
        DfaValue dfaLeft = stateBefore.pop();
        DfaValueFactory factory = interpreter.getFactory();
        boolean unknownTargetType = false;
        DfaCondition condition = null;
        if (this.myClassObjectCheck) {
            PsiType type = (PsiType)stateBefore.getDfType(dfaRight).getConstantOfType(PsiType.class);
            if (type == null || type instanceof PsiPrimitiveType) {
                condition = dfaLeft.cond(RelationType.NE, (DfType)DfTypes.NULL);
                unknownTargetType = true;
            } else {
                dfaRight = factory.fromDfType(DfTypes.typedObject(type, Nullability.NOT_NULL));
            }
        }
        if (condition == null) {
            condition = dfaLeft.cond(RelationType.IS, dfaRight);
        }
        ArrayList<DfaInstructionState> states = new ArrayList<DfaInstructionState>(2);
        DfType leftType = stateBefore.getDfType(dfaLeft);
        if (condition.isUnknown()) {
            this.pushResult(interpreter, stateBefore, DfTypes.BOOLEAN, new DfaValue[]{dfaLeft, dfaRight});
            states.add(this.nextState(interpreter, stateBefore));
        } else {
            DfaMemoryState trueState = stateBefore.createCopy();
            if (trueState.applyCondition(condition)) {
                this.pushResult(interpreter, trueState, unknownTargetType ? DfTypes.BOOLEAN : DfTypes.TRUE, new DfaValue[]{dfaLeft, dfaRight});
                states.add(this.nextState(interpreter, trueState));
            }
            DfaCondition negated = condition.negate();
            if (unknownTargetType ? stateBefore.applyContractCondition(negated) : stateBefore.applyCondition(negated)) {
                this.pushResult(interpreter, stateBefore, DfTypes.FALSE, new DfaValue[]{dfaLeft, dfaRight});
                states.add(this.nextState(interpreter, stateBefore));
                DfaNullability oldNullability = DfaNullability.fromDfType(leftType);
                DfaNullability newNullability = DfaNullability.fromDfType(stateBefore.getDfType(dfaLeft));
                if (newNullability == DfaNullability.NULL && oldNullability == DfaNullability.UNKNOWN) {
                    stateBefore.markEphemeral();
                }
            }
        }
        return states.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    public List<VariableDescriptor> getRequiredDescriptors(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            InstanceofInstruction.$$$reportNull$$$0(2);
        }
        return ((StreamEx)StreamEx.of((Collection)factory.getValues()).select(DfaVariableValue.class).map(DfaVariableValue::getDescriptor).filter(desc -> {
            GetterDescriptor getterDescriptor;
            return desc instanceof GetterDescriptor && PsiTypesUtil.isGetClass((PsiMethod)(getterDescriptor = (GetterDescriptor)desc).getPsiElement());
        })).toList();
    }

    public String toString() {
        return "INSTANCE_OF " + (this.myClassObjectCheck ? "(CLASS)" : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/InstanceofInstruction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getRequiredDescriptors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

