/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfJvmIntegralType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NumericBinaryInstruction
extends EvalInstruction {
    @Nullable
    private final LongRangeBinOp myBinOp;

    public NumericBinaryInstruction(@Nullable LongRangeBinOp binOp, @Nullable DfaAnchor anchor) {
        super(anchor, 2);
        this.myBinOp = binOp;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        if (factory == null) {
            NumericBinaryInstruction.$$$reportNull$$$0(0);
        }
        if (state == null) {
            NumericBinaryInstruction.$$$reportNull$$$0(1);
        }
        if (arguments == null) {
            NumericBinaryInstruction.$$$reportNull$$$0(2);
        }
        if (this.myBinOp == null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                NumericBinaryInstruction.$$$reportNull$$$0(3);
            }
            return dfaTypeValue;
        }
        DfaValue left = arguments[0];
        DfaValue right = arguments[1];
        DfType leftType = state.getDfType(left);
        DfType rightType = state.getDfType(right);
        if (leftType instanceof DfIntegralType && rightType instanceof DfIntegralType) {
            DfJvmIntegralType resultType = leftType instanceof DfLongType ? DfTypes.LONG : DfTypes.INT;
            DfaValue dfaValue = factory.getBinOpFactory().create(left, right, state, (DfIntegralType)resultType, this.myBinOp);
            if (dfaValue == null) {
                NumericBinaryInstruction.$$$reportNull$$$0(4);
            }
            return dfaValue;
        }
        if (leftType instanceof DfDoubleConstantType) {
            DfDoubleConstantType d1 = (DfDoubleConstantType)leftType;
            if (rightType instanceof DfDoubleConstantType) {
                DfDoubleConstantType d2 = (DfDoubleConstantType)rightType;
                DfaTypeValue dfaTypeValue = factory.fromDfType(NumericBinaryInstruction.eval(this.myBinOp, (Double)d1.getValue(), (Double)d2.getValue()));
                if (dfaTypeValue == null) {
                    NumericBinaryInstruction.$$$reportNull$$$0(5);
                }
                return dfaTypeValue;
            }
        }
        if (leftType instanceof DfFloatConstantType) {
            DfFloatConstantType f1 = (DfFloatConstantType)leftType;
            if (rightType instanceof DfFloatConstantType) {
                DfFloatConstantType f2 = (DfFloatConstantType)rightType;
                DfaTypeValue dfaTypeValue = factory.fromDfType(NumericBinaryInstruction.eval(this.myBinOp, ((Float)f1.getValue()).floatValue(), ((Float)f2.getValue()).floatValue()));
                if (dfaTypeValue == null) {
                    NumericBinaryInstruction.$$$reportNull$$$0(6);
                }
                return dfaTypeValue;
            }
        }
        DfaTypeValue dfaTypeValue = factory.getUnknown();
        if (dfaTypeValue == null) {
            NumericBinaryInstruction.$$$reportNull$$$0(7);
        }
        return dfaTypeValue;
    }

    private static DfType eval(LongRangeBinOp op, float f1, float f2) {
        return switch (op) {
            case LongRangeBinOp.PLUS -> DfTypes.floatValue(f1 + f2).makeWide();
            case LongRangeBinOp.MINUS -> DfTypes.floatValue(f1 - f2).makeWide();
            case LongRangeBinOp.MUL -> DfTypes.floatValue(f1 * f2).makeWide();
            case LongRangeBinOp.DIV -> DfTypes.floatValue(f1 / f2).makeWide();
            case LongRangeBinOp.MOD -> DfTypes.floatValue(f1 % f2).makeWide();
            default -> DfType.TOP;
        };
    }

    private static DfType eval(LongRangeBinOp op, double d1, double d2) {
        return switch (op) {
            case LongRangeBinOp.PLUS -> DfTypes.doubleValue(d1 + d2).makeWide();
            case LongRangeBinOp.MINUS -> DfTypes.doubleValue(d1 - d2).makeWide();
            case LongRangeBinOp.MUL -> DfTypes.doubleValue(d1 * d2).makeWide();
            case LongRangeBinOp.DIV -> DfTypes.doubleValue(d1 / d2).makeWide();
            case LongRangeBinOp.MOD -> DfTypes.doubleValue(d1 % d2).makeWide();
            default -> DfType.TOP;
        };
    }

    public String toString() {
        return this.myBinOp == null ? "UNKNOWN_NUMERIC_OP" : "NUMERIC_OP " + String.valueOf(this.myBinOp);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/NumericBinaryInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/NumericBinaryInstruction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

