/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInspection.dataFlow.jvm.JvmPsiRangeSetUtil;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfIntType;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaBinOpValue;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimitiveConversionInstruction
extends EvalInstruction {
    @NotNull
    private final PsiPrimitiveType myTargetType;

    public PrimitiveConversionInstruction(@NotNull PsiPrimitiveType targetType, @Nullable DfaAnchor anchor) {
        if (targetType == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(0);
        }
        super(anchor, 1);
        this.myTargetType = targetType;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        LongRangeSet set;
        DfaValue value;
        if (factory == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(1);
        }
        if (state == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(3);
        }
        if ((value = arguments[0]) instanceof DfaBinOpValue) {
            value = PrimitiveConversionInstruction.tryReduceOnCast((DfaBinOpValue)value, state, this.myTargetType);
        }
        DfType dfType = state.getDfType(value);
        if (value instanceof DfaVariableValue && dfType instanceof DfIntType && (set = JvmPsiRangeSetUtil.typeRange((PsiType)this.myTargetType)) != null && !LongRangeSet.all().equals(set) && ((DfIntType)dfType).meetRange(set).equals((Object)dfType)) {
            DfaValue dfaValue = value;
            if (dfaValue == null) {
                PrimitiveConversionInstruction.$$$reportNull$$$0(4);
            }
            return dfaValue;
        }
        if (dfType instanceof DfPrimitiveType) {
            DfaTypeValue dfaTypeValue = factory.fromDfType(((DfPrimitiveType)dfType).castTo(this.myTargetType));
            if (dfaTypeValue == null) {
                PrimitiveConversionInstruction.$$$reportNull$$$0(5);
            }
            return dfaTypeValue;
        }
        DfaTypeValue dfaTypeValue = factory.getUnknown();
        if (dfaTypeValue == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(6);
        }
        return dfaTypeValue;
    }

    public String toString() {
        return "CONVERT_PRIMITIVE " + this.myTargetType.getPresentableText();
    }

    @NotNull
    private static DfaValue tryReduceOnCast(@NotNull DfaBinOpValue value, @NotNull DfaMemoryState state, @NotNull PsiPrimitiveType type) {
        if (value == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(7);
        }
        if (state == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(8);
        }
        if (type == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(9);
        }
        if (!TypeConversionUtil.isIntegralNumberType((PsiType)type)) {
            DfaBinOpValue dfaBinOpValue = value;
            if (dfaBinOpValue == null) {
                PrimitiveConversionInstruction.$$$reportNull$$$0(10);
            }
            return dfaBinOpValue;
        }
        LongRangeBinOp operation = value.getOperation();
        if ((operation == LongRangeBinOp.PLUS || operation == LongRangeBinOp.MINUS) && JvmPsiRangeSetUtil.castTo(DfLongType.extractRange(state.getDfType(value.getRight())), type).equals(LongRangeSet.point((long)0L))) {
            DfaVariableValue dfaVariableValue = value.getLeft();
            if (dfaVariableValue == null) {
                PrimitiveConversionInstruction.$$$reportNull$$$0(11);
            }
            return dfaVariableValue;
        }
        if (operation == LongRangeBinOp.PLUS && JvmPsiRangeSetUtil.castTo(DfLongType.extractRange(state.getDfType((DfaValue)value.getLeft())), type).equals(LongRangeSet.point((long)0L))) {
            DfaValue dfaValue = value.getRight();
            if (dfaValue == null) {
                PrimitiveConversionInstruction.$$$reportNull$$$0(12);
            }
            return dfaValue;
        }
        DfaBinOpValue dfaBinOpValue = value;
        if (dfaBinOpValue == null) {
            PrimitiveConversionInstruction.$$$reportNull$$$0(13);
        }
        return dfaBinOpValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/PrimitiveConversionInstruction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/PrimitiveConversionInstruction";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "eval";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryReduceOnCast";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "eval";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "tryReduceOnCast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

