/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.java.inst;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.interpreter.DataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.java.anchor.JavaExpressionAnchor;
import com.intellij.codeInspection.dataFlow.jvm.problems.ClassCastProblem;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.ExpressionPushingInstruction;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaCondition;
import com.intellij.codeInspection.dataFlow.value.DfaControlTransferValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeCastInstruction
extends ExpressionPushingInstruction {
    private final PsiExpression myCasted;
    private final PsiType myCastTo;
    @Nullable
    private final DfaControlTransferValue myTransferValue;

    public TypeCastInstruction(PsiTypeCastExpression castExpression, PsiExpression casted, PsiType castTo, @Nullable DfaControlTransferValue value) {
        this(new JavaExpressionAnchor((PsiExpression)castExpression), casted, castTo, value);
    }

    private TypeCastInstruction(DfaAnchor castExpression, PsiExpression casted, PsiType castTo, @Nullable DfaControlTransferValue value) {
        super(castExpression);
        assert (!(castTo instanceof PsiPrimitiveType));
        this.myCasted = casted;
        this.myCastTo = TypeConversionUtil.erasure((PsiType)castTo);
        this.myTransferValue = value;
    }

    @NotNull
    public Instruction bindToFactory(@NotNull DfaValueFactory factory) {
        if (factory == null) {
            TypeCastInstruction.$$$reportNull$$$0(0);
        }
        if (this.myTransferValue == null) {
            TypeCastInstruction typeCastInstruction = this;
            if (typeCastInstruction == null) {
                TypeCastInstruction.$$$reportNull$$$0(1);
            }
            return typeCastInstruction;
        }
        return new TypeCastInstruction(this.getDfaAnchor(), this.myCasted, this.myCastTo, this.myTransferValue.bindToFactory(factory));
    }

    public PsiExpression getCasted() {
        return this.myCasted;
    }

    @Nullable
    public UnsatisfiedConditionProblem getConditionProblem() {
        JavaExpressionAnchor anchor = (JavaExpressionAnchor)this.getDfaAnchor();
        return anchor == null ? null : new ClassCastProblem((PsiTypeCastExpression)anchor.getExpression());
    }

    public DfaInstructionState[] accept(@NotNull DataFlowInterpreter interpreter, @NotNull DfaMemoryState stateBefore) {
        if (interpreter == null) {
            TypeCastInstruction.$$$reportNull$$$0(2);
        }
        if (stateBefore == null) {
            TypeCastInstruction.$$$reportNull$$$0(3);
        }
        DfaValueFactory factory = interpreter.getFactory();
        PsiType fromType = this.getCasted().getType();
        TypeConstraint constraint = TypeConstraints.instanceOf(this.myCastTo);
        boolean castPossible = true;
        ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
        if (this.myTransferValue != null) {
            DfaMemoryState castFail = stateBefore.createCopy();
            if (fromType != null && (!constraint.isResolved() || this.myCastTo.isConvertibleFrom(fromType))) {
                if (!TypeCastInstruction.castTopOfStack(factory, stateBefore, constraint)) {
                    castPossible = false;
                } else {
                    result.add(this.nextState(interpreter, stateBefore));
                    this.pushResult(interpreter, stateBefore, stateBefore.pop(), new DfaValue[0]);
                }
            }
            DfaValue value = castFail.peek();
            DfaCondition notNullCondition = value.cond(RelationType.NE, (DfType)DfTypes.NULL);
            DfaCondition notTypeCondition = value.cond(RelationType.IS_NOT, DfTypes.typedObject(this.myCastTo, Nullability.NOT_NULL));
            if (castFail.applyCondition(notNullCondition) && castFail.applyCondition(notTypeCondition)) {
                List states = this.myTransferValue.dispatch(castFail, interpreter);
                for (DfaInstructionState cceState : states) {
                    cceState.getMemoryState().markEphemeral();
                }
                result.addAll(states);
            }
        } else {
            StandardDataFlowInterpreter standard;
            if (fromType != null && this.myCastTo.isConvertibleFrom(fromType) && !TypeCastInstruction.castTopOfStack(factory, stateBefore, constraint)) {
                castPossible = false;
            }
            if (castPossible || interpreter instanceof StandardDataFlowInterpreter && !(standard = (StandardDataFlowInterpreter)interpreter).stopOnCast()) {
                result.add(this.nextState(interpreter, stateBefore));
            }
            this.pushResult(interpreter, stateBefore, stateBefore.pop(), new DfaValue[0]);
        }
        UnsatisfiedConditionProblem problem = this.getConditionProblem();
        if (problem != null) {
            interpreter.getListener().onCondition(problem, stateBefore.peek(), castPossible ? ThreeState.UNSURE : ThreeState.YES, stateBefore);
        }
        return result.toArray(DfaInstructionState.EMPTY_ARRAY);
    }

    private static boolean castTopOfStack(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, @NotNull TypeConstraint type) {
        DfaValue value;
        DfType dfType;
        DfType result;
        if (factory == null) {
            TypeCastInstruction.$$$reportNull$$$0(4);
        }
        if (state == null) {
            TypeCastInstruction.$$$reportNull$$$0(5);
        }
        if (type == null) {
            TypeCastInstruction.$$$reportNull$$$0(6);
        }
        if (!(result = (dfType = state.getDfType(value = state.peek())).meet(type.asDfType())).equals((Object)dfType)) {
            if (result == DfTypes.NULL || !state.meetDfType(value, result)) {
                return false;
            }
            if (!(value instanceof DfaVariableValue)) {
                state.pop();
                state.push((DfaValue)factory.fromDfType(result));
            }
        }
        return true;
    }

    public String toString() {
        return "CAST_TO " + this.myCastTo.getCanonicalText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/java/inst/TypeCastInstruction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateBefore";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/java/inst/TypeCastInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "bindToFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindToFactory";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "castTopOfStack";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

