/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm;

import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.callMatcher.CallMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldChecker {
    private final boolean myTrustDirectFieldInitializers;
    private final boolean myTrustFieldInitializersInConstructors;
    private final boolean myCanInstantiateItself;
    private final PsiClass myClass;
    private final FieldChecker myParent;

    private FieldChecker(PsiElement context) {
        PsiClass contextClass;
        PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiMember.class}), PsiMethod.class);
        this.myClass = contextClass = method != null ? method.getContainingClass() : (context instanceof PsiClass ? (PsiClass)context : null);
        if (method == null || this.myClass == null) {
            this.myCanInstantiateItself = false;
            this.myTrustFieldInitializersInConstructors = false;
            this.myTrustDirectFieldInitializers = false;
            this.myParent = null;
            return;
        }
        this.myParent = PsiUtil.isLocalOrAnonymousClass((PsiClass)this.myClass) ? new FieldChecker(this.myClass.getParent()) : null;
        ClassInitializationInfo info = (ClassInitializationInfo)CachedValuesManager.getProjectPsiDependentCache((PsiElement)contextClass, ClassInitializationInfo::new);
        this.myCanInstantiateItself = info.myCanInstantiateItself;
        if (method.hasModifierProperty("static") || method.isConstructor()) {
            this.myTrustDirectFieldInitializers = true;
            this.myTrustFieldInitializersInConstructors = false;
            return;
        }
        this.myTrustFieldInitializersInConstructors = !info.mySuperCtorsCallMethods && !info.myCtorsCallMethods;
        this.myTrustDirectFieldInitializers = !info.mySuperCtorsCallMethods;
    }

    public boolean canTrustFieldInitializer(PsiField field) {
        if (this.myParent != null && !this.myParent.canTrustFieldInitializer(field)) {
            return false;
        }
        if (field.hasInitializer()) {
            boolean staticField = field.hasModifierProperty("static");
            if (staticField && this.myClass != null && field.getContainingClass() != this.myClass) {
                return true;
            }
            return this.myTrustDirectFieldInitializers && (!this.myCanInstantiateItself || !staticField);
        }
        return this.myTrustFieldInitializersInConstructors;
    }

    public static FieldChecker getChecker(@Nullable PsiElement context) {
        if (context == null) {
            return new FieldChecker(null);
        }
        return (FieldChecker)CachedValuesManager.getProjectPsiDependentCache((PsiElement)context, FieldChecker::new);
    }

    private static class ClassInitializationInfo {
        private static final CallMatcher SAFE_CALLS = CallMatcher.staticCall("java.util.Objects", "requireNonNull");
        final boolean myCanInstantiateItself;
        final boolean myCtorsCallMethods;
        final boolean mySuperCtorsCallMethods;

        ClassInitializationInfo(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                ClassInitializationInfo.$$$reportNull$$$0(0);
            }
            boolean canInstantiateItself = false;
            for (PsiElement child = psiClass.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof PsiMember) || !((PsiMember)child).hasModifierProperty("static") || SyntaxTraverser.psiTraverser((PsiElement)child).filter(PsiNewExpression.class).filterMap(PsiNewExpression::getClassReference).find(classRef -> classRef.isReferenceTo((PsiElement)psiClass)) == null) continue;
                canInstantiateItself = true;
                break;
            }
            this.myCanInstantiateItself = canInstantiateItself;
            this.mySuperCtorsCallMethods = !InheritanceUtil.processSupers((PsiClass)psiClass, (boolean)false, superClass -> !ClassInitializationInfo.canCallMethodsInConstructors(superClass, true));
            this.myCtorsCallMethods = ClassInitializationInfo.canCallMethodsInConstructors(psiClass, false);
        }

        private static boolean canCallMethodsInConstructors(@NotNull PsiClass aClass, boolean virtual) {
            if (aClass == null) {
                ClassInitializationInfo.$$$reportNull$$$0(1);
            }
            boolean inByteCode = false;
            if (aClass instanceof PsiCompiledElement) {
                inByteCode = true;
                PsiElement navigationElement = aClass.getNavigationElement();
                if (navigationElement instanceof PsiClass) {
                    aClass = (PsiClass)navigationElement;
                }
            }
            for (PsiMethod constructor : aClass.getConstructors()) {
                if (inByteCode && JavaMethodContractUtil.isPure(constructor) && !JavaMethodContractUtil.hasExplicitContractAnnotation(constructor)) continue;
                if (!constructor.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return true;
                }
                PsiCodeBlock body = constructor.getBody();
                if (body == null) continue;
                for (PsiMethodCallExpression call : ((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)body)).filter(PsiMethodCallExpression.class)) {
                    PsiReferenceExpression methodExpression = call.getMethodExpression();
                    if (methodExpression.textMatches((CharSequence)"this") || methodExpression.textMatches((CharSequence)"super") || SAFE_CALLS.test(call)) continue;
                    if (!virtual) {
                        return true;
                    }
                    PsiMethod target = call.resolveMethod();
                    if (target == null || !PsiUtil.canBeOverridden((PsiMethod)target)) continue;
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/FieldChecker$ClassInitializationInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canCallMethodsInConstructors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

