/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.jvm.descriptors;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.MutationSignature;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.descriptors.PsiVarDescriptor;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThisDescriptor
extends PsiVarDescriptor {
    @NotNull
    private final PsiClass myQualifier;
    private final int myHash;

    public ThisDescriptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ThisDescriptor.$$$reportNull$$$0(0);
        }
        this.myQualifier = psiClass;
        this.myHash = Objects.hashCode(psiClass.getQualifiedName());
    }

    @NotNull
    public String toString() {
        if (this.myQualifier instanceof PsiAnonymousClass) {
            String string = "(anonymous " + ((PsiAnonymousClass)this.myQualifier).getBaseClassReference().getText() + ").this";
            if (string == null) {
                ThisDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.myQualifier.getName() + ".this";
        if (string == null) {
            ThisDescriptor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    PsiType getType(@Nullable DfaVariableValue qualifier) {
        return new PsiImmediateClassType(this.myQualifier, PsiSubstitutor.EMPTY);
    }

    @Override
    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier) {
        DfType dfType = DfTypes.typedObject(this.getType(qualifier), Nullability.NOT_NULL);
        if (dfType == null) {
            ThisDescriptor.$$$reportNull$$$0(3);
        }
        return dfType;
    }

    @NotNull
    public PsiClass getPsiElement() {
        PsiClass psiClass = this.myQualifier;
        if (psiClass == null) {
            ThisDescriptor.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    public boolean isStable() {
        return true;
    }

    public int hashCode() {
        return this.myHash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ThisDescriptor && ((ThisDescriptor)obj).myQualifier == this.myQualifier;
    }

    @Override
    @NotNull
    public DfType getInitialDfType(@NotNull DfaVariableValue thisValue, @Nullable PsiElement context) {
        if (thisValue == null) {
            ThisDescriptor.$$$reportNull$$$0(5);
        }
        DfType dfType = this.getDfType(thisValue.getQualifier());
        if (context != null) {
            PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)context.getParent(), PsiMethod.class);
            if (method != null && this.myQualifier.equals((Object)method.getContainingClass())) {
                if (this.myQualifier instanceof PsiEnumConstantInitializer) {
                    PsiEnumConstant constant = ((PsiEnumConstantInitializer)this.myQualifier).getEnumConstant();
                    DfConstantType<?> dfConstantType = DfTypes.referenceConstant((Object)constant, TypeConstraints.exactClass(this.myQualifier));
                    if (dfConstantType == null) {
                        ThisDescriptor.$$$reportNull$$$0(6);
                    }
                    return dfConstantType;
                }
                if (!method.isConstructor() && MutationSignature.fromMethod(method).preservesThis()) {
                    DfType dfType2 = dfType.meet((DfType)Mutability.UNMODIFIABLE_VIEW.asDfType());
                    if (dfType2 == null) {
                        ThisDescriptor.$$$reportNull$$$0(7);
                    }
                    return dfType2;
                }
                if (method.isConstructor()) {
                    DfType dfType3 = dfType.meet((DfType)DfTypes.LOCAL_OBJECT);
                    if (dfType3 == null) {
                        ThisDescriptor.$$$reportNull$$$0(8);
                    }
                    return dfType3;
                }
            }
            if (this.myQualifier.equals((Object)context)) {
                DfType dfType4 = dfType.meet((DfType)DfTypes.LOCAL_OBJECT);
                if (dfType4 == null) {
                    ThisDescriptor.$$$reportNull$$$0(9);
                }
                return dfType4;
            }
        }
        DfType dfType5 = dfType;
        if (dfType5 == null) {
            ThisDescriptor.$$$reportNull$$$0(10);
        }
        return dfType5;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    public static DfaVariableValue createThisValue(@NotNull DfaValueFactory factory, @Nullable PsiClass aClass) {
        if (factory == null) {
            ThisDescriptor.$$$reportNull$$$0(11);
        }
        if (aClass == null) {
            return null;
        }
        return factory.getVarFactory().createVariableValue((VariableDescriptor)new ThisDescriptor(aClass));
    }

    @Override
    @NotNull
    public DfaValue createValue(@NotNull DfaValueFactory factory, @Nullable DfaValue qualifier) {
        if (factory == null) {
            ThisDescriptor.$$$reportNull$$$0(12);
        }
        if (qualifier != null) {
            DfaTypeValue dfaTypeValue = factory.getUnknown();
            if (dfaTypeValue == null) {
                ThisDescriptor.$$$reportNull$$$0(13);
            }
            return dfaTypeValue;
        }
        DfaVariableValue dfaVariableValue = factory.getVarFactory().createVariableValue((VariableDescriptor)this);
        if (dfaVariableValue == null) {
            ThisDescriptor.$$$reportNull$$$0(14);
        }
        return dfaVariableValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/ThisDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/jvm/descriptors/ThisDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialDfType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInitialDfType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createThisValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 8, 9, 10, 13, 14 -> new IllegalStateException(string);
        };
    }
}

