/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleRangeType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfDoubleConstantType
extends DfConstantType<Double>
implements DfDoubleType {
    private final boolean shouldWiden;

    DfDoubleConstantType(double value) {
        this(value, false);
    }

    private DfDoubleConstantType(double value, boolean widen) {
        super((Object)value);
        this.shouldWiden = widen;
    }

    public DfDoubleConstantType makeWide() {
        return this.shouldWiden ? this : new DfDoubleConstantType((Double)this.getValue(), true);
    }

    public DfType widen() {
        return this.shouldWiden ? DfTypes.DOUBLE : super.widen();
    }

    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfDoubleConstantType.$$$reportNull$$$0(0);
        }
        DfType dfType = Objects.requireNonNull(this.join(other, false));
        if (dfType == null) {
            DfDoubleConstantType.$$$reportNull$$$0(1);
        }
        return dfType;
    }

    @Nullable
    public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfDoubleConstantType.$$$reportNull$$$0(2);
        }
        return this.join(other, true);
    }

    private DfType join(@NotNull DfType other, boolean exact) {
        if (other == null) {
            DfDoubleConstantType.$$$reportNull$$$0(3);
        }
        if (other.isSuperType((DfType)this)) {
            return other;
        }
        if (other instanceof DfDoubleRangeType) {
            return ((DfDoubleRangeType)other).join(this, exact);
        }
        if (other instanceof DfDoubleConstantType) {
            double val1 = (Double)this.getValue();
            double val2 = (Double)((DfDoubleConstantType)other).getValue();
            if (Double.isNaN(val1)) {
                return DfDoubleRangeType.create(val2, val2, false, true);
            }
            if (Double.isNaN(val2)) {
                return DfDoubleRangeType.create(val1, val1, false, true);
            }
            double from = Math.min(val1, val2);
            double to = Math.max(val1, val2);
            return exact ? null : DfDoubleRangeType.create(from, to, false, false);
        }
        return exact ? null : DfType.TOP;
    }

    @NotNull
    public DfType fromRelation(@NotNull RelationType relationType) {
        double value;
        if (relationType == null) {
            DfDoubleConstantType.$$$reportNull$$$0(4);
        }
        if (Double.isNaN(value = ((Double)this.getValue()).doubleValue())) {
            DfDoubleType dfDoubleType = relationType == RelationType.NE ? DfTypes.DOUBLE : BOTTOM;
            if (dfDoubleType == null) {
                DfDoubleConstantType.$$$reportNull$$$0(5);
            }
            return dfDoubleType;
        }
        DfType dfType = DfDoubleRangeType.fromRelation(relationType, value, value);
        if (dfType == null) {
            DfDoubleConstantType.$$$reportNull$$$0(6);
        }
        return dfType;
    }

    @NotNull
    public DfType tryNegate() {
        double value = (Double)this.getValue();
        if (Double.isNaN(value)) {
            DfType dfType = DfDoubleRangeType.create(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, false);
            if (dfType == null) {
                DfDoubleConstantType.$$$reportNull$$$0(7);
            }
            return dfType;
        }
        DfType dfType = DfDoubleRangeType.create(value, value, true, true);
        if (dfType == null) {
            DfDoubleConstantType.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DfDoubleConstantType)) return false;
        DfDoubleConstantType that = (DfDoubleConstantType)o;
        if (!super.equals(o)) return false;
        if (this.shouldWiden != that.shouldWiden) return false;
        return true;
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.shouldWiden ? 1 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfDoubleConstantType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfDoubleConstantType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRelation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tryNegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromRelation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

