/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypes;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DfDoubleRangeType
implements DfDoubleType {
    private final double myFrom;
    private final double myTo;
    private final boolean myInvert;
    private final boolean myNaN;

    DfDoubleRangeType(double from, double to, boolean invert, boolean nan) {
        this.myFrom = from;
        this.myTo = to;
        this.myInvert = invert;
        this.myNaN = nan;
    }

    static DfType create(double from, double to, boolean invert, boolean nan) {
        assert (!Double.isNaN(from));
        assert (!Double.isNaN(to));
        if (Double.compare(from, to) > 0) {
            return nan ? new DfDoubleConstantType(Double.NaN) : DfType.BOTTOM;
        }
        if (to == Double.POSITIVE_INFINITY && from == Double.NEGATIVE_INFINITY) {
            if (invert) {
                return nan ? new DfDoubleConstantType(Double.NaN) : DfType.BOTTOM;
            }
            return new DfDoubleRangeType(from, to, false, nan);
        }
        if (to == Double.POSITIVE_INFINITY) {
            to = DfDoubleRangeType.nextDown(from);
            from = Double.NEGATIVE_INFINITY;
            boolean bl = invert = !invert;
        }
        if (!nan && !invert && Double.compare(from, to) == 0) {
            return new DfDoubleConstantType(from);
        }
        if (!nan && invert && from == Double.NEGATIVE_INFINITY && to == DfDoubleRangeType.nextDown(Double.POSITIVE_INFINITY)) {
            return new DfDoubleConstantType(Double.POSITIVE_INFINITY);
        }
        return new DfDoubleRangeType(from, to, invert, nan);
    }

    public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfDoubleRangeType.$$$reportNull$$$0(0);
        }
        if (other == DfType.BOTTOM || other.equals((Object)this)) {
            return true;
        }
        if (other instanceof DfDoubleConstantType) {
            double val = (Double)((DfDoubleConstantType)other).getValue();
            if (Double.isNaN(val)) {
                return this.myNaN;
            }
            int from = Double.compare(this.myFrom, val);
            int to = Double.compare(val, this.myTo);
            return (from <= 0 && to <= 0) != this.myInvert;
        }
        if (other instanceof DfDoubleRangeType) {
            DfDoubleRangeType range = (DfDoubleRangeType)other;
            if (range.myNaN && !this.myNaN) {
                return false;
            }
            if (!this.myInvert && this.myFrom == Double.NEGATIVE_INFINITY && this.myTo == Double.POSITIVE_INFINITY) {
                return true;
            }
            int from = Double.compare(this.myFrom, range.myFrom);
            int to = Double.compare(range.myTo, this.myTo);
            if (this.myInvert) {
                if (range.myInvert) {
                    return from >= 0 && to >= 0;
                }
                return Double.compare(range.myTo, this.myFrom) < 0 || Double.compare(range.myFrom, this.myTo) > 0;
            }
            return !range.myInvert && from <= 0 && to <= 0;
        }
        return false;
    }

    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfDoubleRangeType.$$$reportNull$$$0(1);
        }
        DfType dfType = this.join(other, false);
        if (dfType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    @Nullable
    public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfDoubleRangeType.$$$reportNull$$$0(3);
        }
        return this.join(other, true);
    }

    DfType join(@NotNull DfType other, boolean exact) {
        DfDoubleRangeType res;
        if (other == null) {
            DfDoubleRangeType.$$$reportNull$$$0(4);
        }
        if (other.isSuperType((DfType)this)) {
            return other;
        }
        if (this.isSuperType(other)) {
            return this;
        }
        if (other instanceof DfDoubleConstantType) {
            double value = (Double)((DfDoubleConstantType)other).getValue();
            if (Double.isNaN(value)) {
                return DfDoubleRangeType.create(this.myFrom, this.myTo, this.myInvert, true);
            }
            return this.joinRange(value, value, exact);
        }
        if (!(other instanceof DfDoubleRangeType)) {
            return exact ? null : TOP;
        }
        DfDoubleRangeType range = (DfDoubleRangeType)other;
        DfDoubleRangeType dfDoubleRangeType = res = range.myNaN && !this.myNaN ? new DfDoubleRangeType(this.myFrom, this.myTo, this.myInvert, true) : this;
        if (range.myInvert) {
            if (range.myFrom > Double.NEGATIVE_INFINITY && (res = res.joinRange(Double.NEGATIVE_INFINITY, DfDoubleRangeType.nextDown(range.myFrom), exact)) == null) {
                return null;
            }
            if (range.myTo < Double.POSITIVE_INFINITY && (res = res.joinRange(DfDoubleRangeType.nextUp(range.myTo), Double.POSITIVE_INFINITY, exact)) == null) {
                return null;
            }
        } else {
            res = res.joinRange(range.myFrom, range.myTo, exact);
        }
        return res;
    }

    private DfDoubleRangeType joinRange(double from, double to, boolean exact) {
        if (Double.compare(from, to) > 0) {
            return this;
        }
        if (this.myInvert) {
            if (Double.compare(to, this.myFrom) < 0 || Double.compare(from, this.myTo) > 0) {
                return this;
            }
            int fromCmp = Double.compare(this.myFrom, from);
            int toCmp = Double.compare(to, this.myTo);
            if (fromCmp >= 0 && toCmp >= 0 || fromCmp < 0 && toCmp < 0) {
                return exact ? null : (DfDoubleRangeType)DfDoubleRangeType.create(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, false, this.myNaN);
            }
            if (fromCmp >= 0) {
                return (DfDoubleRangeType)DfDoubleRangeType.create(DfDoubleRangeType.nextUp(to), this.myTo, true, this.myNaN);
            }
            return (DfDoubleRangeType)DfDoubleRangeType.create(this.myFrom, DfDoubleRangeType.nextDown(from), true, this.myNaN);
        }
        if (Double.compare(this.myTo, DfDoubleRangeType.nextDown(from)) < 0 || Double.compare(to, DfDoubleRangeType.nextDown(this.myFrom)) < 0) {
            if (this.myFrom == Double.NEGATIVE_INFINITY && to == Double.POSITIVE_INFINITY) {
                return (DfDoubleRangeType)DfDoubleRangeType.create(DfDoubleRangeType.nextUp(this.myTo), DfDoubleRangeType.nextDown(from), true, this.myNaN);
            }
            if (exact) {
                return null;
            }
        }
        return (DfDoubleRangeType)DfDoubleRangeType.create(Math.min(this.myFrom, from), Math.max(this.myTo, to), false, this.myNaN);
    }

    @NotNull
    public DfType meet(@NotNull DfType other) {
        boolean nan;
        if (other == null) {
            DfDoubleRangeType.$$$reportNull$$$0(5);
        }
        if (other.isSuperType((DfType)this)) {
            DfDoubleRangeType dfDoubleRangeType = this;
            if (dfDoubleRangeType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(6);
            }
            return dfDoubleRangeType;
        }
        if (this.isSuperType(other)) {
            DfType dfType = other;
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(7);
            }
            return dfType;
        }
        if (!(other instanceof DfDoubleRangeType)) {
            DfType dfType = DfType.BOTTOM;
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(8);
            }
            return dfType;
        }
        DfDoubleRangeType range = (DfDoubleRangeType)other;
        boolean bl = nan = range.myNaN && this.myNaN;
        if (!this.myInvert) {
            if (!range.myInvert) {
                double from = Math.max(this.myFrom, range.myFrom);
                double to = Math.min(this.myTo, range.myTo);
                DfType dfType = DfDoubleRangeType.create(from, to, false, nan);
                if (dfType == null) {
                    DfDoubleRangeType.$$$reportNull$$$0(9);
                }
                return dfType;
            }
            int fromCmp = Double.compare(this.myFrom, range.myFrom);
            int toCmp = Double.compare(range.myTo, this.myTo);
            if (fromCmp >= 0) {
                DfType dfType = DfDoubleRangeType.create(Math.max(this.myFrom, DfDoubleRangeType.nextUp(range.myTo)), this.myTo, false, nan);
                if (dfType == null) {
                    DfDoubleRangeType.$$$reportNull$$$0(10);
                }
                return dfType;
            }
            if (toCmp >= 0) {
                DfType dfType = DfDoubleRangeType.create(this.myFrom, Math.min(this.myTo, DfDoubleRangeType.nextDown(range.myFrom)), false, nan);
                if (dfType == null) {
                    DfDoubleRangeType.$$$reportNull$$$0(11);
                }
                return dfType;
            }
            if (this.myFrom == Double.NEGATIVE_INFINITY && this.myTo == Double.POSITIVE_INFINITY) {
                DfType dfType = DfDoubleRangeType.create(range.myFrom, range.myTo, true, nan);
                if (dfType == null) {
                    DfDoubleRangeType.$$$reportNull$$$0(12);
                }
                return dfType;
            }
            DfType dfType = DfDoubleRangeType.create(this.myFrom, this.myTo, false, nan);
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(13);
            }
            return dfType;
        }
        if (!range.myInvert) {
            DfType dfType = range.meet(this);
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(14);
            }
            return dfType;
        }
        if (this.myTo >= Math.nextDown(range.myFrom) && range.myTo >= Math.nextDown(this.myFrom)) {
            double from = Math.min(this.myFrom, range.myFrom);
            double to = Math.max(this.myTo, range.myTo);
            DfType dfType = DfDoubleRangeType.create(from, to, true, nan);
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(15);
            }
            return dfType;
        }
        if (this.myFrom < range.myFrom) {
            DfType dfType = DfDoubleRangeType.create(this.myFrom, this.myTo, true, nan);
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(16);
            }
            return dfType;
        }
        DfType dfType = DfDoubleRangeType.create(range.myFrom, range.myTo, true, nan);
        if (dfType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(17);
        }
        return dfType;
    }

    @NotNull
    public DfType fromRelation(@NotNull RelationType relationType) {
        if (relationType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(18);
        }
        if (relationType == RelationType.EQ) {
            DfDoubleRangeType result = this.myNaN ? this : DfDoubleRangeType.create(this.myFrom, this.myTo, this.myInvert, true);
            DfType zero = DfTypes.doubleRange(-0.0, 0.0);
            DfDoubleRangeType dfDoubleRangeType = this.meet(zero) != BOTTOM ? result.join(zero) : result;
            if (dfDoubleRangeType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(19);
            }
            return dfDoubleRangeType;
        }
        if (this.myInvert) {
            double max = this.myTo == Double.POSITIVE_INFINITY ? DfDoubleRangeType.nextDown(this.myFrom) : Double.POSITIVE_INFINITY;
            double min = this.myFrom == Double.NEGATIVE_INFINITY ? DfDoubleRangeType.nextUp(this.myTo) : Double.NEGATIVE_INFINITY;
            return DfDoubleRangeType.fromRelation(relationType, min, max);
        }
        return DfDoubleRangeType.fromRelation(relationType, this.myFrom, this.myTo);
    }

    @NotNull
    static DfType fromRelation(@NotNull RelationType relationType, double min, double d) {
        double max;
        if (relationType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(20);
        }
        assert (!Double.isNaN(min));
        assert (!Double.isNaN(max));
        DfDoubleType dfDoubleType = switch (relationType) {
            case RelationType.LE -> DfDoubleRangeType.create(Double.NEGATIVE_INFINITY, max == 0.0 ? 0.0 : max, false, true);
            case RelationType.LT -> {
                if (max == Double.NEGATIVE_INFINITY) {
                    yield DfTypes.DOUBLE_NAN;
                }
                yield DfDoubleRangeType.create(Double.NEGATIVE_INFINITY, Math.nextDown(max), false, true);
            }
            case RelationType.GE -> DfDoubleRangeType.create(min == 0.0 ? -0.0 : min, Double.POSITIVE_INFINITY, false, true);
            case RelationType.GT -> {
                if (min == Double.POSITIVE_INFINITY) {
                    yield DfTypes.DOUBLE_NAN;
                }
                yield DfDoubleRangeType.create(Math.nextUp(min), Double.POSITIVE_INFINITY, false, true);
            }
            case RelationType.EQ -> {
                if (min == 0.0) {
                    min = -0.0;
                }
                if (max == 0.0) {
                    max = 0.0;
                }
                yield DfDoubleRangeType.create(min, max, false, true);
            }
            case RelationType.NE -> {
                if (min == max) {
                    if (min == 0.0) {
                        yield DfDoubleRangeType.create(-0.0, 0.0, true, true);
                    }
                    yield DfDoubleRangeType.create(min, min, true, true);
                }
                yield DfTypes.DOUBLE;
            }
            default -> DfTypes.DOUBLE;
        };
        if (dfDoubleType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(21);
        }
        return dfDoubleType;
    }

    @NotNull
    public DfType tryNegate() {
        DfType dfType = DfDoubleRangeType.create(this.myFrom, this.myTo, !this.myInvert, !this.myNaN);
        if (dfType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(22);
        }
        return dfType;
    }

    @Override
    @NotNull
    public DfType castTo(@NotNull PsiPrimitiveType type) {
        if (type == null) {
            DfDoubleRangeType.$$$reportNull$$$0(23);
        }
        if (type.equals((Object)PsiTypes.longType())) {
            LongRangeSet range;
            if (!this.myInvert) {
                range = LongRangeSet.range((long)((long)this.myFrom), (long)((long)this.myTo));
            } else {
                range = LongRangeSet.empty();
                if (this.myFrom > Double.NEGATIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)Long.MIN_VALUE, (long)((long)DfDoubleRangeType.nextDown(this.myFrom))));
                }
                if (this.myTo < Double.POSITIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)((long)DfDoubleRangeType.nextUp(this.myTo)), (long)Long.MAX_VALUE));
                }
            }
            if (this.myNaN) {
                range = range.join(LongRangeSet.point((long)0L));
            }
            DfType dfType = DfTypes.longRange(range);
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(24);
            }
            return dfType;
        }
        if (type.equals((Object)PsiTypes.intType()) || type.equals((Object)PsiTypes.shortType()) || type.equals((Object)PsiTypes.byteType()) || type.equals((Object)PsiTypes.charType())) {
            DfType result;
            LongRangeSet range;
            if (!this.myInvert) {
                range = LongRangeSet.range((long)((int)this.myFrom), (long)((int)this.myTo));
            } else {
                range = LongRangeSet.empty();
                if (this.myFrom > Double.NEGATIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)Integer.MIN_VALUE, (long)((int)DfDoubleRangeType.nextDown(this.myFrom))));
                }
                if (this.myTo < Double.POSITIVE_INFINITY) {
                    range = range.join(LongRangeSet.range((long)((int)DfDoubleRangeType.nextUp(this.myTo)), (long)Integer.MAX_VALUE));
                }
            }
            if (this.myNaN) {
                range = range.join(LongRangeSet.point((long)0L));
            }
            if ((result = DfTypes.intRange(range)) instanceof DfPrimitiveType && !type.equals((Object)PsiTypes.intType())) {
                DfType dfType = ((DfPrimitiveType)result).castTo(type);
                if (dfType == null) {
                    DfDoubleRangeType.$$$reportNull$$$0(25);
                }
                return dfType;
            }
            DfType dfType = result;
            if (dfType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(26);
            }
            return dfType;
        }
        if (type.equals((Object)PsiTypes.doubleType())) {
            DfDoubleRangeType dfDoubleRangeType = this;
            if (dfDoubleRangeType == null) {
                DfDoubleRangeType.$$$reportNull$$$0(27);
            }
            return dfDoubleRangeType;
        }
        DfType dfType = DfType.TOP;
        if (dfType == null) {
            DfDoubleRangeType.$$$reportNull$$$0(28);
        }
        return dfType;
    }

    @NotNull
    public String toString() {
        Object range;
        if (this.myInvert) {
            if (this.myFrom == this.myTo) {
                range = "!= " + String.valueOf(Double.compare(this.myFrom, -0.0) == 0 && Double.compare(this.myTo, 0.0) == 0 ? "\u00b10.0" : Double.valueOf(this.myFrom));
            } else {
                String first = this.myFrom == Double.NEGATIVE_INFINITY ? "" : DfDoubleRangeType.formatRange(Double.NEGATIVE_INFINITY, DfDoubleRangeType.nextDown(this.myFrom));
                String second = this.myTo == Double.POSITIVE_INFINITY ? "" : DfDoubleRangeType.formatRange(DfDoubleRangeType.nextUp(this.myTo), Double.POSITIVE_INFINITY);
                range = StreamEx.of((Object[])new String[]{first, second}).without((Object)"").joining((CharSequence)" || ");
            }
        } else {
            range = DfDoubleRangeType.formatRange(this.myFrom, this.myTo);
        }
        Object result = "double";
        if (!((String)range).isEmpty()) {
            result = (String)result + " " + (String)range;
        }
        if (!this.myNaN) {
            result = (String)result + " not NaN";
        } else if (!((String)range).isEmpty()) {
            result = (String)result + " (or NaN)";
        }
        Object object = result;
        if (object == null) {
            DfDoubleRangeType.$$$reportNull$$$0(29);
        }
        return object;
    }

    private static double nextDown(double val) {
        if (Double.compare(val, 0.0) == 0) {
            return -0.0;
        }
        return Math.nextDown(val);
    }

    private static double nextUp(double val) {
        if (Double.compare(val, -0.0) == 0) {
            return 0.0;
        }
        return Math.nextUp(val);
    }

    private static String formatRange(double from, double to) {
        int cmp = Double.compare(from, to);
        if (cmp == 0) {
            return Double.toString(from);
        }
        if (Double.compare(from, -0.0) == 0 && Double.compare(to, 0.0) == 0) {
            return "\u00b10.0";
        }
        if (from == Double.NEGATIVE_INFINITY) {
            if (to == Double.POSITIVE_INFINITY) {
                return "";
            }
            return DfDoubleRangeType.formatTo(to);
        }
        if (to == Double.POSITIVE_INFINITY) {
            return DfDoubleRangeType.formatFrom(from);
        }
        return DfDoubleRangeType.formatFrom(from) + " && " + DfDoubleRangeType.formatTo(to);
    }

    @NotNull
    private static String formatFrom(double from) {
        double prev = DfDoubleRangeType.nextDown(from);
        if (Double.toString(prev).length() < Double.toString(from).length()) {
            String string = "> " + prev;
            if (string == null) {
                DfDoubleRangeType.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = ">= " + from;
        if (string == null) {
            DfDoubleRangeType.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static String formatTo(double to) {
        double next = DfDoubleRangeType.nextUp(to);
        if (Double.toString(next).length() < Double.toString(to).length()) {
            String string = "< " + next;
            if (string == null) {
                DfDoubleRangeType.$$$reportNull$$$0(32);
            }
            return string;
        }
        String string = "<= " + to;
        if (string == null) {
            DfDoubleRangeType.$$$reportNull$$$0(33);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DfDoubleRangeType type = (DfDoubleRangeType)o;
        return Double.compare(type.myFrom, this.myFrom) == 0 && Double.compare(type.myTo, this.myTo) == 0 && this.myInvert == type.myInvert && this.myNaN == type.myNaN;
    }

    public int hashCode() {
        return Objects.hash(this.myFrom, this.myTo, this.myInvert, this.myNaN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfDoubleRangeType";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfDoubleRangeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRelation";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "tryNegate";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "castTo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFrom";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fromRelation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "castTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 21, 22, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33 -> new IllegalStateException(string);
        };
    }
}

