/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatRangeType;
import com.intellij.codeInspection.dataFlow.types.DfFloatType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DfFloatConstantType
extends DfConstantType<Float>
implements DfFloatType {
    private final boolean shouldWiden;

    DfFloatConstantType(float value) {
        this(value, false);
    }

    private DfFloatConstantType(float value, boolean widen) {
        super((Object)Float.valueOf(value));
        this.shouldWiden = widen;
    }

    public DfFloatConstantType makeWide() {
        return this.shouldWiden ? this : new DfFloatConstantType(((Float)this.getValue()).floatValue(), true);
    }

    public DfType widen() {
        return this.shouldWiden ? DfTypes.FLOAT : super.widen();
    }

    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfFloatConstantType.$$$reportNull$$$0(0);
        }
        DfType dfType = Objects.requireNonNull(this.join(other, false));
        if (dfType == null) {
            DfFloatConstantType.$$$reportNull$$$0(1);
        }
        return dfType;
    }

    @Nullable
    public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfFloatConstantType.$$$reportNull$$$0(2);
        }
        return this.join(other, true);
    }

    private DfType join(@NotNull DfType other, boolean exact) {
        if (other == null) {
            DfFloatConstantType.$$$reportNull$$$0(3);
        }
        if (other.isSuperType((DfType)this)) {
            return other;
        }
        if (other instanceof DfFloatRangeType) {
            return ((DfFloatRangeType)other).join(this, exact);
        }
        if (other instanceof DfFloatConstantType) {
            float val1 = ((Float)this.getValue()).floatValue();
            float val2 = ((Float)((DfFloatConstantType)other).getValue()).floatValue();
            if (Float.isNaN(val1)) {
                return DfFloatRangeType.create(val2, val2, false, true);
            }
            if (Float.isNaN(val2)) {
                return DfFloatRangeType.create(val1, val1, false, true);
            }
            float from = Math.min(val1, val2);
            float to = Math.max(val1, val2);
            return exact ? null : DfFloatRangeType.create(from, to, false, false);
        }
        return exact ? null : DfType.TOP;
    }

    @NotNull
    public DfType fromRelation(@NotNull RelationType relationType) {
        float value;
        if (relationType == null) {
            DfFloatConstantType.$$$reportNull$$$0(4);
        }
        if (Float.isNaN(value = ((Float)this.getValue()).floatValue())) {
            DfFloatType dfFloatType = relationType == RelationType.NE ? DfTypes.FLOAT : BOTTOM;
            if (dfFloatType == null) {
                DfFloatConstantType.$$$reportNull$$$0(5);
            }
            return dfFloatType;
        }
        DfType dfType = DfFloatRangeType.fromRelation(relationType, value, value);
        if (dfType == null) {
            DfFloatConstantType.$$$reportNull$$$0(6);
        }
        return dfType;
    }

    @NotNull
    public DfType tryNegate() {
        float value = ((Float)this.getValue()).floatValue();
        if (Float.isNaN(value)) {
            DfType dfType = DfFloatRangeType.create(Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, false, false);
            if (dfType == null) {
                DfFloatConstantType.$$$reportNull$$$0(7);
            }
            return dfType;
        }
        DfType dfType = DfFloatRangeType.create(value, value, true, true);
        if (dfType == null) {
            DfFloatConstantType.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DfFloatConstantType)) return false;
        DfFloatConstantType that = (DfFloatConstantType)o;
        if (!super.equals(o)) return false;
        if (this.shouldWiden != that.shouldWiden) return false;
        return true;
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.shouldWiden ? 1 : 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfFloatConstantType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfFloatConstantType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRelation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tryNegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromRelation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

