/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfAntiConstantType;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfEphemeralReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceConstantType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DfGenericObjectType
extends DfAntiConstantType<Object>
implements DfReferenceType {
    @NotNull
    private final TypeConstraint myConstraint;
    @NotNull
    private final DfaNullability myNullability;
    @NotNull
    private final Mutability myMutability;
    @Nullable
    private final SpecialField mySpecialField;
    @NotNull
    private final DfType mySpecialFieldType;
    private final boolean myLocal;
    private int hashCode;

    DfGenericObjectType(@NotNull Set<Object> notValues, @NotNull TypeConstraint constraint, @NotNull DfaNullability nullability, @NotNull Mutability mutability, @Nullable SpecialField field, @NotNull DfType type, boolean local) {
        if (notValues == null) {
            DfGenericObjectType.$$$reportNull$$$0(0);
        }
        if (constraint == null) {
            DfGenericObjectType.$$$reportNull$$$0(1);
        }
        if (nullability == null) {
            DfGenericObjectType.$$$reportNull$$$0(2);
        }
        if (mutability == null) {
            DfGenericObjectType.$$$reportNull$$$0(3);
        }
        if (type == null) {
            DfGenericObjectType.$$$reportNull$$$0(4);
        }
        super(notValues);
        assert (constraint != TypeConstraints.BOTTOM);
        this.myConstraint = constraint;
        this.myNullability = nullability;
        this.myMutability = mutability;
        this.mySpecialField = field;
        this.mySpecialFieldType = type instanceof DfReferenceType ? ((DfReferenceType)type).dropSpecialField() : type;
        this.myLocal = local;
    }

    @Override
    @NotNull
    public DfaNullability getNullability() {
        DfaNullability dfaNullability = this.myNullability;
        if (dfaNullability == null) {
            DfGenericObjectType.$$$reportNull$$$0(5);
        }
        return dfaNullability;
    }

    @Override
    @NotNull
    public TypeConstraint getConstraint() {
        TypeConstraint typeConstraint = this.myConstraint;
        if (typeConstraint == null) {
            DfGenericObjectType.$$$reportNull$$$0(6);
        }
        return typeConstraint;
    }

    @Override
    @NotNull
    public Mutability getMutability() {
        Mutability mutability = this.myMutability;
        if (mutability == null) {
            DfGenericObjectType.$$$reportNull$$$0(7);
        }
        return mutability;
    }

    public boolean isLocal() {
        return this.myLocal;
    }

    @Override
    @Nullable
    public SpecialField getSpecialField() {
        return this.mySpecialField;
    }

    @Override
    @NotNull
    public DfType getSpecialFieldType() {
        DfType dfType = this.mySpecialFieldType;
        if (dfType == null) {
            DfGenericObjectType.$$$reportNull$$$0(8);
        }
        return dfType;
    }

    public DfType tryNegate() {
        if (this.myMutability != Mutability.UNKNOWN || this.myLocal || this.mySpecialField != null) {
            return null;
        }
        TypeConstraint negated = this.myConstraint.tryNegate();
        if (negated == null) {
            return null;
        }
        DfType result = negated.asDfType();
        return this.myNullability == DfaNullability.NOT_NULL ? result.join((DfType)DfTypes.NULL) : result.meet((DfType)DfTypes.NOT_NULL_OBJECT);
    }

    @NotNull
    public Set<Object> getNotValues() {
        if (this.myNullability == DfaNullability.NOT_NULL) {
            HashSet<Object> values = new HashSet<Object>(this.myNotValues);
            values.add(null);
            Set<Object> set = Collections.unmodifiableSet(values);
            if (set == null) {
                DfGenericObjectType.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set set = super.getNotValues();
        if (set == null) {
            DfGenericObjectType.$$$reportNull$$$0(10);
        }
        return set;
    }

    Set<Object> getRawNotValues() {
        return super.getNotValues();
    }

    @Override
    @NotNull
    public DfReferenceType dropTypeConstraint() {
        return this.myConstraint == TypeConstraints.TOP ? this : new DfGenericObjectType(this.myNotValues, TypeConstraints.TOP, this.myNullability, this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType dropMutability() {
        return this.myMutability == Mutability.UNKNOWN ? this : new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, Mutability.UNKNOWN, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType dropLocality() {
        DfGenericObjectType dfGenericObjectType = this.myLocal ? new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability, this.mySpecialField, this.mySpecialFieldType, false) : this;
        if (dfGenericObjectType == null) {
            DfGenericObjectType.$$$reportNull$$$0(11);
        }
        return dfGenericObjectType;
    }

    @Override
    @NotNull
    public DfReferenceType dropNullability() {
        return this.myNullability == DfaNullability.UNKNOWN ? this : new DfGenericObjectType(this.myNotValues, this.myConstraint, DfaNullability.UNKNOWN, this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType dropSpecialField() {
        return this.mySpecialField == null ? this : new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability, null, BOTTOM, this.myLocal);
    }

    @Override
    @NotNull
    public DfReferenceType convert(@NotNull TypeConstraints.TypeConstraintFactory factory) {
        DfType dfType;
        if (factory == null) {
            DfGenericObjectType.$$$reportNull$$$0(12);
        }
        TypeConstraint newConstraint = this.myConstraint.convert(factory);
        DfType dfType2 = this.mySpecialFieldType;
        if (dfType2 instanceof DfReferenceType) {
            DfReferenceType refType = (DfReferenceType)dfType2;
            dfType = refType.convert(factory);
        } else {
            dfType = this.mySpecialFieldType;
        }
        DfType newSpecialFieldType = dfType;
        return new DfGenericObjectType(this.myNotValues, newConstraint, this.myNullability, this.myMutability, this.mySpecialField, newSpecialFieldType, this.myLocal);
    }

    public boolean isSuperType(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(13);
        }
        if (other == BOTTOM || other == this) {
            return true;
        }
        if (other instanceof DfNullConstantType) {
            return this.getNullability() != DfaNullability.NOT_NULL;
        }
        if (!(other instanceof DfReferenceType)) {
            return false;
        }
        DfReferenceType type = (DfReferenceType)other;
        if (!this.myNotValues.isEmpty()) {
            if (other instanceof DfReferenceConstantType) {
                if (this.myNotValues.contains(((DfReferenceConstantType)other).getValue())) {
                    return false;
                }
            } else if (other instanceof DfGenericObjectType) {
                if (!((DfGenericObjectType)other).myNotValues.containsAll(this.myNotValues)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.isLocal() && !type.isLocal() && !this.getConstraint().isComparedByEquals()) {
            return false;
        }
        if (type.getNullability() != this.getNullability() && this.getNullability() != DfaNullability.UNKNOWN && type.getNullability() != DfaNullability.NOT_NULL) {
            return false;
        }
        if (!this.getConstraint().isSuperConstraintOf(type.getConstraint())) {
            return false;
        }
        if (this.getMutability().join(type.getMutability()) != this.getMutability()) {
            return false;
        }
        SpecialField sf = this.getSpecialField();
        if (sf != null) {
            if (sf != type.getSpecialField()) {
                return false;
            }
            if (!this.getSpecialFieldType().isSuperType(type.getSpecialFieldType())) {
                return false;
            }
        }
        return true;
    }

    public boolean isMergeable(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(14);
        }
        if (other == BOTTOM || other == this) {
            return true;
        }
        if (!this.isSuperType(other)) {
            return false;
        }
        if (this.getNullability() == DfaNullability.UNKNOWN || this.getNullability() == DfaNullability.FLUSHED) {
            DfaNullability otherNullability = DfaNullability.fromDfType(other);
            return otherNullability != DfaNullability.NULL && otherNullability != DfaNullability.NULLABLE;
        }
        return true;
    }

    @NotNull
    public DfType join(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(15);
        }
        if (this.isSuperType(other)) {
            DfGenericObjectType dfGenericObjectType = this;
            if (dfGenericObjectType == null) {
                DfGenericObjectType.$$$reportNull$$$0(16);
            }
            return dfGenericObjectType;
        }
        if (other.isSuperType((DfType)this)) {
            DfType dfType = other;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(17);
            }
            return dfType;
        }
        if (!(other instanceof DfReferenceType)) {
            DfType dfType = TOP;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(18);
            }
            return dfType;
        }
        DfReferenceType type = (DfReferenceType)other;
        if (other instanceof DfNullConstantType || other instanceof DfEphemeralReferenceType) {
            DfType dfType = other.join((DfType)this);
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(19);
            }
            return dfType;
        }
        TypeConstraint constraint = this.getConstraint().join(type.getConstraint());
        if (constraint == TypeConstraints.BOTTOM) {
            throw new AssertionError((Object)("Join failed: " + String.valueOf(this) + "(" + this.getConstraint().debugInfo() + ") | " + String.valueOf(other) + " (" + type.getConstraint().debugInfo() + ")"));
        }
        DfaNullability nullability = this.getNullability().unite(type.getNullability());
        Mutability mutability = this.getMutability().join(type.getMutability());
        boolean locality = this.isLocal() && type.isLocal();
        SpecialField sf = Objects.equals((Object)this.getSpecialField(), (Object)type.getSpecialField()) ? this.getSpecialField() : null;
        DfType sfType = sf == null ? BOTTOM : this.getSpecialFieldType().join(type.getSpecialFieldType());
        HashSet<Object> notValues = this.myNotValues;
        if (type instanceof DfGenericObjectType) {
            notValues = new HashSet<Object>(this.myNotValues);
            notValues.retainAll(((DfGenericObjectType)other).myNotValues);
        }
        if (type instanceof DfReferenceConstantType) {
            notValues = new HashSet(this.myNotValues);
            notValues.remove(((DfReferenceConstantType)type).getValue());
        }
        return new DfGenericObjectType(notValues, constraint, nullability, mutability, sf, sfType, locality);
    }

    @Nullable
    public DfType tryJoinExactly(@NotNull DfType other) {
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(20);
        }
        if (this.isMergeable(other)) {
            return this;
        }
        if (other.isMergeable((DfType)this)) {
            return other;
        }
        if (!(other instanceof DfReferenceType)) {
            return null;
        }
        if (other instanceof DfNullConstantType) {
            if (this.mySpecialField != null) {
                return null;
            }
            return new DfGenericObjectType(this.myNotValues, this.getConstraint(), DfaNullability.NULL.unite(this.getNullability()), this.getMutability(), null, BOTTOM, this.isLocal());
        }
        if (other instanceof DfReferenceConstantType) {
            Object otherValue = ((DfReferenceConstantType)other).getValue();
            if (!this.myNotValues.contains(otherValue)) {
                return null;
            }
            if (this.mySpecialField != null) {
                return null;
            }
            HashSet<Object> notValues = new HashSet<Object>(this.myNotValues);
            notValues.remove(otherValue);
            TypeConstraint constraint = this.getConstraint().tryJoinExactly(((DfReferenceConstantType)other).getConstraint());
            return constraint == null ? null : new DfGenericObjectType(notValues, constraint, this.getNullability(), this.getMutability(), null, BOTTOM, this.isLocal());
        }
        if (other instanceof DfGenericObjectType) {
            DfGenericObjectType objectType = (DfGenericObjectType)other;
            Mutability otherMutability = objectType.getMutability();
            DfaNullability otherNullability = objectType.getNullability();
            Set<Object> otherNotValues = objectType.getRawNotValues();
            TypeConstraint otherConstraint = objectType.getConstraint();
            SpecialField otherSpecialField = objectType.getSpecialField();
            DfType otherSfType = objectType.getSpecialFieldType();
            boolean otherLocal = objectType.isLocal();
            boolean MUTABILITY = true;
            int NULLABILITY = 2;
            int NOT_VALUES = 4;
            int CONSTRAINT = 8;
            int SPECIAL_FIELD = 16;
            int SF_TYPE = 32;
            int LOCAL = 64;
            int bits = 0;
            if (otherMutability != this.myMutability) {
                bits |= 1;
            }
            if (otherNullability != this.myNullability) {
                bits |= 2;
            }
            if (!otherNotValues.equals(this.myNotValues)) {
                bits |= 4;
            }
            if (!otherConstraint.equals(this.myConstraint)) {
                bits |= 8;
            }
            if (otherSpecialField != this.mySpecialField) {
                bits |= 0x10;
            }
            if (!otherSfType.equals((Object)this.mySpecialFieldType)) {
                bits |= 0x20;
            }
            if (otherLocal != this.myLocal) {
                bits |= 0x40;
            }
            switch (bits) {
                case 8: 
                case 10: {
                    TypeConstraint constraint = otherConstraint.tryJoinExactly(this.myConstraint);
                    return constraint == null ? null : new DfGenericObjectType(this.myNotValues, constraint, this.myNullability.unite(otherNullability), this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
                }
                case 1: {
                    return new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability.join(otherMutability), this.mySpecialField, this.mySpecialFieldType, this.myLocal);
                }
                case 2: {
                    return new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability.unite(otherNullability), this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
                }
                case 4: {
                    HashSet<Object> notValues = new HashSet<Object>(this.myNotValues);
                    notValues.retainAll(otherNotValues);
                    return new DfGenericObjectType(notValues, this.myConstraint, this.myNullability, this.myMutability, this.mySpecialField, this.mySpecialFieldType, this.myLocal);
                }
                case 32: {
                    DfType sfType = otherSfType.tryJoinExactly(this.mySpecialFieldType);
                    return sfType == null ? null : new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability, this.mySpecialField, sfType, this.myLocal);
                }
            }
        }
        return null;
    }

    @NotNull
    public DfType meet(@NotNull DfType other) {
        DfType sfType;
        SpecialField sf;
        boolean locality;
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(21);
        }
        if (other instanceof DfConstantType || other instanceof DfEphemeralReferenceType) {
            DfType dfType = other.meet((DfType)this);
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(22);
            }
            return dfType;
        }
        if (this.isSuperType(other)) {
            DfType dfType = other;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(23);
            }
            return dfType;
        }
        if (other.isSuperType((DfType)this)) {
            DfGenericObjectType dfGenericObjectType = this;
            if (dfGenericObjectType == null) {
                DfGenericObjectType.$$$reportNull$$$0(24);
            }
            return dfGenericObjectType;
        }
        if (!(other instanceof DfReferenceType)) {
            DfType dfType = BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(25);
            }
            return dfType;
        }
        DfReferenceType type = (DfReferenceType)other;
        TypeConstraint constraint = this.getConstraint().meet(type.getConstraint());
        if (constraint == TypeConstraints.BOTTOM) {
            DfType dfType = this.isSuperType(DfTypes.NULL) && other.isSuperType((DfType)DfTypes.NULL) ? DfTypes.NULL : BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(26);
            }
            return dfType;
        }
        DfaNullability nullability = this.getNullability().intersect(type.getNullability());
        if (nullability == null) {
            DfType dfType = BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(27);
            }
            return dfType;
        }
        Mutability mutability = this.getMutability().meet(type.getMutability());
        if (mutability == null) {
            DfType dfType = BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(28);
            }
            return dfType;
        }
        boolean bl = locality = this.isLocal() || type.isLocal();
        if (this.getSpecialField() == null) {
            sf = type.getSpecialField();
            sfType = type.getSpecialFieldType();
        } else if (type.getSpecialField() == null) {
            sf = this.getSpecialField();
            sfType = this.getSpecialFieldType();
        } else {
            sf = this.getSpecialField();
            if (sf != type.getSpecialField()) {
                DfType dfType = BOTTOM;
                if (dfType == null) {
                    DfGenericObjectType.$$$reportNull$$$0(29);
                }
                return dfType;
            }
            sfType = this.getSpecialFieldType().meet(type.getSpecialFieldType());
        }
        if (sf != null && sfType == BOTTOM) {
            DfType dfType = BOTTOM;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(30);
            }
            return dfType;
        }
        HashSet<Object> notValues = this.myNotValues;
        if (type instanceof DfGenericObjectType) {
            Set otherNotValues = ((DfGenericObjectType)other).myNotValues;
            if (otherNotValues.containsAll(this.myNotValues)) {
                notValues = otherNotValues;
            } else if (!this.myNotValues.containsAll(otherNotValues)) {
                DfEphemeralReferenceType ephemeralValue;
                notValues = new HashSet<Object>(this.myNotValues);
                notValues.addAll(otherNotValues);
                if (nullability == DfaNullability.NOT_NULL && (ephemeralValue = DfGenericObjectType.checkEphemeral(constraint, notValues)) != null) {
                    DfEphemeralReferenceType dfEphemeralReferenceType = ephemeralValue;
                    if (dfEphemeralReferenceType == null) {
                        DfGenericObjectType.$$$reportNull$$$0(31);
                    }
                    return dfEphemeralReferenceType;
                }
            }
        }
        if (nullability == DfaNullability.NOT_NULL && constraint.isSingleton()) {
            return new DfReferenceConstantType(constraint, constraint, false);
        }
        return new DfGenericObjectType((Set<Object>)notValues, constraint, nullability, mutability, sf, sfType, locality);
    }

    public DfType widen() {
        DfType wideSpecialField = this.mySpecialFieldType.widen();
        if (!wideSpecialField.equals((Object)this.mySpecialFieldType)) {
            return new DfGenericObjectType(this.myNotValues, this.myConstraint, this.myNullability, this.myMutability, this.mySpecialField, wideSpecialField, this.myLocal);
        }
        return this;
    }

    private static DfEphemeralReferenceType checkEphemeral(TypeConstraint constraint, Set<Object> notValues) {
        if (notValues.isEmpty()) {
            return null;
        }
        Object value = notValues.iterator().next();
        if (!(value instanceof PsiEnumConstant)) {
            return null;
        }
        PsiClass enumClass = ((PsiEnumConstant)value).getContainingClass();
        if (enumClass == null) {
            return null;
        }
        TypeConstraint enumType = TypeConstraints.instanceOf((PsiType)JavaPsiFacade.getElementFactory((Project)enumClass.getProject()).createType(enumClass));
        if (!enumType.equals(constraint)) {
            return null;
        }
        Set allEnumConstants = StreamEx.of((Object[])enumClass.getFields()).select(PsiEnumConstant.class).toSet();
        if (notValues.size() != allEnumConstants.size()) {
            return null;
        }
        for (Object notValue : notValues) {
            if (!(notValue instanceof PsiEnumConstant)) {
                return null;
            }
            if (allEnumConstants.remove(notValue)) continue;
            return null;
        }
        if (allEnumConstants.isEmpty()) {
            return new DfEphemeralReferenceType(constraint);
        }
        return null;
    }

    @NotNull
    public DfType meetRelation(@NotNull RelationType relationType, @NotNull DfType other) {
        if (relationType == null) {
            DfGenericObjectType.$$$reportNull$$$0(32);
        }
        if (other == null) {
            DfGenericObjectType.$$$reportNull$$$0(33);
        }
        if ((relationType == RelationType.EQ || relationType == RelationType.IS) && this.isLocal() && this.myConstraint.isComparedByEquals()) {
            DfType dfType = this.dropLocality().meetRelation(relationType, other);
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(34);
            }
            return dfType;
        }
        DfType dfType = super.meetRelation(relationType, other);
        if (dfType == null) {
            DfGenericObjectType.$$$reportNull$$$0(35);
        }
        return dfType;
    }

    @NotNull
    public DfType fromRelation(@NotNull RelationType relationType) {
        DfType negated;
        if (relationType == null) {
            DfGenericObjectType.$$$reportNull$$$0(36);
        }
        if (relationType == RelationType.EQ || relationType == RelationType.IS) {
            DfReferenceType result = this;
            if (this.myConstraint.isComparedByEquals()) {
                result = result.dropLocality();
            }
            if (this.myNullability == DfaNullability.NULLABLE) {
                result = result.dropNullability();
            }
            DfReferenceType dfReferenceType = result;
            if (dfReferenceType == null) {
                DfGenericObjectType.$$$reportNull$$$0(37);
            }
            return dfReferenceType;
        }
        if (relationType == RelationType.IS_NOT && (negated = this.tryNegate()) != null) {
            DfType dfType = negated;
            if (dfType == null) {
                DfGenericObjectType.$$$reportNull$$$0(38);
            }
            return dfType;
        }
        DfReferenceType dfReferenceType = DfTypes.OBJECT_OR_NULL;
        if (dfReferenceType == null) {
            DfGenericObjectType.$$$reportNull$$$0(39);
        }
        return dfReferenceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DfGenericObjectType type = (DfGenericObjectType)o;
        return this.myLocal == type.myLocal && this.myNullability == type.myNullability && this.myMutability == type.myMutability && this.mySpecialField == type.mySpecialField && this.myConstraint.equals(type.myConstraint) && this.mySpecialFieldType.equals((Object)type.mySpecialFieldType) && this.myNotValues.equals(type.myNotValues);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 1;
            result = 31 * result + this.myConstraint.hashCode();
            result = 31 * result + this.myNullability.hashCode();
            result = 31 * result + this.myMutability.hashCode();
            result = 31 * result + (this.mySpecialField == null ? 0 : this.mySpecialField.hashCode());
            result = 31 * result + this.mySpecialFieldType.hashCode();
            result = 31 * result + Boolean.hashCode(this.myLocal);
            this.hashCode = result = 31 * result + this.myNotValues.hashCode();
        }
        return this.hashCode;
    }

    protected String renderValue(Object value) {
        return DfaPsiUtil.renderValue(value);
    }

    @Override
    @NotNull
    public String toString() {
        ArrayList<Object> components = new ArrayList<Object>();
        if (this.myConstraint != TypeConstraints.TOP) {
            components.add(this.myConstraint.toString());
        }
        if (this.myNullability != DfaNullability.UNKNOWN) {
            components.add(this.myNullability.toString());
        }
        if (this.myMutability != Mutability.UNKNOWN) {
            components.add(this.myMutability.name());
        }
        if (this.myLocal) {
            components.add(JavaBundle.message((String)"type.information.local.object", (Object[])new Object[0]));
        }
        if (this.mySpecialField != null) {
            components.add(String.valueOf((Object)this.mySpecialField) + "=" + String.valueOf(this.mySpecialFieldType));
        }
        if (!this.myNotValues.isEmpty()) {
            components.add(super.toString());
        }
        String string = String.join((CharSequence)" ", components);
        if (string == null) {
            DfGenericObjectType.$$$reportNull$$$0(40);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 35, 37, 38, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mutability";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/types/DfGenericObjectType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relationType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/types/DfGenericObjectType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialFieldType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "dropLocality";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "meet";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "meetRelation";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "fromRelation";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isMergeable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryJoinExactly";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "meet";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "meetRelation";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fromRelation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11, 16, 17, 18, 19, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 35, 37, 38, 39, 40 -> new IllegalStateException(string);
        };
    }
}

