/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.types;

import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.Mutability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DerivedVariableDescriptor;
import com.intellij.openapi.util.NlsSafe;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DfReferenceType
extends DfType {
    @NotNull
    public DfaNullability getNullability();

    @NotNull
    public TypeConstraint getConstraint();

    @NotNull
    default public Mutability getMutability() {
        Mutability mutability = Mutability.UNKNOWN;
        if (mutability == null) {
            DfReferenceType.$$$reportNull$$$0(0);
        }
        return mutability;
    }

    @Nullable
    default public SpecialField getSpecialField() {
        return null;
    }

    @NotNull
    default public DfType getSpecialFieldType() {
        DfType dfType = BOTTOM;
        if (dfType == null) {
            DfReferenceType.$$$reportNull$$$0(1);
        }
        return dfType;
    }

    @NotNull
    default public DfReferenceType dropTypeConstraint() {
        DfReferenceType dfReferenceType = this;
        if (dfReferenceType == null) {
            DfReferenceType.$$$reportNull$$$0(2);
        }
        return dfReferenceType;
    }

    @NotNull
    default public DfReferenceType dropLocality() {
        DfReferenceType dfReferenceType = this;
        if (dfReferenceType == null) {
            DfReferenceType.$$$reportNull$$$0(3);
        }
        return dfReferenceType;
    }

    @NotNull
    public DfReferenceType dropNullability();

    @NotNull
    default public DfReferenceType dropMutability() {
        DfReferenceType dfReferenceType = this;
        if (dfReferenceType == null) {
            DfReferenceType.$$$reportNull$$$0(4);
        }
        return dfReferenceType;
    }

    @NotNull
    default public DfReferenceType dropSpecialField() {
        DfReferenceType dfReferenceType = this;
        if (dfReferenceType == null) {
            DfReferenceType.$$$reportNull$$$0(5);
        }
        return dfReferenceType;
    }

    default public DfType correctTypeOnFlush(DfType typeBeforeFlush) {
        DfaNullability nullability;
        DfaNullability inherentNullability = this.getNullability();
        if (inherentNullability == DfaNullability.NULLABLE && ((nullability = DfaNullability.fromDfType(typeBeforeFlush)) == DfaNullability.FLUSHED || nullability == DfaNullability.NULL || nullability == DfaNullability.NOT_NULL)) {
            return this.dropNullability().meet(DfaNullability.FLUSHED.asDfType());
        }
        return this;
    }

    default public DfType correctForClosure() {
        DfReferenceType newType = this.dropLocality();
        if (newType.getMutability() == Mutability.MUST_NOT_MODIFY) {
            newType = newType.dropMutability();
        }
        return newType;
    }

    @NotNull
    default public DfType getBasicType() {
        DfReferenceType dfReferenceType = this.dropSpecialField();
        if (dfReferenceType == null) {
            DfReferenceType.$$$reportNull$$$0(6);
        }
        return dfReferenceType;
    }

    @NotNull
    default public @NotNull List<@NotNull DerivedVariableDescriptor> getDerivedVariables() {
        SpecialField field = SpecialField.fromQualifierType(this);
        if (field != null) {
            List<DerivedVariableDescriptor> list = List.of(field);
            if (list == null) {
                DfReferenceType.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<DerivedVariableDescriptor> list = List.of();
        if (list == null) {
            DfReferenceType.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    default public @NotNull Map<@NotNull DerivedVariableDescriptor, @NotNull DfType> getDerivedValues() {
        SpecialField field = this.getSpecialField();
        Map<Object, DfType> map = field == null ? Map.of() : Map.of(field, this.getSpecialFieldType());
        if (map == null) {
            DfReferenceType.$$$reportNull$$$0(9);
        }
        return map;
    }

    default public boolean mayAlias(DfType otherType) {
        if (this.isLocal() || otherType.isLocal()) {
            return false;
        }
        if (otherType.meet((DfType)this) != BOTTOM) {
            return true;
        }
        return SpecialField.COLLECTION_SIZE.isMyQualifierType(otherType) && SpecialField.COLLECTION_SIZE.isMyQualifierType(this);
    }

    default public boolean isImmutableQualifier() {
        return this.getMutability() == Mutability.UNMODIFIABLE;
    }

    @NotNull
    public DfReferenceType convert(@NotNull TypeConstraints.TypeConstraintFactory var1);

    @NlsSafe
    @NotNull
    public String toString();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/dataFlow/types/DfReferenceType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutability";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecialFieldType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTypeConstraint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dropLocality";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dropMutability";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dropSpecialField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasicType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedVariables";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedValues";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

