/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deprecation.ReplaceFieldReferenceFix;
import com.intellij.codeInspection.deprecation.ReplaceMethodCallFix;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaDeprecationUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeprecationInspectionBase
extends LocalInspectionTool {
    public boolean IGNORE_IN_SAME_OUTERMOST_CLASS = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    public static void checkDeprecated(@NotNull PsiModifierListOwner element, @NotNull PsiElement elementToHighlight, @Nullable TextRange rangeInElement, boolean ignoreInsideDeprecated, boolean ignoreImportStatements, boolean ignoreMethodsOfDeprecated, boolean ignoreInSameOutermostClass, @NotNull ProblemsHolder holder, boolean forRemoval) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(0);
        }
        if (elementToHighlight == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(2);
        }
        if (JavaDeprecationUtils.isDeprecated((PsiElement)element, elementToHighlight)) {
            if (forRemoval != DeprecationInspectionBase.isForRemovalAttributeSet(element)) {
                return;
            }
        } else {
            if (!ignoreMethodsOfDeprecated) {
                PsiClass containingClass;
                PsiClass psiClass = containingClass = element instanceof PsiMember ? ((PsiMember)element).getContainingClass() : null;
                if (containingClass != null) {
                    DeprecationInspectionBase.checkDeprecated((PsiModifierListOwner)containingClass, elementToHighlight, rangeInElement, ignoreInsideDeprecated, ignoreImportStatements, false, ignoreInSameOutermostClass, holder, forRemoval);
                }
            }
            return;
        }
        if (ignoreInSameOutermostClass && DeprecationInspectionBase.areElementsInSameOutermostClass((PsiElement)element, elementToHighlight)) {
            return;
        }
        if (ignoreInsideDeprecated && DeprecationInspectionBase.isElementInsideDeprecated(elementToHighlight)) {
            return;
        }
        if (ignoreImportStatements && DeprecationInspectionBase.isElementInsideImportStatement(elementToHighlight)) {
            return;
        }
        String sinceString = DeprecationInspectionBase.getSinceString(element);
        String description = sinceString == null || sinceString.isBlank() ? JavaErrorBundle.message(forRemoval ? "marked.for.removal.symbol" : "deprecated.symbol", DeprecationInspectionBase.getPresentableName((PsiElement)element)) : JavaErrorBundle.message(forRemoval ? "marked.for.removal.symbol.since" : "deprecated.since.symbol", DeprecationInspectionBase.getPresentableName((PsiElement)element), sinceString);
        LocalQuickFix replacementQuickFix = DeprecationInspectionBase.getReplacementQuickFix(element, elementToHighlight);
        holder.registerProblem(elementToHighlight, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInElement, LocalQuickFix.notNullElements((LocalQuickFix)replacementQuickFix));
    }

    private static boolean isElementInsideImportStatement(@NotNull PsiElement elementToHighlight) {
        if (elementToHighlight == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(3);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)elementToHighlight, PsiImportStatement.class) != null;
    }

    public static boolean isElementInsideDeprecated(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(4);
        }
        PsiElement parent = element;
        while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiModifierListOwner.class, (boolean)true)) != null) {
            if (!PsiImplUtil.isDeprecated((PsiElement)parent)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static LocalQuickFix getReplacementQuickFix(@NotNull PsiModifierListOwner deprecatedElement, @NotNull PsiElement elementToHighlight) {
        if (deprecatedElement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(5);
        }
        if (elementToHighlight == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(6);
        }
        PsiMethodCallExpression methodCall = DeprecationInspectionBase.getMethodCall(elementToHighlight);
        if (deprecatedElement instanceof PsiMethod) {
            PsiMethod replacement;
            PsiMethod method = (PsiMethod)deprecatedElement;
            if (methodCall != null && (replacement = DeprecationInspectionBase.findReplacementInJavaDoc(method, methodCall)) != null) {
                ReplaceMethodCallFix action = new ReplaceMethodCallFix((PsiMethodCallExpression)elementToHighlight.getParent().getParent(), replacement);
                return LocalQuickFix.from((ModCommandAction)action);
            }
        }
        if (deprecatedElement instanceof PsiField) {
            PsiMember replacement;
            PsiField field = (PsiField)deprecatedElement;
            PsiReferenceExpression referenceExpression = DeprecationInspectionBase.getFieldReferenceExpression(elementToHighlight);
            if (referenceExpression != null && (replacement = DeprecationInspectionBase.findReplacementInJavaDoc(field, referenceExpression)) != null) {
                ReplaceFieldReferenceFix action = new ReplaceFieldReferenceFix(referenceExpression, replacement);
                return LocalQuickFix.from((ModCommandAction)action);
            }
        }
        return null;
    }

    public static String getPresentableName(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(7);
        }
        if (psiElement instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)psiElement)) {
            return ((PsiMethod)psiElement).getName();
        }
        return HighlightMessageUtil.getSymbolName((PsiElement)psiElement);
    }

    private static String getSinceString(@NotNull PsiModifierListOwner element) {
        PsiExpression expression;
        Object object;
        PsiAnnotationMemberValue value;
        PsiAnnotation annotation;
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(8);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (String[])new String[]{"java.lang.Deprecated"})) != null && (value = annotation.findAttributeValue("since")) instanceof PsiExpression && (object = ExpressionUtils.computeConstantExpression(expression = (PsiExpression)value)) instanceof String) {
            String since = (String)object;
            return since;
        }
        return null;
    }

    protected static boolean isForRemovalAttributeSet(@NotNull PsiModifierListOwner element) {
        PsiAnnotation annotation;
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(9);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)element, (String[])new String[]{"java.lang.Deprecated"})) != null) {
            return DeprecationInspectionBase.isForRemovalAttributeSet(annotation);
        }
        return false;
    }

    protected static boolean isForRemovalAttributeSet(@NotNull PsiAnnotation deprecatedAnnotation) {
        if (deprecatedAnnotation == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(10);
        }
        return Boolean.TRUE == AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)deprecatedAnnotation, (String)"forRemoval");
    }

    private static boolean areElementsInSameOutermostClass(PsiElement refElement, PsiElement elementToHighlight) {
        PsiClass outermostClass = (PsiClass)CachedValuesManager.getCachedValue((PsiElement)refElement, () -> new CachedValueProvider.Result((Object)PsiUtil.getTopLevelClass((PsiElement)refElement), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        return outermostClass != null && outermostClass == PsiUtil.getTopLevelClass((PsiElement)elementToHighlight);
    }

    static OptCheckbox getSameOutermostClassCheckBox() {
        return OptPane.checkbox((String)"IGNORE_IN_SAME_OUTERMOST_CLASS", (String)JavaAnalysisBundle.message((String)"ignore.in.the.same.outermost.class", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]);
    }

    private static PsiMember findReplacementInJavaDoc(@NotNull PsiField field, @NotNull PsiReferenceExpression referenceExpression) {
        if (field == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(11);
        }
        if (referenceExpression == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(12);
        }
        PsiClass qualifierClass = RefactoringChangeUtil.getQualifierClass((PsiReferenceExpression)referenceExpression);
        return ((Optional)((StreamEx)((StreamEx)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc((PsiDocCommentOwner)field, PsiField.class, (PsiElement)field, qualifierClass).filter(tagField -> DeprecationInspectionBase.areReplaceable(tagField, referenceExpression))).select(PsiMember.class).append((Stream)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc((PsiDocCommentOwner)field, PsiMethod.class, (PsiElement)field, qualifierClass).filter(tagMethod -> DeprecationInspectionBase.areReplaceable(tagMethod, referenceExpression)))).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    private static PsiMethod findReplacementInJavaDoc(@NotNull PsiMethod method, @NotNull PsiMethodCallExpression call) {
        if (method == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(13);
        }
        if (call == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(14);
        }
        if (method instanceof PsiConstructorCall) {
            return null;
        }
        if (method instanceof ClsMethodImpl) {
            PsiMethod sourceMethod = ((ClsMethodImpl)method).getSourceMirrorMethod();
            return sourceMethod == null ? null : DeprecationInspectionBase.findReplacementInJavaDoc(sourceMethod, call);
        }
        return ((Optional)((StreamEx)DeprecationInspectionBase.getReplacementCandidatesFromJavadoc((PsiDocCommentOwner)method, PsiMethod.class, (PsiElement)call, RefactoringChangeUtil.getQualifierClass((PsiReferenceExpression)call.getMethodExpression())).filter(tagMethod -> DeprecationInspectionBase.areReplaceable(method, tagMethod, call))).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    @NotNull
    private static <T extends PsiDocCommentOwner> StreamEx<? extends T> getReplacementCandidatesFromJavadoc(PsiDocCommentOwner member, Class<T> clazz, PsiElement context, PsiClass qualifierClass) {
        PsiDocComment doc = member.getDocComment();
        if (doc == null) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                DeprecationInspectionBase.$$$reportNull$$$0(15);
            }
            return streamEx;
        }
        Collection docTags = PsiTreeUtil.findChildrenOfType((PsiElement)doc, PsiDocTag.class);
        if (docTags.isEmpty()) {
            StreamEx streamEx = StreamEx.empty();
            if (streamEx == null) {
                DeprecationInspectionBase.$$$reportNull$$$0(16);
            }
            return streamEx;
        }
        StreamEx streamEx = (StreamEx)((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)docTags).filter(t -> {
            String name = t.getName();
            return "link".equals(name) || "see".equals(name);
        })).map(tag -> tag.getValueElement()).nonNull().map(value -> value.getReference()).nonNull().map(reference -> reference.resolve()).select(clazz).distinct()).filter(tagMethod -> !tagMethod.isDeprecated())).filter(tagMethod -> PsiResolveHelper.getInstance((Project)context.getProject()).isAccessible((PsiMember)tagMethod, context, qualifierClass))).filter(tagMethod -> !member.getManager().areElementsEquivalent((PsiElement)tagMethod, (PsiElement)member));
        if (streamEx == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(17);
        }
        return streamEx;
    }

    private static boolean areReplaceable(PsiField suggested, PsiReferenceExpression expression) {
        if (ExpressionUtils.isVoidContext((PsiExpression)expression)) {
            return true;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, true);
        if (expectedType == null) {
            return true;
        }
        PsiType suggestedType = suggested.getType();
        return TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)suggestedType);
    }

    private static boolean areReplaceable(PsiMethod suggested, PsiReferenceExpression expression) {
        if (!suggested.getParameterList().isEmpty()) {
            return false;
        }
        if (ExpressionUtils.isVoidContext((PsiExpression)expression)) {
            return true;
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, true);
        if (expectedType == null) {
            return true;
        }
        PsiType suggestedType = suggested.getReturnType();
        return suggestedType != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)suggestedType);
    }

    private static boolean areReplaceable(@NotNull PsiMethod initial, @NotNull PsiMethod suggestedReplacement, @NotNull PsiMethodCallExpression call) {
        MethodCandidateInfo result;
        Object qualifierText;
        boolean isInitialStatic;
        if (initial == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(18);
        }
        if (suggestedReplacement == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(19);
        }
        if (call == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(20);
        }
        if (isInitialStatic = initial.hasModifierProperty("static")) {
            qualifierText = Objects.requireNonNull(suggestedReplacement.getContainingClass()).getQualifiedName() + ".";
        } else {
            PsiExpression qualifierExpression = call.getMethodExpression().getQualifierExpression();
            qualifierText = qualifierExpression == null ? "" : qualifierExpression.getText() + ".";
            PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
            if (qualifier == null) {
                return false;
            }
            PsiClass qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifier.getType());
            if (qualifierClass == null) {
                return false;
            }
            PsiClass suggestedClass = suggestedReplacement.getContainingClass();
            if (suggestedClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)qualifierClass, (PsiClass)suggestedClass, (boolean)true)) {
                return false;
            }
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)initial.getProject());
        PsiExpressionList arguments = call.getArgumentList();
        PsiMethodCallExpression suggestedCall = (PsiMethodCallExpression)elementFactory.createExpressionFromText((String)qualifierText + suggestedReplacement.getName() + arguments.getText(), (PsiElement)call);
        PsiType type = ExpectedTypeUtils.findExpectedType((PsiExpression)call, true);
        if (type != null && !type.equals(PsiTypes.voidType())) {
            PsiType suggestedCallType = suggestedCall.getType();
            if (!ExpressionUtils.isVoidContext((PsiExpression)call) && suggestedCallType != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)suggestedCallType)) {
                return false;
            }
        }
        return (result = (MethodCandidateInfo)ObjectUtils.tryCast((Object)suggestedCall.resolveMethodGenerics(), MethodCandidateInfo.class)) != null && result.isApplicable();
    }

    @Nullable
    private static PsiReferenceExpression getFieldReferenceExpression(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(21);
        }
        if (element instanceof PsiReferenceExpression) {
            return (PsiReferenceExpression)element;
        }
        return (PsiReferenceExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiReferenceExpression.class);
    }

    @Nullable
    private static PsiMethodCallExpression getMethodCall(@NotNull PsiElement element) {
        if (element == null) {
            DeprecationInspectionBase.$$$reportNull$$$0(22);
        }
        if (element instanceof PsiReferenceExpression) {
            return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiMethodCallExpression.class);
        }
        if (element instanceof PsiIdentifier) {
            return DeprecationInspectionBase.getMethodCall(element.getParent());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedAnnotation";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/deprecation/DeprecationInspectionBase";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedReplacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/deprecation/DeprecationInspectionBase";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementCandidatesFromJavadoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkDeprecated";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isElementInsideImportStatement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isElementInsideDeprecated";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementQuickFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSinceString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isForRemovalAttributeSet";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findReplacementInJavaDoc";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "areReplaceable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFieldReferenceExpression";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMethodCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

