/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.deprecation;

import com.intellij.codeInspection.deprecation.DeprecationInspectionQuickFixesKt;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.siyeh.InspectionGadgetsBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J!\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0094\u0002R!\u0010\b\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u00050\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014 \n*\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e0\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInspection/deprecation/ReplaceFieldReferenceFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiReferenceExpression;", "expr", "replacementMember", "Lcom/intellij/psi/PsiMember;", "<init>", "(Lcom/intellij/psi/PsiReferenceExpression;Lcom/intellij/psi/PsiMember;)V", "myReplacementMemberPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myReplacementText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getFamilyName", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.java.analysis.impl"})
public final class ReplaceFieldReferenceFix
extends PsiUpdateModCommandAction<PsiReferenceExpression> {
    @NotNull
    private final SmartPsiElementPointer<PsiMember> myReplacementMemberPointer;
    private final String myReplacementText;

    public ReplaceFieldReferenceFix(@NotNull PsiReferenceExpression expr, @NotNull PsiMember replacementMember) {
        String string;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)replacementMember, (String)"replacementMember");
        super((PsiElement)expr);
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)replacementMember.getProject()).createSmartPsiElementPointer((PsiElement)replacementMember);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createSmartPsiElementPointer(...)");
        this.myReplacementMemberPointer = smartPsiElementPointer;
        PsiMember psiMember = replacementMember;
        if (psiMember instanceof PsiField) {
            string = PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)replacementMember), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        } else if (psiMember instanceof PsiMethod) {
            string = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)replacementMember), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)0);
        } else {
            throw new IllegalArgumentException();
        }
        this.myReplacementText = string;
    }

    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("replace.field.reference.fix.family.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiReferenceExpression element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{this.myReplacementText};
        Presentation presentation = Presentation.of((String)InspectionGadgetsBundle.message("replace.field.reference.fix.text", objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiReferenceExpression expr, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PsiMember psiMember = (PsiMember)this.myReplacementMemberPointer.getElement();
        if (psiMember == null) {
            return;
        }
        PsiMember replacementMember = psiMember;
        String qualifierText = DeprecationInspectionQuickFixesKt.access$generateQualifierText(expr, replacementMember);
        Project project = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        Project project2 = project;
        PsiElement replaced = expr.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(qualifierText + replacementMember.getName() + (replacementMember instanceof PsiMethod ? "()" : ""), (PsiElement)expr));
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(replaced);
    }
}

