/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.equalsAndHashcode;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EqualsAndHashcodeBase
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        Project project;
        Pair pair;
        if (holder == null) {
            EqualsAndHashcodeBase.$$$reportNull$$$0(0);
        }
        if ((pair = (Pair)CachedValuesManager.getManager((Project)(project = holder.getProject())).getCachedValue((UserDataHolder)project, () -> {
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiClass psiObjectClass = (PsiClass)ReadAction.compute(() -> psiFacade.findClass("java.lang.Object", GlobalSearchScope.allScope((Project)project)));
            if (psiObjectClass == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
            }
            PsiMethod[] methods = psiObjectClass.getMethods();
            PsiMethod myEquals = null;
            PsiMethod myHashCode = null;
            for (PsiMethod method : methods) {
                @NonNls String name = method.getName();
                if ("equals".equals(name)) {
                    myEquals = method;
                    continue;
                }
                if (!"hashCode".equals(name)) continue;
                myHashCode = method;
            }
            return CachedValueProvider.Result.create((Object)Pair.create(myEquals, myHashCode), (Object[])new Object[]{psiObjectClass});
        })) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                EqualsAndHashcodeBase.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final PsiMethod myEquals = (PsiMethod)pair.first;
        final PsiMethod myHashCode = (PsiMethod)pair.second;
        if (myEquals == null || myHashCode == null || !myEquals.isValid() || !myHashCode.isValid()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                EqualsAndHashcodeBase.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitClass(aClass);
                boolean[] hasEquals = new boolean[]{false};
                boolean[] hasHashCode = new boolean[]{false};
                EqualsAndHashcodeBase.processClass(aClass, hasEquals, hasHashCode, myEquals, myHashCode);
                if (hasEquals[0] != hasHashCode[0]) {
                    if (hasHashCode[0] && aClass.isRecord()) {
                        return;
                    }
                    PsiIdentifier identifier = aClass.getNameIdentifier();
                    holder.registerProblem((PsiElement)(identifier != null ? identifier : aClass), hasEquals[0] ? JavaAnalysisBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{"<code>equals()</code>", "<code>hashCode()</code>"}) : JavaAnalysisBundle.message((String)"inspection.equals.hashcode.only.one.defined.problem.descriptor", (Object[])new Object[]{"<code>hashCode()</code>", "<code>equals()</code>"}), EqualsAndHashcodeBase.this.buildFixes(isOnTheFly, hasEquals[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase$1", "visitClass"));
            }
        };
    }

    private static void processClass(PsiClass aClass, boolean[] hasEquals, boolean[] hasHashCode, PsiMethod equals, PsiMethod hashcode) {
        PsiMethod[] methods;
        for (PsiMethod method : methods = aClass.getMethods()) {
            if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)equals) && !method.hasModifierProperty("abstract")) {
                hasEquals[0] = true;
                continue;
            }
            if (!MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)hashcode) || method.hasModifierProperty("abstract")) continue;
            hasHashCode[0] = true;
        }
    }

    @NotNull
    public String getGroupDisplayName() {
        return "";
    }

    @NotNull
    public String getShortName() {
        return "EqualsAndHashcode";
    }

    protected LocalQuickFix[] buildFixes(boolean isOnTheFly, boolean hasEquals) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/equalsAndHashcode/EqualsAndHashcodeBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

