/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionContainer;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.OptionControllerProvider;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.java.JavaBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EntryPointsManager")
public abstract class EntryPointsManagerBase
extends EntryPointsManager
implements PersistentStateComponent<Element>,
OptionContainer {
    @ApiStatus.Internal
    public static final ExtensionPointName<EntryPoint> DEAD_CODE_EP_NAME = new ExtensionPointName("com.intellij.deadCode");
    @NonNls
    private static final String[] STANDARD_ANNOS = new String[]{"javax.ws.rs.*"};
    private volatile List<String> ADDITIONAL_ANNOS;
    public JDOMExternalizableStringList ADDITIONAL_ANNOTATIONS;
    protected List<String> myWriteAnnotations;
    private final Map<String, SmartRefElementPointer> myPersistentEntryPoints;
    private final Set<ClassPattern> myPatterns;
    private final Set<RefElement> myTemporaryEntryPoints;
    private static final String VERSION = "2.0";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String ENTRY_POINT_ATTR = "entry_point";
    private boolean myAddNonJavaEntries;
    private boolean myResolved;
    protected final Project myProject;
    private long myLastModificationCount;

    @NotNull
    public Collection<String> getAdditionalAnnotations() {
        List<String> annos = this.ADDITIONAL_ANNOS;
        if (annos == null) {
            annos = new ArrayList<String>();
            Collections.addAll(annos, STANDARD_ANNOS);
            for (EntryPoint extension : DEAD_CODE_EP_NAME.getExtensionList()) {
                Object[] ignoredAnnotations = extension.getIgnoreAnnotations();
                if (ignoredAnnotations == null) continue;
                ContainerUtil.addAll(annos, (Object[])ignoredAnnotations);
            }
            this.ADDITIONAL_ANNOS = annos = Collections.unmodifiableList(annos);
        }
        List<String> list = annos;
        if (list == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(0);
        }
        return list;
    }

    public EntryPointsManagerBase(@NotNull Project project) {
        if (project == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(1);
        }
        this.ADDITIONAL_ANNOTATIONS = new JDOMExternalizableStringList();
        this.myWriteAnnotations = new ArrayList<String>();
        this.myPersistentEntryPoints = new LinkedHashMap<String, SmartRefElementPointer>();
        this.myPatterns = new LinkedHashSet<ClassPattern>();
        this.myTemporaryEntryPoints = Collections.synchronizedSet(new HashSet());
        this.myAddNonJavaEntries = true;
        this.myLastModificationCount = -1L;
        this.myProject = project;
        DEAD_CODE_EP_NAME.addChangeListener(() -> {
            if (this.ADDITIONAL_ANNOS != null) {
                this.ADDITIONAL_ANNOS = null;
            }
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart((Object)"EntryPointsManagerBase.DEAD_CODE_EP_NAME changed");
        }, (Disposable)this);
    }

    public static EntryPointsManagerBase getInstance(Project project) {
        return (EntryPointsManagerBase)EntryPointsManager.getInstance((Project)project);
    }

    public void loadState(@NotNull Element element) {
        Element entryPointsElement;
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(2);
        }
        if ((entryPointsElement = element.getChild("entry_points")) != null) {
            String version = entryPointsElement.getAttributeValue(VERSION_ATTR);
            if (!Comparing.strEqual((String)version, (String)VERSION)) {
                EntryPointsManagerBase.convert(entryPointsElement, this.myPersistentEntryPoints);
            } else {
                List content = entryPointsElement.getChildren();
                for (Element entryElement : content) {
                    if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
                    SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(entryElement);
                    this.myPersistentEntryPoints.put(entryPoint.getFQName(), (SmartRefElementPointer)entryPoint);
                }
            }
        }
        try {
            this.ADDITIONAL_ANNOTATIONS.readExternal(element);
        }
        catch (Throwable version) {
            // empty catch block
        }
        this.getPatterns().clear();
        for (Element pattern : element.getChildren("pattern")) {
            ClassPattern classPattern = new ClassPattern();
            XmlSerializer.deserializeInto((Element)pattern, (Object)classPattern);
            this.getPatterns().add(classPattern);
        }
        this.myWriteAnnotations.clear();
        Element writeAnnotations = element.getChild("writeAnnotations");
        if (writeAnnotations != null) {
            for (Element annoElement : writeAnnotations.getChildren("writeAnnotation")) {
                String value = annoElement.getAttributeValue("name");
                if (value == null) continue;
                this.myWriteAnnotations.add(value);
            }
        }
    }

    public Element getState() {
        Element element = new Element("state");
        EntryPointsManagerBase.writeExternal(element, this.myPersistentEntryPoints, this.ADDITIONAL_ANNOTATIONS);
        if (!this.getPatterns().isEmpty()) {
            for (ClassPattern pattern : this.getPatterns()) {
                element.addContent(XmlSerializer.serialize((Object)pattern));
            }
        }
        if (!this.myWriteAnnotations.isEmpty()) {
            Element writeAnnotations = new Element("writeAnnotations");
            for (String writeAnnotation : this.myWriteAnnotations) {
                writeAnnotations.addContent(new Element("writeAnnotation").setAttribute("name", writeAnnotation));
            }
            element.addContent(writeAnnotations);
        }
        return element;
    }

    public static void writeExternal(@NotNull Element element, @NotNull Map<String, SmartRefElementPointer> persistentEntryPoints, @NotNull JDOMExternalizableStringList additional_annotations) {
        Collection<SmartRefElementPointer> elementPointers;
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(3);
        }
        if (persistentEntryPoints == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(4);
        }
        if (additional_annotations == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(5);
        }
        if (!(elementPointers = persistentEntryPoints.values()).isEmpty()) {
            Element entryPointsElement = new Element("entry_points");
            entryPointsElement.setAttribute(VERSION_ATTR, VERSION);
            for (SmartRefElementPointer entryPoint : elementPointers) {
                assert (entryPoint.isPersistent());
                entryPoint.writeExternal(entryPointsElement);
            }
            element.addContent(entryPointsElement);
        }
        if (!additional_annotations.isEmpty()) {
            additional_annotations.writeExternal(element);
        }
    }

    public void resolveEntryPoints(@NotNull RefManager manager) {
        if (manager == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(6);
        }
        if (!this.myResolved) {
            this.myResolved = true;
            this.cleanup();
            this.validateEntryPoints();
            ReadAction.run(() -> {
                for (SmartRefElementPointer entryPoint : this.myPersistentEntryPoints.values()) {
                    if (!entryPoint.resolve(manager)) continue;
                    RefEntity refElement = entryPoint.getRefElement();
                    ((RefElementImpl)refElement).setEntry(true);
                    ((RefElementImpl)refElement).setPermanentEntry(entryPoint.isPersistent());
                }
                this.getPatternEntryPoints(manager).forEach(entity -> {
                    entity.setEntry(true);
                    entity.setPermanentEntry(true);
                });
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeTemporaryEntryPoints() {
        Set<RefElement> set = this.myTemporaryEntryPoints;
        synchronized (set) {
            for (RefElement entryPoint : this.myTemporaryEntryPoints) {
                ((RefElementImpl)entryPoint).setEntry(false);
            }
        }
        this.myTemporaryEntryPoints.clear();
    }

    @NotNull
    private List<RefElementImpl> getPatternEntryPoints(@NotNull RefManager manager) {
        if (manager == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(7);
        }
        ArrayList<RefElementImpl> entries = new ArrayList<RefElementImpl>();
        for (ClassPattern pattern : this.myPatterns) {
            RefEntity refClass = (RefEntity)ReadAction.compute(() -> manager.getReference("class", pattern.pattern));
            if (refClass == null) continue;
            if (pattern.method.isEmpty()) {
                for (RefMethod refMethod : ((RefClass)refClass).getConstructors()) {
                    entries.add((RefElementImpl)refMethod);
                }
                continue;
            }
            List children = refClass.getChildren();
            for (RefEntity entity : children) {
                if (!(entity instanceof RefMethodImpl) || !entity.getName().startsWith(pattern.method + "(")) continue;
                entries.add((RefElementImpl)entity);
            }
        }
        ArrayList<RefElementImpl> arrayList = entries;
        if (arrayList == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void addEntryPoint(@NotNull RefElement newEntryPoint, boolean isPersistent) {
        RefClass refClass;
        if (newEntryPoint == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(9);
        }
        if (!newEntryPoint.isValid()) {
            return;
        }
        if (isPersistent && (newEntryPoint instanceof RefClass || newEntryPoint instanceof RefMethod)) {
            RefClass refClass2 = refClass = newEntryPoint instanceof RefMethod ? ((RefMethod)newEntryPoint).getOwnerClass() : (RefClass)newEntryPoint;
            if (refClass != null && !refClass.isAnonymous()) {
                ClassPattern classPattern = new ClassPattern();
                classPattern.pattern = new SmartRefElementPointerImpl((RefEntity)refClass, true).getFQName();
                if (newEntryPoint instanceof RefMethod && !(newEntryPoint instanceof RefImplicitConstructor)) {
                    classPattern.method = EntryPointsManagerBase.getMethodName(newEntryPoint);
                }
                this.getPatterns().add(classPattern);
                EntryPointsManagerBase entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getRefManager().getProject());
                if (this != entryPointsManager) {
                    entryPointsManager.addEntryPoint(newEntryPoint, true);
                }
                return;
            }
        }
        if (newEntryPoint instanceof RefClass) {
            refClass = (RefClass)newEntryPoint;
            if (refClass.isAnonymous()) {
                return;
            }
            if (isPersistent) {
                for (RefMethod refConstructor : refClass.getConstructors()) {
                    this.addEntryPoint((RefElement)refConstructor, isPersistent);
                }
            }
        }
        if (!isPersistent) {
            this.myTemporaryEntryPoints.add(newEntryPoint);
            ((RefElementImpl)newEntryPoint).setEntry(true);
        } else if (this.myPersistentEntryPoints.get(newEntryPoint.getExternalName()) == null) {
            EntryPointsManagerBase entryPointsManager;
            SmartRefElementPointerImpl entry = new SmartRefElementPointerImpl((RefEntity)newEntryPoint, true);
            this.myPersistentEntryPoints.put(entry.getFQName(), (SmartRefElementPointer)entry);
            ((RefElementImpl)newEntryPoint).setEntry(true);
            ((RefElementImpl)newEntryPoint).setPermanentEntry(true);
            if (entry.isPersistent() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getRefManager().getProject()))) {
                entryPointsManager.addEntryPoint(newEntryPoint, true);
            }
        }
    }

    @NotNull
    private static String getMethodName(@NotNull RefElement newEntryPoint) {
        String methodSignature;
        int indexOf;
        if (newEntryPoint == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(10);
        }
        String string = (indexOf = (methodSignature = newEntryPoint.getName()).indexOf(40)) > 0 ? methodSignature.substring(0, indexOf) : methodSignature;
        if (string == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void removeEntryPoint(@NotNull RefElement anEntryPoint) {
        Project project;
        EntryPointsManagerBase entryPointsManager;
        if (anEntryPoint == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(12);
        }
        this.myTemporaryEntryPoints.remove(anEntryPoint);
        Set<Map.Entry<String, SmartRefElementPointer>> set = this.myPersistentEntryPoints.entrySet();
        String key = null;
        for (Map.Entry<String, SmartRefElementPointer> entry : set) {
            SmartRefElementPointer value = entry.getValue();
            if (value.getRefElement() != anEntryPoint) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.myPersistentEntryPoints.remove(key);
        }
        ((RefElementImpl)anEntryPoint).setEntry(false);
        if (anEntryPoint.isPermanentEntry() && anEntryPoint.isValid() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(project = anEntryPoint.getPsiElement().getProject()))) {
            entryPointsManager.removeEntryPoint(anEntryPoint);
        }
        if (anEntryPoint instanceof RefMethod || anEntryPoint instanceof RefClass) {
            RefClass aClass;
            RefClass refClass = aClass = anEntryPoint instanceof RefClass ? (RefClass)anEntryPoint : ((RefMethod)anEntryPoint).getOwnerClass();
            if (aClass != null) {
                String qualifiedName = aClass.getQualifiedName();
                Iterator<ClassPattern> iterator = this.getPatterns().iterator();
                while (iterator.hasNext()) {
                    ClassPattern classPattern = iterator.next();
                    if (!Objects.equals(classPattern.pattern, qualifiedName)) continue;
                    if (anEntryPoint instanceof RefMethod && ((RefMethod)anEntryPoint).isConstructor() || anEntryPoint instanceof RefClass) {
                        if (!classPattern.method.isEmpty()) continue;
                        iterator.remove();
                        continue;
                    }
                    String methodName = EntryPointsManagerBase.getMethodName(anEntryPoint);
                    if (!methodName.equals(classPattern.method)) continue;
                    iterator.remove();
                }
            }
        }
    }

    public RefElement @NotNull [] getEntryPoints(@NotNull RefManager refManager) {
        if (refManager == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(13);
        }
        this.validateEntryPoints();
        ArrayList<Object> entries = new ArrayList<Object>();
        Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer refElementPointer : collection) {
            RefEntity elt = refElementPointer.getRefElement();
            if (!(elt instanceof RefElement)) continue;
            entries.add((RefElement)elt);
        }
        entries.addAll(this.myTemporaryEntryPoints);
        entries.addAll(this.getPatternEntryPoints(refManager));
        RefElement[] refElementArray = entries.toArray(new RefElement[0]);
        if (refElementArray == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(14);
        }
        return refElementArray;
    }

    public void dispose() {
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateEntryPoints() {
        long count = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        if (count != this.myLastModificationCount) {
            SmartRefElementPointer[] entries;
            this.myLastModificationCount = count;
            Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
            for (SmartRefElementPointer entry : entries = collection.toArray(new SmartRefElementPointer[0])) {
                RefElement refElement2 = (RefElement)entry.getRefElement();
                if (refElement2 == null || refElement2.isValid()) continue;
                this.myPersistentEntryPoints.remove(entry.getFQName());
            }
            Set<RefElement> set = this.myTemporaryEntryPoints;
            synchronized (set) {
                this.myTemporaryEntryPoints.removeIf(refElement -> !refElement.isValid());
            }
        }
    }

    public void cleanup() {
        this.purgeTemporaryEntryPoints();
        Collection<SmartRefElementPointer> entries = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer entry : entries) {
            entry.freeReference();
        }
    }

    public boolean isAddNonJavaEntries() {
        return this.myAddNonJavaEntries;
    }

    public void addAllPersistentEntries(@NotNull EntryPointsManagerBase manager) {
        if (manager == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(15);
        }
        this.myPersistentEntryPoints.putAll(manager.myPersistentEntryPoints);
        this.myPatterns.addAll(manager.getPatterns());
    }

    @ApiStatus.Internal
    public static void convert(@NotNull Element element, @NotNull Map<? super String, ? super SmartRefElementPointer> persistentEntryPoints) {
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(16);
        }
        if (persistentEntryPoints == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(17);
        }
        List content = element.getChildren();
        for (Element entryElement : content) {
            if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
            Object fqName = entryElement.getAttributeValue("FQNAME");
            String type = entryElement.getAttributeValue("TYPE");
            if (Comparing.strEqual((String)type, (String)"method")) {
                int spaceIdx = ((String)fqName).indexOf(32);
                int lastDotIdx = ((String)fqName).lastIndexOf(46);
                int parenIndex = ((String)fqName).indexOf(40);
                while (lastDotIdx > parenIndex) {
                    lastDotIdx = ((String)fqName).lastIndexOf(46, lastDotIdx - 1);
                }
                boolean noType = spaceIdx < 0 || spaceIdx + 1 > lastDotIdx;
                String className = ((String)fqName).substring(noType ? 0 : spaceIdx + 1, lastDotIdx);
                String methodSignature = noType ? ((String)fqName).substring(lastDotIdx + 1) : ((String)fqName).substring(0, spaceIdx) + " " + ((String)fqName).substring(lastDotIdx + 1);
                fqName = className + " " + methodSignature;
            } else if (Comparing.strEqual((String)type, (String)"field")) {
                int lastDotIdx = ((String)fqName).lastIndexOf(46);
                if (lastDotIdx <= 0 || lastDotIdx >= ((String)fqName).length() - 2) continue;
                String className = ((String)fqName).substring(0, lastDotIdx);
                String fieldName = ((String)fqName).substring(lastDotIdx + 1);
                fqName = className + " " + fieldName;
            }
            SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(type, (String)fqName);
            persistentEntryPoints.put(entryPoint.getFQName(), (SmartRefElementPointer)entryPoint);
        }
    }

    public void setAddNonJavaEntries(boolean addNonJavaEntries) {
        this.myAddNonJavaEntries = addNonJavaEntries;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(18);
        }
        return element instanceof PsiField && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), this.myWriteAnnotations, (int)0);
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        String qualifiedName;
        PsiClass containingClass;
        String qualifiedName2;
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(19);
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)element;
        if (!this.ADDITIONAL_ANNOTATIONS.isEmpty() && this.ADDITIONAL_ANNOTATIONS.contains((Object)Deprecated.class.getName()) && element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return true;
        }
        if (element instanceof PsiClass && (qualifiedName2 = ((PsiClass)element).getQualifiedName()) != null) {
            for (ClassPattern pattern : this.getPatterns()) {
                if (!pattern.method.isEmpty() || !EntryPointsManagerBase.isAcceptedByPattern((PsiClass)element, qualifiedName2, pattern, new HashSet())) continue;
                return true;
            }
        }
        if (element instanceof PsiMethod && (containingClass = ((PsiMethod)element).getContainingClass()) != null && (qualifiedName = containingClass.getQualifiedName()) != null) {
            String name = ((PsiMethod)element).getName();
            for (ClassPattern pattern : this.getPatterns()) {
                if (pattern.method.isEmpty()) continue;
                boolean acceptedName = name.equals(pattern.method);
                if (!acceptedName) {
                    Pattern methodRegexp = pattern.getMethodRegexp();
                    boolean bl = acceptedName = methodRegexp != null && methodRegexp.matcher(name).matches();
                }
                if (!acceptedName || !EntryPointsManagerBase.isAcceptedByPattern(containingClass, qualifiedName, pattern, new HashSet())) continue;
                return true;
            }
        }
        Collection<String> defaultAdditionalAnnotations = this.getAdditionalAnnotations();
        return AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)owner, (Collection)this.ADDITIONAL_ANNOTATIONS) || AnnotationUtil.checkAnnotatedUsingPatterns((PsiModifierListOwner)owner, defaultAdditionalAnnotations) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)owner, (Collection)this.ADDITIONAL_ANNOTATIONS) || MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)owner, defaultAdditionalAnnotations);
    }

    private static boolean isAcceptedByPattern(@NotNull PsiClass element, @NotNull String qualifiedName, @NotNull ClassPattern pattern, @NotNull Set<? super PsiClass> visited) {
        if (element == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(20);
        }
        if (qualifiedName == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(21);
        }
        if (pattern == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(22);
        }
        if (visited == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(23);
        }
        if (qualifiedName.equals(pattern.pattern)) {
            return true;
        }
        Pattern regexp = pattern.getRegexp();
        if (regexp != null) {
            try {
                if (regexp.matcher(qualifiedName).matches()) {
                    return true;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (pattern.hierarchically) {
            for (PsiClass superClass : element.getSupers()) {
                String superClassQualifiedName = superClass.getQualifiedName();
                if (!visited.add((PsiClass)superClass) || superClassQualifiedName == null || !EntryPointsManagerBase.isAcceptedByPattern(superClass, superClassQualifiedName, pattern, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public List<String> getCustomAdditionalAnnotations() {
        List<String> list = List.copyOf(this.ADDITIONAL_ANNOTATIONS);
        if (list == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public List<String> getWriteAnnotations() {
        List<String> list = List.copyOf(this.myWriteAnnotations);
        if (list == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public Set<ClassPattern> getPatterns() {
        Set<ClassPattern> set = this.myPatterns;
        if (set == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(26);
        }
        return set;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"myWriteAnnotations", (String)JavaBundle.message((String)"separator.mark.field.as.implicitly.written.if.annotated.by", (Object[])new Object[0]), (StringValidator)new JavaClassValidator().annotationsOnly()), OptPane.stringList((String)"ADDITIONAL_ANNOTATIONS", (String)JavaBundle.message((String)"separator.mark.as.entry.point.if.annotated.by", (Object[])new Object[0]), (StringValidator)new JavaClassValidator().annotationsOnly())});
        if (optPane == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(27);
        }
        return optPane;
    }

    @NotNull
    public static ModCommandAction createAddImplicitWriteAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(28);
        }
        return new AddAnnotation(qualifiedName, "EntryPointsManager.myWriteAnnotations", QuickFixBundle.message("fix.add.write.annotation.text", qualifiedName));
    }

    @NotNull
    public static ModCommandAction createAddEntryPointAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            EntryPointsManagerBase.$$$reportNull$$$0(29);
        }
        return new AddAnnotation(qualifiedName, "EntryPointsManager.ADDITIONAL_ANNOTATIONS", QuickFixBundle.message("fix.unused.symbol.injection.text", qualifiedName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/EntryPointsManagerBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentEntryPoints";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional_annotations";
                break;
            }
            case 6: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntryPoint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anEntryPoint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 21: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternEntryPoints";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPoints";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomAdditionalAnnotations";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriteAnnotations";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveEntryPoints";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPatternEntryPoints";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addEntryPoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeEntryPoint";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getEntryPoints";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAllPersistentEntries";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByPattern";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createAddImplicitWriteAnnotation";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createAddEntryPointAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 12, 13, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28, 29 -> new IllegalArgumentException(string);
        };
    }

    @Tag(value="pattern")
    public static class ClassPattern {
        @Attribute(value="value")
        @NlsSafe
        public String pattern;
        @Attribute(value="hierarchically")
        public boolean hierarchically;
        @Attribute(value="method")
        public String method;
        private Pattern regexp;
        private Pattern methodRegexp;

        public ClassPattern(@NotNull ClassPattern classPattern) {
            if (classPattern == null) {
                ClassPattern.$$$reportNull$$$0(0);
            }
            this.pattern = "";
            this.method = "";
            this.hierarchically = classPattern.hierarchically;
            this.pattern = classPattern.pattern;
            this.method = classPattern.method;
        }

        public ClassPattern() {
            this.pattern = "";
            this.method = "";
        }

        @Nullable
        public Pattern getRegexp() {
            if (this.regexp == null && this.pattern.contains("*")) {
                this.regexp = ClassPattern.createRegexp(this.pattern);
            }
            return this.regexp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPattern pattern1 = (ClassPattern)o;
            if (this.hierarchically != pattern1.hierarchically) {
                return false;
            }
            if (!this.pattern.equals(pattern1.pattern)) {
                return false;
            }
            return this.method.equals(pattern1.method);
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 31 * result + (this.hierarchically ? 1 : 0);
            result = 31 * result + this.method.hashCode();
            return result;
        }

        Pattern getMethodRegexp() {
            if (this.methodRegexp == null && this.method.contains("*")) {
                this.methodRegexp = ClassPattern.createRegexp(this.method);
            }
            return this.methodRegexp;
        }

        private static Pattern createRegexp(@NotNull String pattern) {
            if (pattern == null) {
                ClassPattern.$$$reportNull$$$0(1);
            }
            String replace = pattern.replace(".", "\\.").replace("*", ".*");
            try {
                return Pattern.compile(replace);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$ClassPattern";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRegexp";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddAnnotation
    implements ModCommandAction {
        @NotNull
        private final String myQualifiedName;
        @NotNull
        private final String myBindId;
        @NotNull
        @IntentionName
        private final String myMessage;

        private AddAnnotation(@NotNull String qualifiedName, @NotNull String bindId, @NotNull @IntentionName String message) {
            if (qualifiedName == null) {
                AddAnnotation.$$$reportNull$$$0(0);
            }
            if (bindId == null) {
                AddAnnotation.$$$reportNull$$$0(1);
            }
            if (message == null) {
                AddAnnotation.$$$reportNull$$$0(2);
            }
            this.myQualifiedName = qualifiedName;
            this.myBindId = bindId;
            this.myMessage = message;
        }

        @NotNull
        public Presentation getPresentation(@NotNull ActionContext context) {
            if (context == null) {
                AddAnnotation.$$$reportNull$$$0(3);
            }
            Presentation presentation = Presentation.of((String)this.myMessage);
            if (presentation == null) {
                AddAnnotation.$$$reportNull$$$0(4);
            }
            return presentation;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("fix.unused.symbol.injection.family", new Object[0]);
            if (string == null) {
                AddAnnotation.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            if (context == null) {
                AddAnnotation.$$$reportNull$$$0(6);
            }
            ModCommand modCommand = ModCommand.updateOptionList((PsiElement)context.file(), (String)this.myBindId, list -> {
                list.add(this.myQualifiedName);
                list.sort(null);
            });
            if (modCommand == null) {
                AddAnnotation.$$$reportNull$$$0(7);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifiedName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bindId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$AddAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$AddAnnotation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class Provider
    implements OptionControllerProvider {
        @NotNull
        public OptionController forContext(@NotNull PsiElement context) {
            if (context == null) {
                Provider.$$$reportNull$$$0(0);
            }
            Project project = context.getProject();
            OptionController optionController = EntryPointsManagerBase.getInstance(project).getOptionController().onValueSet((bindId, value) -> ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged());
            if (optionController == null) {
                Provider.$$$reportNull$$$0(1);
            }
            return optionController;
        }

        @NotNull
        public String name() {
            return "EntryPointsManager";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$Provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/EntryPointsManagerBase$Provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forContext";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

