/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SuspiciousCollectionsMethodCallsInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean REPORT_CONVERTIBLE_METHOD_CALLS = true;

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"REPORT_CONVERTIBLE_METHOD_CALLS", (String)JavaAnalysisBundle.message((String)"report.suspicious.but.possibly.correct.method.calls", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(1);
        }
        final ArrayList patternMethods = new ArrayList();
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression methodCall) {
                PsiExpression[] args;
                if (methodCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((args = methodCall.getArgumentList().getExpressions()).length < 1) {
                    return;
                }
                for (int idx = 0; idx < Math.min(2, args.length); ++idx) {
                    String message = SuspiciousCollectionsMethodCallsInspection.getSuspiciousMethodCallMessage(methodCall, SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, args[idx], idx);
                    if (message == null) continue;
                    holder.registerProblem((PsiElement)methodCall.getArgumentList().getExpressions()[idx], message, new LocalQuickFix[0]);
                }
            }

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                PsiSubstitutor psiSubstitutor;
                MethodSignature signature;
                String message;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                PsiClassType.ClassResolveResult functionalInterfaceResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
                if (interfaceMethod != null && interfaceMethod.getParameterList().getParametersCount() == 1 && (message = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiReferenceExpression)expression, (signature = interfaceMethod.getSignature(psiSubstitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)functionalInterfaceResolveResult))).getParameterTypes()[0], SuspiciousCollectionsMethodCallsInspection.this.REPORT_CONVERTIBLE_METHOD_CALLS, patternMethods, 0)) != null) {
                    holder.registerProblem((PsiElement)ObjectUtils.notNull((Object)expression.getReferenceNameElement(), (Object)expression), message, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCall";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.probable.bugs", (Object[])new Object[0]);
        if (string == null) {
            SuspiciousCollectionsMethodCallsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "SuspiciousMethodCalls";
    }

    @InspectionMessage
    private static String getSuspiciousMethodCallMessage(PsiMethodCallExpression methodCall, boolean reportConvertibleMethodCalls, List<SuspiciousMethodCallUtil.PatternMethod> patternMethods, PsiExpression arg, int i) {
        boolean exactType;
        PsiType argType = arg.getType();
        String plainMessage = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, arg, argType, (exactType = arg instanceof PsiNewExpression) || reportConvertibleMethodCalls, patternMethods, i);
        if (plainMessage != null && !exactType) {
            String methodName = methodCall.getMethodExpression().getReferenceName();
            if (SuspiciousMethodCallUtil.isCollectionAcceptingMethod(methodName)) {
                return plainMessage;
            }
            TypeConstraint constraint = TypeConstraint.fromDfType(CommonDataflow.getDfType(arg));
            PsiType type = constraint.getPsiType(methodCall.getProject());
            if (type != null && SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodCall, arg, type, reportConvertibleMethodCalls, patternMethods, i) == null) {
                return null;
            }
        }
        return plainMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/miscGenerics/SuspiciousCollectionsMethodCallsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

