/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class RefFieldImpl
extends RefJavaElementImpl
implements RefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER_MASK = 262144;
    private static final int IMPLICITLY_READ_MASK = 524288;
    private static final int IMPLICITLY_WRITTEN_MASK = 0x100000;
    private static final int IS_ENUM_CONSTANT = 0x200000;

    RefFieldImpl(UField field, PsiElement psi, RefManager manager) {
        super((UDeclaration)field, psi, manager);
        if (field instanceof UEnumConstant) {
            this.setEnumConstant(true);
        }
    }

    protected synchronized void initialize() {
        PsiElement psi = this.getPsiElement();
        LOG.assertTrue(psi != null);
        UField uElement = this.getUastElement();
        LOG.assertTrue(uElement != null);
        WritableRefEntity parentRef = (WritableRefEntity)RefMethodImpl.findParentRef(psi, (UElement)uElement, this.myManager);
        if (parentRef == null) {
            return;
        }
        if (!this.myManager.isDeclarationsFound()) {
            parentRef.add((RefEntity)this);
        } else {
            this.setOwner(parentRef);
        }
    }

    @Deprecated
    public PsiField getElement() {
        return (PsiField)super.getPsiElement();
    }

    public UField getUastElement() {
        return (UField)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UField.class);
    }

    @Override
    protected void markReferenced(@NotNull RefElementImpl refFrom, boolean forWriting, boolean forReading, UExpression expressionFrom) {
        UClassInitializer initializer;
        if (refFrom == null) {
            RefFieldImpl.$$$reportNull$$$0(0);
        }
        this.addInReference((RefElement)refFrom);
        boolean referencedFromClassInitializer = false;
        if (forWriting && expressionFrom != null && (initializer = (UClassInitializer)UastUtils.getParentOfType((UElement)expressionFrom, UClassInitializer.class)) != null && refFrom.getPsiElement() == ((UClass)UastUtils.getParentOfType((UElement)initializer, UClass.class)).getSourcePsi()) {
            UExpression qualifierExpression;
            UExpression uExpression = qualifierExpression = expressionFrom instanceof UQualifiedReferenceExpression ? ((UQualifiedReferenceExpression)expressionFrom).getReceiver() : null;
            if (qualifierExpression == null || qualifierExpression instanceof UThisExpression) {
                referencedFromClassInitializer = true;
            }
        }
        if (forWriting) {
            this.setUsedForWriting(true);
        }
        if (forReading) {
            this.setUsedForReading(true);
        }
        this.setForbidProtectedAccess(refFrom, expressionFrom);
        this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)refFrom, referencedFromClassInitializer, forReading, forWriting, expressionFrom == null ? null : expressionFrom.getSourcePsi());
    }

    public synchronized boolean isUsedForReading() {
        if (this.checkFlag(65536L)) {
            return true;
        }
        RefClass ownerClass = this.getOwnerClass();
        return ownerClass != null && ownerClass.isRecord();
    }

    private void setUsedForReading(boolean usedForReading) {
        this.setFlag(usedForReading, 65536L);
    }

    public synchronized boolean isUsedForWriting() {
        if (this.checkFlag(131072L)) {
            return true;
        }
        RefClass ownerClass = this.getOwnerClass();
        return ownerClass != null && ownerClass.isRecord();
    }

    private synchronized void setUsedForWriting(boolean usedForWriting) {
        this.setFlag(false, 262144L);
        this.setFlag(usedForWriting, 131072L);
    }

    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144L);
    }

    private void setEnumConstant(boolean enumConstant) {
        this.setFlag(enumConstant, 0x200000L);
    }

    public boolean isEnumConstant() {
        return this.checkFlag(0x200000L);
    }

    private void setImplicitlyRead(boolean implicitlyRead) {
        this.setFlag(implicitlyRead, 524288L);
    }

    public boolean isImplicitlyRead() {
        return this.checkFlag(524288L);
    }

    private void setImplicitlyWritten(boolean implicitlyWritten) {
        this.setFlag(implicitlyWritten, 0x100000L);
    }

    public boolean isImplicitlyWritten() {
        return this.checkFlag(0x100000L);
    }

    public void accept(@NotNull RefVisitor visitor2) {
        if (visitor2 == null) {
            RefFieldImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof RefJavaVisitor) {
            RefJavaVisitor javaVisitor = (RefJavaVisitor)visitor2;
            ReadAction.run(() -> javaVisitor.visitField((RefField)this));
        } else {
            super.accept(visitor2);
        }
    }

    public void buildReferences() {
        UField uField = this.getUastElement();
        if (uField != null) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            refUtil.addReferencesTo((UElement)uField, (RefJavaElement)this, new UElement[]{uField.getUastInitializer()});
            refUtil.addReferencesTo((UElement)uField, (RefJavaElement)this, uField.getUAnnotations().toArray(UElementKt.EMPTY_ARRAY));
            if (uField instanceof UEnumConstant) {
                refUtil.addReferencesTo((UElement)uField, (RefJavaElement)this, new UElement[]{uField});
            }
            if (uField.getUastInitializer() != null || uField instanceof UEnumConstant) {
                this.setInitializerMasks();
            } else if (RefUtil.isImplicitWrite((PsiElement)uField.getJavaPsi())) {
                this.setImplicitlyWritten(true);
                this.setInitializerMasks();
            }
            if (RefUtil.isImplicitRead((PsiElement)uField.getJavaPsi())) {
                this.setImplicitlyRead(true);
            }
            refUtil.addTypeReference((UElement)uField, uField.getType(), (RefManager)this.getRefManager(), (RefJavaElement)this);
        }
    }

    private void setInitializerMasks() {
        if (!this.checkFlag(131072L)) {
            this.setFlag(true, 262144L);
            this.setFlag(true, 131072L);
        }
    }

    public RefClass getOwnerClass() {
        RefClass c;
        WritableRefEntity writableRefEntity = this.getOwner();
        return writableRefEntity instanceof RefClass ? (c = (RefClass)writableRefEntity) : null;
    }

    public String getExternalName() {
        WritableRefEntity owner = this.getOwner();
        if (owner == null) {
            LOG.error("No parent class for: " + this.getName());
            return null;
        }
        return owner.getExternalName() + " " + this.getName();
    }

    @Nullable
    static RefField fieldFromExternalName(RefManager manager, String externalName) {
        return (RefField)manager.getReference((PsiElement)RefFieldImpl.findPsiField(PsiManager.getInstance((Project)manager.getProject()), externalName));
    }

    @Nullable
    public static PsiField findPsiField(PsiManager manager, String externalName) {
        String className;
        PsiClass psiClass;
        int classNameDelimiter = externalName.lastIndexOf(32);
        if (classNameDelimiter > 0 && classNameDelimiter < externalName.length() - 1 && (psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)(className = externalName.substring(0, classNameDelimiter)))) != null) {
            String fieldName = externalName.substring(classNameDelimiter + 1);
            return psiClass.findFieldByName(fieldName, false);
        }
        return null;
    }

    public boolean isSuspicious() {
        if (this.isEntry()) {
            return false;
        }
        return super.isSuspicious() || this.isUsedForReading() != this.isUsedForWriting();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFrom";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/reference/RefFieldImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markReferenced";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

