/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyAnnotator;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnnecessaryModuleDependencyInspection
extends GlobalInspectionTool {
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(0);
        }
        return new UnnecessaryModuleDependencyAnnotator(refManager);
    }

    public JobDescriptor @Nullable [] getAdditionalJobs(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(1);
        }
        return JobDescriptor.EMPTY_ARRAY;
    }

    public boolean queryExternalUsagesRequests(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        GlobalJavaInspectionContext javaInspectionContext;
        if (manager == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(2);
        }
        if (globalContext == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(3);
        }
        if (problemDescriptionsProcessor == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(4);
        }
        if ((javaInspectionContext = (GlobalJavaInspectionContext)globalContext.getExtension(GlobalJavaInspectionContext.CONTEXT)) != null) {
            final RefManager refManager = globalContext.getRefManager();
            final HashMap to2FromCandidatePairsToRemove = new HashMap();
            for (Module module : ModuleManager.getInstance((Project)refManager.getProject()).getModules()) {
                RefModule refModule = refManager.getRefModule(module);
                CommonProblemDescriptor[] descriptions = problemDescriptionsProcessor.getDescriptions((RefEntity)Objects.requireNonNull(refModule));
                if (descriptions == null) continue;
                String sourceModuleName = module.getName();
                for (CommonProblemDescriptor description : descriptions) {
                    QuickFix[] fixes = description.getFixes();
                    if (fixes == null) continue;
                    Arrays.stream(fixes).map(fix -> fix instanceof RemoveModuleDependencyFix ? ((RemoveModuleDependencyFix)fix).myDependency : null).filter(Objects::nonNull).forEach(targetName -> to2FromCandidatePairsToRemove.computeIfAbsent(targetName, k -> new HashSet()).add(sourceModuleName));
                }
            }
            refManager.iterate((RefVisitor)new RefJavaVisitor(this){

                public void visitClass(@NotNull RefClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (aClass.isAnonymous() || aClass.isLocalClass()) {
                        return;
                    }
                    RefModule toModule = aClass.getModule();
                    if (toModule == null) {
                        return;
                    }
                    String toModuleName = toModule.getName();
                    if (!to2FromCandidatePairsToRemove.containsKey(toModuleName)) {
                        return;
                    }
                    if ("private".equals(aClass.getAccessModifier())) {
                        return;
                    }
                    javaInspectionContext.enqueueClassUsagesProcessor(aClass, reference -> {
                        LinkedHashSet<CommonProblemDescriptor> problemDescriptors;
                        boolean removed;
                        CommonProblemDescriptor[] descriptions;
                        RefModule fromModule;
                        RefElement refFrom;
                        PsiFile containingFile = reference.getElement().getContainingFile();
                        if (!(containingFile instanceof PsiClassOwner) && (refFrom = refManager.getReference((PsiElement)containingFile)) != null && (fromModule = refFrom.getModule()) != null && (descriptions = problemDescriptionsProcessor.getDescriptions((RefEntity)fromModule)) != null && (removed = (problemDescriptors = new LinkedHashSet<CommonProblemDescriptor>(Arrays.asList(descriptions))).removeIf(descriptor -> {
                            Object[] fixes = descriptor.getFixes();
                            return fixes != null && ContainerUtil.exists((Object[])fixes, fix -> fix instanceof RemoveModuleDependencyFix && toModuleName.equals(((RemoveModuleDependencyFix)fix).myDependency));
                        }))) {
                            problemDescriptionsProcessor.ignoreElement((RefEntity)fromModule);
                            if (!problemDescriptors.isEmpty()) {
                                problemDescriptionsProcessor.addProblemElement((RefEntity)fromModule, (CommonProblemDescriptor[])problemDescriptors.toArray(CommonProblemDescriptor[]::new));
                            }
                        }
                        return true;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$1", "visitClass"));
                }
            });
        }
        return false;
    }

    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(7);
        }
        if (globalContext == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(8);
        }
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            boolean onlyGeneratedSources = true;
            block0: for (ContentEntry entry : moduleRootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    if (JavaProjectRootsUtil.isForGeneratedSources(sourceFolder)) continue;
                    onlyGeneratedSources = false;
                    continue block0;
                }
            }
            if (onlyGeneratedSources) {
                return null;
            }
            OrderEntry[] declaredDependencies = moduleRootManager.getOrderEntries();
            ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
            Set modules = (Set)refModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES);
            ArrayList<Module> candidates = new ArrayList<Module>();
            for (SourceFolder sourceFolder : declaredDependencies) {
                Module dependency;
                if (!(sourceFolder instanceof ModuleOrderEntry) || ((ModuleOrderEntry)sourceFolder).getScope() == DependencyScope.RUNTIME || ((ModuleOrderEntry)sourceFolder).isExported() || (dependency = ((ModuleOrderEntry)sourceFolder).getModule()) == null || modules != null && modules.remove(dependency)) continue;
                candidates.add(dependency);
            }
            for (Module dependency : candidates) {
                if (modules != null) {
                    HashSet outs = new HashSet();
                    OrderEnumerator.orderEntries((Module)dependency).withoutSdk().exportedOnly().recursively().forEachModule(outs::add);
                    if (ContainerUtil.intersects((Collection)modules, outs)) continue;
                }
                descriptors.add(UnnecessaryModuleDependencyInspection.createDescriptor(scope, manager, module, dependency));
            }
            return descriptors.isEmpty() ? null : descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    @Nullable
    public RemoveModuleDependencyFix getQuickFix(String hint) {
        return new RemoveModuleDependencyFix(hint);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.declaration.redundancy", (Object[])new Object[0]);
        if (string == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "UnnecessaryModuleDependencyInspection";
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(10);
        }
        return fix instanceof RemoveModuleDependencyFix ? ((RemoveModuleDependencyFix)fix).myDependency : null;
    }

    private static CommonProblemDescriptor createDescriptor(AnalysisScope scope, InspectionManager manager, @NotNull Module module, @NotNull Module dependency) {
        if (module == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(11);
        }
        if (dependency == null) {
            UnnecessaryModuleDependencyInspection.$$$reportNull$$$0(12);
        }
        String dependencyName = dependency.getName();
        String moduleName = module.getName();
        if (scope.containsModule(dependency)) {
            String allContainsMessage = JavaAnalysisBundle.message((String)"unnecessary.module.dependency.problem.descriptor", (Object[])new Object[]{moduleName, dependencyName});
            return manager.createProblemDescriptor(allContainsMessage, module, new QuickFix[]{new RemoveModuleDependencyFix(dependencyName)});
        }
        String message = JavaAnalysisBundle.message((String)"suspected.module.dependency.problem.descriptor", (Object[])new Object[]{moduleName, dependencyName, scope.getDisplayName()});
        return manager.createProblemDescriptor(message, module, new QuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalJobs";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    public static class RemoveModuleDependencyFix
    implements QuickFix<ModuleProblemDescriptor> {
        private final String myDependency;

        public RemoveModuleDependencyFix(String dependency) {
            this.myDependency = dependency;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"remove.dependency", (Object[])new Object[0]);
            if (string == null) {
                RemoveModuleDependencyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ModuleProblemDescriptor descriptor) {
            if (project == null) {
                RemoveModuleDependencyFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveModuleDependencyFix.$$$reportNull$$$0(2);
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)descriptor.getModule()).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                String mDependency;
                if (!(entry instanceof ModuleOrderEntry) || !Objects.equals(mDependency = ((ModuleOrderEntry)entry).getModuleName(), this.myDependency)) continue;
                model.removeOrderEntry(entry);
                break;
            }
            model.commit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

