/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsDeclarationLocalInspection;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsGraphAnnotator;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class RedundantThrowsDeclarationInspection
extends GlobalJavaBatchInspectionTool {
    public boolean IGNORE_ENTRY_POINTS = false;
    private final RedundantThrowsDeclarationLocalInspection myLocalInspection = new RedundantThrowsDeclarationLocalInspection(this);

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_ENTRY_POINTS", (String)JavaAnalysisBundle.message((String)"ignore.exceptions.thrown.by.entry.points.methods", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public CommonProblemDescriptor @Nullable [] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(5);
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (refMethod.isSyntheticJSP()) {
            return null;
        }
        if (this.IGNORE_ENTRY_POINTS && refMethod.isEntry()) {
            return null;
        }
        Object[] unThrown = refMethod.getUnThrownExceptions();
        if (unThrown == null) {
            return null;
        }
        PsiElement element = refMethod.getPsiElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)element;
        if (method.hasModifier(JvmModifier.NATIVE)) {
            return null;
        }
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, method.getContainingClass())) {
            return null;
        }
        HashSet unThrownSet = ContainerUtil.newHashSet((Object[])unThrown);
        return (CommonProblemDescriptor[])((StreamEx)RedundantThrowsDeclarationLocalInspection.getRedundantThrowsCandidates(method, this.IGNORE_ENTRY_POINTS).filter(throwRefType -> unThrownSet.contains(throwRefType.getType().resolve()))).map(throwRefType -> {
            PsiJavaCodeReferenceElement throwsRef = throwRefType.getReference();
            String message = RedundantThrowsDeclarationInspection.getMessage(refMethod);
            MyQuickFix fix = new MyQuickFix(processor, throwRefType.getType().getClassName(), this.IGNORE_ENTRY_POINTS);
            return manager.createProblemDescriptor((PsiElement)throwsRef, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false);
        }).toArray((Object[])CommonProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    @InspectionMessage
    private static String getMessage(@NotNull RefMethod refMethod) {
        if (refMethod == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(6);
        }
        if (refMethod.isAbstract()) {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.throws.problem.descriptor", (Object[])new Object[0]);
            if (string == null) {
                RedundantThrowsDeclarationInspection.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (!refMethod.getDerivedMethods().isEmpty()) {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.throws.problem.descriptor1", (Object[])new Object[0]);
            if (string == null) {
                RedundantThrowsDeclarationInspection.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = JavaAnalysisBundle.message((String)"inspection.redundant.throws.problem.descriptor2", (Object[])new Object[0]);
        if (string == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        if (manager == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(10);
        }
        if (globalContext == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(12);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(this){

            public void visitMethod(@NotNull RefMethod refMethod) {
                if (refMethod == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (processor.getDescriptions((RefEntity)refMethod) == null) {
                    return;
                }
                if ("private".equals(refMethod.getAccessModifier())) {
                    return;
                }
                globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                    processor.ignoreElement((RefEntity)refMethod);
                    return true;
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$1", "visitMethod"));
            }
        });
        return false;
    }

    @NotNull
    public QuickFix<ProblemDescriptor> getQuickFix(String hint) {
        return new MyQuickFix(null, hint, this.IGNORE_ENTRY_POINTS);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(13);
        }
        return fix instanceof MyQuickFix ? ((MyQuickFix)fix).myHint : null;
    }

    @NotNull
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(14);
        }
        return new RedundantThrowsGraphAnnotator(refManager);
    }

    @NotNull
    public LocalInspectionTool getSharedLocalInspectionTool() {
        RedundantThrowsDeclarationLocalInspection redundantThrowsDeclarationLocalInspection = this.myLocalInspection;
        if (redundantThrowsDeclarationLocalInspection == null) {
            RedundantThrowsDeclarationInspection.$$$reportNull$$$0(15);
        }
        return redundantThrowsDeclarationLocalInspection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 10, 11, 12, 13, 14 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSharedLocalInspectionTool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "queryExternalUsagesRequests";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final String myHint;
        private final boolean myIgnoreEntryPoints;

        MyQuickFix(ProblemDescriptionsProcessor processor, String hint, boolean ignoreEntryPoints) {
            this.myProcessor = processor;
            this.myHint = hint;
            this.myIgnoreEntryPoints = ignoreEntryPoints;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.redundant.throws.remove.quickfix", (Object[])new Object[0]);
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            CommonProblemDescriptor[] problems;
            PsiMethod psiMethod;
            RefMethod refMethod;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if (this.myProcessor != null) {
                RefEntity refElement = this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
                if (!(refElement instanceof RefMethod) || !refElement.isValid()) {
                    return;
                }
                refMethod = (RefMethod)refElement;
                psiMethod = (PsiMethod)ObjectUtils.tryCast((Object)refMethod.getPsiElement(), PsiMethod.class);
                problems = this.myProcessor.getDescriptions((RefEntity)refMethod);
            } else {
                psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
                if (psiMethod == null) {
                    return;
                }
                refMethod = null;
                problems = new CommonProblemDescriptor[]{descriptor};
            }
            this.removeExcessiveThrows(refMethod, psiMethod, problems);
        }

        private void removeExcessiveThrows(@Nullable RefMethod refMethod, @Nullable PsiMethod psiMethod, CommonProblemDescriptor @Nullable [] problems) {
            if (psiMethod == null) {
                return;
            }
            if (problems == null) {
                return;
            }
            Project project = psiMethod.getProject();
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
            MyQuickFix.fixTryStatements(psiMethod, problems);
            Set refsToDelete = Arrays.stream(problems).map(problem -> (ProblemDescriptor)problem).map(ProblemDescriptor::getPsiElement).filter(psiElement -> psiElement instanceof PsiJavaCodeReferenceElement).map(reference -> (PsiJavaCodeReferenceElement)reference).map(arg_0 -> ((PsiElementFactory)factory).createType(arg_0)).flatMap(psiClassType -> this.removeException(refMethod, (PsiType)psiClassType, psiMethod)).collect(Collectors.toSet());
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(refsToDelete)) {
                return;
            }
            WriteAction.run(() -> {
                for (PsiElement element : refsToDelete) {
                    new CommentTracker().deleteAndRestoreComments(element);
                }
            });
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static void fixTryStatements(@NotNull PsiMethod method, CommonProblemDescriptor @NotNull [] problems) {
            if (method == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            if (problems == null) {
                MyQuickFix.$$$reportNull$$$0(4);
            }
            Project project = method.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            Set<PsiClassType> redundantTypes = MyQuickFix.getRedundantExceptionTypes(problems, factory);
            Map<@NotNull PsiFile, @NotNull Set<@NotNull PsiTryStatement>> tryStatementsInFile = MyQuickFix.getFilesWithTryStatements(method);
            for (Set<PsiTryStatement> tryStatements : tryStatementsInFile.values()) {
                HashMap<@NotNull Object, @Nullable PsiTypeElement> mappings = new HashMap<Object, PsiTypeElement>();
                for (PsiTryStatement tryStatement : tryStatements) {
                    TryStatementInfo graph = new TryStatementInfo(tryStatement);
                    graph.breakConnectionsFromRedundantExceptions(redundantTypes, method);
                    for (PsiCatchSection section : tryStatement.getCatchSections()) {
                        PsiDisjunctionType parameterType;
                        PsiTypeElement catchParamTypeElement;
                        PsiParameter parameter = section.getParameter();
                        if (parameter == null || (catchParamTypeElement = parameter.getTypeElement()) == null) continue;
                        PsiType catchParamType = parameter.getType();
                        List<PsiType> types = graph.getEssentialExceptionsOfCatch(section);
                        if (types.isEmpty()) {
                            mappings.put(section, null);
                            continue;
                        }
                        if (!(catchParamType instanceof PsiDisjunctionType) || (parameterType = (PsiDisjunctionType)catchParamType).getDisjunctions().size() == types.size()) continue;
                        PsiType newDisjunctionType = PsiDisjunctionType.createDisjunction(types, (PsiManager)method.getManager());
                        PsiTypeElement newDisjunctionTypeElement = factory.createTypeElement(newDisjunctionType);
                        mappings.put(catchParamTypeElement, newDisjunctionTypeElement);
                    }
                }
                if (mappings.isEmpty()) continue;
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(tryStatements)) {
                    return;
                }
                WriteAction.run(() -> {
                    JavaCodeStyleManager instance = JavaCodeStyleManager.getInstance((Project)project);
                    for (Map.Entry mapping : mappings.entrySet()) {
                        PsiElement from = (PsiElement)mapping.getKey();
                        PsiElement to = (PsiElement)mapping.getValue();
                        if (!from.isValid()) continue;
                        if (to == null) {
                            new CommentTracker().deleteAndRestoreComments(from);
                            continue;
                        }
                        if (!to.isValid()) continue;
                        @NotNull @Nullable PsiElement element = new CommentTracker().replaceAndRestoreComments(from, to);
                        instance.shortenClassReferences(element);
                    }
                    for (PsiTryStatement tryStatement : tryStatements) {
                        if (!tryStatement.isValid() || tryStatement.getCatchSections().length != 0 || tryStatement.getFinallyBlock() != null || tryStatement.getResourceList() != null) continue;
                        BlockUtils.unwrapTryBlock((PsiTryStatement)tryStatement);
                    }
                });
            }
        }

        @Contract(pure=true)
        @NotNull
        private static @NotNull Map<@NotNull PsiFile, @NotNull Set<@NotNull PsiTryStatement>> getFilesWithTryStatements(@NotNull PsiMethod method) {
            if (method == null) {
                MyQuickFix.$$$reportNull$$$0(5);
            }
            Collection references = ReferencesSearch.search((PsiElement)method).findAll();
            HashMap<@NotNull PsiFile, @NotNull Set<@NotNull PsiTryStatement>> tryStatementsInFile = new HashMap<PsiFile, Set<PsiTryStatement>>();
            for (PsiReference reference : references) {
                if (!(reference instanceof PsiElement)) continue;
                PsiElement element = (PsiElement)reference;
                PsiFile file = element.getContainingFile();
                PsiClass clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                PsiTreeUtil.treeWalkUp((PsiElement)element, (PsiElement)clazz, (curr, prev) -> {
                    if (curr instanceof PsiTryStatement) {
                        Set tryStatements = tryStatementsInFile.computeIfAbsent(file, k -> new HashSet());
                        tryStatements.add((PsiTryStatement)curr);
                    }
                    return true;
                });
            }
            HashMap<PsiFile, Set<PsiTryStatement>> hashMap = tryStatementsInFile;
            if (hashMap == null) {
                MyQuickFix.$$$reportNull$$$0(6);
            }
            return hashMap;
        }

        private static Set<PsiClassType> getRedundantExceptionTypes(CommonProblemDescriptor @NotNull [] problems, @NotNull PsiElementFactory factory) {
            if (factory == null) {
                MyQuickFix.$$$reportNull$$$0(7);
            }
            if (problems == null) {
                MyQuickFix.$$$reportNull$$$0(8);
            }
            return StreamEx.of((Object[])problems).select(ProblemDescriptor.class).map(ProblemDescriptor::getPsiElement).select(PsiJavaCodeReferenceElement.class).map(arg_0 -> ((PsiElementFactory)factory).createType(arg_0)).toSet();
        }

        private StreamEx<PsiElement> removeException(@Nullable RefMethod refMethod, @NotNull PsiType exceptionType, @NotNull PsiMethod psiMethod) {
            if (exceptionType == null) {
                MyQuickFix.$$$reportNull$$$0(9);
            }
            if (psiMethod == null) {
                MyQuickFix.$$$reportNull$$$0(10);
            }
            StreamEx elements = ((StreamEx)RedundantThrowsDeclarationLocalInspection.getRedundantThrowsCandidates(psiMethod, this.myIgnoreEntryPoints).filter(throwRefType -> exceptionType.isAssignableFrom((PsiType)throwRefType.getType()))).map(RedundantThrowsDeclarationLocalInspection.ThrowRefType::getReference).flatMap(ref -> this.appendRelatedJavadocThrows(refMethod, psiMethod, (PsiJavaCodeReferenceElement)ref));
            if (refMethod != null) {
                ProblemDescriptionsProcessor.resolveAllProblemsInElement((ProblemDescriptionsProcessor)this.myProcessor, (RefEntity)refMethod);
            }
            return elements;
        }

        private StreamEx<PsiElement> appendRelatedJavadocThrows(@Nullable RefMethod refMethod, @NotNull PsiMethod psiMethod, @NotNull PsiJavaCodeReferenceElement ref) {
            if (psiMethod == null) {
                MyQuickFix.$$$reportNull$$$0(11);
            }
            if (ref == null) {
                MyQuickFix.$$$reportNull$$$0(12);
            }
            StreamEx res = StreamEx.of((Object)ref);
            if (refMethod == null) {
                return res;
            }
            PsiDocComment comment = psiMethod.getDocComment();
            if (comment == null) {
                return res;
            }
            PsiClass[] unThrown = refMethod.getUnThrownExceptions();
            if (unThrown == null) {
                return res;
            }
            List redundantThrows = ((StreamEx)RedundantThrowsDeclarationLocalInspection.getRedundantThrowsCandidates(psiMethod, this.myIgnoreEntryPoints).map(RedundantThrowsDeclarationLocalInspection.ThrowRefType::getType).filter(type -> ArrayUtil.contains((Object)type.resolve(), (Object[])unThrown))).toList();
            StreamEx javadocThrows = StreamEx.of((Object[])comment.getTags()).filterBy(PsiDocTag::getName, (Object)"throws");
            PsiJavaCodeReferenceElement[] throwsListElements = psiMethod.getThrowsList().getReferenceElements();
            if (throwsListElements.length == 1 && redundantThrows.size() == 1) {
                return (StreamEx)res.append((Stream)javadocThrows);
            }
            StreamEx relatedJavadocThrows = (StreamEx)javadocThrows.filter(tag -> MyQuickFix.isTagRelatedToRedundantThrow(tag, redundantThrows));
            return (StreamEx)res.append((Stream)relatedJavadocThrows);
        }

        private static boolean isTagRelatedToRedundantThrow(@NotNull PsiDocTag tag, @NotNull List<? extends PsiClassType> redundantThrows) {
            if (tag == null) {
                MyQuickFix.$$$reportNull$$$0(13);
            }
            if (redundantThrows == null) {
                MyQuickFix.$$$reportNull$$$0(14);
            }
            assert ("throws".equals(tag.getName())) : "the tag has to be of the @throws kind";
            PsiClass throwsClass = JavaDocUtil.resolveClassInTagValue((PsiDocTagValue)tag.getValueElement());
            if (throwsClass == null) {
                return false;
            }
            PsiClassType type = PsiTypesUtil.getClassType((PsiClass)throwsClass);
            return ContainerUtil.exists(redundantThrows, e -> e.isAssignableFrom((PsiType)type));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "redundantThrows";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesWithTryStatements";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fixTryStatements";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesWithTryStatements";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getRedundantExceptionTypes";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "removeException";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "appendRelatedJavadocThrows";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "isTagRelatedToRedundantThrow";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalArgumentException(string);
            };
        }

        private static final class TryStatementInfo {
            @NotNull
            private final @NotNull Map<@NotNull PsiCatchSection, @NotNull Set<@NotNull PsiType>> catchToExceptionTypes;
            @NotNull
            private final @NotNull Map<@NotNull PsiType, @NotNull Set<@NotNull PsiElement>> exceptionToInducers;

            private TryStatementInfo(@NotNull PsiTryStatement tryStatement) {
                if (tryStatement == null) {
                    TryStatementInfo.$$$reportNull$$$0(0);
                }
                this.catchToExceptionTypes = new HashMap<PsiCatchSection, Set<PsiType>>();
                this.exceptionToInducers = new HashMap<PsiType, Set<PsiElement>>();
                this.analyzeCatchSections(tryStatement);
                PsiCodeBlock block = tryStatement.getTryBlock();
                PsiResourceList resourceList = tryStatement.getResourceList();
                this.analyzeCodeBlock((PsiElement)block);
                this.analyzeCodeBlock((PsiElement)resourceList);
                this.analyzeCodeBlock(resourceList);
            }

            @Contract(pure=true)
            @NotNull
            private @NotNull Set<@NotNull PsiElement> getExceptionInducers(@NotNull PsiType exceptionType) {
                if (exceptionType == null) {
                    TryStatementInfo.$$$reportNull$$$0(1);
                }
                Set<PsiElement> set = this.exceptionToInducers.getOrDefault(exceptionType, Collections.emptySet());
                if (set == null) {
                    TryStatementInfo.$$$reportNull$$$0(2);
                }
                return set;
            }

            @Contract(pure=true)
            @NotNull
            private @Unmodifiable @NotNull List<@NotNull PsiType> getEssentialExceptionsOfCatch(@NotNull PsiCatchSection catchSection) {
                if (catchSection == null) {
                    TryStatementInfo.$$$reportNull$$$0(3);
                }
                List list = ContainerUtil.filter((Collection)this.catchToExceptionTypes.get(catchSection), this::isEssentialException);
                if (list == null) {
                    TryStatementInfo.$$$reportNull$$$0(4);
                }
                return list;
            }

            @Contract(pure=true)
            private boolean isEssentialException(@NotNull PsiType type) {
                if (type == null) {
                    TryStatementInfo.$$$reportNull$$$0(5);
                }
                if (ExceptionUtil.isGeneralExceptionType((PsiType)type)) {
                    return true;
                }
                if (type instanceof PsiClassType && ExceptionUtil.isUncheckedException((PsiClassType)((PsiClassType)type))) {
                    return true;
                }
                return !this.getExceptionInducers(type).isEmpty();
            }

            @Contract(pure=true)
            private void analyzeCatchSections(@NotNull PsiTryStatement tryStatement) {
                if (tryStatement == null) {
                    TryStatementInfo.$$$reportNull$$$0(6);
                }
                for (PsiCatchSection catchSection : tryStatement.getCatchSections()) {
                    PsiParameter parameter = catchSection.getParameter();
                    if (parameter == null) continue;
                    PsiType catchType = parameter.getType();
                    if (catchType instanceof PsiDisjunctionType) {
                        PsiDisjunctionType disjunctionType = (PsiDisjunctionType)catchType;
                        for (PsiType disjunction : disjunctionType.getDisjunctions()) {
                            this.addCatchSectionType(catchSection, disjunction);
                        }
                        continue;
                    }
                    this.addCatchSectionType(catchSection, catchType);
                }
            }

            @Contract(pure=true)
            private void analyzeCodeBlock(final @Nullable PsiElement block) {
                if (block == null) {
                    return;
                }
                block.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                    public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
                        if (callExpression == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        List exceptions = ExceptionUtil.getUnhandledExceptions((PsiCallExpression)callExpression, (PsiElement)block);
                        for (PsiClassType exception : exceptions) {
                            this.addExceptionInducer((PsiType)exception, (PsiElement)callExpression);
                        }
                    }

                    public void visitThrowStatement(@NotNull PsiThrowStatement statement) {
                        PsiExpression exception;
                        if (statement == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((exception = statement.getException()) == null) {
                            return;
                        }
                        PsiType type = exception.getType();
                        if (type == null) {
                            return;
                        }
                        this.addExceptionInducer(type, (PsiElement)statement);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "callExpression";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "statement";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix$TryStatementInfo$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitCallExpression";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitThrowStatement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            @Contract(pure=true)
            private void analyzeCodeBlock(@Nullable PsiResourceList resourceList) {
                if (resourceList == null) {
                    return;
                }
                for (PsiResourceListElement element : resourceList) {
                    List exceptions = ExceptionUtil.getCloserExceptions((PsiResourceListElement)element);
                    for (PsiClassType exception : exceptions) {
                        this.addExceptionInducer((PsiType)exception, (PsiElement)element);
                    }
                }
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void addCatchSectionType(@NotNull PsiCatchSection catchSection, @NotNull PsiType exception) {
                if (catchSection == null) {
                    TryStatementInfo.$$$reportNull$$$0(7);
                }
                if (exception == null) {
                    TryStatementInfo.$$$reportNull$$$0(8);
                }
                @NotNull Set exceptionTypes = this.catchToExceptionTypes.computeIfAbsent(catchSection, k -> new LinkedHashSet());
                exceptionTypes.add(exception);
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private void addExceptionInducer(@NotNull PsiType exception, @NotNull PsiElement inducer) {
                if (exception == null) {
                    TryStatementInfo.$$$reportNull$$$0(9);
                }
                if (inducer == null) {
                    TryStatementInfo.$$$reportNull$$$0(10);
                }
                @NotNull Set inducers = this.exceptionToInducers.computeIfAbsent(exception, k -> new HashSet());
                inducers.add(inducer);
            }

            private void breakConnectionsFromRedundantExceptions(@NotNull Set<? extends PsiClassType> redundantTypes, @NotNull PsiMethod method) {
                if (redundantTypes == null) {
                    TryStatementInfo.$$$reportNull$$$0(11);
                }
                if (method == null) {
                    TryStatementInfo.$$$reportNull$$$0(12);
                }
                for (PsiCatchSection catchSection : this.catchToExceptionTypes.keySet()) {
                    for (PsiType exception : this.catchToExceptionTypes.get(catchSection)) {
                        if (!ContainerUtil.exists(redundantTypes, arg_0 -> ((PsiType)exception).isAssignableFrom(arg_0))) continue;
                        Iterator<@NotNull PsiElement> catchTypeInducers = this.getExceptionInducers(exception).iterator();
                        while (catchTypeInducers.hasNext()) {
                            JavaResolveResult result;
                            PsiElement element;
                            PsiMethod resolvedMethod;
                            @NotNull PsiElement callInducer = catchTypeInducers.next();
                            if (!(callInducer instanceof PsiCall) || (resolvedMethod = (element = (result = PsiDiamondType.getDiamondsAwareResolveResult((PsiCall)((PsiCall)callInducer))).getElement()) instanceof PsiMethod ? (PsiMethod)element : null) != method) continue;
                            catchTypeInducers.remove();
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tryStatement";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exceptionType";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix$TryStatementInfo";
                        break;
                    }
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "catchSection";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exception";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inducer";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "redundantTypes";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "method";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationInspection$MyQuickFix$TryStatementInfo";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getExceptionInducers";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEssentialExceptionsOfCatch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getExceptionInducers";
                        break;
                    }
                    case 2: 
                    case 4: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getEssentialExceptionsOfCatch";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "isEssentialException";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "analyzeCatchSections";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "addCatchSectionType";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "addExceptionInducer";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "breakConnectionsFromRedundantExceptions";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 4 -> new IllegalStateException(string);
                };
            }
        }
    }
}

