/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.UnhandledExceptions;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsDeclarationInspection;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.JavaOverridingMethodUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class RedundantThrowsDeclarationLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)RedundantThrowsDeclarationLocalInspection.class.getName());
    @NotNull
    private final RedundantThrowsDeclarationInspection myGlobalTool;

    @TestOnly
    public RedundantThrowsDeclarationLocalInspection() {
        this(new RedundantThrowsDeclarationInspection());
    }

    public RedundantThrowsDeclarationLocalInspection(@NotNull RedundantThrowsDeclarationInspection tool) {
        if (tool == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(0);
        }
        this.myGlobalTool = tool;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = this.myGlobalTool.getGroupDisplayName();
        if (string == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = this.myGlobalTool.getShortName();
        if (string == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String string = JavaAnalysisBundle.message((String)"inspection.redundant.throws.display.name", (Object[])new Object[0]);
        if (string == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(4);
        }
        return new RedundantThrowsVisitor(holder, this.myGlobalTool.IGNORE_ENTRY_POINTS);
    }

    @Contract(pure=true)
    static StreamEx<ThrowRefType> getRedundantThrowsCandidates(@Nullable PsiMethod method, boolean ignoreEntryPoints) {
        if (method == null) {
            return StreamEx.empty();
        }
        if (method instanceof SyntheticElement) {
            return StreamEx.empty();
        }
        if (ignoreEntryPoints && UnusedDeclarationInspectionBase.isDeclaredAsEntryPoint((PsiElement)method)) {
            return StreamEx.empty();
        }
        if (method.hasModifier(JvmModifier.NATIVE)) {
            return StreamEx.empty();
        }
        if (JavaHighlightUtil.isSerializationRelatedMethod(method, method.getContainingClass())) {
            return StreamEx.empty();
        }
        PsiReferenceList throwsList = method.getThrowsList();
        RedundantThrowsDeclarationLocalInspection.checkInconsistency(throwsList, method.getClass().getSimpleName());
        Object[] referenceElements = throwsList.getReferenceElements();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        return (StreamEx)((StreamEx)StreamEx.of((Object[])referenceElements).map(ref -> new ThrowRefType((PsiJavaCodeReferenceElement)ref, factory.createType(ref))).filter(ThrowRefType::isCheckedException)).filter(p -> !p.isRemoteExceptionInRemoteMethod(method));
    }

    private static void checkInconsistency(@NotNull PsiReferenceList throwsList) {
        if (throwsList == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(5);
        }
        RedundantThrowsDeclarationLocalInspection.checkInconsistency(throwsList, null);
    }

    private static void checkInconsistency(@NotNull PsiReferenceList throwsList, @Nullable String methodClassName) {
        PsiClassType[] referencedTypes;
        PsiJavaCodeReferenceElement[] referenceElements;
        if (throwsList == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(6);
        }
        if ((referenceElements = throwsList.getReferenceElements()).length != (referencedTypes = throwsList.getReferencedTypes()).length) {
            if (methodClassName == null) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)throwsList, PsiMethod.class);
                methodClassName = method != null ? method.getClass().getSimpleName() : "null";
            }
            LOGGER.error("Stub-PSI inconsistency detected. The number of elements in the throws list doesn't match the number of types in the throws list. The method's class is " + methodClassName, new Attachment[]{new Attachment("throwsList.sourcePsi.txt", throwsList.isValid() ? throwsList.getText() : "<invalid>")});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwsList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkInconsistency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    static final class RedundantThrowsVisitor
    extends JavaElementVisitor {
        @NotNull
        private final ProblemsHolder myHolder;
        private final boolean myIgnoreEntryPoints;

        private RedundantThrowsVisitor(@NotNull ProblemsHolder holder, boolean ignoreEntryPoints) {
            if (holder == null) {
                RedundantThrowsVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myIgnoreEntryPoints = ignoreEntryPoints;
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                RedundantThrowsVisitor.$$$reportNull$$$0(1);
            }
            ((StreamEx)((StreamEx)((StreamEx)RedundantThrowsDeclarationLocalInspection.getRedundantThrowsCandidates(method, this.myIgnoreEntryPoints).filter(throwRefType -> !throwRefType.isThrownIn(method))).filter(throwRefType -> !throwRefType.isInOverriddenOf(method))).filter(throwRefType -> !throwRefType.isCaught(method))).forEach(throwRefType -> {
                PsiJavaCodeReferenceElement reference = throwRefType.myReference;
                PsiClassType exceptionType = throwRefType.myType;
                String description = JavaErrorBundle.message("exception.is.never.thrown", JavaHighlightUtil.formatType((PsiType)exceptionType));
                RedundantThrowsQuickFix fix = new RedundantThrowsQuickFix(exceptionType.getCanonicalText(), PsiFormatUtil.formatSimple((PsiNamedElement)method));
                this.myHolder.registerProblem((PsiElement)reference, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$RedundantThrowsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static final class RedundantThrowsQuickFix
        extends PsiUpdateModCommandQuickFix {
            @NotNull
            private final String myMethodName;
            @NotNull
            private final String myExceptionName;

            private RedundantThrowsQuickFix(@NotNull String exceptionName, @NotNull String methodName) {
                if (exceptionName == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(0);
                }
                if (methodName == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(1);
                }
                this.myExceptionName = exceptionName;
                this.myMethodName = methodName;
            }

            @IntentionName
            @NotNull
            public String getName() {
                String exceptionName = StringUtil.getShortName((String)this.myExceptionName);
                String string = QuickFixBundle.message("fix.throws.list.remove.exception", exceptionName, this.myMethodName);
                if (string == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(2);
                }
                return string;
            }

            @IntentionFamilyName
            @NotNull
            public String getFamilyName() {
                String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
                if (string == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(3);
                }
                return string;
            }

            protected void applyFix(@NotNull Project project, @NotNull PsiElement elem, @NotNull ModPsiUpdater updater) {
                if (project == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(4);
                }
                if (elem == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(5);
                }
                if (updater == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(6);
                }
                if (!(elem instanceof PsiJavaCodeReferenceElement)) {
                    return;
                }
                PsiElement maybeMethod = PsiTreeUtil.skipParentsOfType((PsiElement)elem, (Class[])new Class[]{PsiReferenceList.class});
                if (!(maybeMethod instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)maybeMethod;
                RedundantThrowsQuickFix.getRelatedJavadocThrows((PsiJavaCodeReferenceElement)elem, method.getDocComment()).forEach(e -> e.delete());
                new CommentTracker().deleteAndRestoreComments(elem);
            }

            @NotNull
            static Stream<PsiDocTag> getRelatedJavadocThrows(@NotNull PsiJavaCodeReferenceElement currentThrowsRef, @Nullable PsiDocComment comment) {
                if (currentThrowsRef == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(7);
                }
                if (comment == null) {
                    Stream<PsiDocTag> stream = Stream.empty();
                    if (stream == null) {
                        RedundantThrowsQuickFix.$$$reportNull$$$0(8);
                    }
                    return stream;
                }
                PsiElement maybeThrowsList = currentThrowsRef.getParent();
                if (!(maybeThrowsList instanceof PsiReferenceList)) {
                    Stream<PsiDocTag> stream = Stream.empty();
                    if (stream == null) {
                        RedundantThrowsQuickFix.$$$reportNull$$$0(9);
                    }
                    return stream;
                }
                PsiReferenceList throwsList = (PsiReferenceList)maybeThrowsList;
                if (throwsList.getReferenceElements().length == 1) {
                    StreamEx streamEx = StreamEx.of((Object[])comment.getTags()).filterBy(PsiDocTag::getName, (Object)"throws");
                    if (streamEx == null) {
                        RedundantThrowsQuickFix.$$$reportNull$$$0(10);
                    }
                    return streamEx;
                }
                PsiElement maybeClass = currentThrowsRef.resolve();
                if (!(maybeClass instanceof PsiClass)) {
                    Stream<PsiDocTag> stream = Stream.empty();
                    if (stream == null) {
                        RedundantThrowsQuickFix.$$$reportNull$$$0(11);
                    }
                    return stream;
                }
                PsiClass reference = (PsiClass)maybeClass;
                List<PsiClassType> throwsListWithoutCurrent = RedundantThrowsQuickFix.getThrowsListWithoutCurrent(throwsList, currentThrowsRef);
                PsiClassType referenceType = PsiTypesUtil.getClassType((PsiClass)reference);
                if (throwsListWithoutCurrent.contains(referenceType)) {
                    Stream<PsiDocTag> stream = Stream.empty();
                    if (stream == null) {
                        RedundantThrowsQuickFix.$$$reportNull$$$0(12);
                    }
                    return stream;
                }
                PsiManager manager = reference.getManager();
                Predicate<PsiDocTag> isTagRelatedToCurrentThrowsRef = tag -> {
                    PsiClass throwsClass = JavaDocUtil.resolveClassInTagValue((PsiDocTagValue)tag.getValueElement());
                    if (throwsClass == null) {
                        return false;
                    }
                    return manager.areElementsEquivalent((PsiElement)throwsClass, (PsiElement)reference) || throwsClass.isInheritor(reference, true) && !RedundantThrowsQuickFix.isParentInThrowsListPresent(throwsClass, throwsListWithoutCurrent);
                };
                AbstractStreamEx abstractStreamEx = StreamEx.of((Object[])comment.getTags()).filterBy(PsiDocTag::getName, (Object)"throws").filter(isTagRelatedToCurrentThrowsRef);
                if (abstractStreamEx == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(13);
                }
                return abstractStreamEx;
            }

            private static boolean isParentInThrowsListPresent(@NotNull PsiClass clazz, @NotNull List<PsiClassType> throwsList) {
                if (clazz == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(14);
                }
                if (throwsList == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(15);
                }
                PsiClassType type = PsiTypesUtil.getClassType((PsiClass)clazz);
                return ContainerUtil.exists(throwsList, e -> e.isAssignableFrom((PsiType)type));
            }

            private static List<PsiClassType> getThrowsListWithoutCurrent(@NotNull PsiReferenceList throwsList, @NotNull PsiJavaCodeReferenceElement currentRef) {
                if (throwsList == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(16);
                }
                if (currentRef == null) {
                    RedundantThrowsQuickFix.$$$reportNull$$$0(17);
                }
                Object[] referenceElements = throwsList.getReferenceElements();
                RedundantThrowsDeclarationLocalInspection.checkInconsistency(throwsList);
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)throwsList.getProject());
                return ((StreamEx)StreamEx.of((Object[])referenceElements).filter(ref -> ref != currentRef)).map(arg_0 -> ((PsiElementFactory)factory).createType(arg_0)).toList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 8, 9, 10, 11, 12, 13 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "exceptionName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$RedundantThrowsVisitor$RedundantThrowsQuickFix";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elem";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentThrowsRef";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "throwsList";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentRef";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$RedundantThrowsVisitor$RedundantThrowsQuickFix";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRelatedJavadocThrows";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "getRelatedJavadocThrows";
                        break;
                    }
                    case 14: 
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "isParentInThrowsListPresent";
                        break;
                    }
                    case 16: 
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "getThrowsListWithoutCurrent";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
                };
            }
        }
    }

    static final class ThrowRefType {
        @NotNull
        private final PsiJavaCodeReferenceElement myReference;
        @NotNull
        private final PsiClassType myType;

        private ThrowRefType(@NotNull PsiJavaCodeReferenceElement reference, @NotNull PsiClassType type) {
            if (reference == null) {
                ThrowRefType.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ThrowRefType.$$$reportNull$$$0(1);
            }
            this.myReference = reference;
            this.myType = type;
        }

        @Contract(pure=true)
        private boolean isCheckedException() {
            return !ExceptionUtil.isUncheckedException((PsiClassType)this.myType);
        }

        @Contract(pure=true)
        private boolean isRemoteExceptionInRemoteMethod(@NotNull PsiMethod psiMethod) {
            if (psiMethod == null) {
                ThrowRefType.$$$reportNull$$$0(2);
            }
            if (!this.myType.equalsToText("java.rmi.RemoteException")) {
                return false;
            }
            PsiClass containingClass = psiMethod.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            JavaPsiFacade instance = JavaPsiFacade.getInstance((Project)containingClass.getProject());
            PsiClass remote = instance.findClass("java.rmi.Remote", GlobalSearchScope.allScope((Project)containingClass.getProject()));
            return remote != null && containingClass.isInheritor(remote, true);
        }

        @Contract(pure=true)
        private boolean isInOverriddenOf(@NotNull PsiMethod method) {
            if (method == null) {
                ThrowRefType.$$$reportNull$$$0(3);
            }
            if (!PsiUtil.canBeOverridden((PsiMethod)method)) {
                return false;
            }
            Predicate<PsiMethod> methodContainsThrownExceptions = m -> !ArrayUtil.isEmpty((Object[])m.getThrowsList().getReferencedTypes());
            Stream<PsiMethod> overridingMethods = JavaOverridingMethodUtil.getOverridingMethodsIfCheapEnough(method, null, methodContainsThrownExceptions);
            if (overridingMethods == null) {
                return true;
            }
            return overridingMethods.anyMatch(m -> this.isThrownIn((PsiMethod)m) || this.isInThrowsListOf((PsiMethod)m));
        }

        @Contract(pure=true)
        private boolean isThrownIn(@NotNull PsiMethod method) {
            if (method == null) {
                ThrowRefType.$$$reportNull$$$0(4);
            }
            if (method.hasModifierProperty("abstract")) {
                return true;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return true;
            }
            if (JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
                return true;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return true;
            }
            UnhandledExceptions exceptions = UnhandledExceptions.ofMethod((PsiMethod)method);
            if (exceptions.hasUnresolvedCalls()) {
                return true;
            }
            Set unhandled = exceptions.exceptions();
            return ContainerUtil.exists((Iterable)unhandled, arg_0 -> ((PsiClassType)this.myType).isAssignableFrom(arg_0));
        }

        @Contract(pure=true)
        private boolean isInThrowsListOf(@NotNull PsiMethod method) {
            if (method == null) {
                ThrowRefType.$$$reportNull$$$0(5);
            }
            return ContainerUtil.exists((Object[])method.getThrowsList().getReferencedTypes(), arg_0 -> ((PsiClassType)this.myType).isAssignableFrom(arg_0));
        }

        boolean isCaught(@NotNull PsiMethod method) {
            if (method == null) {
                ThrowRefType.$$$reportNull$$$0(6);
            }
            if (method.getUseScope() instanceof GlobalSearchScope) {
                PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)method.getProject());
                PsiSearchHelper.SearchCostResult search = searchHelper.isCheapEnoughToSearch(method.getName(), (GlobalSearchScope)method.getUseScope(), null);
                if (search == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                    return false;
                }
                if (search == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return true;
                }
            }
            Collection references = ReferencesSearch.search((PsiElement)method).findAll();
            for (PsiReference reference : references) {
                PsiClass clazz;
                PsiElement element;
                boolean catchSectionAbsent;
                if (!(reference instanceof PsiElement) || (catchSectionAbsent = PsiTreeUtil.treeWalkUp((PsiElement)(element = (PsiElement)reference), (PsiElement)(clazz = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)), (PairProcessor)new TryBlockCatchTypeProcessor(this.myType)))) continue;
                return true;
            }
            return false;
        }

        @NotNull
        PsiJavaCodeReferenceElement getReference() {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = this.myReference;
            if (psiJavaCodeReferenceElement == null) {
                ThrowRefType.$$$reportNull$$$0(7);
            }
            return psiJavaCodeReferenceElement;
        }

        @NotNull
        PsiClassType getType() {
            PsiClassType psiClassType = this.myType;
            if (psiClassType == null) {
                ThrowRefType.$$$reportNull$$$0(8);
            }
            return psiClassType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$ThrowRefType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$ThrowRefType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReference";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isRemoteExceptionInRemoteMethod";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isInOverriddenOf";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isThrownIn";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isInThrowsListOf";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isCaught";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }

        private static class TryBlockCatchTypeProcessor
        implements PairProcessor<PsiElement, PsiElement> {
            @NotNull
            private final PsiClassType myType;

            private TryBlockCatchTypeProcessor(@NotNull PsiClassType type) {
                if (type == null) {
                    TryBlockCatchTypeProcessor.$$$reportNull$$$0(0);
                }
                this.myType = type;
            }

            public boolean process(PsiElement curr, PsiElement prev) {
                if (!(curr instanceof PsiTryStatement)) {
                    return true;
                }
                PsiTryStatement tryStatement = (PsiTryStatement)curr;
                return Arrays.stream(tryStatement.getCatchSections()).map(PsiCatchSection::getCatchType).filter(Objects::nonNull).filter(e -> !ExceptionUtil.isGeneralExceptionType((PsiType)e)).noneMatch(e -> e.isAssignableFrom((PsiType)this.myType));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$ThrowRefType$TryBlockCatchTypeProcessor", "<init>"));
            }
        }
    }
}

